/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.steam;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverSteamValve;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.misc.teams.GTTeam;
import gregtech.common.misc.teams.GTTeamManager;
import gregtech.common.misc.teams.PipelessSteamManager;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.godforge.util.ForgeOfGodsUI;

public class MTESteamPipelessHatch
extends MTEHatchCustomFluidBase {
    private static final int STEAM_SELECTOR_WINDOW_ID = 11;
    private GTTeam ownerTeam;
    private SteamType selectedSteam = SteamType.STEAM;
    private SteamType previousSteam = null;

    public MTESteamPipelessHatch(int aID, String aName, String aNameRegional, int aTier) {
        super((Set<Fluid>)ImmutableSet.of((Object)FluidUtils.getSteam(1).getFluid(), (Object)FluidUtils.getSuperHeatedSteam(1).getFluid()), aTier == 0 ? 4000 * (int)WirelessNetworkManager.ticks_between_energy_addition : Integer.MAX_VALUE, aID, aName, aNameRegional, aTier);
    }

    public MTESteamPipelessHatch(String aName, int aTier, ITexture[][][] aTexture) {
        super((Set<Fluid>)ImmutableSet.of((Object)FluidUtils.getSteam(1).getFluid(), (Object)FluidUtils.getSuperHeatedSteam(1).getFluid()), aTier == 0 ? 4000 * (int)WirelessNetworkManager.ticks_between_energy_addition : Integer.MAX_VALUE, aName, aTier, new String[]{""}, aTexture);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamPipelessHatch(this.mName, this.mTier, this.mTextures);
    }

    @Override
    public String[] getDescription() {
        if (this.mTier == 0) {
            return new String[]{EnumChatFormatting.GRAY + "Stores steam globally in a network, up to 2^(2^31) L.", EnumChatFormatting.GRAY + "Does not connect to pipes. This block withdraws Steam from the network.", EnumChatFormatting.GRAY + "Supports Steam, Superheated Steam and Supercritical Steam (and their dense variants).", EnumChatFormatting.GRAY + "Capacity: " + GTUtility.formatNumbers(this.getCapacity()) + "L", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Where does it come from? Capable of extracting Steam from seemingly nowhere, and even", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "without any type of Pipes, you begin to question what you thought you knew about this", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "simple action of boiling water. One thing's for sure though, it still may not be enough..."};
        }
        return new String[]{EnumChatFormatting.GRAY + "Stores steam globally in a network, up to 2^(2^31) L.", EnumChatFormatting.GRAY + "Does not connect to pipes. This block withdraws Steam from the network.", EnumChatFormatting.GRAY + "Supports Steam, Superheated Steam and Supercritical Steam (and their dense variants).", EnumChatFormatting.GRAY + "Capacity: " + GTUtility.formatNumbers(this.getCapacity()) + "L", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Your dream recalled a 'Wireless Energy Hatch,' but you don't remember anything like the", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "power of this hatch. By utilizing the immense strength of dehumidification, you've found", EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "a way to harness the incredible energy of water to heights you never thought possible..."};
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_WIRELESS_ON[0]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_WIRELESS_ON[0]};
    }

    @Override
    protected ITexture getBaseTexture(int colorIndex) {
        if (this.mTier == 0) {
            return TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZE_SIDE);
        }
        return TextureFactory.of(Textures.BlockIcons.MACHINE_STEEL_SIDE);
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return CoverSteamValve.isFluidCompatible(aFluid);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        this.tryFetchingSteam();
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.previousSteam != null) {
            if (this.getFluid() == null || this.getFluid().getFluid() != this.selectedSteam.getFluid()) {
                this.flushSteam();
                this.tryFetchingSteam();
            }
            this.previousSteam = null;
        }
        if (aTick % WirelessNetworkManager.ticks_between_energy_addition == 0L) {
            this.tryFetchingSteam();
        }
    }

    private PipelessSteamManager getSteamManager() {
        if (this.ownerTeam == null) {
            IGregTechTileEntity te = this.getBaseMetaTileEntity();
            this.ownerTeam = GTTeamManager.getTeam(te.getOwnerName(), te.getOwnerUuid());
        }
        return GTTeamManager.getSteamData(this.ownerTeam);
    }

    private void tryFetchingSteam() {
        long currentSteam = this.getFluidAmount();
        long maxSteam = this.getCapacity();
        long steamToTransfer = Math.min(maxSteam - currentSteam, (long)this.getCapacity());
        if (steamToTransfer <= 0L) {
            return;
        }
        PipelessSteamManager manager = this.getSteamManager();
        long drained = this.selectedSteam.drainNetwork(manager, steamToTransfer);
        this.fill(this.selectedSteam.getFluidStack(drained), true);
    }

    private void flushSteam() {
        if (this.getFluid() == null || this.getFluidAmount() == 0) {
            return;
        }
        for (SteamType type : SteamType.VALUES) {
            if (type.getFluid() != this.getFluid().getFluid()) continue;
            type.fillNetwork(this.getSteamManager(), this.getFluidAmount());
            this.drain(Integer.MAX_VALUE, true);
            return;
        }
    }

    @Override
    public void onBlockDestroyed() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.flushSteam();
        }
        super.onBlockDestroyed();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("SteamType", this.selectedSteam.ordinal());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.selectedSteam = SteamType.VALUES[aNBT.func_74762_e("SteamType")];
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        return new FluidTankInfo[0];
    }

    @Override
    protected FluidSlotWidget createFluidSlot() {
        return super.createFluidSlot().setFilter(f -> this.isFluidInputAllowed(new FluidStack(f, 1)));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext ctx) {
        super.addUIWidgets(builder, ctx);
        ctx.addSyncedWindow(11, this::createSteamSelectorWindow);
        builder.widget(new ButtonWidget().setOnClick((data, widget) -> ForgeOfGodsUI.reopenWindow(widget, 11)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).addTooltip("Choose Steam Type").setTooltipShowUpDelay(5).setSize(18, 18).setPos(7, 63));
        builder.widget(new ItemDrawable(GTOreDictUnificator.get(OrePrefixes.pipeMedium, Materials.Bronze, 1L)).asWidget().setPos(8, 64).setSize(16, 16));
    }

    protected ModularWindow createSteamSelectorWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)180, (int)150);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.selectedSteam.ordinal(), val -> {
            this.selectedSteam = SteamType.VALUES[val];
        }));
        builder.widget(new ItemDrawable(GTOreDictUnificator.get(OrePrefixes.pipeMedium, Materials.Bronze, 1L)).asWidget().setPos(3, 3).setSize(16, 16));
        builder.widget(new TextWidget(new Text("Steam Type")).setTextAlignment(Alignment.CenterLeft).setPos(20, 3).setSize(160, 20));
        builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(this.getGUIWidth() - 15, 3));
        MultiChildWidget typeColumn = new MultiChildWidget();
        typeColumn.setSize(174, 120);
        typeColumn.setPos(6, 24);
        builder.widget((Widget)typeColumn);
        for (int i = 0; i < SteamType.VALUES.length; ++i) {
            SteamType type = SteamType.VALUES[i];
            typeColumn.addChild(new ButtonWidget().setOnClick((data, widget) -> {
                if (widget.isClient()) {
                    return;
                }
                this.previousSteam = this.selectedSteam;
                this.selectedSteam = type;
            }).setBackground(() -> {
                if (this.selectedSteam == type) {
                    return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
                }
                return new IDrawable[]{IDrawable.EMPTY};
            }).setSize(18, 18).setPos(0, 20 * i));
            typeColumn.addChild(new ItemDrawable(GTUtility.getFluidDisplayStack(type.getFluidStack(1L), false)).asWidget().setPos(1, i * 20 + 1).setSize(16, 16));
            typeColumn.addChild(new TextWidget(new Text(type.getName())).setTextAlignment(Alignment.CenterLeft).setPos(22, i * 20).setSize(152, 20));
        }
        return builder.build();
    }

    @Override
    public String[] getInfoData() {
        String name = this.mTier == 0 ? "Pipeless Steam Hatch" : "Pipeless Jetstream Hatch";
        return new String[]{EnumChatFormatting.BLUE + name + EnumChatFormatting.RESET, "Stored Fluid:", EnumChatFormatting.GOLD + (this.mFluid == null ? "No Fluid" : this.mFluid.getLocalizedName()) + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mFluid == null ? 0L : (long)this.mFluid.amount) + " L" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getCapacity()) + " L" + EnumChatFormatting.RESET};
    }

    private static enum SteamType {
        STEAM{
            private Fluid fluid;

            @Override
            Fluid getFluid() {
                if (this.fluid == null) {
                    this.fluid = FluidRegistry.getFluid((String)"steam");
                }
                return this.fluid;
            }

            @Override
            String getName() {
                return "Steam";
            }

            @Override
            void fillNetwork(PipelessSteamManager manager, long amount) {
                manager.fillSteam(amount);
            }

            @Override
            long drainNetwork(PipelessSteamManager manager, long amount) {
                return manager.drainSteam(amount, false);
            }
        }
        ,
        DENSE_STEAM{
            private Fluid fluid;

            @Override
            Fluid getFluid() {
                if (this.fluid == null) {
                    this.fluid = Materials.DenseSteam.mGas;
                }
                return this.fluid;
            }

            @Override
            String getName() {
                return "Dense Steam";
            }

            @Override
            void fillNetwork(PipelessSteamManager manager, long amount) {
                manager.fillDenseSteam(amount);
            }

            @Override
            long drainNetwork(PipelessSteamManager manager, long amount) {
                return manager.drainDenseSteam(amount, false);
            }
        }
        ,
        SH_STEAM{
            private Fluid fluid;

            @Override
            Fluid getFluid() {
                if (this.fluid == null) {
                    this.fluid = FluidRegistry.getFluid((String)"ic2superheatedsteam");
                }
                return this.fluid;
            }

            @Override
            String getName() {
                return "Superheated Steam";
            }

            @Override
            void fillNetwork(PipelessSteamManager manager, long amount) {
                manager.fillSuperheatedSteam(amount);
            }

            @Override
            long drainNetwork(PipelessSteamManager manager, long amount) {
                return manager.drainSuperheatedSteam(amount, false);
            }
        }
        ,
        DENSE_SH_STEAM{
            private Fluid fluid;

            @Override
            Fluid getFluid() {
                if (this.fluid == null) {
                    this.fluid = Materials.DenseSuperheatedSteam.mGas;
                }
                return this.fluid;
            }

            @Override
            String getName() {
                return "Dense Superheated Steam";
            }

            @Override
            void fillNetwork(PipelessSteamManager manager, long amount) {
                manager.fillDenseSuperheatedSteam(amount);
            }

            @Override
            long drainNetwork(PipelessSteamManager manager, long amount) {
                return manager.drainDenseSuperheatedSteam(amount, false);
            }
        }
        ,
        SC_STEAM{
            private Fluid fluid;

            @Override
            Fluid getFluid() {
                if (this.fluid == null) {
                    this.fluid = FluidRegistry.getFluid((String)"supercriticalsteam");
                }
                return this.fluid;
            }

            @Override
            String getName() {
                return "Supercritical Steam";
            }

            @Override
            void fillNetwork(PipelessSteamManager manager, long amount) {
                manager.fillSupercriticalSteam(amount);
            }

            @Override
            long drainNetwork(PipelessSteamManager manager, long amount) {
                return manager.drainSupercriticalSteam(amount, false);
            }
        }
        ,
        DENSE_SC_STEAM{
            private Fluid fluid;

            @Override
            Fluid getFluid() {
                if (this.fluid == null) {
                    this.fluid = Materials.DenseSupercriticalSteam.mGas;
                }
                return this.fluid;
            }

            @Override
            String getName() {
                return "Dense Supercritical Steam";
            }

            @Override
            void fillNetwork(PipelessSteamManager manager, long amount) {
                manager.fillDenseSupercriticalSteam(amount);
            }

            @Override
            long drainNetwork(PipelessSteamManager manager, long amount) {
                return manager.drainDenseSupercriticalSteam(amount, false);
            }
        };

        static final SteamType[] VALUES;

        FluidStack getFluidStack(long amount) {
            return new FluidStack(this.getFluid(), (int)amount);
        }

        abstract Fluid getFluid();

        abstract String getName();

        abstract void fillNetwork(PipelessSteamManager var1, long var2);

        abstract long drainNetwork(PipelessSteamManager var1, long var2);

        static {
            VALUES = SteamType.values();
        }
    }
}

