/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.widgets.LockedWhileActiveButton;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetricsExporter;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import gregtech.crossmod.visualprospecting.VisualProspectingDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTEOreDrillingPlantBase
extends MTEDrillerBase
implements IMetricsExporter {
    private final List<ChunkPosition> oreBlockPositions = new ArrayList<ChunkPosition>();
    protected int mTier = 1;
    private int chunkRadiusConfig = this.getRadiusInChunks();
    private boolean replaceWithCobblestone = true;
    private int clientOreListSize = 0;
    private int clientCurrentChunk = 0;
    private int clientTotalChunks = 0;
    private int clientYHead = 0;
    private String veinName = null;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    MTEOreDrillingPlantBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    MTEOreDrillingPlantBase(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("chunkRadiusConfig", this.chunkRadiusConfig);
        aNBT.func_74757_a("replaceWithCobblestone", this.replaceWithCobblestone);
        if (this.veinName != null) {
            aNBT.func_74778_a("veinName", this.veinName);
        } else if (aNBT.func_74764_b("veinName")) {
            aNBT.func_82580_o("veinName");
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkRadiusConfig")) {
            this.chunkRadiusConfig = aNBT.func_74762_e("chunkRadiusConfig");
        }
        if (aNBT.func_74764_b("replaceWithCobblestone")) {
            this.replaceWithCobblestone = aNBT.func_74767_n("replaceWithCobblestone");
        }
        this.veinName = aNBT.func_74764_b("veinName") ? aNBT.func_74779_i("veinName") : null;
    }

    private void adjustChunkRadius(boolean increase) {
        if (increase) {
            if (this.chunkRadiusConfig <= this.getRadiusInChunks()) {
                ++this.chunkRadiusConfig;
            }
            if (this.chunkRadiusConfig > this.getRadiusInChunks()) {
                this.chunkRadiusConfig = 1;
            }
        } else {
            if (this.chunkRadiusConfig > 0) {
                --this.chunkRadiusConfig;
            }
            if (this.chunkRadiusConfig == 0) {
                this.chunkRadiusConfig = this.getRadiusInChunks();
            }
        }
        if (this.mCurrentChunk != null && this.mChunkLoadingEnabled) {
            GTChunkManager.releaseChunk((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
        }
        this.oreBlockPositions.clear();
        this.createInitialWorkingChunk();
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        if (this.getBaseMetaTileEntity().isActive()) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workarea_fail"));
        } else {
            this.adjustChunkRadius(!aPlayer.func_70093_af());
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + GTUtility.formatNumbers((long)this.chunkRadiusConfig << 4) + " " + StatCollector.func_74838_a((String)"GT5U.machines.radius"));
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.replaceWithCobblestone = !this.replaceWithCobblestone;
        GTUtility.sendChatToPlayer(aPlayer, "Replace with cobblestone " + this.replaceWithCobblestone);
        return true;
    }

    @Override
    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (yHead != oldYHead) {
            this.oreBlockPositions.clear();
        }
        if (this.mWorkChunkNeedsReload && this.mChunkLoadingEnabled) {
            GTChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), null);
            this.mWorkChunkNeedsReload = false;
        }
        this.fillMineListIfEmpty(xDrill, yDrill, zDrill, xPipe, zPipe, yHead);
        if (this.oreBlockPositions.isEmpty()) {
            if (this.veinName == null) {
                this.updateVeinNameFromVP(this.getDrillCoords());
            }
            switch (this.tryLowerPipeState()) {
                case 2: {
                    this.mMaxProgresstime = 0;
                    this.setRuntimeFailureReason(CheckRecipeResultRegistry.MISSING_MINING_PIPE);
                    return false;
                }
                case 3: {
                    this.workState = 2;
                    return true;
                }
                case 1: {
                    this.workState = 1;
                    return true;
                }
            }
            this.fillMineListIfEmpty(xDrill, yDrill, zDrill, xPipe, zPipe, yHead);
        }
        return this.tryProcessOreList();
    }

    private boolean tryProcessOreList() {
        boolean simulateResult;
        if (this.protectsExcessItem() && !(simulateResult = this.processOreList(true))) {
            this.mEUt = 0;
            this.mMaxProgresstime = 0;
            return false;
        }
        boolean result = this.processOreList(false);
        if (!result) {
            this.mEUt = 0;
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }

    private boolean processOreList(boolean simulate) {
        ChunkPosition oreBlockPos = null;
        List<ChunkPosition> oreBlockPositions = simulate ? MTEOreDrillingPlantBase.copyOreBlockPositions(this.oreBlockPositions) : this.oreBlockPositions;
        int x = 0;
        int y = 0;
        int z = 0;
        Block oreBlock = null;
        int oreBlockMetadata = 0;
        while (!(oreBlock != null && GTUtility.isOre(oreBlock, oreBlockMetadata) || oreBlockPositions.isEmpty())) {
            oreBlockPos = oreBlockPositions.remove(0);
            x = oreBlockPos.field_151329_a;
            y = oreBlockPos.field_151327_b;
            z = oreBlockPos.field_151328_c;
            if (GTUtility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), x, y, z, true)) {
                oreBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
            }
            oreBlockMetadata = this.getBaseMetaTileEntity().getWorld().func_72805_g(x, y, z);
        }
        if (!this.tryConsumeDrillingFluid(simulate)) {
            oreBlockPositions.add(0, oreBlockPos);
            this.setRuntimeFailureReason(CheckRecipeResultRegistry.NO_DRILLING_FLUID);
            return false;
        }
        if (oreBlock != null && GTUtility.isOre(oreBlock, oreBlockMetadata)) {
            short metaData = 0;
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
            if (tTileEntity instanceof TileEntityOres) {
                metaData = ((TileEntityOres)tTileEntity).mMetaData;
            }
            Collection<ItemStack> oreBlockDrops = this.getBlockDrops(oreBlock, x, y, z);
            ItemStack cobble = GTUtility.getCobbleForOre(oreBlock, metaData);
            if (!simulate) {
                if (this.replaceWithCobblestone) {
                    this.getBaseMetaTileEntity().getWorld().func_147465_d(x, y, z, Block.func_149634_a((Item)cobble.func_77973_b()), cobble.func_77960_j(), 3);
                } else {
                    this.getBaseMetaTileEntity().getWorld().func_147468_f(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
                }
            }
            ItemStack[] toOutput = this.getOutputByDrops(oreBlockDrops);
            if (simulate && !this.canOutputAll(toOutput)) {
                this.setRuntimeFailureReason(CheckRecipeResultRegistry.ITEM_OUTPUT_FULL);
                return false;
            }
            this.mOutputItems = toOutput;
        }
        return true;
    }

    private static List<ChunkPosition> copyOreBlockPositions(List<ChunkPosition> oreBlockPositions) {
        ArrayList<ChunkPosition> ret = new ArrayList<ChunkPosition>();
        for (ChunkPosition chunkPosition : oreBlockPositions) {
            ret.add(new ChunkPosition(chunkPosition.field_151329_a, chunkPosition.field_151327_b, chunkPosition.field_151328_c));
        }
        return ret;
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (!this.mChunkLoadingEnabled) {
            return super.workingAtBottom(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
        }
        if (this.mCurrentChunk == null) {
            this.createInitialWorkingChunk();
            return true;
        }
        if (this.mWorkChunkNeedsReload) {
            GTChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
            this.mWorkChunkNeedsReload = false;
            return true;
        }
        if (this.oreBlockPositions.isEmpty()) {
            this.fillChunkMineList(yHead, yDrill);
            if (this.oreBlockPositions.isEmpty()) {
                GTChunkManager.releaseChunk((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
                if (!this.moveToNextChunk(xDrill >> 4, zDrill >> 4)) {
                    this.workState = 2;
                    this.updateVeinNameFromVP();
                }
                return true;
            }
        }
        return this.tryProcessOreList();
    }

    private void createInitialWorkingChunk() {
        this.mCurrentChunk = this.getTopLeftChunkCoords();
        this.updateVeinNameFromVP();
        if (this.mChunkLoadingEnabled) {
            GTChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
            this.mWorkChunkNeedsReload = false;
        }
    }

    @NotNull
    private ChunkCoordIntPair getTopLeftChunkCoords() {
        return this.getCornerCoords(-1, -1);
    }

    @NotNull
    private ChunkCoordIntPair getBottomRightChunkCoords() {
        return this.getCornerCoords(1, 1);
    }

    @NotNull
    private ChunkCoordIntPair getCornerCoords(int xMultiplier, int zMultiplier) {
        ChunkCoordIntPair drillPos = this.getDrillCoords();
        return new ChunkCoordIntPair(drillPos.field_77276_a + xMultiplier * this.chunkRadiusConfig + (this.getXDrill() - (drillPos.field_77276_a << 4) < 8 ? 0 : 1), drillPos.field_77275_b + zMultiplier * this.chunkRadiusConfig + (this.getZDrill() - (drillPos.field_77275_b << 4) < 8 ? 0 : 1));
    }

    @NotNull
    private ChunkCoordIntPair getDrillCoords() {
        return new ChunkCoordIntPair(this.getXDrill() >> 4, this.getZDrill() >> 4);
    }

    private int getTotalChunkCount() {
        ChunkCoordIntPair topLeft = this.getTopLeftChunkCoords();
        ChunkCoordIntPair bottomRight = this.getBottomRightChunkCoords();
        return (bottomRight.field_77276_a - topLeft.field_77276_a) * (bottomRight.field_77275_b - topLeft.field_77275_b);
    }

    private int getChunkNumber() {
        if (this.mCurrentChunk == null) {
            return 0;
        }
        ChunkCoordIntPair topLeft = this.getTopLeftChunkCoords();
        ChunkCoordIntPair drillPos = this.getDrillCoords();
        if (this.workState == 0) {
            return 1;
        }
        if (this.workState == 2) {
            return 0;
        }
        int chunkNumber = this.chunkRadiusConfig * 2 * (this.mCurrentChunk.field_77275_b - topLeft.field_77275_b) + this.mCurrentChunk.field_77276_a - topLeft.field_77276_a + 1;
        if (this.mCurrentChunk.field_77275_b < drillPos.field_77275_b || this.mCurrentChunk.field_77275_b == drillPos.field_77275_b && this.mCurrentChunk.field_77276_a < drillPos.field_77276_a) {
            ++chunkNumber;
        }
        return chunkNumber;
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        boolean result;
        if (!this.mChunkLoadingEnabled || this.oreBlockPositions.isEmpty()) {
            result = super.workingUpward(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
        } else {
            result = this.tryProcessOreList();
            if (this.oreBlockPositions.isEmpty()) {
                GTChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
            }
        }
        if (!result) {
            this.setShutdownReason(StatCollector.func_74838_a((String)"GT5U.gui.text.drill_exhausted"));
        }
        return result;
    }

    @Override
    protected void onAbort() {
        this.oreBlockPositions.clear();
        if (this.mCurrentChunk != null) {
            GTChunkManager.releaseChunk((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
        }
        this.mCurrentChunk = null;
        this.updateVeinNameFromVP();
    }

    private boolean moveToNextChunk(int centerX, int centerZ) {
        if (this.mCurrentChunk == null) {
            return false;
        }
        int left = centerX - this.chunkRadiusConfig + (this.getXDrill() - (centerX << 4) < 8 ? 0 : 1);
        int right = left + this.chunkRadiusConfig * 2;
        int bottom = centerZ + this.chunkRadiusConfig + (this.getZDrill() - (centerZ << 4) < 8 ? 0 : 1);
        int nextChunkX = this.mCurrentChunk.field_77276_a + 1;
        int nextChunkZ = this.mCurrentChunk.field_77275_b;
        if (nextChunkX >= right) {
            nextChunkX = left;
            ++nextChunkZ;
        }
        if (nextChunkX == centerX && nextChunkZ == centerZ && ++nextChunkX >= right) {
            nextChunkX = left;
            ++nextChunkZ;
        }
        if (nextChunkZ >= bottom) {
            this.mCurrentChunk = null;
            return false;
        }
        this.mCurrentChunk = new ChunkCoordIntPair(nextChunkX, nextChunkZ);
        this.updateVeinNameFromVP();
        GTChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), new ChunkCoordIntPair(nextChunkX, nextChunkZ));
        return true;
    }

    private void updateVeinNameFromVP() {
        this.updateVeinNameFromVP(this.mCurrentChunk);
    }

    private void updateVeinNameFromVP(@NotNull ChunkCoordIntPair coords) {
        this.veinName = VisualProspectingDatabase.getVeinName(this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, coords).orElse(null);
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    protected List<IHatchElement<? super MTEDrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.InputBus, (Object)HatchElement.OutputBus, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy);
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GTUtility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -3 * (1 << (tier << 1));
        this.mMaxProgresstime = this.calculateMaxProgressTime(tier);
    }

    @Override
    public int calculateMaxProgressTime(int tier, boolean simulateWorking) {
        return (int)Math.max(1.0, (double)(this.workState == 0 || this.workState == 1 || simulateWorking ? this.getBaseProgressTime() : 80) / Math.pow(2.0, tier));
    }

    private ItemStack[] getOutputByDrops(Collection<ItemStack> oreBlockDrops) {
        long voltage = this.getMaxInputVoltage();
        HashSet outputItems = new HashSet();
        oreBlockDrops.forEach(currentItem -> {
            if (!this.doUseMaceratorRecipe((ItemStack)currentItem)) {
                outputItems.add(this.multiplyStackSize((ItemStack)currentItem));
                return;
            }
            GTRecipe tRecipe = RecipeMaps.maceratorRecipes.findRecipeQuery().items((ItemStack)currentItem).voltage(voltage).find();
            if (tRecipe == null) {
                outputItems.add(currentItem);
                return;
            }
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                ItemStack recipeOutput = tRecipe.mOutputs[i].func_77946_l();
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) < tRecipe.getOutputChance(i)) {
                    this.multiplyStackSize(recipeOutput);
                }
                outputItems.add(recipeOutput);
            }
        });
        return outputItems.toArray(new ItemStack[0]);
    }

    private boolean doUseMaceratorRecipe(ItemStack currentItem) {
        ItemData itemData = GTOreDictUnificator.getItemData(currentItem);
        return itemData == null || itemData.mPrefix != OrePrefixes.crushed && itemData.mPrefix != OrePrefixes.dustImpure && itemData.mPrefix != OrePrefixes.dust && itemData.mPrefix != OrePrefixes.gem && itemData.mPrefix != OrePrefixes.gemChipped && itemData.mPrefix != OrePrefixes.gemExquisite && itemData.mPrefix != OrePrefixes.gemFlawed && itemData.mPrefix != OrePrefixes.gemFlawless && itemData.mMaterial.mMaterial != Materials.Oilsands;
    }

    private ItemStack multiplyStackSize(ItemStack itemStack) {
        itemStack.field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(4) + 1;
        return itemStack;
    }

    private Collection<ItemStack> getBlockDrops(Block oreBlock, int posX, int posY, int posZ) {
        TileEntity tTileEntity;
        int blockMeta = this.getBaseMetaTileEntity().getMetaID(posX, posY, posZ);
        if (oreBlock.canSilkHarvest(this.getBaseMetaTileEntity().getWorld(), null, posX, posY, posZ, blockMeta)) {
            return Collections.singleton(new ItemStack(oreBlock, 1, blockMeta));
        }
        if (oreBlock instanceof BlockOresAbstract && (tTileEntity = this.getBaseMetaTileEntity().getTileEntity(posX, posY, posZ)) instanceof TileEntityOres) {
            TileEntityOres tTileEntityOres = (TileEntityOres)tTileEntity;
            if (tTileEntityOres.mMetaData >= 16000) {
                return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, blockMeta, this.mTier + 3);
            }
            return tTileEntityOres.getSilkTouchDrops(oreBlock);
        }
        return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, blockMeta, 0);
    }

    private boolean tryConsumeDrillingFluid(boolean simulate) {
        return this.depleteInput(new FluidStack(ItemList.sDrillingFluid, 2000), simulate);
    }

    private void fillChunkMineList(int yHead, int yDrill) {
        if (this.mCurrentChunk == null || !this.oreBlockPositions.isEmpty()) {
            return;
        }
        int minX = this.mCurrentChunk.field_77276_a << 4;
        int maxX = minX + 16;
        int minZ = this.mCurrentChunk.field_77275_b << 4;
        int maxZ = minZ + 16;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = yHead; y < yDrill; ++y) {
                    this.tryAddOreBlockToMineList(x, y, z);
                }
            }
        }
    }

    private void fillMineListIfEmpty(int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead) {
        if (!this.oreBlockPositions.isEmpty()) {
            return;
        }
        this.tryAddOreBlockToMineList(xPipe, yHead - 1, zPipe);
        if (yHead == yDrill) {
            return;
        }
        if (this.mChunkLoadingEnabled) {
            int startX = xDrill >> 4 << 4;
            int startZ = zDrill >> 4 << 4;
            for (int x = startX; x < startX + 16; ++x) {
                for (int z = startZ; z < startZ + 16; ++z) {
                    this.tryAddOreBlockToMineList(x, yHead, z);
                }
            }
        } else {
            int radius = this.chunkRadiusConfig << 4;
            for (int xOff = -radius; xOff <= radius; ++xOff) {
                for (int zOff = -radius; zOff <= radius; ++zOff) {
                    this.tryAddOreBlockToMineList(xDrill + xOff, yHead, zDrill + zOff);
                }
            }
        }
    }

    private void tryAddOreBlockToMineList(int x, int y, int z) {
        Block block = this.getBaseMetaTileEntity().getBlock(x, y, z);
        int blockMeta = this.getBaseMetaTileEntity().getMetaID(x, y, z);
        ChunkPosition blockPos = new ChunkPosition(x, y, z);
        if (!this.oreBlockPositions.contains(blockPos)) {
            if (block instanceof BlockOresAbstract) {
                TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
                if (tTileEntity instanceof TileEntityOres && ((TileEntityOres)tTileEntity).mNatural) {
                    this.oreBlockPositions.add(blockPos);
                }
            } else if (GTUtility.isOre(block, blockMeta)) {
                this.oreBlockPositions.add(blockPos);
            }
        }
    }

    protected abstract int getRadiusInChunks();

    protected abstract int getBaseProgressTime();

    protected MultiblockTooltipBuilder createTooltip(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        int baseCycleTime = this.calculateMaxProgressTime(this.getMinTier(), true);
        tt.addMachineType("Miner, MBM").addInfo("Use a Screwdriver to configure block radius").addInfo("Maximum radius is " + GTUtility.formatNumbers((long)this.getRadiusInChunks() << 4) + " blocks").addInfo("Use Soldering iron to turn off chunk mode").addInfo("Use Wire Cutter to toggle replacing mined blocks with cobblestone").addInfo("In chunk mode, working area center is the chunk corner nearest to the drill").addInfo("Gives ~3x as much crushed ore vs normal processing").addInfo("Fortune bonus of " + GTUtility.formatNumbers(this.mTier + 3) + ". Only works on small ores").addInfo("Minimum energy hatch tier: " + GTUtility.getColoredTierNameFromTier((byte)this.getMinTier())).addInfo("Base cycle time: " + (baseCycleTime < 20 ? GTUtility.formatNumbers(baseCycleTime) + " ticks" : GTUtility.formatNumbers((double)baseCycleTime / 20.0) + " seconds")).beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GTValues.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes, optional, any base casing", 1).addInputHatch("Drilling Fluid, any base casing", 1).addOutputBus("Any base casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.drill_ores_left_chunk", (Object[])new Object[]{numberFormat.format((long)this.clientOreListSize)})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.clientOreListSize > 0 && this.workState == 1))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.drill_ores_left_layer", (Object[])new Object[]{numberFormat.format((long)this.clientYHead), numberFormat.format((long)this.clientOreListSize)})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.clientYHead > 0 && this.workState == 0))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.drill_chunks_left", (Object[])new Object[]{numberFormat.format((long)this.clientCurrentChunk), numberFormat.format((long)this.clientTotalChunks)})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.clientCurrentChunk > 0 && this.workState == 1))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.drill_current_vein", (Object[])new Object[]{this.veinName})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.veinName != null && (this.workState == 1 || this.workState == 0)))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this.oreBlockPositions::size, newInt -> {
            this.clientOreListSize = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getTotalChunkCount, newInt -> {
            this.clientTotalChunks = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getChunkNumber, newInt -> {
            this.clientCurrentChunk = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.workState, newInt -> {
            this.workState = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getYHead, newInt -> {
            this.clientYHead = newInt;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.veinName, newString -> {
            this.veinName = newString;
        }));
    }

    @Override
    protected List<ButtonWidget> getAdditionalButtons(ModularWindow.Builder builder, UIBuildContext buildContext) {
        return ImmutableList.of((Object)((ButtonWidget)new LockedWhileActiveButton(this.getBaseMetaTileEntity(), builder).setOnClick((clickData, widget) -> this.adjustChunkRadius(clickData.mouseButton == 0)).setPlayClickSound(true).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_WORK_AREA}).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.chunkRadiusConfig, val -> {
            this.chunkRadiusConfig = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74837_a((String)"GT5U.gui.button.ore_drill_radius_1", (Object[])new Object[]{GTUtility.formatNumbers((long)this.chunkRadiusConfig << 4)}), (Object)StatCollector.func_74838_a((String)"GT5U.gui.button.ore_drill_radius_2"))).setTooltipShowUpDelay(5).setSize(16, 16)), (Object)((ButtonWidget)new LockedWhileActiveButton(this.getBaseMetaTileEntity(), builder).setOnClick((clickData, widget) -> {
            this.replaceWithCobblestone = !this.replaceWithCobblestone;
        }).setPlayClickSound(true).setBackground(() -> {
            if (this.replaceWithCobblestone) {
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_REPLACE_COBBLE_ON};
            }
            return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_REPLACE_COBBLE_OFF};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.replaceWithCobblestone, val -> {
            this.replaceWithCobblestone = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74838_a((String)(this.replaceWithCobblestone ? "GT5U.gui.button.ore_drill_cobblestone_on" : "GT5U.gui.button.ore_drill_cobblestone_off")))).setTooltipShowUpDelay(5).setSize(16, 16)));
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_MINER_OP;
    }

    @Override
    public String[] getInfoData() {
        String diameter = GTUtility.formatNumbers((long)this.chunkRadiusConfig * 2L);
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.minermulti") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + diameter + "x" + diameter + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.chunks")};
    }

    @Override
    @NotNull
    public List<String> reportMetrics() {
        if (this.getBaseMetaTileEntity().isActive()) {
            ImmutableList immutableList;
            switch (this.workState) {
                case 1: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74837_a((String)"GT5U.gui.text.drill_ores_left_chunk", (Object[])new Object[]{GTUtility.formatNumbers(this.oreBlockPositions.size())}), (Object)StatCollector.func_74837_a((String)"GT5U.gui.text.drill_chunks_left", (Object[])new Object[]{GTUtility.formatNumbers(this.getChunkNumber()), GTUtility.formatNumbers(this.getTotalChunkCount())}), (Object)(this.veinName == null ? "" : StatCollector.func_74837_a((String)"GT5U.gui.text.drill_current_vein", (Object[])new Object[]{this.veinName})));
                    break;
                }
                case 0: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74837_a((String)"GT5U.gui.text.drill_ores_left_layer", (Object[])new Object[]{this.getYHead(), GTUtility.formatNumbers(this.oreBlockPositions.size())}), (Object)(this.veinName == null ? "" : StatCollector.func_74837_a((String)"GT5U.gui.text.drill_current_vein", (Object[])new Object[]{this.veinName})));
                    break;
                }
                case 2: 
                case 3: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74838_a((String)"GT5U.gui.text.retracting_pipe"));
                    break;
                }
                default: {
                    immutableList = ImmutableList.of();
                }
            }
            return immutableList;
        }
        return ImmutableList.of((Object)this.getFailureReason().map(reason -> StatCollector.func_74837_a((String)"GT5U.gui.text.drill_offline_reason", (Object[])new Object[]{reason})).orElseGet(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.drill_offline_generic", (Object[])new Object[0])));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }
}

