/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEWorldAccelerator
extends MTETieredMachineBlock {
    private static final ClassValue<String> simpleNameCache = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> type) {
            return type.getSimpleName();
        }
    };
    private static final HashSet<Class<? extends TileEntity>> _mBlacklistedTiles = new HashSet();
    private int _mRadiusTierOverride = -1;
    private int _mSpeedTierOverride = -1;
    private byte mMode = 0;
    private static Textures.BlockIcons.CustomIcon _mGTIco_Norm_Idle;
    private static Textures.BlockIcons.CustomIcon _mGTIco_Norm_Active;
    private static Textures.BlockIcons.CustomIcon _mGTIco_TE_Idle;
    private static Textures.BlockIcons.CustomIcon _mGTIco_TE_Active;
    private static final int[] mAccelerateStatic;
    private static final int AMPERAGE_NORMAL = 3;
    private static final int AMPERAGE_TE = 6;
    private static final String[] mModeStr;
    private static final String[] mUnlocalizedModeStr;

    public static boolean addTileToBlacklist(Class<? extends TileEntity> clazz) {
        return _mBlacklistedTiles.add(clazz);
    }

    public static boolean addTileToBlacklist(TileEntity tileEntity) {
        return _mBlacklistedTiles.add(tileEntity.getClass());
    }

    public static HashSet<Class<? extends TileEntity>> get_mBlacklistedTiles() {
        return _mBlacklistedTiles;
    }

    private int getRadiusTierOverride() {
        if (this._mRadiusTierOverride == -1) {
            this._mRadiusTierOverride = this.mTier;
        }
        return this._mRadiusTierOverride;
    }

    private int getSpeedTierOverride() {
        if (this._mSpeedTierOverride == -1) {
            this._mSpeedTierOverride = this.mTier;
        }
        return this._mSpeedTierOverride;
    }

    private int incSpeedTierOverride() {
        this._mSpeedTierOverride = this.getSpeedTierOverride() + 1;
        if (this._mSpeedTierOverride > this.mTier) {
            this._mSpeedTierOverride = 1;
        }
        return this._mSpeedTierOverride;
    }

    private int incRadiusTierOverride() {
        this._mRadiusTierOverride = this.getRadiusTierOverride() + 1;
        if (this._mRadiusTierOverride > this.mTier) {
            this._mRadiusTierOverride = 1;
        }
        return this._mRadiusTierOverride;
    }

    @Override
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        _mGTIco_Norm_Idle = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR");
        _mGTIco_Norm_Active = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_ACTIVE");
        _mGTIco_TE_Idle = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_TE");
        _mGTIco_TE_Active = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_TE_ACTIVE");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onValueUpdate(byte aValue) {
        this.mMode = aValue;
    }

    @Override
    public byte getUpdateData() {
        return this.mMode;
    }

    public MTEWorldAccelerator(int pID, String pName, String pNameRegional, int pTier) {
        super(pID, pName, pNameRegional, pTier, 0, "", new ITexture[0]);
    }

    @Override
    public String[] getDescription() {
        return new String[]{String.format("Accelerating things (Max Radius: %d | Max Speed Bonus: x%d)", this.mTier, mAccelerateStatic[this.mTier]), "Use a screwdriver to change mode, sneak to change Radius", "Use a wrench to change speed", "To accelerate TileEntities, this machine has to be adjacent to it", String.format("Normal mode consumes up to %s amperage, depending on radius", 3), String.format("TE mode consumes %s amperage", 6)};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> tInfoDisplay = new ArrayList<String>();
        tInfoDisplay.add(StatCollector.func_74837_a((String)"GT5U.infodata.world_accelerator.mode", (Object[])new Object[]{StatCollector.func_74838_a((String)mUnlocalizedModeStr[this.mMode])}));
        tInfoDisplay.add(StatCollector.func_74837_a((String)"GT5U.infodata.world_accelerator.speed", (Object[])new Object[]{mAccelerateStatic[this.getSpeedTierOverride()], mAccelerateStatic[this.mTier]}));
        tInfoDisplay.add(StatCollector.func_74837_a((String)"GT5U.infodata.world_accelerator.consuming", (Object[])new Object[]{this.getEnergyDemand(this.getSpeedTierOverride(), this.getRadiusTierOverride(), this.mMode == 1)}));
        if (this.mMode == 0) {
            tInfoDisplay.add(StatCollector.func_74837_a((String)"GT5U.infodata.world_accelerator.radius", (Object[])new Object[]{this.getRadiusTierOverride(), this.mTier}));
        }
        return tInfoDisplay.toArray(new String[0]);
    }

    public MTEWorldAccelerator(String pName, int pTier, int pInvSlotCount, String[] pDescription, ITexture[][][] pTextures) {
        super(pName, pTier, pInvSlotCount, pDescription, pTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity pTileEntity) {
        return new MTEWorldAccelerator(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] pTextures) {
        return null;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity pBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean pActive, boolean pRedstone) {
        if (this.mMode == 0) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], side.offsetY != 0 ? null : (pActive ? TextureFactory.of(_mGTIco_Norm_Active) : TextureFactory.of(_mGTIco_Norm_Idle))};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], side.offsetY != 0 ? null : (pActive ? TextureFactory.of(_mGTIco_TE_Active) : TextureFactory.of(_mGTIco_TE_Idle))};
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity pBaseMetaTileEntity, int pIndex, ForgeDirection side, ItemStack pStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity pBaseMetaTileEntity, int pIndex, ForgeDirection side, ItemStack pStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound pNBT) {
        pNBT.func_74774_a("mAccelMode", this.mMode);
        pNBT.func_74774_a("mSpeed", (byte)this.getSpeedTierOverride());
        pNBT.func_74774_a("mRadius", (byte)this.getRadiusTierOverride());
    }

    public long getEnergyDemand(int pSpeedTier, int pRangeTier, boolean pIsAcceleratingTEs) {
        if (pIsAcceleratingTEs) {
            return GTValues.V[pSpeedTier] * 6L;
        }
        float multiplier = 100.0f / (float)this.mTier * (float)pRangeTier / 100.0f;
        long demand = GTValues.V[pSpeedTier] * 3L;
        float tDemand = (float)demand * multiplier;
        return (int)tDemand;
    }

    @Override
    public void loadNBTData(NBTTagCompound pNBT) {
        this.mMode = pNBT.func_74771_c("mAccelMode");
        if (pNBT.func_74764_b("mSpeed")) {
            this._mSpeedTierOverride = pNBT.func_74771_c("mSpeed");
        }
        if (pNBT.func_74764_b("mRadius")) {
            this._mRadiusTierOverride = pNBT.func_74771_c("mRadius");
        }
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer pPlayer) {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier] * 50L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return 8L;
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer pPlayer, float aX, float aY, float aZ) {
        this.incSpeedTierOverride();
        this.func_70296_d();
        PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("Machine acceleration changed to x%d", mAccelerateStatic[this.getSpeedTierOverride()]));
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer pPlayer, float pX, float pY, float pZ) {
        if (pPlayer.func_70093_af()) {
            if (this.mMode == 0) {
                this.incRadiusTierOverride();
                this.func_70296_d();
                PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("Machine radius changed to %d Blocks", this.getRadiusTierOverride()));
            } else {
                PlayerChatHelper.SendError((EntityPlayer)pPlayer, (String)"Can't change radius; Machine is in TileEntity Mode!");
            }
        } else {
            this.mMode = (byte)(this.mMode == 0 ? 1 : 0);
            this.func_70296_d();
            PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("Switched mode to: %s", mModeStr[this.mMode]));
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity pBaseMetaTileEntity, long pTick) {
        try {
            if (!pBaseMetaTileEntity.isServerSide()) {
                return;
            }
            long tEnergyDemand = this.getEnergyDemand(this.getSpeedTierOverride(), this.getRadiusTierOverride(), this.mMode == 1);
            if (pBaseMetaTileEntity.getStoredEU() < tEnergyDemand || !pBaseMetaTileEntity.isAllowedToWork()) {
                if (pBaseMetaTileEntity.isActive()) {
                    pBaseMetaTileEntity.setActive(false);
                }
            } else if (pBaseMetaTileEntity.decreaseStoredEnergyUnits(tEnergyDemand, false)) {
                World tWorld = pBaseMetaTileEntity.getWorld();
                if (this.mMode == 0) {
                    if (pTick % 20L == 0L) {
                        this.doAccelerateNormalBlocks(pBaseMetaTileEntity, tWorld);
                    }
                } else {
                    this.doAccelerateTileEntities(pBaseMetaTileEntity, tWorld);
                }
            } else if (pBaseMetaTileEntity.isActive()) {
                pBaseMetaTileEntity.setActive(false);
            }
        }
        catch (Exception e) {
            GTLog.err.println("MTEWorldAccelerator.onPostTick.crash\n" + e.getMessage());
        }
    }

    private void doAccelerateTileEntities(IGregTechTileEntity pBaseMetaTileEntity, World pWorld) {
        try {
            if (!pBaseMetaTileEntity.isActive()) {
                this.getBaseMetaTileEntity().setActive(true);
            }
            block2: for (ForgeDirection tDir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tTile = pBaseMetaTileEntity.getTileEntityAtSide(tDir);
                if (this.isTEBlackListed(tTile)) continue;
                long tMaxTime = System.nanoTime() + 1000000L;
                for (int j = 0; j < mAccelerateStatic[this.getSpeedTierOverride()]; ++j) {
                    tTile.func_145845_h();
                    if (System.nanoTime() > tMaxTime) continue block2;
                }
            }
        }
        catch (Exception e) {
            GTLog.err.println("MTEWorldAccelerator.doAccelerateTileEntities.crash\n" + e.getMessage());
        }
    }

    private boolean isTEBlackListed(TileEntity pTile) {
        if (pTile == null) {
            return true;
        }
        if (!pTile.canUpdate()) {
            return true;
        }
        if (pTile.func_145837_r()) {
            return true;
        }
        String tSimpleClassName = simpleNameCache.get(pTile.getClass());
        String tCanonicalName = pTile.getClass().getCanonicalName().toLowerCase();
        if (tSimpleClassName.contains("conduit") || tSimpleClassName.contains("wire") || tSimpleClassName.contains("cable")) {
            return true;
        }
        if (tCanonicalName.contains("appeng") || tCanonicalName.contains(Mods.GregTech.ID)) {
            return true;
        }
        if (tSimpleClassName.contains("solar") || tCanonicalName.contains("solar")) {
            return true;
        }
        for (String tS : GTValues.blacklistedTileEntiyClassNamesForWA) {
            if (!tCanonicalName.equalsIgnoreCase(tS)) continue;
            return true;
        }
        return _mBlacklistedTiles.stream().map(Class::getCanonicalName).map(String::toLowerCase).anyMatch(tCanonicalName::equalsIgnoreCase);
    }

    private void doAccelerateNormalBlocks(IGregTechTileEntity pBaseMetaTileEntity, World pWorld) {
        if (!pBaseMetaTileEntity.isActive()) {
            this.getBaseMetaTileEntity().setActive(true);
        }
        Random rnd = new Random();
        int tX = pBaseMetaTileEntity.getXCoord();
        short tY = pBaseMetaTileEntity.getYCoord();
        int tZ = pBaseMetaTileEntity.getZCoord();
        int tX1 = tX - this.getRadiusTierOverride();
        int tX2 = tX + this.getRadiusTierOverride();
        int tY1 = Math.max(tY - this.getRadiusTierOverride(), 0);
        int tY2 = Math.min(tY + this.getRadiusTierOverride(), 255);
        int tZ1 = tZ - this.getRadiusTierOverride();
        int tZ2 = tZ + this.getRadiusTierOverride();
        for (int xi = tX1; xi <= tX2; ++xi) {
            for (int yi = tY1; yi <= tY2; ++yi) {
                for (int zi = tZ1; zi <= tZ2; ++zi) {
                    this.tryTickBlock(pWorld, xi, yi, zi, rnd);
                }
            }
        }
    }

    private void tryTickBlock(World pWorld, int pX, int pY, int pZ, Random pRnd) {
        try {
            for (int j = 0; j < this.getSpeedTierOverride(); ++j) {
                Block tBlock = pWorld.func_147439_a(pX, pY, pZ);
                if (!tBlock.func_149653_t()) continue;
                tBlock.func_149674_a(pWorld, pX, pY, pZ, pRnd);
            }
        }
        catch (Exception e) {
            GTLog.err.println("MTEWorldAccelerator.tryTickBlock.crash\n" + e.getMessage());
        }
    }

    static {
        mAccelerateStatic = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, 512, 512, 512, 512, 512};
        mModeStr = new String[]{"Blocks", "TileEntities"};
        mUnlocalizedModeStr = new String[]{"GT5U.word_accelerator.mode.blocks", "GT5U.word_accelerator.mode.tile_entities"};
    }
}

