/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicGenerator;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class MTENaquadahReactor
extends MTEBasicGenerator {
    public MTENaquadahReactor(int aID, String aName, String[] aDescription, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, aDescription, new ITexture[0]);
        if (aTier > 8 || aTier < 4) {
            new Exception("Tier without Recipe Map!").printStackTrace();
        }
    }

    public MTENaquadahReactor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        if (aTier > 8 || aTier < 4) {
            new Exception("Tier without Recipe Map!").printStackTrace();
        }
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        return (side.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && side != this.getBaseMetaTileEntity().getFrontFacing() && side != this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENaquadahReactor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        RecipeMap<FuelBackend> ret;
        switch (this.mTier) {
            case 4: {
                ret = RecipeMaps.smallNaquadahReactorFuels;
                break;
            }
            case 5: {
                ret = RecipeMaps.largeNaquadahReactorFuels;
                break;
            }
            case 6: {
                ret = RecipeMaps.hugeNaquadahReactorFuels;
                break;
            }
            case 7: {
                ret = RecipeMaps.extremeNaquadahReactorFuels;
                break;
            }
            case 8: {
                ret = RecipeMaps.ultraHugeNaquadahReactorFuels;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public int getCapacity() {
        return this.getRecipeMap() != null ? (((RecipeMapBackend)this.getRecipeMap().getBackend()).getProperties().minFluidInputs > 0 ? 8000 * (this.mTier + 1) : 0) : 0;
    }

    @Override
    public int getEfficiency() {
        return this.mTier == 4 ? 80 : 100 + 50 * (this.mTier - 5);
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BACK), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BACK_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BOTTOM), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BOTTOM_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_SIDE), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_SIDE_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BACK_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BACK_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BOTTOM_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_BOTTOM_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_SIDE_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_SIDE_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public int getPollution() {
        return 0;
    }
}

