/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.IBlockWithTextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IAllSidedTexturedTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.RenderOverlay;
import gregtech.common.blocks.BlockFrameBox;
import gregtech.common.blocks.BlockMachines;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class GTRendererBlock
implements ISimpleBlockRenderingHandler {
    public static final float blockMin = 0.0f;
    public static final float blockMax = 1.0f;
    private static final float coverThickness = 0.125f;
    private static final float coverInnerMin = 0.125f;
    private static final float coverInnerMax = 0.875f;
    @Deprecated
    public static GTRendererBlock INSTANCE;
    public static int mRenderID;
    private final ITexture[][] textureArray = new ITexture[6][];
    private final ITexture[] overlayHolder = new ITexture[1];
    final ITexture[][] tIcons = new ITexture[ForgeDirection.VALID_DIRECTIONS.length][];
    final ITexture[][] tCovers = new ITexture[ForgeDirection.VALID_DIRECTIONS.length][];
    final boolean[] tIsCovered = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
    final TileEntityOres tTileEntity = new TileEntityOres();

    public static void register() {
        mRenderID = RenderingRegistry.getNextAvailableRenderId();
        INSTANCE = new GTRendererBlock();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)INSTANCE);
    }

    public boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IPipeRenderedTileEntity) {
            IPipeRenderedTileEntity pipeRenderedTileEntity = (IPipeRenderedTileEntity)tTileEntity;
            this.textureArray[0] = pipeRenderedTileEntity.getTextureCovered(ForgeDirection.DOWN);
            this.textureArray[1] = pipeRenderedTileEntity.getTextureCovered(ForgeDirection.UP);
            this.textureArray[2] = pipeRenderedTileEntity.getTextureCovered(ForgeDirection.NORTH);
            this.textureArray[3] = pipeRenderedTileEntity.getTextureCovered(ForgeDirection.SOUTH);
            this.textureArray[4] = pipeRenderedTileEntity.getTextureCovered(ForgeDirection.WEST);
            this.textureArray[5] = pipeRenderedTileEntity.getTextureCovered(ForgeDirection.EAST);
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, this.textureArray);
        }
        if (tTileEntity instanceof IAllSidedTexturedTileEntity) {
            IAllSidedTexturedTileEntity allSidedTexturedTileEntity = (IAllSidedTexturedTileEntity)tTileEntity;
            ITexture[] texture = allSidedTexturedTileEntity.getTexture(aBlock);
            this.textureArray[0] = texture;
            this.textureArray[1] = texture;
            this.textureArray[2] = texture;
            this.textureArray[3] = texture;
            this.textureArray[4] = texture;
            this.textureArray[5] = texture;
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, this.textureArray);
        }
        if (tTileEntity instanceof ITexturedTileEntity) {
            ITexturedTileEntity texturedTileEntity = (ITexturedTileEntity)tTileEntity;
            this.textureArray[0] = texturedTileEntity.getTexture(aBlock, ForgeDirection.DOWN);
            this.textureArray[1] = texturedTileEntity.getTexture(aBlock, ForgeDirection.UP);
            this.textureArray[2] = texturedTileEntity.getTexture(aBlock, ForgeDirection.NORTH);
            this.textureArray[3] = texturedTileEntity.getTexture(aBlock, ForgeDirection.SOUTH);
            this.textureArray[4] = texturedTileEntity.getTexture(aBlock, ForgeDirection.WEST);
            this.textureArray[5] = texturedTileEntity.getTexture(aBlock, ForgeDirection.EAST);
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, this.textureArray);
        }
        return false;
    }

    public boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer, ITexture[][] aTextures) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        ITexture[] overlays = RenderOverlay.get(aWorld, aX, aY, aZ);
        if (overlays != null) {
            GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[0], true);
            if (overlays[0] != null) {
                this.overlayHolder[0] = overlays[0];
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.overlayHolder, true);
            }
            GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[1], true);
            if (overlays[1] != null) {
                this.overlayHolder[0] = overlays[1];
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.overlayHolder, true);
            }
            GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[2], true);
            if (overlays[2] != null) {
                this.overlayHolder[0] = overlays[2];
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.overlayHolder, true);
            }
            GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[3], true);
            if (overlays[3] != null) {
                this.overlayHolder[0] = overlays[3];
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.overlayHolder, true);
            }
            GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[4], true);
            if (overlays[4] != null) {
                this.overlayHolder[0] = overlays[4];
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.overlayHolder, true);
            }
            GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[5], true);
            if (overlays[5] != null) {
                this.overlayHolder[0] = overlays[5];
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.overlayHolder, true);
            }
        } else {
            GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[0], true);
            GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[1], true);
            GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[2], true);
            GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[3], true);
            GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[4], true);
            GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[5], true);
        }
        return true;
    }

    public boolean renderPipeBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, IPipeRenderedTileEntity aTileEntity, RenderBlocks aRenderer) {
        byte aConnections = aTileEntity.getConnections();
        if ((aConnections & 0xC0) != 0) {
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float thickness = aTileEntity.getThickNess();
        if (thickness >= 0.99f) {
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float pipeMin = (1.0f - thickness) / 2.0f;
        float pipeMax = 1.0f - pipeMin;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            ForgeDirection iSide = ForgeDirection.VALID_DIRECTIONS[i];
            this.tIsCovered[i] = aTileEntity.hasCoverAtSide(iSide);
            this.tCovers[i] = aTileEntity.getTexture(aBlock, iSide);
            this.tIcons[i] = aTileEntity.getTextureUncovered(iSide);
        }
        switch (aConnections) {
            case 0: {
                aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                break;
            }
            case 48: {
                aBlock.func_149676_a(0.0f, pipeMin, pipeMin, 1.0f, pipeMax, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                break;
            }
            case 3: {
                aBlock.func_149676_a(pipeMin, 0.0f, pipeMin, pipeMax, 1.0f, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                break;
            }
            case 12: {
                aBlock.func_149676_a(pipeMin, pipeMin, 0.0f, pipeMax, pipeMax, 1.0f);
                aRenderer.func_147775_a(aBlock);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                break;
            }
            default: {
                if ((aConnections & 0x10) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(0.0f, pipeMin, pipeMin, pipeMin, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                    GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                    GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                    GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                }
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                if ((aConnections & 0x20) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMax, pipeMin, pipeMin, 1.0f, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                    GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                    GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                    GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                }
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                if ((aConnections & 1) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, 0.0f, pipeMin, pipeMax, pipeMin, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                    GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                    GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                    GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                }
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                if ((aConnections & 2) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, pipeMax, pipeMin, pipeMax, 1.0f, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                    GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
                    GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                    GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                }
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                if ((aConnections & 4) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, pipeMin, 0.0f, pipeMax, pipeMax, pipeMin);
                    aRenderer.func_147775_a(aBlock);
                    GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                    GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                    GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                    GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                }
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[2], false);
                if ((aConnections & 8) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMax, pipeMax, pipeMax, 1.0f);
                    aRenderer.func_147775_a(aBlock);
                    GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[0], false);
                    GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[1], false);
                    GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[4], false);
                    GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[5], false);
                }
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tIcons[3], false);
            }
        }
        if (this.tIsCovered[0]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!this.tIsCovered[2]) {
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
            }
            if (!this.tIsCovered[3]) {
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
            }
            if (!this.tIsCovered[4]) {
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
            }
            if (!this.tIsCovered[5]) {
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
            }
            GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
            if ((aConnections & 1) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.0, (double)pipeMin);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
                aRenderer.func_147782_a(0.0, 0.0, (double)pipeMax, 1.0, 0.0, 1.0);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
                aRenderer.func_147782_a(0.0, 0.0, (double)pipeMin, (double)pipeMin, 0.0, (double)pipeMax);
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
                aRenderer.func_147782_a((double)pipeMax, 0.0, (double)pipeMin, 1.0, 0.0, (double)pipeMax);
            }
            GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[0], false);
        }
        if (this.tIsCovered[1]) {
            aBlock.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!this.tIsCovered[2]) {
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
            }
            if (!this.tIsCovered[3]) {
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
            }
            if (!this.tIsCovered[4]) {
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
            }
            if (!this.tIsCovered[5]) {
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
            }
            GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
            if ((aConnections & 2) != 0) {
                aRenderer.func_147782_a(0.0, 1.0, 0.0, 1.0, 1.0, (double)pipeMin);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
                aRenderer.func_147782_a(0.0, 1.0, (double)pipeMax, 1.0, 1.0, 1.0);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
                aRenderer.func_147782_a(0.0, 1.0, (double)pipeMin, (double)pipeMin, 1.0, (double)pipeMax);
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
                aRenderer.func_147782_a((double)pipeMax, 1.0, (double)pipeMin, 1.0, 1.0, (double)pipeMax);
            }
            GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[1], false);
        }
        if (this.tIsCovered[2]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
            aRenderer.func_147775_a(aBlock);
            if (!this.tIsCovered[0]) {
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
            }
            if (!this.tIsCovered[1]) {
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
            }
            if (!this.tIsCovered[4]) {
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
            }
            if (!this.tIsCovered[5]) {
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
            }
            GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
            if ((aConnections & 4) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 0.0, 1.0, (double)pipeMin, 0.0);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
                aRenderer.func_147782_a(0.0, (double)pipeMax, 0.0, 1.0, 1.0, 0.0);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, 0.0, (double)pipeMin, (double)pipeMax, 0.0);
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
                aRenderer.func_147782_a((double)pipeMax, (double)pipeMin, 0.0, 1.0, (double)pipeMax, 0.0);
            }
            GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[2], false);
        }
        if (this.tIsCovered[3]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!this.tIsCovered[0]) {
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
            }
            if (!this.tIsCovered[1]) {
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
            }
            if (!this.tIsCovered[4]) {
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
            }
            if (!this.tIsCovered[5]) {
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
            }
            GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
            if ((aConnections & 8) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 1.0, 1.0, (double)pipeMin, 1.0);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
                aRenderer.func_147782_a(0.0, (double)pipeMax, 1.0, 1.0, 1.0, 1.0);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, 1.0, (double)pipeMin, (double)pipeMax, 1.0);
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
                aRenderer.func_147782_a((double)pipeMax, (double)pipeMin, 1.0, 1.0, (double)pipeMax, 1.0);
            }
            GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[3], false);
        }
        if (this.tIsCovered[4]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!this.tIsCovered[0]) {
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
            }
            if (!this.tIsCovered[1]) {
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
            }
            if (!this.tIsCovered[2]) {
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
            }
            if (!this.tIsCovered[3]) {
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
            }
            GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
            if ((aConnections & 0x10) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 0.0, 0.0, (double)pipeMin, 1.0);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
                aRenderer.func_147782_a(0.0, (double)pipeMax, 0.0, 0.0, 1.0, 1.0);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, 0.0, 0.0, (double)pipeMax, (double)pipeMin);
                GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, (double)pipeMax, 0.0, (double)pipeMax, 1.0);
            }
            GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[4], false);
        }
        if (this.tIsCovered[5]) {
            aBlock.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!this.tIsCovered[0]) {
                GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
            }
            if (!this.tIsCovered[1]) {
                GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
            }
            if (!this.tIsCovered[2]) {
                GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
            }
            if (!this.tIsCovered[3]) {
                GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
            }
            GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
            if ((aConnections & 0x20) != 0) {
                aRenderer.func_147782_a(1.0, 0.0, 0.0, 1.0, (double)pipeMin, 1.0);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
                aRenderer.func_147782_a(1.0, (double)pipeMax, 0.0, 1.0, 1.0, 1.0);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
                aRenderer.func_147782_a(1.0, (double)pipeMin, 0.0, 1.0, (double)pipeMax, (double)pipeMin);
                GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
                aRenderer.func_147782_a(1.0, (double)pipeMin, (double)pipeMax, 1.0, (double)pipeMax, 1.0);
            }
            GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.tCovers[5], false);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addHitEffects(EffectRenderer effectRenderer, Block block, World world, int x, int y, int z, int ordinalSide) {
        double rX = (double)x + XSTR.XSTR_INSTANCE.nextDouble() * 0.8 + 0.1;
        double rY = (double)y + XSTR.XSTR_INSTANCE.nextDouble() * 0.8 + 0.1;
        double rZ = (double)z + XSTR.XSTR_INSTANCE.nextDouble() * 0.8 + 0.1;
        if (ordinalSide == 0) {
            rY = (double)y - 0.1;
        } else if (ordinalSide == 1) {
            rY = (double)y + 1.1;
        } else if (ordinalSide == 2) {
            rZ = (double)z - 0.1;
        } else if (ordinalSide == 3) {
            rZ = (double)z + 1.1;
        } else if (ordinalSide == 4) {
            rX = (double)x - 0.1;
        } else if (ordinalSide == 5) {
            rX = (double)x + 1.1;
        }
        effectRenderer.func_78873_a(new EntityDiggingFX(world, rX, rY, rZ, 0.0, 0.0, 0.0, block, block.func_149643_k(world, x, y, z), ordinalSide).func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDestroyEffects(EffectRenderer effectRenderer, Block block, World world, int x, int y, int z) {
        for (int iX = 0; iX < 4; ++iX) {
            for (int iY = 0; iY < 4; ++iY) {
                for (int iZ = 0; iZ < 4; ++iZ) {
                    double bX = (double)x + ((double)iX + 0.5) / 4.0;
                    double bY = (double)y + ((double)iY + 0.5) / 4.0;
                    double bZ = (double)z + ((double)iZ + 0.5) / 4.0;
                    effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(world, bX, bY, bZ, bX - (double)x - 0.5, bY - (double)y - 0.5, bZ - (double)z - 0.5, block, block.func_149643_k(world, x, y, z)).func_70596_a(x, y, z));
                }
            }
        }
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        IBlockWithTextures texturedBlock;
        ITexture[][] texture;
        aRenderer.field_147863_w = false;
        aRenderer.field_147844_c = true;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (aBlock instanceof BlockOresAbstract) {
            this.tTileEntity.mMetaData = (short)aMeta;
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            ITexture[] texture2 = this.tTileEntity.getTexture(aBlock);
            GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, texture2, true);
            GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, texture2, true);
            GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, texture2, true);
            GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, texture2, true);
            GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, texture2, true);
            GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, texture2, true);
        } else if (aMeta > 0 && aMeta < GregTechAPI.METATILEENTITIES.length && aBlock instanceof BlockMachines && GregTechAPI.METATILEENTITIES[aMeta] != null && !GregTechAPI.METATILEENTITIES[aMeta].renderInInventory(aBlock, aMeta, aRenderer)) {
            GTRendererBlock.renderNormalInventoryMetaTileEntity(aBlock, aMeta, aRenderer);
        } else if (aBlock instanceof BlockFrameBox) {
            ITexture[] texture3 = ((BlockFrameBox)aBlock).getTexture(aMeta);
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, texture3, true);
            GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, texture3, true);
            GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, texture3, true);
            GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, texture3, true);
            GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, texture3, true);
            GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, texture3, true);
        } else if (aBlock instanceof IBlockWithTextures && (texture = (texturedBlock = (IBlockWithTextures)aBlock).getTextures(aMeta)) != null) {
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, texture[ForgeDirection.DOWN.ordinal()], true);
            GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, texture[ForgeDirection.UP.ordinal()], true);
            GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, texture[ForgeDirection.NORTH.ordinal()], true);
            GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, texture[ForgeDirection.SOUTH.ordinal()], true);
            GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, texture[ForgeDirection.WEST.ordinal()], true);
            GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, texture[ForgeDirection.EAST.ordinal()], true);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        aRenderer.field_147844_c = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void renderNormalInventoryMetaTileEntity(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        if (aMeta <= 0) return;
        if (aMeta >= GregTechAPI.METATILEENTITIES.length) {
            return;
        }
        IMetaTileEntity tMetaTileEntity = GregTechAPI.METATILEENTITIES[aMeta];
        if (tMetaTileEntity == null) {
            return;
        }
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        IGregTechTileEntity iGregTechTileEntity = tMetaTileEntity.getBaseMetaTileEntity();
        if (iGregTechTileEntity instanceof IPipeRenderedTileEntity) {
            IPipeRenderedTileEntity renderedPipe = (IPipeRenderedTileEntity)((Object)iGregTechTileEntity);
            if (tMetaTileEntity instanceof MetaPipeEntity) {
                MetaPipeEntity pipeEntity = (MetaPipeEntity)tMetaTileEntity;
                float tThickness = renderedPipe.getThickNess();
                float pipeMin = (1.0f - tThickness) / 2.0f;
                float pipeMax = 1.0f - pipeMin;
                aBlock.func_149676_a(0.0f, pipeMin, pipeMin, 1.0f, pipeMax, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, pipeEntity.getTexture(iGregTechTileEntity, ForgeDirection.DOWN, 48, -1, false, false), true);
                GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, pipeEntity.getTexture(iGregTechTileEntity, ForgeDirection.UP, 48, -1, false, false), true);
                GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, pipeEntity.getTexture(iGregTechTileEntity, ForgeDirection.NORTH, 48, -1, false, false), true);
                GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, pipeEntity.getTexture(iGregTechTileEntity, ForgeDirection.SOUTH, 48, -1, false, false), true);
                GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, pipeEntity.getTexture(iGregTechTileEntity, ForgeDirection.WEST, 48, -1, true, false), true);
                GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, pipeEntity.getTexture(iGregTechTileEntity, ForgeDirection.EAST, 48, -1, true, false), true);
                return;
            }
        }
        GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, ForgeDirection.DOWN, ForgeDirection.WEST, -1, true, false), true);
        GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, ForgeDirection.UP, ForgeDirection.WEST, -1, true, false), true);
        GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, ForgeDirection.NORTH, ForgeDirection.WEST, -1, true, false), true);
        GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, ForgeDirection.SOUTH, ForgeDirection.WEST, -1, true, false), true);
        GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, ForgeDirection.WEST, ForgeDirection.WEST, -1, true, false), true);
        GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, ForgeDirection.EAST, ForgeDirection.WEST, -1, true, false), true);
    }

    public static void renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aRenderer.field_147837_f && !aBlock.func_149646_a(aWorld, aX, aY - 1, aZ, 0)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderYNeg(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aRenderer.field_147837_f && !aBlock.func_149646_a(aWorld, aX, aY + 1, aZ, 1)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderYPos(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aRenderer.field_147837_f && !aBlock.func_149646_a(aWorld, aX, aY, aZ - 1, 2)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderZNeg(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aRenderer.field_147837_f && !aBlock.func_149646_a(aWorld, aX, aY, aZ + 1, 3)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderZPos(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aRenderer.field_147837_f && !aBlock.func_149646_a(aWorld, aX - 1, aY, aZ, 4)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderXNeg(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aRenderer.field_147837_f && !aBlock.func_149646_a(aWorld, aX + 1, aY, aZ, 5)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderXPos(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        IMetaTileEntity metaTileEntity;
        aRenderer.field_147863_w = Minecraft.func_71379_u() && GTMod.gregtechproxy.mRenderTileAmbientOcclusion;
        aRenderer.field_147844_c = false;
        TileEntity tileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tileEntity == null && aBlock instanceof BlockFrameBox) {
            BlockFrameBox frameBlock = (BlockFrameBox)aBlock;
            int meta = aWorld.func_72805_g(aX, aY, aZ);
            ITexture[] texture = frameBlock.getTexture(meta);
            if (texture == null) {
                return false;
            }
            this.textureArray[0] = texture;
            this.textureArray[1] = texture;
            this.textureArray[2] = texture;
            this.textureArray[3] = texture;
            this.textureArray[4] = texture;
            this.textureArray[5] = texture;
            this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, this.textureArray);
            return true;
        }
        if (aBlock instanceof IBlockWithTextures) {
            IBlockWithTextures texturedBlock = (IBlockWithTextures)aBlock;
            int meta = aWorld.func_72805_g(aX, aY, aZ);
            ITexture[][] texture = texturedBlock.getTextures(meta);
            if (texture == null) {
                return false;
            }
            this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, texture);
            return true;
        }
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) != null && metaTileEntity.renderInWorld(aWorld, aX, aY, aZ, aBlock, aRenderer)) {
            aRenderer.field_147863_w = false;
            return true;
        }
        if (tileEntity instanceof IPipeRenderedTileEntity && this.renderPipeBlock(aWorld, aX, aY, aZ, aBlock, (IPipeRenderedTileEntity)tileEntity, aRenderer)) {
            aRenderer.field_147863_w = false;
            return true;
        }
        if (this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer)) {
            aRenderer.field_147863_w = false;
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return mRenderID;
    }
}

