/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.factory;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ContainerCustomizer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.util.item.GhostCircuitItemStackHandler;
import gregtech.common.items.ItemIntegratedCircuit;
import gregtech.common.modularui2.widget.CoverTabButton;
import gregtech.common.modularui2.widget.GhostCircuitSlotWidget;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public final class GTBaseGuiBuilder {
    private final IMetaTileEntity mte;
    private final PosGuiData posGuiData;
    private final PanelSyncManager syncManager;
    private int width = 176;
    private int height = 166;
    private boolean doesBindPlayerInventory = true;
    private boolean doesAddTitle = true;
    private boolean doesAddCoverTabs = true;
    private boolean doesAddGhostCircuitSlot;
    private boolean doesAddGregTechLogo;

    public GTBaseGuiBuilder(IMetaTileEntity mte, PosGuiData data, PanelSyncManager syncManager) {
        IConfigurationCircuitSupport ccs;
        this.mte = mte;
        this.posGuiData = data;
        this.syncManager = syncManager;
        this.doesAddGhostCircuitSlot = mte instanceof IConfigurationCircuitSupport && (ccs = (IConfigurationCircuitSupport)((Object)mte)).allowSelectCircuit();
        this.doesAddGregTechLogo = !this.doesAddGhostCircuitSlot;
    }

    public GTBaseGuiBuilder setWidth(int width) {
        this.width = width;
        return this;
    }

    public GTBaseGuiBuilder setHeight(int height) {
        this.height = height;
        return this;
    }

    public GTBaseGuiBuilder doesBindPlayerInventory(boolean doesBindPlayerInventory) {
        this.doesBindPlayerInventory = doesBindPlayerInventory;
        return this;
    }

    public GTBaseGuiBuilder doesAddTitle(boolean doesAddTitle) {
        this.doesAddTitle = doesAddTitle;
        return this;
    }

    public GTBaseGuiBuilder doesAddCoverTabs(boolean doesAddCoverTabs) {
        this.doesAddCoverTabs = doesAddCoverTabs;
        return this;
    }

    public GTBaseGuiBuilder doesAddGhostCircuitSlot(boolean doesAddGhostCircuitSlot) {
        this.doesAddGhostCircuitSlot = doesAddGhostCircuitSlot;
        return this;
    }

    public GTBaseGuiBuilder doesAddGregTechLogo(boolean doesAddGregTechLogo) {
        this.doesAddGregTechLogo = doesAddGregTechLogo;
        return this;
    }

    public ModularPanel build() {
        ModularPanel panel = ModularPanel.defaultPanel((String)this.mte.getGuiId(), (int)this.width, (int)this.height);
        if (this.doesBindPlayerInventory) {
            panel.bindPlayerInventory();
        }
        if (this.doesAddTitle && NetworkUtils.isClient()) {
            panel.child(this.createTitle());
        }
        if (this.doesAddCoverTabs) {
            panel.child(this.createCoverTabs());
        }
        if (this.doesAddGhostCircuitSlot) {
            panel.child(this.createGhostCircuitSlot());
        }
        if (this.doesAddGregTechLogo) {
            panel.child(this.createGregTechLogo());
        }
        this.syncManager.setContainerCustomizer(new ContainerCustomizer());
        this.syncManager.getContainerCustomizer().setCanInteractWith($ -> {
            IGregTechTileEntity gtTE = this.mte.getBaseMetaTileEntity();
            return gtTE != null && gtTE.canAccessData();
        });
        this.syncManager.addCloseListener($ -> this.mte.func_70296_d());
        return panel;
    }

    private IWidget createTitle() {
        String title = this.mte.getLocalName();
        return (IWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().coverChildren()).topRelAnchor(0.0f, 1.0f)).widgetTheme("backgroundTitle")).child((IWidget)((TextWidget)((TextWidget)((TextWidget)((TextWidget)IKey.str((String)title).asWidget().widgetTheme("textTitle")).marginLeft(5)).marginRight(5)).marginTop(5)).marginBottom(1));
    }

    private IWidget createCoverTabs() {
        Flow column = ((Flow)((Flow)((Flow)Flow.column().coverChildren()).leftRel(0.0f, 2, 1.0f)).top(1)).childPadding(2);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection side = ForgeDirection.getOrientation((int)i);
            String panelKey = "cover_panel_" + side.toString().toLowerCase();
            IPanelHandler panel = this.syncManager.panel(panelKey, this.coverPanelBuilder(panelKey, side), true);
            column.child((IWidget)new CoverTabButton(this.mte.getBaseMetaTileEntity(), side, panel));
        }
        this.posGuiData.getNEISettings().addNEIExclusionArea((IWidget)column);
        return column;
    }

    private PanelSyncHandler.IPanelBuilder coverPanelBuilder(String name, ForgeDirection side) {
        return (syncManager, syncHandler) -> (ModularPanel)((ModularPanel)GTGuis.createPopUpPanel(name).size(176, 107)).child((IWidget)((Flow)((Flow)((Flow)Flow.column().coverChildren()).childPadding(4).center()).child((IWidget)IKey.str((String)("Cover Panel " + side.toString().toLowerCase())).asWidget())).child((IWidget)new ItemDrawable(ItemList.GigaChad.get(1L, new Object[0])).asIcon().asWidget()));
    }

    private IWidget createGhostCircuitSlot() {
        IConfigurationCircuitSupport ccs;
        IMetaTileEntity iMetaTileEntity = this.mte;
        if (!(iMetaTileEntity instanceof IConfigurationCircuitSupport) || !(ccs = (IConfigurationCircuitSupport)((Object)iMetaTileEntity)).allowSelectCircuit()) {
            throw new IllegalStateException("Tried to add configuration circuit slot to an unsupported machine!");
        }
        IntSyncValue selectedSyncHandler = new IntSyncValue(() -> {
            ItemStack selectedItem = this.mte.func_70301_a(ccs.getCircuitSlot());
            if (selectedItem != null && selectedItem.func_77973_b() instanceof ItemIntegratedCircuit) {
                return selectedItem.func_77960_j() - 1;
            }
            return -1;
        });
        this.syncManager.syncValue("selector_screen_selected", (SyncHandler)selectedSyncHandler);
        return (IWidget)new GhostCircuitSlotWidget(this.mte, selectedSyncHandler).slot(new ModularSlot((IItemHandler)new GhostCircuitItemStackHandler(this.mte), 0, true)).pos(ccs.getCircuitSlotX() - 1, ccs.getCircuitSlotY() - 1);
    }

    private IWidget createGregTechLogo() {
        return (IWidget)((Widget)new Widget().widgetTheme("pictureLogo").size(17, 17)).pos(152, 63);
    }
}

