/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.teams;

import gregtech.common.misc.teams.ITeamData;
import java.math.BigInteger;
import net.minecraft.nbt.NBTTagCompound;

public class PipelessSteamManager
implements ITeamData {
    private static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);
    private BigInteger storedSteam = BigInteger.ZERO;
    private BigInteger storedSuperheatedSteam = BigInteger.ZERO;
    private BigInteger storedSupercriticalSteam = BigInteger.ZERO;

    @Override
    public void writeToNBT(NBTTagCompound NBT2) {
        NBT2.func_74773_a("PipelessSteam", this.storedSteam.toByteArray());
        NBT2.func_74773_a("PipelessSuperheatedSteam", this.storedSuperheatedSteam.toByteArray());
        NBT2.func_74773_a("PipelessSupercriticalSteam", this.storedSupercriticalSteam.toByteArray());
    }

    @Override
    public void readFromNBT(NBTTagCompound NBT2) {
        this.storedSteam = new BigInteger(NBT2.func_74770_j("PipelessSteam"));
        this.storedSuperheatedSteam = new BigInteger(NBT2.func_74770_j("PipelessSuperheatedSteam"));
        this.storedSupercriticalSteam = new BigInteger(NBT2.func_74770_j("PipelessSupercriticalSteam"));
    }

    public void setSteam(BigInteger steam) {
        this.storedSteam = steam;
        this.markDirty();
    }

    public void setSuperheatedSteam(BigInteger superheatedSteam) {
        this.storedSuperheatedSteam = superheatedSteam;
        this.markDirty();
    }

    public void setSupercriticalSteam(BigInteger supercriticalSteam) {
        this.storedSupercriticalSteam = supercriticalSteam;
        this.markDirty();
    }

    public BigInteger getSteam() {
        return this.storedSteam;
    }

    public BigInteger getSuperheatedSteam() {
        return this.storedSuperheatedSteam;
    }

    public BigInteger getSupercriticalSteam() {
        return this.storedSupercriticalSteam;
    }

    public void fillSteam(long steam) {
        this.fillSteam(BigInteger.valueOf(steam));
    }

    public void fillDenseSteam(long denseSteam) {
        this.fillSteam(BigInteger.valueOf(denseSteam).multiply(ONE_THOUSAND));
    }

    public void fillSteam(BigInteger steam) {
        this.storedSteam = this.storedSteam.add(steam);
        if (this.storedSteam.compareTo(BigInteger.ZERO) < 0) {
            this.storedSteam = BigInteger.ZERO;
        }
        this.markDirty();
    }

    public void fillSuperheatedSteam(long superheatedSteam) {
        this.fillSuperheatedSteam(BigInteger.valueOf(superheatedSteam));
    }

    public void fillDenseSuperheatedSteam(long denseSuperheatedSteam) {
        this.fillSuperheatedSteam(BigInteger.valueOf(denseSuperheatedSteam).multiply(ONE_THOUSAND));
    }

    public void fillSuperheatedSteam(BigInteger superheatedSteam) {
        this.storedSuperheatedSteam = this.storedSuperheatedSteam.add(superheatedSteam);
        if (this.storedSuperheatedSteam.compareTo(BigInteger.ZERO) < 0) {
            this.storedSuperheatedSteam = BigInteger.ZERO;
        }
        this.markDirty();
    }

    public void fillSupercriticalSteam(long supercriticalSteam) {
        this.fillSupercriticalSteam(BigInteger.valueOf(supercriticalSteam));
    }

    public void fillDenseSupercriticalSteam(long denseSupercriticalSteam) {
        this.fillSupercriticalSteam(BigInteger.valueOf(denseSupercriticalSteam).multiply(ONE_THOUSAND));
    }

    public void fillSupercriticalSteam(BigInteger supercriticalSteam) {
        this.storedSupercriticalSteam = this.storedSupercriticalSteam.add(supercriticalSteam);
        if (this.storedSupercriticalSteam.compareTo(BigInteger.ZERO) < 0) {
            this.storedSupercriticalSteam = BigInteger.ZERO;
        }
        this.markDirty();
    }

    public long drainSteam(long steam, boolean simulate) {
        return this.drainSteam(BigInteger.valueOf(steam), simulate).longValue();
    }

    public long drainDenseSteam(long denseSteam, boolean simulate) {
        return this.drainSteam(BigInteger.valueOf(denseSteam).multiply(ONE_THOUSAND), simulate).divide(ONE_THOUSAND).longValue();
    }

    private BigInteger drainSteam(BigInteger request, boolean simulate) {
        int cmp = this.storedSteam.compareTo(request);
        if (cmp > 0) {
            if (!simulate) {
                this.storedSteam = this.storedSteam.subtract(request);
                this.markDirty();
            }
            return request;
        }
        if (cmp == 0) {
            if (!simulate) {
                this.storedSteam = BigInteger.ZERO;
                this.markDirty();
            }
            return request;
        }
        BigInteger oldVal = this.storedSteam;
        if (!simulate) {
            this.storedSteam = BigInteger.ZERO;
            this.markDirty();
        }
        return oldVal;
    }

    public long drainSuperheatedSteam(long superheatedSteam, boolean simulate) {
        return this.drainSuperheatedSteam(BigInteger.valueOf(superheatedSteam), simulate).longValue();
    }

    public long drainDenseSuperheatedSteam(long denseSuperheatedSteam, boolean simulate) {
        return this.drainSuperheatedSteam(BigInteger.valueOf(denseSuperheatedSteam).multiply(ONE_THOUSAND), simulate).divide(ONE_THOUSAND).longValue();
    }

    private BigInteger drainSuperheatedSteam(BigInteger request, boolean simulate) {
        int cmp = this.storedSuperheatedSteam.compareTo(request);
        if (cmp > 0) {
            if (!simulate) {
                this.storedSuperheatedSteam = this.storedSuperheatedSteam.subtract(request);
                this.markDirty();
            }
            return request;
        }
        if (cmp == 0) {
            if (!simulate) {
                this.storedSuperheatedSteam = BigInteger.ZERO;
                this.markDirty();
            }
            return request;
        }
        BigInteger oldVal = this.storedSuperheatedSteam;
        if (!simulate) {
            this.storedSuperheatedSteam = BigInteger.ZERO;
            this.markDirty();
        }
        return oldVal;
    }

    public long drainSupercriticalSteam(long supercriticalSteam, boolean simulate) {
        return this.drainSupercriticalSteam(BigInteger.valueOf(supercriticalSteam), simulate).longValue();
    }

    public long drainDenseSupercriticalSteam(long denseSupercriticalSteam, boolean simulate) {
        return this.drainSupercriticalSteam(BigInteger.valueOf(denseSupercriticalSteam).multiply(ONE_THOUSAND), simulate).divide(ONE_THOUSAND).longValue();
    }

    private BigInteger drainSupercriticalSteam(BigInteger request, boolean simulate) {
        int cmp = this.storedSupercriticalSteam.compareTo(request);
        if (cmp > 0) {
            if (!simulate) {
                this.storedSupercriticalSteam = this.storedSupercriticalSteam.subtract(request);
                this.markDirty();
            }
            return request;
        }
        if (cmp == 0) {
            if (!simulate) {
                this.storedSupercriticalSteam = BigInteger.ZERO;
                this.markDirty();
            }
            return request;
        }
        BigInteger oldVal = this.storedSupercriticalSteam;
        if (!simulate) {
            this.storedSupercriticalSteam = BigInteger.ZERO;
            this.markDirty();
        }
        return oldVal;
    }
}

