/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import appeng.api.util.DimensionalCoord;
import appeng.client.render.BlockPosHighlighter;
import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiFactories;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.GenericListSyncHandler;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.SingleChildWidget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.PageButton;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.items.GTGenericItem;
import gregtech.api.net.PakcetDebugRedstoneCover;
import gregtech.common.covers.CoverPosition;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemRedstoneSniffer
extends GTGenericItem
implements IGuiHolder<GuiData> {
    public ItemRedstoneSniffer(String aUnlocalized, String aEnglish, String aEnglishTooltip) {
        super(aUnlocalized, aEnglish, aEnglishTooltip);
        this.func_77625_d(1);
    }

    @Override
    protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        aList.add("Author: \u00a79Frosty\u00a74Fire1");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            GuiFactories.item().open(player);
        }
        return super.func_77659_a(stack, world, player);
    }

    public ModularPanel buildUI(GuiData guiData, final PanelSyncManager guiSyncManager) {
        int scale;
        if (NetworkUtils.isClient()) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            scale = settings.field_74335_Z > 0 ? settings.field_74335_Z : 4;
        } else {
            scale = 1;
        }
        int textColor = Color.rgb((int)255, (int)255, (int)255);
        AtomicReference<String> freqFilter = new AtomicReference<String>("");
        AtomicReference<String> ownerFilter = new AtomicReference<String>("");
        final AtomicInteger lastPage = new AtomicInteger(0);
        if (guiData.getMainHandItem().func_77978_p() != null && guiData.getMainHandItem().func_77978_p().func_74764_b("last_page")) {
            lastPage.set(guiData.getMainHandItem().func_77978_p().func_74762_e("last_page"));
        }
        IntSyncValue pageSyncer = new IntSyncValue(lastPage::get, page -> {
            lastPage.set(page);
            if (guiData.getMainHandItem().func_77978_p() == null) {
                guiData.getMainHandItem().func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = guiData.getMainHandItem().func_77978_p();
            tag.func_74768_a("last_page", page);
        });
        guiSyncManager.syncValue("last_page", (SyncHandler)pageSyncer);
        PagedWidget.Controller controller = new PagedWidget.Controller(){

            public void setPage(int page) {
                super.setPage(page);
                ((IntSyncValue)guiSyncManager.getSyncHandler("last_page:0")).setValue((Object)page);
                System.out.println(String.format("set page to %d", page));
            }
        };
        ListWidget regularListWidget = new ListWidget();
        regularListWidget.sizeRel(1.0f);
        ListWidget advancedListWidget = new ListWidget();
        advancedListWidget.sizeRel(1.0f);
        guiSyncManager.syncValue("player_is_op", (SyncHandler)new BooleanSyncValue(() -> false, () -> {
            EntityPlayerMP player = (EntityPlayerMP)guiData.getPlayer();
            return player.field_71133_b.func_71203_ab().func_152596_g(player.func_146103_bH());
        }));
        StringSyncValue freqFilterSyncer = new StringSyncValue(freqFilter::get, freqFilter::set);
        freqFilterSyncer.setChangeListener(() -> {
            if (NetworkUtils.isClient()) {
                WidgetTree.resize((IWidget)regularListWidget);
                WidgetTree.resize((IWidget)advancedListWidget);
            }
        });
        guiSyncManager.syncValue("freq_filter", (SyncHandler)freqFilterSyncer);
        StringSyncValue ownerFilterSyncer = new StringSyncValue(ownerFilter::get, ownerFilter::set);
        ownerFilterSyncer.setChangeListener(() -> {
            if (NetworkUtils.isClient()) {
                WidgetTree.resize((IWidget)advancedListWidget);
            }
        });
        guiSyncManager.syncValue("owner_filter", (SyncHandler)ownerFilterSyncer);
        ModularPanel panel = ModularPanel.defaultPanel((String)"redstone_sniffer");
        ((Flex)panel.flex().sizeRel(0.5f, 0.75f)).align(Alignment.Center);
        PagedWidget data = new PagedWidget(){

            public void afterInit() {
                this.setPage(lastPage.get());
            }
        };
        data.sizeRel(1.0f, 0.7f);
        data.controller(controller);
        GenericListSyncHandler regularMapSyncer = new GenericListSyncHandler(() -> {
            ArrayList result = new ArrayList();
            GregTechAPI.sWirelessRedstone.forEach((frequency, ignored) -> {
                boolean isPrivate = frequency > 65535;
                int displayFreq = isPrivate ? frequency - 65536 : frequency;
                result.add(new SnifferEntry(String.valueOf(displayFreq), isPrivate));
            });
            return result;
        }, (IByteBufAdapter)new SnifferEntryAdapter());
        regularMapSyncer.setChangeListener(() -> {
            AtomicInteger bgStripe = new AtomicInteger(0);
            int stripe1 = Color.rgb((int)79, (int)82, (int)119);
            int stripe2 = Color.rgb((int)67, (int)58, (int)96);
            ArrayList<SnifferEntry> entries = new ArrayList<SnifferEntry>(regularMapSyncer.getValue());
            entries.sort(Comparator.comparingInt(a -> ((SnifferEntry)a).isPrivate ? 1 : 0));
            ArrayList regularList = new ArrayList();
            entries.forEach(entry -> {
                bgStripe.getAndIncrement();
                regularList.add((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().setEnabledIf(w -> ((StringSyncValue)guiSyncManager.getSyncHandler("freq_filter:0")).getStringValue().isEmpty() || ((SnifferEntry)entry).freq.equals(((StringSyncValue)guiSyncManager.getSyncHandler("freq_filter:0")).getStringValue()))).sizeRel(1.0f, 0.1f * (float)scale)).expanded()).background(new IDrawable[]{bgStripe.get() % 2 == 0 ? new Rectangle().setColor(stripe1) : new Rectangle().setColor(stripe2)})).child((IWidget)((TextWidget)new TextWidget(((SnifferEntry)entry).freq).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(((SnifferEntry)entry).isPrivate ? "Yes" : "No").widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center)));
            });
            regularList.forEach(arg_0 -> ((ListWidget)regularListWidget).child(arg_0));
            WidgetTree.resize((IWidget)regularListWidget);
        });
        guiSyncManager.syncValue("regular_map", (SyncHandler)regularMapSyncer);
        data.addPage((IWidget)((Flow)new Column().child((IWidget)((Flow)((Flow)new Row().heightRel(0.1f)).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.frequency")).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.private")).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center)))).child((IWidget)((SingleChildWidget)new SingleChildWidget().sizeRel(1.0f, 0.9f)).child((IWidget)regularListWidget)));
        GenericListSyncHandler advancedMapSyncer = new GenericListSyncHandler(() -> {
            ArrayList result = new ArrayList();
            GregTechAPI.sAdvancedWirelessRedstone.forEach((uuid, coverMap) -> {
                if (this.canSeeCovers(guiData, (String)uuid)) {
                    String owner = uuid.equals("null") ? "Public" : SpaceProjectManager.getPlayerNameFromUUID(UUID.fromString(uuid));
                    coverMap.forEach((frequency, covers) -> covers.forEach((coverPosition, ignored) -> result.add(new SnifferEntry(owner, (String)frequency, (CoverPosition)coverPosition))));
                }
            });
            return result;
        }, (IByteBufAdapter)new SnifferEntryAdapter());
        advancedMapSyncer.setChangeListener(() -> {
            ArrayList<SnifferEntry> entries = new ArrayList<SnifferEntry>(advancedMapSyncer.getValue());
            entries.sort((a, b) -> {
                if (((SnifferEntry)a).owner.equals("Public")) {
                    return -1;
                }
                if (((SnifferEntry)b).owner.equals("Public")) {
                    return 1;
                }
                return ((SnifferEntry)a).owner.compareTo(((SnifferEntry)b).owner);
            });
            List<IWidget> advancedList = this.processAdvancedFrequencies(entries, advancedListWidget, guiSyncManager, scale, textColor);
            advancedList.forEach(arg_0 -> ((ListWidget)advancedListWidget).child(arg_0));
            WidgetTree.resize((IWidget)advancedListWidget);
        });
        guiSyncManager.syncValue("adv_map", (SyncHandler)advancedMapSyncer);
        data.addPage((IWidget)((Flow)new Column().child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().heightRel(0.1f)).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.owner")).widthRel(0.15f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.frequency")).widthRel(0.35f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.dimension")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.action")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center)))).child((IWidget)((SingleChildWidget)new SingleChildWidget().sizeRel(1.0f, 0.9f)).child((IWidget)advancedListWidget)));
        panel.child((IWidget)((Flow)((Flow)((Flow)new Column().margin(10)).child((IWidget)((Flow)((Flow)((Flow)new Row().heightRel(0.1f)).marginBottom(10)).child((IWidget)((PageButton)((PageButton)new PageButton(0, controller).widthRel(0.5f)).align(Alignment.CenterLeft)).overlay(new IDrawable[]{IKey.lang((String)"gt.item.redstone_sniffer.regular_wireless")}))).child((IWidget)((PageButton)((PageButton)new PageButton(1, controller).widthRel(0.5f)).align(Alignment.CenterRight)).overlay(new IDrawable[]{IKey.lang((String)"gt.item.redstone_sniffer.advanced_wireless")})))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().heightRel(0.1f)).marginBottom(10)).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.frequency_filter")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextFieldWidget)new TextFieldWidget().sizeRel(0.25f, 0.5f)).setTextColor(textColor).value((IStringValue)SyncHandlers.string(() -> ((StringSyncValue)guiSyncManager.getSyncHandler("freq_filter:0")).getStringValue(), filter -> ((StringSyncValue)guiSyncManager.getSyncHandler("freq_filter:0")).setStringValue(filter))))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.owner_filter")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextFieldWidget)new TextFieldWidget().sizeRel(0.25f, 0.5f)).setTextColor(textColor).value((IStringValue)SyncHandlers.string(() -> ((StringSyncValue)guiSyncManager.getSyncHandler("owner_filter:0")).getStringValue(), filter -> ((StringSyncValue)guiSyncManager.getSyncHandler("owner_filter:0")).setStringValue(filter)))))).child((IWidget)data));
        panel.background(new IDrawable[]{new Rectangle().setColor(Color.rgb((int)53, (int)46, (int)77))});
        return panel;
    }

    public List<IWidget> processAdvancedFrequencies(List<SnifferEntry> entryList, ListWidget listWidget, PanelSyncManager guiSyncManager, int scale, int textColor) {
        ArrayList<IWidget> result = new ArrayList<IWidget>();
        AtomicInteger bgStripe = new AtomicInteger(0);
        int stripe1 = Color.rgb((int)79, (int)82, (int)119);
        int stripe2 = Color.rgb((int)67, (int)58, (int)96);
        entryList.forEach(entry -> {
            bgStripe.getAndIncrement();
            CoverPosition cover = ((SnifferEntry)entry).coverPosition;
            result.add((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().setEnabledIf(w -> (((StringSyncValue)guiSyncManager.getSyncHandler("owner_filter:0")).getStringValue().isEmpty() || ((SnifferEntry)entry).owner.contains(((StringSyncValue)guiSyncManager.getSyncHandler("owner_filter:0")).getStringValue())) && ((SnifferEntry)entry).freq.contains(((StringSyncValue)guiSyncManager.getSyncHandler("freq_filter:0")).getStringValue()))).sizeRel(1.0f, 0.1f * (float)scale)).background(new IDrawable[]{bgStripe.get() % 2 == 0 ? new Rectangle().setColor(stripe1) : new Rectangle().setColor(stripe2)})).expanded()).child((IWidget)((TextWidget)new TextWidget(((SnifferEntry)entry).owner).widthRel(0.15f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(((SnifferEntry)entry).freq).widthRel(0.35f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(cover.getDimName()).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((Flow)((Flow)new Row().widthRel(0.25f)).child((IWidget)((SingleChildWidget)new SingleChildWidget().widthRel(0.5f)).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(25, 25)).align(Alignment.Center)).overlay(new IDrawable[]{UITexture.fullImage((String)Mods.GregTech.ID, (String)"gui/overlay_button/redstoneSnifferLocate").asIcon().size(19, 19).margin(3)})).tooltip(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)"gt.item.redstone_sniffer.locate")))).onMousePressed(mouseButton -> {
                GTValues.NW.sendToServer(new PakcetDebugRedstoneCover(cover.dim, cover.x, cover.y, cover.z, false));
                ArrayList<DimensionalCoord> list = new ArrayList<DimensionalCoord>();
                list.add(new DimensionalCoord(cover.x, cover.y, cover.z, cover.dim));
                String foundMsg = String.format("Highlighting cover at %d,%d,%d", cover.x, cover.y, cover.z);
                BlockPosHighlighter.highlightBlocks((EntityPlayer)guiSyncManager.getPlayer(), list, (String)foundMsg, (String)"Cannot highlight because you're not in the same dimension!");
                listWidget.getPanel().closeIfOpen(false);
                return true;
            })))).child((IWidget)((SingleChildWidget)((SingleChildWidget)new SingleChildWidget().setEnabledIf(w -> ((BooleanSyncValue)guiSyncManager.getSyncHandler("player_is_op:0")).getBoolValue())).widthRel(0.5f)).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(25, 25)).align(Alignment.Center)).overlay(new IDrawable[]{UITexture.fullImage((String)Mods.GregTech.ID, (String)"gui/overlay_button/redstoneSnifferTeleport").asIcon().size(19, 19).margin(3)})).tooltip(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)"gt.item.redstone_sniffer.teleport")))).onMousePressed(mouseButton -> {
                GTValues.NW.sendToServer(new PakcetDebugRedstoneCover(cover.dim, cover.x, cover.y, cover.z, true));
                listWidget.getPanel().closeIfOpen(false);
                return true;
            })))));
        });
        return result;
    }

    public boolean canSeeCovers(GuiData guiData, String uuid) {
        UUID leader = SpaceProjectManager.getLeader(guiData.getPlayer().func_110124_au());
        return uuid.equals("null") || SpaceProjectManager.getLeader(UUID.fromString(uuid)).equals(leader);
    }

    public class SnifferEntryAdapter
    implements IByteBufAdapter<SnifferEntry> {
        public SnifferEntry deserialize(PacketBuffer buffer) throws IOException {
            String owner = buffer.func_150789_c(buffer.readInt());
            String freq = buffer.func_150789_c(buffer.readInt());
            boolean isPrivate = buffer.readBoolean();
            if (buffer.readBoolean()) {
                int x = buffer.readInt();
                int y = buffer.readInt();
                int z = buffer.readInt();
                int dim = buffer.readInt();
                int side = buffer.readInt();
                String dimName = buffer.func_150789_c(buffer.readInt());
                CoverPosition coverPosition = new CoverPosition(new ChunkCoordinates(x, y, z), dimName, dim, side);
                return new SnifferEntry(owner, freq, coverPosition);
            }
            return new SnifferEntry(freq, isPrivate);
        }

        public void serialize(PacketBuffer buffer, SnifferEntry value) throws IOException {
            buffer.writeInt(value.owner.length());
            buffer.func_150785_a(value.owner);
            buffer.writeInt(value.freq.length());
            buffer.func_150785_a(value.freq);
            buffer.writeBoolean(value.isPrivate);
            boolean coverPositionExists = value.coverPosition != null;
            buffer.writeBoolean(coverPositionExists);
            if (coverPositionExists) {
                buffer.writeInt(((SnifferEntry)value).coverPosition.x);
                buffer.writeInt(((SnifferEntry)value).coverPosition.y);
                buffer.writeInt(((SnifferEntry)value).coverPosition.z);
                buffer.writeInt(((SnifferEntry)value).coverPosition.dim);
                buffer.writeInt(((SnifferEntry)value).coverPosition.side);
                buffer.writeInt(((SnifferEntry)value).coverPosition.dimName.length());
                buffer.func_150785_a(((SnifferEntry)value).coverPosition.dimName);
            }
        }

        public boolean areEqual(@NotNull SnifferEntry t1, @NotNull SnifferEntry t2) {
            if (t1.coverPosition == null && t2.coverPosition != null || t1.coverPosition != null && t2.coverPosition == null) {
                return false;
            }
            if (t1.coverPosition == null) {
                return t1.freq.equals(t2.freq) && t1.isPrivate == t2.isPrivate;
            }
            return t1.coverPosition.equals(t2.coverPosition) && t1.owner.equals(t2.owner) && t1.freq.equals(t2.freq);
        }
    }

    public class SnifferEntry {
        private final String owner;
        private final String freq;
        private final boolean isPrivate;
        private final CoverPosition coverPosition;

        public SnifferEntry(String owner, String freq, CoverPosition coverPosition) {
            this.owner = owner;
            this.freq = freq;
            this.isPrivate = false;
            this.coverPosition = coverPosition;
        }

        public SnifferEntry(String freq, boolean isPrivate) {
            this.owner = "";
            this.freq = freq;
            this.isPrivate = isPrivate;
            this.coverPosition = null;
        }
    }
}

