/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverItemMeter;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.modularui.widget.ItemWatcherSlotWidget;
import gregtech.common.gui.mui1.cover.CoverUiFactory;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import java.text.FieldPosition;
import java.text.NumberFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ItemMeterUIFactory
extends CoverUiFactory<CoverItemMeter> {
    private static final int startX = 10;
    private static final int startY = 25;
    private static final int spaceX = 18;
    private static final int spaceY = 18;
    protected static final NumberFormatMUI numberFormatAll = new NumberFormatMUI(){

        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            if (number < 0.0) {
                return toAppendTo.append(GTUtility.trans("ALL", "All"));
            }
            return super.format(number, toAppendTo, pos);
        }
    };
    private static final int MAX_SLOT_NUMBER = 0x3FFFFFFE;
    private int maxSlot;
    private int maxThreshold;

    public ItemMeterUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected CoverItemMeter adaptCover(Cover cover) {
        if (cover instanceof CoverItemMeter) {
            CoverItemMeter adapterCover = (CoverItemMeter)cover;
            return adapterCover;
        }
        return null;
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        String INVERTED = GTUtility.trans("INVERTED", "Inverted");
        String NORMAL = GTUtility.trans("NORMAL", "Normal");
        this.setMaxSlot();
        this.setMaxThreshold();
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget<CoverItemMeter>(this::getCover, this.getUIBuildContext()).addFollower(CoverDataFollowerToggleButtonWidget.ofRedstone(), CoverItemMeter::isInverted, CoverItemMeter::setInverted, widget -> widget.addTooltip(0, NORMAL).addTooltip(1, INVERTED).setPos(0, 0)).addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getThreshold(), (coverData, state) -> coverData.setThresdhold(state.intValue()), widget -> widget.setBounds(0.0, this.maxThreshold).setScrollValues(1.0, 64.0, 1000.0).setFocusOnGuiOpen(true).setPos(0, 20).setSize(77, 12)).addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getSlot(), (coverData, state) -> coverData.setSlot(state.intValue()), widget -> widget.setBounds(-1.0, this.maxSlot).setDefaultValue(-1.0).setScrollValues(1.0, 100.0, 10.0).setNumberFormat((NumberFormat)numberFormatAll).setPos(0, 38).setSize(55, 12)).setPos(10, 25))).widget(new ItemWatcherSlotWidget().setGetter(this::getTargetItem).setPos(72, 61))).widget(new TextWidget().setStringSupplier(this.getCoverString(c -> c.isInverted() ? INVERTED : NORMAL)).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget(GTUtility.trans("254", "Detect slot #")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(91, 65))).widget(new TextWidget(GTUtility.trans("221", "Item threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(91, 47));
    }

    private void setMaxSlot() {
        IGregTechTileEntity gtTile;
        ICoverable tile = this.getUIBuildContext().getTile();
        this.maxSlot = !tile.isDead() && tile instanceof IGregTechTileEntity && !((gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEDigitalChestBase) ? Math.min(tile.func_70302_i_() - 1, 0x3FFFFFFE) : -1;
    }

    private void setMaxThreshold() {
        IGregTechTileEntity gtTile;
        ICoverable tile = this.getUIBuildContext().getTile();
        this.maxThreshold = !tile.isDead() && tile instanceof IGregTechTileEntity && (gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEDigitalChestBase ? gtTile.getMaxItemCount() : (this.maxSlot > 0 ? this.maxSlot * 64 : Integer.MAX_VALUE);
    }

    private ItemStack getTargetItem() {
        CoverItemMeter cover = (CoverItemMeter)this.getCover();
        if (cover == null || cover.getSlot() < 0) {
            return null;
        }
        ICoverable tile = this.getUIBuildContext().getTile();
        if (tile instanceof TileEntity && !tile.isDead() && tile.func_70302_i_() >= cover.getSlot()) {
            return tile.func_70301_a(cover.getSlot());
        }
        return null;
    }
}

