/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.ICoverDataFollowerWidget;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.Cover;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class CoverDataControllerWidget<T extends Cover>
extends MultiChildWidget
implements ISyncedWidget {
    private final Supplier<T> coverSupplier;
    private final CoverUIBuildContext coverUiContext;
    protected T lastData;
    private boolean needsUpdate;

    public CoverDataControllerWidget(Supplier<T> coverSupplier, CoverUIBuildContext coverUiContext) {
        this.coverSupplier = coverSupplier;
        this.coverUiContext = coverUiContext;
    }

    @Nullable
    protected T getCover() {
        if (this.isCoverValid()) {
            return (T)((Cover)this.coverSupplier.get());
        }
        return null;
    }

    protected boolean updateCoverInWorld(Cover cover) {
        if (!this.isCoverValid()) {
            return false;
        }
        ICoverable coverable = this.coverUiContext.getTile();
        coverable.updateAttachedCover(cover);
        return true;
    }

    private boolean isCoverValid() {
        ICoverable tile = this.coverUiContext.getTile();
        return !tile.isDead() && tile.getCoverAtSide(this.coverUiContext.getCoverSide()).isValid();
    }

    public <U, W extends Widget> CoverDataControllerWidget<T> addFollower(W widget, Function<T, U> dataToStateGetter, BiFunction<T, U, T> dataUpdater, Consumer<W> applyForWidget) {
        ((ICoverDataFollowerWidget)widget).setDataToStateGetter(dataToStateGetter);
        ((ICoverDataFollowerWidget)widget).setStateSetter(state -> {
            Cover newData = (Cover)dataUpdater.apply(this.getLastData(), state);
            this.lastData = newData;
            this.updateCoverInWorld((Cover)this.getLastData());
            this.syncDataToServer(newData);
        });
        applyForWidget.accept(widget);
        this.addChild(widget);
        return this;
    }

    protected void writeToPacket(PacketBuffer buffer, T cover) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            CoverRegistry.writeCoverToNbt(cover, nbt);
            NetworkUtils.writeNBTBase((PacketBuffer)buffer, (NBTBase)nbt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Cover readFromPacket(PacketBuffer buffer) throws IOException {
        NBTBase nbt = NetworkUtils.readNBTBase((PacketBuffer)buffer);
        Cover cover = null;
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            cover = CoverRegistry.getRegistrationFromNbt(tag).buildCover(this.coverUiContext.getCoverSide(), this.coverUiContext.getTile(), tag);
        }
        return cover;
    }

    protected T getLastData() {
        return this.lastData;
    }

    public void onPostInit() {
        this.lastData = this.getCover();
        if (NetworkUtils.isClient()) {
            this.updateChildren(true);
        }
    }

    public void detectAndSendChanges(boolean init) {
        T actualValue = this.getCover();
        if (actualValue == null) {
            this.getWindow().tryClose();
            return;
        }
        if (init || !actualValue.equals(this.getLastData())) {
            this.lastData = actualValue;
            this.syncDataToClient(actualValue);
        }
    }

    protected void syncDataToClient(T data) {
        this.syncToClient(0, buffer -> this.writeToPacket((PacketBuffer)buffer, data));
    }

    protected void syncDataToServer(T data) {
        this.syncToServer(0, buffer -> this.writeToPacket((PacketBuffer)buffer, data));
        this.updateChildren();
    }

    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.updateCoverInWorld(this.readFromPacket(buf));
            this.lastData = this.getCover();
            this.updateChildren();
        }
    }

    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            boolean coverIsValid = this.updateCoverInWorld(this.readFromPacket(buf));
            this.lastData = this.getCover();
            if (coverIsValid) {
                this.markForUpdate();
            } else {
                this.getWindow().closeWindow();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateChildren(boolean postInit) {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof ICoverDataFollowerWidget)) continue;
            ((ICoverDataFollowerWidget)child).updateState(this.getLastData());
            if (!postInit) continue;
            ((ICoverDataFollowerWidget)child).onPostInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateChildren() {
        this.updateChildren(false);
    }

    public void markForUpdate() {
        this.needsUpdate = true;
    }

    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    public static class CoverDataIndexedControllerWidget_ToggleButtons<T extends Cover>
    extends CoverDataControllerWidget<T> {
        private final BiFunction<Integer, T, Boolean> dataToStateGetter;
        private final BiFunction<Integer, T, T> dataUpdater;

        public CoverDataIndexedControllerWidget_ToggleButtons(Supplier<T> coverSupplier, BiFunction<Integer, T, Boolean> dataToStateGetter, BiFunction<Integer, T, T> dataUpdater, CoverUIBuildContext coverUiContext) {
            super(coverSupplier, coverUiContext);
            this.dataToStateGetter = dataToStateGetter;
            this.dataUpdater = dataUpdater;
        }

        public <W extends CoverDataFollowerToggleButtonWidget<T>> CoverDataIndexedControllerWidget_ToggleButtons<T> addToggleButton(int index, W widget, Consumer<CoverDataFollowerToggleButtonWidget<T>> applyForWidget) {
            this.addFollower(widget, data -> this.dataToStateGetter.apply(index, (Integer)((Object)data)), (data, state) -> (Cover)this.dataUpdater.apply(index, (Integer)((Object)data)), applyForWidget);
            return this;
        }
    }
}

