/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.uifactory;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Dyes;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class SelectItemUIFactory {
    private final String header;
    private final ItemStack headerItem;
    public static final int UNSELECTED = -1;
    private static final int cols = 9;
    private final Consumer<ItemStack> selectedCallback;
    private final List<ItemStack> stacks;
    private final boolean noDeselect;
    private int selected;
    private boolean anotherWindow = false;
    private AtomicBoolean dialogOpened;
    private int guiTint = GTUtil.getRGBInt(Dyes.MACHINE_METAL.getRGBA());
    private Supplier<ItemStack> currentGetter;
    private final GUIColorOverride colorOverride = GUIColorOverride.get("SelectItemUIFactory");
    private final Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x222222);
    private final Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x555555);

    private int getTextColorOrDefault(String textType, int defaultColor) {
        return this.colorOverride.getTextColorOrDefault(textType, defaultColor);
    }

    public SelectItemUIFactory(String header, ItemStack headerItem, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks) {
        this(header, headerItem, selectedCallback, stacks, -1);
    }

    public SelectItemUIFactory(String header, ItemStack headerItem, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks, int selected) {
        this(header, headerItem, selectedCallback, stacks, selected, false);
    }

    public SelectItemUIFactory(String header, ItemStack headerItem, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks, int selected, boolean noDeselect) {
        this.header = header;
        this.headerItem = headerItem;
        this.selectedCallback = selectedCallback;
        this.stacks = stacks;
        this.noDeselect = noDeselect;
        this.selected = noDeselect ? Math.max(0, selected) : selected;
    }

    public SelectItemUIFactory setAnotherWindow(boolean anotherWindow, AtomicBoolean dialogOpened) {
        this.anotherWindow = anotherWindow;
        this.dialogOpened = dialogOpened;
        return this;
    }

    public SelectItemUIFactory setGuiTint(int guiTint) {
        this.guiTint = guiTint;
        return this;
    }

    public SelectItemUIFactory setCurrentGetter(Supplier<ItemStack> currentGetter) {
        this.currentGetter = currentGetter;
        return this;
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)(53 + 18 * ((this.stacks.size() - 1) / 9 + 1)));
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        builder.setGuiTint(this.guiTint);
        if (this.headerItem != null) {
            builder.widget(new ItemDrawable(this.headerItem).asWidget().setPos(5, 5).setSize(16, 16));
        }
        builder.widget(new TextWidget(this.header).setDefaultColor(this.COLOR_TITLE.get().intValue()).setPos(25, 9));
        int currentSlotX = 9 + this.getFontRenderer().func_78256_a(StatCollector.func_74838_a((String)"GT5U.gui.select.current"));
        int currentSlotY = 24;
        ((ModularWindow.Builder)builder.widget(new DrawableWidget(){

            public void onScreenUpdate() {
                super.onScreenUpdate();
                if (SelectItemUIFactory.this.currentGetter != null) {
                    ItemStack current = (ItemStack)SelectItemUIFactory.this.currentGetter.get();
                    SelectItemUIFactory.this.selected = GTUtility.findMatchingStackInList(SelectItemUIFactory.this.stacks, current);
                }
            }
        }.setDrawable((IDrawable)GTUITextures.SLOT_DARK_GRAY).setPos(currentSlotX, currentSlotY).setSize(18, 18))).widget(new ItemDrawable(() -> this.getCandidate(this.getSelected())).asWidgetWithTooltip().setPos(currentSlotX + 1, currentSlotY + 1));
        builder.widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.select.current")).setDefaultColor(this.COLOR_TEXT_GRAY.get().intValue()).setPos(8, 25 + (18 - this.getFontRenderer().field_78288_b) / 2));
        int i = 0;
        while (i < this.stacks.size()) {
            final int index = i++;
            builder.widget(new ButtonWidget(){

                public void draw(float partialTicks) {
                    GlStateManager.pushMatrix();
                    GlStateManager.translate((float)0.0f, (float)0.0f, (float)(150 * this.getWindowLayer()));
                    new ItemDrawable((ItemStack)SelectItemUIFactory.this.stacks.get(index)).draw(1.0f, 1.0f, 16.0f, 16.0f, partialTicks);
                    GlStateManager.popMatrix();
                }
            }.setOnClick((clickData, widget) -> {
                if (clickData.mouseButton == 0) {
                    this.setSelected(index, (Widget)widget);
                } else {
                    this.setSelected(-1, (Widget)widget);
                }
                this.selectedCallback.accept(this.getCandidate(this.getSelected()));
                if (clickData.shift) {
                    widget.getWindow().tryClose();
                }
            }).setSynced(false, false).dynamicTooltip(() -> this.getItemTooltips(index)).setUpdateTooltipEveryTick(true).setBackground(() -> new IDrawable[]{index == this.selected ? GTUITextures.SLOT_DARK_GRAY : ModularUITextures.ITEM_SLOT}).setPos(7 + 18 * (index % 9), 43 + 18 * (index / 9)).setSize(18, 18));
        }
        if (this.anotherWindow) {
            this.dialogOpened.set(true);
            builder.widget(new ButtonWidget(){

                public void onDestroy() {
                    SelectItemUIFactory.this.dialogOpened.set(false);
                }
            }.setOnClick((clickData, widget) -> widget.getWindow().tryClose()).setSynced(false, false).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, new Text("x")}).setPos(this.getGUIWidth() - 15, 3).setSize(12, 12));
        }
        return builder.build();
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected, Widget widget) {
        if (selected == this.selected) {
            return;
        }
        int newSelected = GTUtility.clamp(selected, -1, this.stacks.size() - 1);
        if (this.noDeselect && newSelected == -1) {
            return;
        }
        this.selected = newSelected;
    }

    protected List<String> getItemTooltips(int index) {
        return GuiHelper.getItemTooltip((ItemStack)this.stacks.get(index));
    }

    private ItemStack getCandidate(int listIndex) {
        return listIndex < 0 || listIndex >= this.stacks.size() ? null : this.stacks.get(listIndex);
    }

    private FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private int getGUIWidth() {
        return 176;
    }
}

