/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedWirelessRedstoneBase;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public abstract class CoverAdvancedRedstoneTransmitterBase
extends CoverAdvancedWirelessRedstoneBase {
    protected boolean invert;

    public CoverAdvancedRedstoneTransmitterBase(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public boolean isInverted() {
        return this.invert;
    }

    public CoverAdvancedRedstoneTransmitterBase setInverted(boolean inverted) {
        this.invert = inverted;
        return this;
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        this.invert = false;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        super.loadFromNbt(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.invert = tag.func_74767_n("invert");
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        super.readFromPacket(byteData);
        this.invert = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74757_a("invert", this.invert);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeToByteBuf(byteBuf);
        byteBuf.writeBoolean(this.invert);
    }

    private void unregisterSignal() {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        CoverPosition key = CoverAdvancedRedstoneTransmitterBase.getCoverKey(coverable, this.coverSide);
        CoverAdvancedRedstoneTransmitterBase.removeSignalAt(this.uuid, this.frequency, key);
    }

    @Override
    public void onCoverRemoval() {
        this.unregisterSignal();
    }

    @Override
    public void onBaseTEDestroyed() {
        this.unregisterSignal();
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.invert = !this.invert;
        GTUtility.sendChatToPlayer(aPlayer, this.invert ? GTUtility.trans("054", "Inverted") : GTUtility.trans("055", "Normal"));
    }

    @Override
    public void preDataChanged(Cover newCover) {
        if (newCover instanceof CoverAdvancedRedstoneTransmitterBase) {
            CoverAdvancedRedstoneTransmitterBase newTransmitterCover = (CoverAdvancedRedstoneTransmitterBase)newCover;
            if (!Objects.equals(this.frequency, newTransmitterCover.frequency) || !Objects.equals(this.uuid, newTransmitterCover.uuid)) {
                this.unregisterSignal();
            }
        }
    }
}

