/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.common.covers.redstone.CoverAdvancedWirelessRedstoneBase;
import gregtech.common.gui.mui1.cover.AdvancedRedstoneReceiverBaseUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public abstract class CoverAdvancedRedstoneReceiverBase
extends CoverAdvancedWirelessRedstoneBase {
    private GateMode mode;

    public CoverAdvancedRedstoneReceiverBase(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public GateMode getGateMode() {
        return this.mode;
    }

    public CoverAdvancedRedstoneReceiverBase setMode(GateMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        this.mode = GateMode.AND;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        super.loadFromNbt(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.mode = GateMode.values()[tag.func_74771_c("mode")];
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        super.readFromPacket(byteData);
        this.mode = GateMode.values()[byteData.readByte()];
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74774_a("mode", (byte)this.mode.ordinal());
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeToByteBuf(byteBuf);
        byteBuf.writeByte(this.mode.ordinal());
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new AdvancedRedstoneReceiverBaseUIFactory(buildContext).createWindow();
    }

    public static enum GateMode {
        AND,
        NAND,
        OR,
        NOR,
        SINGLE_SOURCE;

    }
}

