/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverVent
extends CoverLegacyData {
    private final int mEfficiency;
    private final Fluid IC2_HOT_COOLANT = FluidRegistry.getFluid((String)"ic2hotcoolant");
    private final Fluid IC2_COOLANT = FluidRegistry.getFluid((String)"ic2coolant");

    public CoverVent(CoverContext context, int aEfficiency) {
        super(context);
        this.mEfficiency = aEfficiency;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (this.coverSide == ForgeDirection.UNKNOWN) {
            this.coverData = 0;
            return;
        }
        if (coverable instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)coverable;
            this.coverData = this.doCoolFluid(this.coverSide, coverable, fluidHandler);
        }
        if (coverable instanceof IMachineProgress) {
            IMachineProgress machine = (IMachineProgress)((Object)coverable);
            this.coverData = this.doProgressEfficiency(this.coverSide, machine, this.coverID);
        }
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 100;
    }

    protected int doProgressEfficiency(ForgeDirection coverSide, IMachineProgress coverable, int coverData) {
        int offsetX = coverable.getOffsetX(coverSide, 1);
        short offsetY = coverable.getOffsetY(coverSide, 1);
        int offsetZ = coverable.getOffsetZ(coverSide, 1);
        World world = coverable.getWorld();
        if (coverable.hasThingsToDo() && coverData != coverable.getProgress() && !GTUtility.hasBlockHitBox(world, offsetX, offsetY, offsetZ)) {
            coverable.increaseProgress(this.mEfficiency);
        }
        return coverable.getProgress();
    }

    protected int doCoolFluid(ForgeDirection coverSide, ICoverable coverable, IFluidHandler fluidHandler) {
        int chances;
        block12: {
            block13: {
                Block blockAtSide;
                World world;
                int offsetZ;
                short offsetY;
                int offsetX;
                block11: {
                    int n;
                    offsetX = coverable.getOffsetX(coverSide, 1);
                    offsetY = coverable.getOffsetY(coverSide, 1);
                    offsetZ = coverable.getOffsetZ(coverSide, 1);
                    world = coverable.getWorld();
                    if (!fluidHandler.canDrain(ForgeDirection.UNKNOWN, this.IC2_HOT_COOLANT)) {
                        return 0;
                    }
                    blockAtSide = coverable.getBlockAtSide(coverSide);
                    if (blockAtSide == null) {
                        return 0;
                    }
                    if (blockAtSide != Blocks.field_150355_j && blockAtSide != Blocks.field_150358_i) break block11;
                    switch (this.mEfficiency) {
                        case 3: {
                            n = 10000;
                            break;
                        }
                        case 2: {
                            n = 5000;
                            break;
                        }
                        default: {
                            n = 2500;
                        }
                    }
                    chances = n;
                    break block12;
                }
                if (!blockAtSide.isAir((IBlockAccess)world, offsetX, (int)offsetY, offsetZ)) break block13;
                switch (this.mEfficiency) {
                    case 3: {
                        chances = 2500;
                        break block12;
                    }
                    case 2: {
                        chances = 1250;
                        break block12;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            return 0;
        }
        if (chances > XSTR.XSTR_INSTANCE.nextInt(10000)) {
            FluidStack hotFluidStack = fluidHandler.drain(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, true);
            FluidStack coldFluidStack = new FluidStack(this.IC2_COOLANT, hotFluidStack.amount);
            fluidHandler.fill(ForgeDirection.UNKNOWN, coldFluidStack, true);
            return hotFluidStack.amount;
        }
        return 0;
    }
}

