/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.ShutterUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;

public class CoverShutter
extends CoverLegacyData {
    public CoverShutter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 4;
        if (this.coverData < 0) {
            this.coverData = 3;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("082", "Open if work enabled"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("083", "Open if work disabled"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("084", "Only Output allowed"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("085", "Only Input allowed"));
            }
        }
        Object t = this.coveredTile.get();
        if (t instanceof BaseMetaPipeEntity) {
            BaseMetaPipeEntity bmpe = (BaseMetaPipeEntity)t;
            bmpe.reloadLocks();
        }
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return this.shouldAllow(3);
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return this.shouldAllow(2);
    }

    @Override
    public boolean letsEnergyIn() {
        return this.shouldAllow(3);
    }

    @Override
    public boolean letsEnergyOut() {
        return this.shouldAllow(2);
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return this.shouldAllow(3);
    }

    @Override
    public boolean letsFluidOut(Fluid fluid) {
        return this.shouldAllow(2);
    }

    @Override
    public boolean letsItemsIn(int slot) {
        return this.shouldAllow(3);
    }

    @Override
    public boolean letsItemsOut(int slot) {
        return this.shouldAllow(2);
    }

    private boolean shouldAllow(int shutterMode) {
        IMachineProgress machine;
        if (this.coverData >= 2) {
            return this.coverData == shutterMode;
        }
        Object t = this.coveredTile.get();
        return !(t instanceof IMachineProgress) || (machine = (IMachineProgress)t).isAllowedToWork() == (this.coverData % 2 == 0);
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ShutterUIFactory(buildContext).createWindow();
    }
}

