/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.ItemMeterUIFactory;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverItemMeter
extends Cover {
    private boolean inverted;
    private int slot;
    private int threshold;

    public CoverItemMeter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
        this.initializeData(context.getCoverInitializer());
    }

    public int getSlot() {
        return this.slot;
    }

    public CoverItemMeter setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public CoverItemMeter setInverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public CoverItemMeter setThresdhold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    protected void initializeData() {
        this.inverted = false;
        this.slot = -1;
        this.threshold = 0;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.inverted = tag.func_74767_n("invert");
        this.slot = tag.func_74762_e("slot");
        this.threshold = tag.func_74762_e("threshold");
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        this.inverted = byteData.readBoolean();
        this.slot = byteData.readInt();
        this.threshold = byteData.readInt();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("invert", this.inverted);
        tag.func_74768_a("slot", this.slot);
        tag.func_74768_a("threshold", this.threshold);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeBoolean(this.inverted);
        byteBuf.writeInt(this.slot);
        byteBuf.writeInt(this.threshold);
    }

    public static byte computeSignalBasedOnItems(ICoverable tileEntity, boolean inverted, int threshold, int slot, int ordinalSide) {
        long max = 0L;
        long used = 0L;
        IMetaTileEntity mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
        if (mte instanceof MTEDigitalChestBase) {
            MTEDigitalChestBase dc = (MTEDigitalChestBase)mte;
            max = dc.getMaxItemCount();
            used = dc.getProgresstime();
        } else if (mte instanceof MTEHatchOutputBusME) {
            if (((MTEHatchOutputBusME)mte).canAcceptItem()) {
                max = 64L;
                used = 0L;
            }
        } else {
            int[] slots;
            int[] nArray;
            if (slot >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = slot;
            } else {
                nArray = tileEntity.func_94128_d(ordinalSide);
            }
            for (int i : slots = nArray) {
                if (i < 0 || i >= tileEntity.func_70302_i_()) continue;
                max += 64L;
                ItemStack stack = tileEntity.func_70301_a(i);
                if (stack == null) continue;
                used += ((long)stack.field_77994_a << 6) / (long)stack.func_77976_d();
            }
        }
        return GTUtility.convertRatioToRedstone(used, max, threshold, inverted);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null) {
            byte signal = CoverItemMeter.computeSignalBasedOnItems(coverable, this.inverted, this.threshold, this.slot, this.coverSide.ordinal());
            coverable.setOutputRedstoneSignal(this.coverSide, signal);
        }
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (this.inverted) {
                this.inverted = false;
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("055", "Normal"));
            } else {
                this.inverted = true;
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("054", "Inverted"));
            }
        } else {
            ++this.slot;
            if (this.slot > coverable.func_70302_i_()) {
                this.slot = -1;
            }
            if (this.slot == -1) {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("053", "Slot: ") + GTUtility.trans("ALL", "All"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("053", "Slot: ") + this.slot);
            }
        }
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public int getDefaultTickRate() {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ItemMeterUIFactory(buildContext).createWindow();
    }
}

