/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.FluidFilterUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CoverFluidfilter
extends Cover {
    private final int FILTER_INPUT_DENY_OUTPUT = 0;
    private final int INVERT_INPUT_DENY_OUTPUT = 1;
    private final int FILTER_INPUT_ANY_OUTPUT = 2;
    private final int INVERT_INPUT_ANY_OUTPUT = 3;
    private final int DENY_INPUT_FILTER_OUTPUT = 4;
    private final int DENY_INPUT_INVERT_OUTPUT = 5;
    private final int ANY_INPUT_FILTER_OUTPUT = 6;
    private final int ANY_INPUT_INVERT_OUTPUT = 7;
    private int mFluidID;
    private int mFilterMode;

    public CoverFluidfilter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
        this.initializeData(context.getCoverInitializer());
    }

    public int getFluidId() {
        return this.mFluidID;
    }

    public CoverFluidfilter setFluidId(int fluidId) {
        this.mFluidID = fluidId;
        return this;
    }

    public int getFilterMode() {
        return this.mFilterMode;
    }

    public CoverFluidfilter setFilterMode(int filterMode) {
        this.mFilterMode = filterMode;
        return this;
    }

    @Override
    protected void initializeData() {
        this.mFluidID = -1;
        this.mFilterMode = 0;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tNBT = (NBTTagCompound)nbt;
            this.mFilterMode = tNBT.func_74762_e("mFilterMode");
            this.mFluidID = tNBT.func_150297_b("mFluid", 8) ? FluidRegistry.getFluidID((String)tNBT.func_74779_i("mFluid")) : -1;
        } else {
            this.initializeData();
        }
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        this.mFilterMode = byteData.readByte();
        this.mFluidID = byteData.readInt();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74768_a("mFilterMode", this.mFilterMode);
        if (this.mFluidID >= 0) {
            tNBT.func_74778_a("mFluid", FluidRegistry.getFluid((int)this.mFluidID).getName());
        }
        return tNBT;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.mFilterMode).writeInt(this.mFluidID);
    }

    @Override
    public String getDescription() {
        Fluid fluid = FluidRegistry.getFluid((int)this.mFluidID);
        if (fluid == null) {
            return "";
        }
        FluidStack sFluid = new FluidStack(fluid, 1000);
        return String.format("Filtering Fluid: %s - %s", sFluid.getLocalizedName(), this.getFilterMode(this.mFilterMode));
    }

    public String getFilterMode(int aFilterMode) {
        String string;
        switch (aFilterMode) {
            case 0: {
                string = GTUtility.trans("043", "Filter input, Deny output");
                break;
            }
            case 1: {
                string = GTUtility.trans("044", "Invert input, Deny output");
                break;
            }
            case 2: {
                string = GTUtility.trans("045", "Filter input, Permit any output");
                break;
            }
            case 3: {
                string = GTUtility.trans("046", "Invert input, Permit any output");
                break;
            }
            case 4: {
                string = GTUtility.trans("307", "Deny input, Filter output");
                break;
            }
            case 5: {
                string = GTUtility.trans("308", "Deny input, Invert output");
                break;
            }
            case 6: {
                string = GTUtility.trans("309", "Permit any input, Filter output");
                break;
            }
            case 7: {
                string = GTUtility.trans("310", "Permit any input, Invert output");
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFilterMode = (this.mFilterMode + (aPlayer.func_70093_af() ? -1 : 1)) % 8;
        if (this.mFilterMode < 0) {
            this.mFilterMode = 7;
        }
        GTUtility.sendChatToPlayer(aPlayer, this.getFilterMode(this.mFilterMode));
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.coverSide == ForgeDirection.UNKNOWN) {
            return false;
        }
        if ((double)aX > 0.375 && (double)aX < 0.625 || this.coverSide.offsetX != 0 && (double)aY > 0.375 && (double)aY < 0.625 || (this.coverSide.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0 && (double)aZ > 0.375 && (double)aZ < 0.625 || this.coverSide.offsetZ != 0) {
            ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
            if (tStack == null) {
                return true;
            }
            FluidStack tFluid = GTUtility.getFluidForFilledItem(tStack, true);
            if (tFluid != null) {
                int aFluid;
                this.mFluidID = aFluid = tFluid.getFluidID();
                FluidStack sFluid = new FluidStack(FluidRegistry.getFluid((int)aFluid), 1000);
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("047", "Filter Fluid: ") + sFluid.getLocalizedName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = this.mFilterMode;
        int aFilterFluid = this.mFluidID;
        if (aFilterMode == 4 || aFilterMode == 5) {
            return false;
        }
        if (aFilterMode == 6 || aFilterMode == 7) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 0 || aFilterMode == 2;
        }
        return aFilterMode == 1 || aFilterMode == 3;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = this.mFilterMode;
        int aFilterFluid = this.mFluidID;
        if (aFilterMode == 0 || aFilterMode == 1) {
            return false;
        }
        if (aFilterMode == 2 || aFilterMode == 3) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 4 || aFilterMode == 6;
        }
        return aFilterMode == 5 || aFilterMode == 7;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new FluidFilterUIFactory(buildContext).createWindow();
    }
}

