/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.FluidRegulatorUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CoverFluidRegulator
extends Cover {
    public static final int TICK_RATE_MIN = 1;
    public static final int TICK_RATE_MAX = 2048;
    public final int mTransferRate;
    private boolean allowFluid = false;
    private int tickRate;
    private int speed;
    private Conditional condition;

    public CoverFluidRegulator(CoverContext context, int aTransferRate, ITexture coverTexture) {
        super(context, coverTexture);
        this.mTransferRate = aTransferRate;
        this.initializeData(context.getCoverInitializer());
    }

    public int getTransferRate() {
        return this.mTransferRate;
    }

    public int getTickRateForUi() {
        return this.tickRate;
    }

    public CoverFluidRegulator setTickRateForUi(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public int getSpeed() {
        return this.speed;
    }

    public CoverFluidRegulator setSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    public Conditional getCondition() {
        return this.condition;
    }

    public CoverFluidRegulator setCondition(Conditional condition) {
        this.condition = condition;
        return this;
    }

    @Override
    protected void initializeData() {
        this.tickRate = 1;
        this.speed = 0;
        this.condition = Conditional.Always;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        if (!(nbt instanceof NBTTagCompound)) {
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.speed = tag.func_74762_e("mSpeed");
        this.tickRate = tag.func_74762_e("mTickRate");
        this.condition = Conditional.VALUES[tag.func_74771_c("mCondition")];
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        this.tickRate = byteData.readInt();
        this.speed = byteData.readInt();
        this.condition = Conditional.VALUES[byteData.readUnsignedByte()];
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("mSpeed", this.speed);
        tag.func_74768_a("mTickRate", this.tickRate);
        tag.func_74774_a("mCondition", (byte)this.condition.ordinal());
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.tickRate).writeInt(this.speed).writeByte(this.condition.ordinal());
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return this.condition.isRedstoneSensitive();
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null || this.speed == 0 || !this.condition.isAllowedToWork(this.coverSide, this.coverID, coverable)) {
            return;
        }
        if (coverable instanceof IFluidHandler) {
            ForgeDirection directionFrom;
            IFluidHandler tTank1;
            IFluidHandler tTank2;
            IFluidHandler fluidHandler = (IFluidHandler)coverable;
            if (this.speed > 0) {
                tTank2 = coverable.getITankContainerAtSide(this.coverSide);
                tTank1 = fluidHandler;
                directionFrom = this.coverSide;
            } else {
                tTank1 = coverable.getITankContainerAtSide(this.coverSide);
                tTank2 = fluidHandler;
                directionFrom = this.coverSide.getOpposite();
            }
            if (tTank1 != null && tTank2 != null) {
                this.allowFluid = true;
                GTUtility.moveFluid(tTank1, tTank2, directionFrom, Math.abs(this.speed), this::canTransferFluid);
                this.allowFluid = false;
            }
        }
    }

    private String getScredriverClickChat() {
        if (Math.abs(this.speed) > this.mTransferRate * this.tickRate) {
            this.speed = this.mTransferRate * this.tickRate * (this.speed > 0 ? 1 : -1);
            return GTUtility.trans("316", "Pump speed limit reached!");
        }
        if (this.tickRate == 1) {
            return GTUtility.trans("048", "Pump speed: ") + this.speed + GTUtility.trans("049", "L/tick ") + this.speed * 20 + GTUtility.trans("050", "L/sec");
        }
        return String.format(GTUtility.trans("207", "Pump speed: %dL every %d ticks, %.2f L/sec on average"), this.speed, this.tickRate, (double)this.speed * 20.0 / (double)this.tickRate);
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step;
        int n = step = aPlayer.func_70093_af() ? 256 : 16;
        this.speed = this.faceClickedOnRightSide(aX, aY, aZ) ? (this.speed += step) : (this.speed -= step);
        GTUtility.sendChatToPlayer(aPlayer, this.getScredriverClickChat());
    }

    private boolean faceClickedOnRightSide(float aX, float aY, float aZ) {
        return GTUtility.getClickedFacingCoords(this.coverSide, aX, aY, aZ)[0] >= 0.5f;
    }

    protected boolean canTransferFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return this.allowFluid;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return this.allowFluid;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return this.tickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new FluidRegulatorUIFactory(buildContext).createWindow();
    }

    @Override
    public boolean allowsTickRateAddition() {
        return false;
    }

    public static enum Conditional {
        Always(false){

            @Override
            boolean isAllowedToWork(ForgeDirection coverSide, int coverID, ICoverable coverable) {
                return true;
            }
        }
        ,
        Conditional(true){

            @Override
            boolean isAllowedToWork(ForgeDirection coverSide, int coverID, ICoverable coverable) {
                return !(coverable instanceof IMachineProgress) || ((IMachineProgress)((Object)coverable)).isAllowedToWork();
            }
        }
        ,
        Inverted(true){

            @Override
            boolean isAllowedToWork(ForgeDirection coverSide, int coverID, ICoverable coverable) {
                return !(coverable instanceof IMachineProgress) || !((IMachineProgress)((Object)coverable)).isAllowedToWork();
            }
        };

        static final Conditional[] VALUES;
        private final boolean redstoneSensitive;

        private Conditional(boolean redstoneSensitive) {
            this.redstoneSensitive = redstoneSensitive;
        }

        abstract boolean isAllowedToWork(ForgeDirection var1, int var2, ICoverable var3);

        boolean isRedstoneSensitive() {
            return this.redstoneSensitive;
        }

        static {
            VALUES = gregtech.common.covers.CoverFluidRegulator$Conditional.values();
        }
    }
}

