/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.covers.CoverContext;
import gregtech.api.covers.CoverPlacementPredicate;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTByteBuffer;
import gregtech.api.util.GTRenderingWorld;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.FacadeBaseUIFactory;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class CoverFacadeBase
extends Cover {
    ItemStack mStack;
    int mFlags;

    public static CoverPlacementPredicate isCoverPlaceable(Function<ItemStack, Block> getTargetBlock, Function<ItemStack, Integer> getTargetmeta) {
        return (side, coverItem, coverable) -> {
            Block targetBlock = (Block)getTargetBlock.apply(coverItem);
            if (targetBlock == null) {
                return false;
            }
            for (ForgeDirection iSide : ForgeDirection.VALID_DIRECTIONS) {
                Block facadeBlock;
                Cover cover;
                if (iSide == side || !(cover = coverable.getCoverAtSide(iSide)).isValid() || (facadeBlock = cover.getFacadeBlock()) == null) continue;
                if (facadeBlock != targetBlock) {
                    return false;
                }
                if (cover.getFacadeMeta() == ((Integer)getTargetmeta.apply(coverItem)).intValue()) continue;
                return false;
            }
            return true;
        };
    }

    public CoverFacadeBase(CoverContext context) {
        super(context, null);
        this.initializeData(context.getCoverInitializer());
    }

    public ItemStack getStack() {
        return this.mStack;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public CoverFacadeBase setFlags(int flags) {
        this.mFlags = flags;
        return this;
    }

    @Override
    protected void initializeData() {
        this.mStack = null;
        this.mFlags = 0;
    }

    @Override
    public void loadFromItemStack(@NotNull ItemStack cover) {
        this.mStack = GTUtility.copyAmount(1, cover);
        this.mFlags = 0;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.mStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mStack"));
        this.mFlags = tag.func_74771_c("mFlags");
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        this.mFlags = byteData.readByte();
        this.mStack = GTByteBuffer.readItemStackFromGreggyByteBuf(byteData);
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.mStack != null) {
            tag.func_74782_a("mStack", (NBTBase)this.mStack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74774_a("mFlags", (byte)this.mFlags);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.mFlags);
        ByteBufUtils.writeItemStack((ByteBuf)byteBuf, (ItemStack)this.mStack);
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFlags = this.mFlags + 1 & 0xF;
        GTUtility.sendChatToPlayer(aPlayer, ((this.mFlags & 1) != 0 ? GTUtility.trans("128.1", "Redstone ") : "") + ((this.mFlags & 2) != 0 ? GTUtility.trans("129.1", "Energy ") : "") + ((this.mFlags & 4) != 0 ? GTUtility.trans("130.1", "Fluids ") : "") + ((this.mFlags & 8) != 0 ? GTUtility.trans("131.1", "Items ") : ""));
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return (this.mFlags & 1) != 0;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return (this.mFlags & 1) != 0;
    }

    @Override
    public boolean letsEnergyIn() {
        return (this.mFlags & 2) != 0;
    }

    @Override
    public boolean letsEnergyOut() {
        return (this.mFlags & 2) != 0;
    }

    @Override
    public boolean letsFluidIn(Fluid fluid) {
        return (this.mFlags & 4) != 0;
    }

    @Override
    public boolean letsFluidOut(Fluid fluid) {
        return (this.mFlags & 4) != 0;
    }

    @Override
    public boolean letsItemsIn(int slot) {
        return (this.mFlags & 8) != 0;
    }

    @Override
    public boolean letsItemsOut(int slot) {
        return (this.mFlags & 8) != 0;
    }

    @Override
    public void onPlayerAttach(EntityPlayer player, ItemStack coverItem) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && coverable.isClientSide()) {
            GTRenderingWorld.register(coverable.getXCoord(), coverable.getYCoord(), coverable.getZCoord(), this.getTargetBlock(coverItem), this.getTargetMeta(coverItem));
        }
    }

    @Override
    public ItemStack asItemStack() {
        return this.mStack;
    }

    @Override
    public ITexture getOverlayTexture() {
        return this.getSpecialFaceTexture();
    }

    @Override
    public ITexture getSpecialFaceTexture() {
        if (GTUtility.isStackInvalid(this.mStack)) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        Block block = this.getTargetBlock(this.mStack);
        if (block == null) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        if (block.func_149701_w() != 0) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        return TextureFactory.builder().setFromBlock(block, this.getTargetMeta(this.mStack)).useWorldCoord().setFromSide(this.coverSide).build();
    }

    @Override
    public Block getFacadeBlock() {
        if (GTUtility.isStackInvalid(this.mStack)) {
            return null;
        }
        return this.getTargetBlock(this.mStack);
    }

    @Override
    public int getFacadeMeta() {
        if (GTUtility.isStackInvalid(this.mStack)) {
            return 0;
        }
        return this.getTargetMeta(this.mStack);
    }

    protected abstract Block getTargetBlock(ItemStack var1);

    protected abstract int getTargetMeta(ItemStack var1);

    @Override
    public boolean isDataNeededOnClient() {
        return true;
    }

    @Override
    public void onDataChanged() {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && coverable.isClientSide()) {
            GTRenderingWorld.register(coverable.getXCoord(), coverable.getYCoord(), coverable.getZCoord(), this.getTargetBlock(this.mStack), this.getTargetMeta(this.mStack));
        }
    }

    @Override
    public void onCoverRemoval() {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && coverable.isClientSide()) {
            for (ForgeDirection iSide : ForgeDirection.VALID_DIRECTIONS) {
                if (iSide == this.coverSide || !(coverable.getCoverAtSide(iSide) instanceof CoverFacadeBase)) continue;
                return;
            }
            if (this.mStack != null) {
                GTRenderingWorld.unregister(coverable.getXCoord(), coverable.getYCoord(), coverable.getZCoord(), this.getTargetBlock(this.mStack), this.getTargetMeta(this.mStack));
            }
        }
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null) {
            coverable.issueCoverUpdate(this.coverSide);
        }
        return false;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new FacadeBaseUIFactory(buildContext).createWindow();
    }
}

