/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.covers.CoverContext;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverDrain
extends CoverLegacyData {
    public CoverDrain(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (this.coverData % 3 > 1 && coverable instanceof IMachineProgress && ((IMachineProgress)((Object)coverable)).isAllowedToWork()) {
            return;
        }
        if (this.coverSide != ForgeDirection.UNKNOWN) {
            Block tBlock = coverable.getBlockAtSide(this.coverSide);
            if (this.coverData < 3 && coverable instanceof IFluidHandler) {
                int tAmount;
                if (this.coverSide == ForgeDirection.UP && coverable.getWorld().func_72896_J() && coverable.getWorld().func_72874_g(coverable.getXCoord(), coverable.getZCoord()) - 2 < coverable.getYCoord() && (tAmount = (int)(coverable.getBiome().field_76751_G * 10.0f)) > 0) {
                    ((IFluidHandler)coverable).fill(this.coverSide, Materials.Water.getFluid(coverable.getWorld().func_72911_I() ? (long)tAmount * 2L : (long)tAmount), true);
                }
                FluidStack tLiquid = null;
                if (tBlock != null) {
                    if ((tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) && coverable.getMetaIDAtSide(this.coverSide) == 0) {
                        tLiquid = Materials.Water.getFluid(1000L);
                    } else if ((tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) && coverable.getMetaIDAtSide(this.coverSide) == 0) {
                        tLiquid = Materials.Lava.getFluid(1000L);
                    } else if (tBlock instanceof IFluidBlock) {
                        tLiquid = ((IFluidBlock)tBlock).drain(coverable.getWorld(), coverable.getOffsetX(this.coverSide, 1), (int)coverable.getOffsetY(this.coverSide, 1), coverable.getOffsetZ(this.coverSide, 1), false);
                    }
                    if (tLiquid != null && tLiquid.getFluid() != null && ((this.coverSide.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 || this.coverSide == ForgeDirection.DOWN && tLiquid.getFluid().getDensity() <= 0 || this.coverSide == ForgeDirection.UP && tLiquid.getFluid().getDensity() >= 0) && ((IFluidHandler)coverable).fill(this.coverSide, tLiquid, false) == tLiquid.amount) {
                        ((IFluidHandler)coverable).fill(this.coverSide, tLiquid, true);
                        coverable.getWorld().func_147468_f(coverable.getXCoord() + this.coverSide.offsetX, coverable.getYCoord() + this.coverSide.offsetY, coverable.getZCoord() + this.coverSide.offsetZ);
                    }
                }
            }
            if (this.coverData >= 3 && tBlock != null && (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k || tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i || tBlock instanceof IFluidBlock)) {
                coverable.getWorld().func_147465_d(coverable.getOffsetX(this.coverSide, 1), (int)coverable.getOffsetY(this.coverSide, 1), coverable.getOffsetZ(this.coverSide, 1), Blocks.field_150350_a, 0, 0);
            }
        }
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 6;
        if (this.coverData < 0) {
            this.coverData = 5;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("022", "Import"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("023", "Import (conditional)"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("024", "Import (invert cond)"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("025", "Keep Liquids Away"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("026", "Keep Liquids Away (conditional)"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("027", "Keep Liquids Away (invert cond)"));
            }
        }
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        IMachineProgress machine;
        Object t = this.coveredTile.get();
        return (t instanceof IMachineProgress && (machine = (IMachineProgress)t).isAllowedToWork()) == this.coverData < 2;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return this.coverData < 3 ? 50 : 1;
    }
}

