/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.metatileentity.implementations.MTEFluidPipe;
import gregtech.api.metatileentity.implementations.MTEFrame;
import gregtech.api.metatileentity.implementations.MTEItemPipe;
import gregtech.api.util.GTItsNotMyFaultException;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.storage.MTEDigitalTankBase;
import gregtech.common.tileentities.storage.MTESuperChest;
import gregtech.common.tileentities.storage.MTESuperTank;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GTPPMTEFluidPipe;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemMachines
extends ItemBlock
implements IFluidContainerItem {
    public ItemMachines(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(GregTechAPI.TAB_GREGTECH);
    }

    public static IMetaTileEntity getMetaTileEntity(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return null;
        }
        if (!(aStack.func_77973_b() instanceof ItemMachines)) {
            return null;
        }
        if (aStack.func_77960_j() < 0 || aStack.func_77960_j() > GregTechAPI.METATILEENTITIES.length) {
            return null;
        }
        return GregTechAPI.METATILEENTITIES[aStack.func_77960_j()];
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        try {
            NBTTagCompound aNBT;
            int tDamage = this.getDamage(aStack);
            if (tDamage <= 0 || tDamage >= GregTechAPI.METATILEENTITIES.length) {
                return;
            }
            if (GregTechAPI.METATILEENTITIES[tDamage] != null) {
                IMetaTileEntity tMetaTileEntity;
                IGregTechTileEntity tTileEntity = GregTechAPI.METATILEENTITIES[tDamage].getBaseMetaTileEntity();
                if (!GregTechAPI.sPostloadFinished && tTileEntity.getMetaTileEntity() instanceof ISecondaryDescribable) {
                    String[] tSecondaryDescription = ((ISecondaryDescribable)((Object)tTileEntity.getMetaTileEntity())).getSecondaryDescription();
                    this.addDescription(null, tSecondaryDescription, tDamage, "_Secondary");
                }
                String tSuffix = (tMetaTileEntity = tTileEntity.getMetaTileEntity()) instanceof ISecondaryDescribable && ((ISecondaryDescribable)((Object)tMetaTileEntity)).isDisplaySecondaryDescription() ? "_Secondary" : "";
                this.addDescription(aList, tTileEntity.getDescription(), tDamage, tSuffix);
                tMetaTileEntity.addAdditionalTooltipInformation(aStack, aList);
            }
            if ((aNBT = aStack.func_77978_p()) != null) {
                if (aNBT.func_74767_n("mMuffler")) {
                    aList.add(GTLanguageManager.addStringLocalization("GT_TileEntity_MUFFLER", "has Muffler Upgrade"));
                }
                if (aNBT.func_74767_n("mSteamConverter")) {
                    aList.add(GTLanguageManager.addStringLocalization("GT_TileEntity_STEAMCONVERTER", "has Steam Upgrade"));
                }
                byte tAmount = 0;
                tAmount = aNBT.func_74771_c("mSteamTanks");
                if (tAmount > 0) {
                    aList.add(tAmount + " " + GTLanguageManager.addStringLocalization("GT_TileEntity_STEAMTANKS", "Steam Tank Upgrades"));
                }
                CoverableTileEntity.addInstalledCoversInformation(aNBT, aList);
                if (aNBT.func_74764_b("mColor") && aNBT.func_74771_c("mColor") != -1) {
                    aList.add(GTLanguageManager.addStringLocalization("GT_TileEntity_COLORED", "Colored") + " (" + Dyes.get((int)(aNBT.func_74771_c((String)"mColor") - 1)).formatting + Dyes.get((int)(aNBT.func_74771_c((String)"mColor") - 1)).mName + EnumChatFormatting.GRAY + ")");
                }
            }
        }
        catch (Throwable e) {
            aList.add(String.format("\u00a7cAn exception was thrown while getting this item's info.\u00a7r", new Object[0]));
            aList.add(e.getLocalizedMessage());
            GTMod.GT_FML_LOGGER.error("addInformation", e);
        }
    }

    private void addDescription(@Nullable List<String> aList, @Nullable String[] aDescription, int aDamage, String aSuffix) {
        if (aDescription == null) {
            return;
        }
        int tLength = aDescription.length;
        for (int i = 0; i < tLength; ++i) {
            String tDescLine = aDescription[i];
            if (!GTUtility.isStringValid(tDescLine)) continue;
            String tKey = String.format("TileEntity_DESCRIPTION_%05d%s_Index_%02d", aDamage, aSuffix, i);
            if (tDescLine.contains("%%%")) {
                String[] tSplitStrings = tDescLine.split("%%%");
                StringBuilder tBuffer = new StringBuilder();
                String[] tRep = new String[tSplitStrings.length / 2];
                for (int j = 0; j < tSplitStrings.length; ++j) {
                    if (j % 2 == 0) {
                        tBuffer.append(tSplitStrings[j]);
                        continue;
                    }
                    tBuffer.append("%s");
                    tRep[j / 2] = tSplitStrings[j];
                }
                String tTranslated = GTUtility.formatStringSafe(GTLanguageManager.addStringLocalization(tKey, tBuffer.toString()), tRep);
                if (aList == null) continue;
                aList.add(tTranslated);
                continue;
            }
            String tTranslated = GTLanguageManager.addStringLocalization(tKey, tDescLine);
            if (aList == null) continue;
            aList.add(tTranslated.isEmpty() ? tDescLine : tTranslated);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerDescription(int aDamage) {
        if (aDamage >= GregTechAPI.METATILEENTITIES.length) {
            return;
        }
        if (GregTechAPI.METATILEENTITIES[aDamage] != null) {
            IMetaTileEntity tMetaTileEntity = GregTechAPI.METATILEENTITIES[aDamage].getBaseMetaTileEntity().getMetaTileEntity();
            if (tMetaTileEntity instanceof ISecondaryDescribable) {
                String[] tSecondaryDescription = ((ISecondaryDescribable)((Object)tMetaTileEntity)).getSecondaryDescription();
                this.addDescription(null, tSecondaryDescription, aDamage, "_Secondary");
            }
            this.addDescription(null, tMetaTileEntity.getDescription(), aDamage, "");
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int ordinalSide, float hitX, float hitY, float hitZ) {
        return false;
    }

    public String func_77667_c(ItemStack aStack) {
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage < 0 || tDamage >= GregTechAPI.METATILEENTITIES.length) {
            return "";
        }
        if (GregTechAPI.METATILEENTITIES[tDamage] != null) {
            return this.func_77658_a() + "." + GregTechAPI.METATILEENTITIES[tDamage].getMetaName();
        }
        return "";
    }

    public String func_77653_i(ItemStack aStack) {
        String aName = super.func_77653_i(aStack);
        short aDamage = (short)this.getDamage(aStack);
        if (aDamage >= 0 && aDamage < GregTechAPI.METATILEENTITIES.length && GregTechAPI.METATILEENTITIES[aDamage] != null) {
            Materials aMaterial = null;
            IMetaTileEntity iMetaTileEntity = GregTechAPI.METATILEENTITIES[aDamage];
            if (iMetaTileEntity instanceof MTEItemPipe) {
                MTEItemPipe itemPipe = (MTEItemPipe)iMetaTileEntity;
                aMaterial = itemPipe.mMaterial;
            } else {
                iMetaTileEntity = GregTechAPI.METATILEENTITIES[aDamage];
                if (iMetaTileEntity instanceof GTPPMTEFluidPipe) {
                    GTPPMTEFluidPipe gtppFluidPipe = (GTPPMTEFluidPipe)iMetaTileEntity;
                    aName = gtppFluidPipe.pipeStats.getLocalizedNameForItem(aName);
                } else {
                    iMetaTileEntity = GregTechAPI.METATILEENTITIES[aDamage];
                    if (iMetaTileEntity instanceof MTEFluidPipe) {
                        MTEFluidPipe fluidPipe = (MTEFluidPipe)iMetaTileEntity;
                        aMaterial = fluidPipe.mMaterial;
                    } else {
                        iMetaTileEntity = GregTechAPI.METATILEENTITIES[aDamage];
                        if (iMetaTileEntity instanceof MTECable) {
                            MTECable cable = (MTECable)iMetaTileEntity;
                            aMaterial = cable.mMaterial;
                        } else {
                            iMetaTileEntity = GregTechAPI.METATILEENTITIES[aDamage];
                            if (iMetaTileEntity instanceof MTEFrame) {
                                MTEFrame frame = (MTEFrame)iMetaTileEntity;
                                aMaterial = frame.mMaterial;
                            }
                        }
                    }
                }
            }
            if (aMaterial != null) {
                aName = aMaterial.getLocalizedNameForItem(aName);
            }
        }
        return aName;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        super.func_77622_d(aStack, aWorld, aPlayer);
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage < 0 || tDamage >= GregTechAPI.METATILEENTITIES.length && GregTechAPI.METATILEENTITIES[tDamage] != null) {
            GregTechAPI.METATILEENTITIES[tDamage].onCreated(aStack, aWorld, aPlayer);
        }
    }

    public boolean placeBlockAt(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ, int aMeta) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage > 0) {
            if (GregTechAPI.METATILEENTITIES[tDamage] == null) {
                return false;
            }
            byte tMetaData = GregTechAPI.METATILEENTITIES[tDamage].getTileEntityBaseType();
            if (!aWorld.func_147465_d(aX, aY, aZ, this.field_150939_a, (int)tMetaData, 3)) {
                return false;
            }
            if (aWorld.func_147439_a(aX, aY, aZ) != this.field_150939_a) {
                throw new GTItsNotMyFaultException("Failed to place Block even though World.setBlock returned true. It COULD be MCPC/Bukkit causing that. In case you really have that installed, don't report this Bug to me, I don't know how to fix it.");
            }
            if (aWorld.func_72805_g(aX, aY, aZ) != tMetaData) {
                throw new GTItsNotMyFaultException("Failed to set the MetaValue of the Block even though World.setBlock returned true. It COULD be MCPC/Bukkit causing that. In case you really have that installed, don't report this Bug to me, I don't know how to fix it.");
            }
            IGregTechTileEntity tTileEntity = (IGregTechTileEntity)aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity != null) {
                IMetaTileEntity iMetaTileEntity;
                IGregTechTileEntity aTileEntity;
                tTileEntity.setInitialValuesAsNBT(tTileEntity.isServerSide() ? aStack.func_77978_p() : null, tDamage);
                if (aPlayer != null) {
                    tTileEntity.setOwnerName(aPlayer.getDisplayName());
                    tTileEntity.setOwnerUuid(aPlayer.func_110124_au());
                }
                tTileEntity.getMetaTileEntity().initDefaultModes(aStack.func_77978_p());
                ForgeDirection oppositeSide = side.getOpposite();
                IMetaTileEntity iMetaTileEntity2 = tTileEntity.getMetaTileEntity();
                if (iMetaTileEntity2 instanceof IConnectable) {
                    IConnectable connectable = (IConnectable)((Object)iMetaTileEntity2);
                    connectable.connect(oppositeSide);
                } else if (aPlayer != null && aPlayer.func_70093_af() && (aTileEntity = tTileEntity.getIGregTechTileEntityAtSide(oppositeSide)) != null && (iMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof IConnectable) {
                    IConnectable connectable = (IConnectable)((Object)iMetaTileEntity);
                    connectable.connect(side);
                }
            }
        } else if (!aWorld.func_147465_d(aX, aY, aZ, this.field_150939_a, (int)tDamage, 3)) {
            return false;
        }
        if (aWorld.func_147439_a(aX, aY, aZ) == this.field_150939_a) {
            this.field_150939_a.func_149689_a(aWorld, aX, aY, aZ, (EntityLivingBase)aPlayer, aStack);
            this.field_150939_a.func_149714_e(aWorld, aX, aY, aZ, (int)tDamage);
        }
        return true;
    }

    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        super.func_77663_a(aStack, aWorld, aPlayer, aTimer, aIsInHand);
        short tDamage = (short)this.getDamage(aStack);
        EntityPlayer tPlayer = (EntityPlayer)aPlayer;
        if (GregTechAPI.METATILEENTITIES[tDamage] instanceof MTESuperChest || GregTechAPI.METATILEENTITIES[tDamage] instanceof MTESuperTank) {
            NBTTagCompound tNBT = aStack.field_77990_d;
            if (tNBT == null) {
                return;
            }
            if (tNBT.func_82582_d()) {
                aStack.func_77982_d(null);
                return;
            }
            if (tNBT.func_74764_b("mItemCount") && tNBT.func_74762_e("mItemCount") > 0 || tNBT.func_74764_b("mFluid") && FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l((String)"mFluid")).amount > 64000) {
                FluidStack tFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l("mFluid"));
                int tEffectDuration = 1200;
                if (tFluid != null) {
                    double tFluidAmount = tFluid.amount;
                    double tMiddlePoint = 4096000.0;
                    double tSmoothingCoefficient = 2000000.0;
                    int tMaxDuration = 12000;
                    double tmp = (tFluidAmount - 4096000.0) / 2000000.0;
                    tEffectDuration = (int)(Math.exp(tmp) / (Math.exp(tmp) + Math.exp(-tmp)) * 12000.0);
                }
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, tEffectDuration, 1));
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, tEffectDuration, 1));
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, tEffectDuration, 1));
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, tEffectDuration, 1));
            }
        }
    }

    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound tNBT;
        if (container != null && (tNBT = container.field_77990_d) != null && tNBT.func_150297_b("mFluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l("mFluid"));
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        int tDamage;
        IMetaTileEntity tMetaTile;
        if (container != null && (tMetaTile = GregTechAPI.METATILEENTITIES[tDamage = container.func_77960_j()]) != null) {
            return tMetaTile.getCapacity();
        }
        return 0;
    }

    @Nullable
    private Fluid getLockedFluid(@Nonnull ItemStack container) {
        NBTTagCompound tag = container.field_77990_d;
        if (tag == null) {
            return null;
        }
        String lockedName = tag.func_74779_i("lockedFluidName");
        if (GTUtility.isStringInvalid(lockedName)) {
            return null;
        }
        return FluidRegistry.getFluid((String)lockedName);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container != null && resource != null) {
            int tDamage = container.func_77960_j();
            IMetaTileEntity tMetaTile = GregTechAPI.METATILEENTITIES[tDamage];
            if (!(tMetaTile instanceof MTEDigitalTankBase)) {
                return 0;
            }
            if (container.field_77994_a > 1) {
                return 0;
            }
            if (container.field_77990_d == null) {
                container.field_77990_d = new NBTTagCompound();
            }
            FluidStack tStoredFluid = this.getFluid(container);
            int tCapacity = this.getCapacity(container);
            if (tCapacity <= 0) {
                return 0;
            }
            Fluid lockedFluid = this.getLockedFluid(container);
            if (lockedFluid != null && resource.getFluid() != lockedFluid) {
                return 0;
            }
            if (tStoredFluid != null && tStoredFluid.isFluidEqual(resource)) {
                int tAmount = Math.min(tCapacity - tStoredFluid.amount, resource.amount);
                if (doFill) {
                    FluidStack tNewFluid = new FluidStack(tStoredFluid, tAmount + tStoredFluid.amount);
                    container.field_77990_d.func_74782_a("mFluid", (NBTBase)tNewFluid.writeToNBT(new NBTTagCompound()));
                }
                return tAmount;
            }
            if (tStoredFluid == null) {
                int tAmount = Math.min(tCapacity, resource.amount);
                if (doFill) {
                    FluidStack tNewFluid = new FluidStack(resource, tAmount);
                    container.field_77990_d.func_74782_a("mFluid", (NBTBase)tNewFluid.writeToNBT(new NBTTagCompound()));
                }
                return tAmount;
            }
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container != null && container.func_77942_o()) {
            int tDamage = container.func_77960_j();
            IMetaTileEntity tMetaTile = GregTechAPI.METATILEENTITIES[tDamage];
            if (!(tMetaTile instanceof MTEDigitalTankBase)) {
                return null;
            }
            FluidStack tStoredFluid = this.getFluid(container);
            if (tStoredFluid != null) {
                int tAmount = Math.min(maxDrain, tStoredFluid.amount);
                FluidStack tNewFluid = new FluidStack(tStoredFluid, tStoredFluid.amount - tAmount);
                FluidStack tOutputFluid = new FluidStack(tStoredFluid, tAmount);
                if (doDrain) {
                    if (tNewFluid.amount <= 0) {
                        container.field_77990_d.func_82580_o("mFluid");
                        if (container.field_77990_d.func_82582_d()) {
                            container.func_77982_d(null);
                        }
                    } else {
                        container.field_77990_d.func_74782_a("mFluid", (NBTBase)tNewFluid.writeToNBT(new NBTTagCompound()));
                    }
                }
                return tOutputFluid;
            }
        }
        return null;
    }
}

