/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IBlockWithTextures;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.common.blocks.BlockCasingsAbstract;
import gregtech.common.blocks.ItemCasings;
import gregtech.common.blocks.MaterialCasings;
import gregtech.common.config.Client;
import gregtech.common.render.GTRendererBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class BlockCasings5
extends BlockCasingsAbstract
implements IHeatingCoil,
IBlockWithTextures {
    public static final Supplier<String> COIL_HEAT_TOOLTIP = AnimatedTooltipHandler.translatedText((String)"gt.coilheattooltip");
    public static final Supplier<String> COIL_UNIT_TOOLTIP = AnimatedTooltipHandler.translatedText((String)"gt.coilunittooltip");
    public static final int ACTIVE_OFFSET = 16;

    public BlockCasings5() {
        super(ItemCasings.class, "gt.blockcasings5", MaterialCasings.INSTANCE, 16);
        this.register(0, ItemList.Casing_Coil_Cupronickel, "Cupronickel Coil Block");
        this.register(1, ItemList.Casing_Coil_Kanthal, "Kanthal Coil Block");
        this.register(2, ItemList.Casing_Coil_Nichrome, "Nichrome Coil Block");
        this.register(3, ItemList.Casing_Coil_TungstenSteel, "TPV-Alloy Coil Block");
        this.register(4, ItemList.Casing_Coil_HSSG, "HSS-G Coil Block");
        this.register(5, ItemList.Casing_Coil_Naquadah, "Naquadah Coil Block");
        this.register(6, ItemList.Casing_Coil_NaquadahAlloy, "Naquadah Alloy Coil Block");
        this.register(7, ItemList.Casing_Coil_ElectrumFlux, "Electrum Flux Coil Block");
        this.register(8, ItemList.Casing_Coil_AwakenedDraconium, "Awakened Draconium Coil Block");
        this.register(9, ItemList.Casing_Coil_HSSS, "HSS-S Coil Block");
        this.register(10, ItemList.Casing_Coil_Trinium, "Trinium Coil Block");
        this.register(11, ItemList.Casing_Coil_Infinity, "Infinity Coil Block");
        this.register(12, ItemList.Casing_Coil_Hypogen, "Hypogen Coil Block");
        this.register(13, ItemList.Casing_Coil_Eternal, "Eternal Coil Block");
    }

    @Override
    public int func_149692_a(int metadata) {
        return super.func_149692_a(metadata) % 16;
    }

    @Override
    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return super.func_149643_k(aWorld, aX, aY, aZ) % 16;
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return 0x80 | aMeta % 16;
    }

    @Override
    @Nullable
    public ITexture[][] getTextures(int metadata) {
        ArrayList<ITexture> textures = new ArrayList<ITexture>();
        if (Client.render.useOldCoils) {
            Textures.BlockIcons blockIcons;
            switch (metadata % 16) {
                case 0: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL;
                    break;
                }
                case 1: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_KANTHAL;
                    break;
                }
                case 2: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_NICHROME;
                    break;
                }
                case 3: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_TUNGSTENSTEEL;
                    break;
                }
                case 4: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_HSSG;
                    break;
                }
                case 5: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_NAQUADAH;
                    break;
                }
                case 6: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_NAQUADAHALLOY;
                    break;
                }
                case 7: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_ELECTRUMFLUX;
                    break;
                }
                case 8: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_AWAKENEDDRACONIUM;
                    break;
                }
                case 9: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_HSSS;
                    break;
                }
                case 10: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_TRINIUM;
                    break;
                }
                case 11: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_INFINITY;
                    break;
                }
                case 12: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_HYPOGEN;
                    break;
                }
                case 13: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_ETERNAL;
                    break;
                }
                default: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL;
                }
            }
            Textures.BlockIcons icon = blockIcons;
            textures.add(TextureFactory.of(icon));
        } else {
            Textures.BlockIcons blockIcons;
            switch (metadata % 16) {
                case 0: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL_BACKGROUND;
                    break;
                }
                case 1: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_KANTHAL_BACKGROUND;
                    break;
                }
                case 2: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_NICHROME_BACKGROUND;
                    break;
                }
                case 3: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_TUNGSTENSTEEL_BACKGROUND;
                    break;
                }
                case 4: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_HSSG_BACKGROUND;
                    break;
                }
                case 5: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_NAQUADAH_BACKGROUND;
                    break;
                }
                case 6: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_NAQUADAHALLOY_BACKGROUND;
                    break;
                }
                case 7: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_ELECTRUMFLUX_BACKGROUND;
                    break;
                }
                case 8: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_AWAKENEDDRACONIUM_BACKGROUND;
                    break;
                }
                case 9: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_HSSS_BACKGROUND;
                    break;
                }
                case 10: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_TRINIUM_BACKGROUND;
                    break;
                }
                case 11: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_INFINITY_BACKGROUND;
                    break;
                }
                case 12: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_HYPOGEN_BACKGROUND;
                    break;
                }
                case 13: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_ETERNAL_BACKGROUND;
                    break;
                }
                default: {
                    blockIcons = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL_BACKGROUND;
                }
            }
            Textures.BlockIcons background = blockIcons;
            textures.add(TextureFactory.builder().addIcon(background).material(Blocks.field_150348_b).build());
            if (metadata >= 16) {
                Textures.BlockIcons blockIcons2;
                switch (metadata % 16) {
                    case 0: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL_FOREGROUND;
                        break;
                    }
                    case 1: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_KANTHAL_FOREGROUND;
                        break;
                    }
                    case 2: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_NICHROME_FOREGROUND;
                        break;
                    }
                    case 3: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_TUNGSTENSTEEL_FOREGROUND;
                        break;
                    }
                    case 4: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_HSSG_FOREGROUND;
                        break;
                    }
                    case 5: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_NAQUADAH_FOREGROUND;
                        break;
                    }
                    case 6: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_NAQUADAHALLOY_FOREGROUND;
                        break;
                    }
                    case 7: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_ELECTRUMFLUX_FOREGROUND;
                        break;
                    }
                    case 8: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_AWAKENEDDRACONIUM_FOREGROUND;
                        break;
                    }
                    case 9: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_HSSS_FOREGROUND;
                        break;
                    }
                    case 10: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_TRINIUM_FOREGROUND;
                        break;
                    }
                    case 11: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_INFINITY_FOREGROUND;
                        break;
                    }
                    case 12: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_HYPOGEN_FOREGROUND;
                        break;
                    }
                    case 13: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_ETERNAL_FOREGROUND;
                        break;
                    }
                    default: {
                        blockIcons2 = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL_FOREGROUND;
                    }
                }
                Textures.BlockIcons foreground = blockIcons2;
                textures.add(TextureFactory.builder().addIcon(foreground).glow().material(Blocks.field_150426_aN).build());
            }
        }
        ITexture[] layers = textures.toArray(new ITexture[0]);
        return new ITexture[][]{layers, layers, layers, layers, layers, layers};
    }

    @Override
    public int func_149645_b() {
        return GTRendererBlock.mRenderID;
    }

    public boolean func_149686_d() {
        return false;
    }

    public static HeatingCoilLevel getCoilHeatFromDamage(int meta) {
        HeatingCoilLevel heatingCoilLevel;
        switch (meta % 16) {
            case 0: {
                heatingCoilLevel = HeatingCoilLevel.LV;
                break;
            }
            case 1: {
                heatingCoilLevel = HeatingCoilLevel.MV;
                break;
            }
            case 2: {
                heatingCoilLevel = HeatingCoilLevel.HV;
                break;
            }
            case 3: {
                heatingCoilLevel = HeatingCoilLevel.EV;
                break;
            }
            case 4: {
                heatingCoilLevel = HeatingCoilLevel.IV;
                break;
            }
            case 5: {
                heatingCoilLevel = HeatingCoilLevel.ZPM;
                break;
            }
            case 6: {
                heatingCoilLevel = HeatingCoilLevel.UV;
                break;
            }
            case 7: {
                heatingCoilLevel = HeatingCoilLevel.UEV;
                break;
            }
            case 8: {
                heatingCoilLevel = HeatingCoilLevel.UIV;
                break;
            }
            case 9: {
                heatingCoilLevel = HeatingCoilLevel.LuV;
                break;
            }
            case 10: {
                heatingCoilLevel = HeatingCoilLevel.UHV;
                break;
            }
            case 11: {
                heatingCoilLevel = HeatingCoilLevel.UMV;
                break;
            }
            case 12: {
                heatingCoilLevel = HeatingCoilLevel.UXV;
                break;
            }
            case 13: {
                heatingCoilLevel = HeatingCoilLevel.MAX;
                break;
            }
            default: {
                heatingCoilLevel = HeatingCoilLevel.None;
            }
        }
        return heatingCoilLevel;
    }

    public static int getMetaFromCoilHeat(HeatingCoilLevel level) {
        int n;
        switch (level) {
            case LV: {
                n = 0;
                break;
            }
            case MV: {
                n = 1;
                break;
            }
            case HV: {
                n = 2;
                break;
            }
            case EV: {
                n = 3;
                break;
            }
            case IV: {
                n = 4;
                break;
            }
            case ZPM: {
                n = 5;
                break;
            }
            case UV: {
                n = 6;
                break;
            }
            case UEV: {
                n = 7;
                break;
            }
            case UIV: {
                n = 8;
                break;
            }
            case LuV: {
                n = 9;
                break;
            }
            case UHV: {
                n = 10;
                break;
            }
            case UMV: {
                n = 11;
                break;
            }
            case UXV: {
                n = 12;
                break;
            }
            case MAX: {
                n = 13;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    public HeatingCoilLevel getCoilHeat(int meta) {
        return BlockCasings5.getCoilHeatFromDamage(meta % 16);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        super.addInformation(stack, player, tooltip, advancedTooltips);
        int metadata = stack.func_77960_j();
        HeatingCoilLevel coilLevel = BlockCasings5.getCoilHeatFromDamage(metadata);
        tooltip.add(COIL_HEAT_TOOLTIP.get() + coilLevel.getHeat() + COIL_UNIT_TOOLTIP.get());
        tooltip.add(StatCollector.func_74837_a((String)"GT5U.tooltip.channelvalue", (Object[])new Object[]{metadata + 1, "coil"}));
    }
}

