/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.net.IGT_NetworkHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@ChannelHandler.Sharable
public class GTNetwork
extends MessageToMessageCodec<FMLProxyPacket, GTPacket>
implements IGT_NetworkHandler {
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel;
    private final GTPacket[] mSubChannels;

    public GTNetwork() {
        this("GregTech", GTPacketTypes.referencePackets());
    }

    public GTNetwork(String channelName, GTPacket ... packetTypes) {
        this.mChannel = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{this, new HandlerShared()});
        byte lastPId = packetTypes[packetTypes.length - 1].getPacketID();
        this.mSubChannels = new GTPacket[lastPId + 1];
        for (GTPacket packetType : packetTypes) {
            byte pId = packetType.getPacketID();
            if (this.mSubChannels[pId] != null) {
                throw new IllegalArgumentException("Duplicate Packet ID! " + pId);
            }
            this.mSubChannels[pId] = packetType;
        }
    }

    protected void encode(ChannelHandlerContext aContext, GTPacket aPacket, List<Object> aOutput) {
        ByteBuf tBuf = Unpooled.buffer().writeByte((int)aPacket.getPacketID());
        aPacket.encode(tBuf);
        aOutput.add(new FMLProxyPacket(tBuf, (String)aContext.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext aContext, FMLProxyPacket aPacket, List<Object> aOutput) {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])aPacket.payload().array());
        GTPacket tPacket = this.mSubChannels[aData.readByte()].decode(aData);
        tPacket.setINetHandler(aPacket.handler());
        aOutput.add(tPacket);
    }

    @Override
    public void sendToPlayer(GTPacket aPacket, EntityPlayerMP aPlayer) {
        if (aPacket == null) {
            GTMod.GT_FML_LOGGER.info("packet null");
            return;
        }
        if (aPlayer == null) {
            GTMod.GT_FML_LOGGER.info("player null");
            return;
        }
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToAllAround(GTPacket aPacket, NetworkRegistry.TargetPoint aPosition) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPosition);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToAll(GTPacket aPacket) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToServer(GTPacket aPacket) {
        this.mChannel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mChannel.get(Side.CLIENT).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendPacketToAllPlayersInRange(World aWorld, GTPacket aPacket, int aX, int aZ) {
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                if (!tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) continue;
                this.sendToPlayer(aPacket, tPlayer);
            }
        }
    }

    @Override
    public void sendToWorld(World world, GTPacket packet) {
        if (!world.field_72995_K) {
            for (EntityPlayer player : world.field_73010_i) {
                if (!(player instanceof EntityPlayerMP)) continue;
                EntityPlayerMP mp = (EntityPlayerMP)player;
                this.sendToPlayer(packet, mp);
            }
        }
    }

    @ChannelHandler.Sharable
    static final class HandlerShared
    extends SimpleChannelInboundHandler<GTPacket> {
        HandlerShared() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, GTPacket aPacket) {
            EntityPlayer aPlayer = GTValues.GT.getThePlayer();
            aPacket.process((IBlockAccess)(aPlayer == null ? null : aPlayer.field_70170_p));
        }
    }
}

