/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.SimpleRecipeMetadataKey;
import gregtech.api.util.BlastFurnaceGasStat;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeMapUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.recipe.QuantumComputerRecipeData;
import gregtech.api.util.recipe.Scanning;
import gregtech.api.util.recipe.Sievert;
import gregtech.common.items.IDMetaItem03;
import gregtech.common.items.MetaGeneratedItem03;
import gtnhlanth.common.item.ItemPhotolithographicMask;
import gtnhlanth.common.item.MaskList;
import gtnhlanth.common.register.LanthItemList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class GTRecipeConstants {
    public static final RecipeMetadataKey<Boolean> LOW_GRAVITY = SimpleRecipeMetadataKey.create(Boolean.class, "low_gravity");
    public static final RecipeMetadataKey<Boolean> CLEANROOM = SimpleRecipeMetadataKey.create(Boolean.class, "cleanroom");
    public static final RecipeMetadataKey<Integer> ADDITIVE_AMOUNT = SimpleRecipeMetadataKey.create(Integer.class, "additives");
    public static final RecipeMetadataKey<Long> FUSION_THRESHOLD = SimpleRecipeMetadataKey.create(Long.class, "fusion_threshold");
    public static final RecipeMetadataKey<Scanning> SCANNING = SimpleRecipeMetadataKey.create(Scanning.class, "scanning");
    public static final RecipeMetadataKey<Integer> FUEL_TYPE = SimpleRecipeMetadataKey.create(Integer.class, "fuel_type");
    public static final RecipeMetadataKey<Integer> FUEL_VALUE = SimpleRecipeMetadataKey.create(Integer.class, "fuel_value");
    public static final RecipeMetadataKey<Integer> COIL_HEAT = SimpleRecipeMetadataKey.create(Integer.class, "coil_heat");
    public static final RecipeMetadataKey<ItemStack> RESEARCH_ITEM = SimpleRecipeMetadataKey.create(ItemStack.class, "research_item");
    public static final RecipeMetadataKey<Object> OREDICT_INPUT = SimpleRecipeMetadataKey.create(Object.class, "oredict_input");
    public static final RecipeMetadataKey<Materials> MATERIAL = SimpleRecipeMetadataKey.create(Materials.class, "material");
    public static final RecipeMetadataKey<Boolean> RECYCLE = SimpleRecipeMetadataKey.create(Boolean.class, "recycle");
    public static final RecipeMetadataKey<Boolean> EXPLODE = SimpleRecipeMetadataKey.create(Boolean.class, "explode");
    public static final RecipeMetadataKey<Boolean> ON_FIRE = SimpleRecipeMetadataKey.create(Boolean.class, "on_fire");
    public static final RecipeMetadataKey<QuantumComputerRecipeData> QUANTUM_COMPUTER_DATA = SimpleRecipeMetadataKey.create(QuantumComputerRecipeData.class, "quantum_computer_data");
    public static final RecipeMetadataKey<Integer> NANO_FORGE_TIER = SimpleRecipeMetadataKey.create(Integer.class, "nano_forge_tier");
    public static final RecipeMetadataKey<Materials> PCB_NANITE_MATERIAL = SimpleRecipeMetadataKey.create(Materials.class, "pcb_nanite_material");
    public static final RecipeMetadataKey<Integer> FOG_EXOTIC_TIER = SimpleRecipeMetadataKey.create(Integer.class, "fog_exotic_tier");
    public static final RecipeMetadataKey<Integer> FOG_PLASMA_TIER = SimpleRecipeMetadataKey.create(Integer.class, "fog_plasma_tier");
    public static final RecipeMetadataKey<Boolean> FOG_PLASMA_MULTISTEP = SimpleRecipeMetadataKey.create(Boolean.class, "fog_plasma_multistep");
    public static final RecipeMetadataKey<String> FOG_UPGRADE_NAME_SHORT = SimpleRecipeMetadataKey.create(String.class, "fog_plasma_upgrade_name_short");
    public static final RecipeMetadataKey<Integer> DEFC_CASING_TIER = SimpleRecipeMetadataKey.create(Integer.class, "defc_casing_tier");
    public static final RecipeMetadataKey<Integer> CHEMPLANT_CASING_TIER = SimpleRecipeMetadataKey.create(Integer.class, "chemplant_casing_tier");
    public static final RecipeMetadataKey<Integer> QFT_FOCUS_TIER = SimpleRecipeMetadataKey.create(Integer.class, "qft_focus_tier");
    public static final RecipeMetadataKey<ItemStack> QFT_CATALYST = SimpleRecipeMetadataKey.create(ItemStack.class, "qft_catalyst");
    public static final RecipeMetadataKey<Integer> COMPRESSION_TIER = SimpleRecipeMetadataKey.create(Integer.class, "compression");
    public static final RecipeMetadataKey<Integer> DISSOLUTION_TANK_RATIO = SimpleRecipeMetadataKey.create(Integer.class, "dissolution_tank_ratio");
    public static final RecipeMetadataKey<Integer> RTG_DURATION_IN_DAYS = SimpleRecipeMetadataKey.create(Integer.class, "rtg_duration_in_days");
    public static final RecipeMetadataKey<Integer> LNG_BASIC_OUTPUT = SimpleRecipeMetadataKey.create(Integer.class, "lng_basic_output");
    public static final RecipeMetadataKey<Integer> NFR_COIL_TIER = SimpleRecipeMetadataKey.create(Integer.class, "nfr_coil_tier");
    public static final RecipeMetadataKey<Integer> NKE_RANGE = SimpleRecipeMetadataKey.create(Integer.class, "nke_range");
    public static final RecipeMetadataKey<Integer> PRECISE_ASSEMBLER_CASING_TIER = SimpleRecipeMetadataKey.create(Integer.class, "precise_assembler_casing_tier");
    public static final RecipeMetadataKey<Integer> COAL_CASING_TIER = SimpleRecipeMetadataKey.create(Integer.class, "coal_casing_tier");
    public static final RecipeMetadataKey<Integer> LFTR_OUTPUT_POWER = SimpleRecipeMetadataKey.create(Integer.class, "lftr_output_power");
    public static final RecipeMetadataKey<Integer> SPARGE_MAX_BYPRODUCT = SimpleRecipeMetadataKey.create(Integer.class, "sparge_max_byproduct");
    public static final RecipeMetadataKey<Integer> RESEARCH_STATION_DATA = SimpleRecipeMetadataKey.create(Integer.class, "research_station_data");
    public static final RecipeMetadataKey<Sievert> SIEVERT = SimpleRecipeMetadataKey.create(Sievert.class, "SIEVERT");
    public static final RecipeMetadataKey<Integer> GLASS = SimpleRecipeMetadataKey.create(Integer.class, "GLASS");
    public static final RecipeMetadataKey<Integer> MASS = SimpleRecipeMetadataKey.create(Integer.class, "mass");
    public static final RecipeMetadataKey<Boolean> NOBLE_GASES = SimpleRecipeMetadataKey.create(Boolean.class, "noble_gases");
    public static final RecipeMetadataKey<Boolean> ANAEROBE_GASES = SimpleRecipeMetadataKey.create(Boolean.class, "anaerobe_gases");
    public static final RecipeMetadataKey<Boolean> NO_GAS = SimpleRecipeMetadataKey.create(Boolean.class, "no_gas");
    public static final RecipeMetadataKey<Integer> EU_MULTIPLIER = SimpleRecipeMetadataKey.create(Integer.class, "eu_multiplier");
    public static final IRecipeMap UniversalArcFurnace = IRecipeMap.newRecipeMap(builder -> {
        if (!GTUtility.isArrayOfLength(builder.getItemInputsBasic(), 1) || GTUtility.isArrayEmptyOrNull(builder.getItemOutputs())) {
            return Collections.emptyList();
        }
        int aDuration = builder.getDuration();
        if (aDuration <= 0) {
            return Collections.emptyList();
        }
        boolean recycle = builder.getMetadataOrDefault(RECYCLE, false);
        ArrayList<GTRecipe> ret = new ArrayList<GTRecipe>();
        for (Materials mat : new Materials[]{Materials.Argon, Materials.Nitrogen}) {
            builder.duration(Math.max(1, mat == Materials.Nitrogen ? aDuration / 4 : aDuration / 24));
            int tPlasmaAmount = (int)Math.max(1L, (long)aDuration / (mat.getMass() * 16L));
            GTRecipeBuilder plasmaBuilder = builder.copy().fluidInputs(mat.getPlasma(tPlasmaAmount)).fluidOutputs(mat.getGas(tPlasmaAmount));
            if (recycle) continue;
            ret.addAll(RecipeMaps.plasmaArcFurnaceRecipes.doAdd(plasmaBuilder));
        }
        builder.duration(aDuration);
        GTRecipeBuilder arcBuilder = builder.copy().fluidInputs(Materials.Oxygen.getGas(aDuration));
        if (recycle) {
            arcBuilder.recipeCategory(RecipeCategories.arcFurnaceRecycling);
        }
        ret.addAll(RecipeMaps.arcFurnaceRecipes.doAdd(arcBuilder));
        return ret;
    });
    public static final IRecipeMap UniversalChemical = IRecipeMap.newRecipeMap(builder -> {
        for (ItemStack input : builder.getItemInputsBasic()) {
            if (!GTUtility.isAnyIntegratedCircuit(input) || input.func_77960_j() < 10) continue;
            return builder.addTo(RecipeMaps.chemicalReactorRecipes);
        }
        return GTUtility.concat(builder.copy().addTo(RecipeMaps.chemicalReactorRecipes), GTRecipeMapUtil.convertCellToFluid(builder, false).metadata(CLEANROOM, false).addTo(RecipeMaps.multiblockChemicalReactorRecipes));
    });
    public static final IRecipeMap WaferEngravingRecipes = IRecipeMap.newRecipeMap(builder -> {
        static enum 1Wafer {
            Naquadah,
            Europium,
            Americium,
            MaskT1,
            MaskT2,
            MaskT3;

        }
        1Wafer wafer = null;
        ItemPhotolithographicMask t1Item = (ItemPhotolithographicMask)LanthItemList.maskMap.get((Object)MaskList.BLANK1);
        ItemPhotolithographicMask t2Item = (ItemPhotolithographicMask)LanthItemList.maskMap.get((Object)MaskList.BLANK2);
        ItemPhotolithographicMask t3Item = (ItemPhotolithographicMask)LanthItemList.maskMap.get((Object)MaskList.BLANK3);
        for (ItemStack input : builder.getItemInputsBasic()) {
            Item patt14357$temp;
            if (input.func_77973_b() instanceof MetaGeneratedItem03) {
                int meta = input.func_77960_j() - 32000;
                if (meta == IDMetaItem03.Circuit_Silicon_Wafer3.ID) {
                    wafer = 1Wafer.Naquadah;
                } else if (meta == IDMetaItem03.Circuit_Silicon_Wafer4.ID) {
                    wafer = 1Wafer.Europium;
                } else if (meta == IDMetaItem03.Circuit_Silicon_Wafer5.ID) {
                    wafer = 1Wafer.Americium;
                }
            }
            if ((patt14357$temp = input.func_77973_b()) instanceof ItemPhotolithographicMask) {
                ItemPhotolithographicMask mask = (ItemPhotolithographicMask)patt14357$temp;
                String spectrum = mask.getDescSpectrum();
                if (spectrum.equals(t1Item.getDescSpectrum())) {
                    wafer = 1Wafer.MaskT1;
                } else if (spectrum.equals(t2Item.getDescSpectrum())) {
                    wafer = 1Wafer.MaskT2;
                } else if (spectrum.equals(t3Item.getDescSpectrum())) {
                    wafer = 1Wafer.MaskT3;
                }
            }
            if (wafer != null) break;
        }
        int recipeTime = builder.duration;
        int halfBoostedRecipeTime = (int)((double)recipeTime * 0.75);
        int boostedRecipeTime = (int)((double)recipeTime * 0.5);
        if (wafer == null) {
            return builder.addTo(RecipeMaps.laserEngraverRecipes);
        }
        switch (wafer) {
            case Naquadah: {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(builder.getItemInputsBasic()));
                ItemStack[] itemInputs = items.toArray(new ItemStack[0]);
                return GTUtility.concat(builder.copy().itemInputs(itemInputs).fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{GTModHandler.getDistilledWater(100L)})).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().itemInputs(itemInputs).fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade1PurifiedWater.getFluid(100L)})).duration(halfBoostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().itemInputs(itemInputs).fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade2PurifiedWater.getFluid(100L)})).duration(boostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes));
            }
            case Europium: {
                return GTUtility.concat(builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade3PurifiedWater.getFluid(100L)})).duration(recipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade4PurifiedWater.getFluid(100L)})).duration(boostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes));
            }
            case Americium: {
                return GTUtility.concat(builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade5PurifiedWater.getFluid(100L)})).duration(recipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade6PurifiedWater.getFluid(100L)})).duration(boostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes));
            }
            case MaskT1: {
                return GTUtility.concat(builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade1PurifiedWater.getFluid(32000L)})).duration(recipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade2PurifiedWater.getFluid(32000L)})).duration(halfBoostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade3PurifiedWater.getFluid(32000L)})).duration(boostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes));
            }
            case MaskT2: {
                return GTUtility.concat(builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade4PurifiedWater.getFluid(32000L)})).duration(recipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade5PurifiedWater.getFluid(32000L)})).duration(boostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes));
            }
            case MaskT3: {
                return GTUtility.concat(builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade6PurifiedWater.getFluid(32000L)})).duration(recipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade7PurifiedWater.getFluid(32000L)})).duration(halfBoostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes), builder.copy().fluidInputs((FluidStack[])ArrayUtils.addAll((Object[])builder.fluidInputs, (Object[])new FluidStack[]{Materials.Grade8PurifiedWater.getFluid(32000L)})).duration(boostedRecipeTime).addTo(RecipeMaps.laserEngraverRecipes));
            }
        }
        throw new RuntimeException("Unreachable code reached in Laser Engraver Recipe Transformer");
    });
    public static final IRecipeMap AssemblyLine = IRecipeMap.newRecipeMap(builder -> {
        Optional<GTRecipe.GTRecipe_WithAlt> rr = builder.forceOreDictInput().validateInputCount(4, 16).validateOutputCount(1, 1).validateOutputFluidCount(-1, 0).validateInputFluidCount(1, 4).buildWithAlt();
        if (!rr.isPresent()) {
            return Collections.emptyList();
        }
        GTRecipe.GTRecipe_WithAlt r = rr.get();
        ItemStack[][] mOreDictAlt = r.mOreDictAlt;
        Object[] inputs = builder.getItemInputsOreDict();
        ItemStack aResearchItem = builder.getMetadata(RESEARCH_ITEM);
        if (aResearchItem == null) {
            return Collections.emptyList();
        }
        ItemStack aOutput = r.mOutputs[0];
        int tPersistentHash = 1;
        int mOreDictAltLength = mOreDictAlt.length;
        for (int i = 0; i < mOreDictAltLength; ++i) {
            ItemStack[] alts = mOreDictAlt[i];
            Object input = inputs[i];
            if (input == null) {
                GTLog.err.println("addAssemblingLineRecipe " + aResearchItem.func_82833_r() + " --> " + aOutput.func_77977_a() + " there is some null item in that recipe");
            }
            if (input instanceof ItemStack) {
                tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash((ItemStack)input, true, false);
                continue;
            }
            if (input instanceof ItemStack[]) {
                for (ItemStack alt : (ItemStack[])input) {
                    tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(alt, true, false);
                    if (alt != null) continue;
                    GTLog.err.println("addAssemblingLineRecipe " + aResearchItem.func_82833_r() + " --> " + aOutput.func_77977_a() + " there is some null alt item in that recipe");
                }
                tPersistentHash *= 31;
                continue;
            }
            if (!(input instanceof Object[])) continue;
            Object[] objs = (Object[])input;
            Arrays.sort(alts, Comparator.comparing(s -> GameRegistry.findUniqueIdentifierFor((Item)s.func_77973_b()).modId).thenComparing(s -> GameRegistry.findUniqueIdentifierFor((Item)s.func_77973_b()).name).thenComparingInt(arg_0 -> ((Item)Items.field_151008_G).getDamage(arg_0)).thenComparingInt(s -> s.field_77994_a));
            tPersistentHash = tPersistentHash * 31 + (objs[0] == null ? "" : objs[0].toString()).hashCode();
            tPersistentHash = tPersistentHash * 31 + ((Number)objs[1]).intValue();
        }
        tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(aResearchItem, true, false);
        tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(aOutput, true, false);
        for (FluidStack fluidInput : r.mFluidInputs) {
            if (fluidInput == null) continue;
            tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(fluidInput, true, false);
        }
        Scanning scanningData = builder.getMetadataOrDefault(SCANNING, new Scanning(0, 0L));
        tPersistentHash = tPersistentHash * 31 + scanningData.time;
        tPersistentHash = tPersistentHash * 31 + (int)scanningData.voltage;
        tPersistentHash = tPersistentHash * 31 + r.mDuration;
        tPersistentHash = tPersistentHash * 31 + r.mEUt;
        GTRecipe.RecipeAssemblyLine tRecipe = new GTRecipe.RecipeAssemblyLine(aResearchItem, scanningData.time, (int)scanningData.voltage, r.mInputs, r.mFluidInputs, aOutput, r.mDuration, r.mEUt, r.mOreDictAlt);
        tRecipe.setPersistentHash(tPersistentHash);
        GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes.add(tRecipe);
        ArrayList<GTRecipe> ret = new ArrayList<GTRecipe>(3);
        ret.addAll(GTValues.RA.stdBuilder().itemInputs(aResearchItem).itemOutputs(aOutput).special(tRecipe.newDataStickForNEI("Writes Research result")).duration(scanningData.time).eut(scanningData.voltage).specialValue(-201).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes));
        ret.add(RecipeMaps.assemblylineVisualRecipes.addFakeRecipe(false, r.mInputs, new ItemStack[]{aOutput}, new ItemStack[]{tRecipe.newDataStickForNEI("Reads Research result")}, r.mFluidInputs, null, r.mDuration, r.mEUt, 0, r.mOreDictAlt, false));
        return ret;
    });
    public static final IRecipeMap BlastFurnaceWithGas = IRecipeMap.newRecipeMap(builder -> {
        int circuitConfig;
        ArrayList<ItemStack> items;
        double durationBase;
        int basicGasAmount;
        ArrayList<GTRecipe> ret;
        block9: {
            block8: {
                OrePrefixes prefix;
                block11: {
                    block10: {
                        ret = new ArrayList<GTRecipe>();
                        basicGasAmount = builder.getMetadataOrDefault(ADDITIVE_AMOUNT, 1000);
                        durationBase = builder.getDuration();
                        items = new ArrayList<ItemStack>(Arrays.asList(builder.getItemInputsBasic()));
                        circuitConfig = 1;
                        if (items.size() != 1) break block8;
                        ItemData data = GTOreDictUnificator.getAssociation(items.get(0));
                        if (data == null) break block9;
                        prefix = data.mPrefix;
                        if (!OrePrefixes.dust.equals((Object)prefix)) break block10;
                        circuitConfig = 1;
                        break block9;
                    }
                    if (!OrePrefixes.dustSmall.equals((Object)prefix)) break block11;
                    circuitConfig = 4;
                    break block9;
                }
                if (!OrePrefixes.dustTiny.equals((Object)prefix)) break block9;
                circuitConfig = 9;
                break block9;
            }
            for (int i = 0; i < items.size(); ++i) {
                if (!GTUtility.isAnyIntegratedCircuit(items.get(i))) continue;
                circuitConfig = items.get(i).func_77960_j();
                items.remove(i--);
            }
        }
        if (builder.getMetadataOrDefault(NO_GAS, false).booleanValue()) {
            items.add(GTUtility.getIntegratedCircuit(circuitConfig));
            ret.addAll(builder.copy().itemInputs(items.toArray(new ItemStack[0])).fluidInputs(new FluidStack[0]).duration((int)Math.max(durationBase * 1.1, 1.0)).addTo(RecipeMaps.blastFurnaceRecipes));
            items.remove(items.size() - 1);
            circuitConfig += 10;
        }
        items.add(GTUtility.getIntegratedCircuit(circuitConfig));
        boolean nobleGases = builder.getMetadataOrDefault(NOBLE_GASES, false);
        boolean anaerobeGases = builder.getMetadataOrDefault(ANAEROBE_GASES, false);
        Collection<Object> gases = new ArrayList();
        if (nobleGases && anaerobeGases) {
            gases = BlastFurnaceGasStat.getNobleAndAnaerobeGases();
        } else if (nobleGases) {
            gases = BlastFurnaceGasStat.getNobleGases();
        } else if (anaerobeGases) {
            gases = BlastFurnaceGasStat.getAnaerobeGases();
        }
        for (BlastFurnaceGasStat gas : gases) {
            int gasAmount = (int)(gas.recipeConsumedAmountMultiplier * (double)basicGasAmount);
            int duration = (int)Math.max(gas.recipeTimeMultiplier * durationBase, 1.0);
            ret.addAll(builder.copy().itemInputs(items.toArray(new ItemStack[0])).fluidInputs(GTUtility.copyAmount(gasAmount, gas.gas)).duration(duration).addTo(RecipeMaps.blastFurnaceRecipes));
        }
        return ret;
    });
    public static IRecipeMap AssemblerOD = IRecipeMap.newRecipeMap(builder -> {
        ArrayList<GTRecipe> ret = new ArrayList<GTRecipe>();
        for (ItemStack input : GTOreDictUnificator.getOresImmutable(builder.getMetadata(OREDICT_INPUT))) {
            ret.addAll(builder.copy().itemInputs(GTRecipeMapUtil.appendArray(builder.getItemInputsBasic(), input)).addTo(RecipeMaps.assemblerRecipes));
        }
        return ret;
    });
    public static IRecipeMap Fuel = IRecipeMap.newRecipeMap(builder -> {
        builder.validateInputCount(1, 1).validateNoInputFluid().validateOutputCount(-1, 1).validateNoOutputFluid();
        if (!builder.isValid()) {
            return Collections.emptyList();
        }
        Integer fuelType = builder.getMetadata(FUEL_TYPE);
        if (fuelType == null) {
            return Collections.emptyList();
        }
        builder.metadata(FUEL_VALUE, builder.getMetadataOrDefault(FUEL_VALUE, 0));
        return FuelType.get(fuelType).getTarget().doAdd((GTRecipeBuilder)builder);
    });

    static {
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(COIL_HEAT);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(FUEL_VALUE);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(NANO_FORGE_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(FOG_EXOTIC_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(FOG_PLASMA_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(DEFC_CASING_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(CHEMPLANT_CASING_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(QFT_FOCUS_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(DISSOLUTION_TANK_RATIO);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(RTG_DURATION_IN_DAYS);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(LNG_BASIC_OUTPUT);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(NFR_COIL_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(NKE_RANGE);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(PRECISE_ASSEMBLER_CASING_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(COAL_CASING_TIER);
        GTRecipeMapUtil.SPECIAL_VALUE_ALIASES.add(RESEARCH_STATION_DATA);
    }

    public static enum FuelType {
        DieselFuel(RecipeMaps.dieselFuels),
        GasTurbine(RecipeMaps.gasTurbineFuels),
        HotFuel(RecipeMaps.hotFuels),
        SemiFluid(RecipeMaps.denseLiquidFuels),
        PlasmaTurbine(RecipeMaps.plasmaFuels),
        Magic(RecipeMaps.magicFuels);

        private static final FuelType[] VALUES;
        private final IRecipeMap target;

        private FuelType(IRecipeMap target) {
            this.target = target;
        }

        public static FuelType get(int fuelType) {
            if (fuelType < 0 || fuelType >= VALUES.length) {
                return SemiFluid;
            }
            return VALUES[fuelType];
        }

        public IRecipeMap getTarget() {
            return this.target;
        }

        static {
            VALUES = FuelType.values();
        }
    }
}

