/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.structure;

import com.google.common.collect.ArrayListMultimap;
import gregtech.api.casing.ICasing;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.structure.CasingInfo;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class MultiblockTooltipBuilder2<MTE extends MTEEnhancedMultiBlockBase<?>>
extends MultiblockTooltipBuilder {
    public final StructureWrapper<MTE> structure;
    private final Object2ObjectArrayMap<ICasing, String> casingNameOverrides = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<IHatchElement<? super MTE>, String> hatchNameOverrides = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<IHatchElement<? super MTE>, String> hatchInfoOverrides = new Object2ObjectArrayMap();
    private final List<IHatchElement<? super MTE>> hatchOrder = new ArrayList<IHatchElement<? super MTE>>();
    private boolean hasMultiampHatches = false;
    private boolean printMultiampSupport = true;

    public MultiblockTooltipBuilder2(StructureWrapper<MTE> structure) {
        this.structure = structure;
    }

    public MultiblockTooltipBuilder2<MTE> beginStructureBlock(boolean hollow) {
        if (!this.structure.minSize.equals((Object)this.structure.maxSize)) {
            super.beginVariableStructureBlock(this.structure.minSize.get0(), this.structure.minSize.get1(), this.structure.minSize.get2(), this.structure.maxSize.get0(), this.structure.maxSize.get1(), this.structure.maxSize.get2(), hollow);
        } else {
            super.beginStructureBlock(this.structure.minSize.get0(), this.structure.minSize.get1(), this.structure.minSize.get2(), hollow);
        }
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> beginStructureBlock() {
        if (!this.structure.minSize.equals((Object)this.structure.maxSize)) {
            super.beginVariableStructureBlock(this.structure.minSize.get0(), this.structure.minSize.get1(), this.structure.minSize.get2(), this.structure.maxSize.get0(), this.structure.maxSize.get1(), this.structure.maxSize.get2(), false);
        } else {
            super.beginStructureBlock(this.structure.minSize.get0(), this.structure.minSize.get1(), this.structure.minSize.get2(), false);
        }
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addCasingNameOverride(ICasing casing, String newName) {
        this.casingNameOverrides.put((Object)casing, (Object)newName);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addCasing(ICasing casing) {
        this.addCasingInfoAuto(this, casing);
        return this;
    }

    public void addCasingInfoExact(MultiblockTooltipBuilder tt, ICasing casing) {
        tt.addCasingInfoExactly(casing.getLocalizedName(), this.structure.getCasingMax(casing), casing.isTiered());
    }

    public void addCasingInfoRange(MultiblockTooltipBuilder tt, ICasing casing) {
        String name = this.casingNameOverrides.containsKey((Object)casing) ? (String)this.casingNameOverrides.get((Object)casing) : casing.getLocalizedName();
        tt.addCasingInfoRange(name, this.structure.getCasingMin(casing), this.structure.getCasingMax(casing), casing.isTiered());
    }

    public void addCasingInfoAuto(MultiblockTooltipBuilder tt, ICasing casing) {
        if (this.structure.getCasingMax(casing) != this.structure.getCasingMin(casing)) {
            this.addCasingInfoRange(tt, casing);
        } else {
            this.addCasingInfoExact(tt, casing);
        }
    }

    public MultiblockTooltipBuilder2<MTE> addHatchNameOverride(IHatchElement<? super MTE> hatch, String newName) {
        this.hatchNameOverrides.put(hatch, (Object)newName);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatchNameOverride(IHatchElement<? super MTE> hatch, ItemStack stack) {
        this.hatchNameOverrides.put(hatch, (Object)stack.func_82833_r());
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatchLocationOverride(IHatchElement<? super MTE> hatch, String newLocation) {
        this.hatchInfoOverrides.put(hatch, (Object)newLocation);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatchLocationOverride(Collection<IHatchElement<? super MTE>> hatches, String newLocation) {
        for (IHatchElement<MTE> iHatchElement : hatches) {
            this.hatchInfoOverrides.put(iHatchElement, (Object)newLocation);
        }
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> disableMultiAmpHatchLine() {
        this.printMultiampSupport = false;
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> setHatchOrder(List<IHatchElement<? super MTE>> hatches) {
        this.hatchOrder.clear();
        this.hatchOrder.addAll(hatches);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatch(ICasing casing, IHatchElement<? super MTE> hatch, int ... dots) {
        String override = (String)this.hatchNameOverrides.get(hatch);
        String info = (String)this.hatchInfoOverrides.get(hatch);
        if (info == null) {
            info = GTUtility.translate("GT5U.MBTT.HatchInfo", casing.getLocalizedName());
        }
        if (dots.length > 0) {
            info = info + GTUtility.translate("GT5U.MBTT.HatchDots", String.join((CharSequence)", ", GTUtility.mapToList(new IntArrayList(dots), Object::toString)));
        }
        if (override != null) {
            this.addOtherStructurePart(override, info, dots);
        } else if (hatch instanceof HatchElement) {
            HatchElement gtHatch = (HatchElement)hatch;
            switch (gtHatch) {
                case Dynamo: {
                    this.addDynamoHatch(info, dots);
                    break;
                }
                case Energy: {
                    this.addEnergyHatch(info, dots);
                    break;
                }
                case ExoticEnergy: {
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.MultiampEnergyHatch", new Object[0]), info, dots);
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.LaserTargetHatch", new Object[0]), info, dots);
                    this.hasMultiampHatches = true;
                    break;
                }
                case MultiAmpEnergy: {
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.MultiampEnergyHatch", new Object[0]), info, dots);
                    break;
                }
                case InputBus: {
                    this.addInputBus(info, dots);
                    break;
                }
                case InputHatch: {
                    this.addInputHatch(info, dots);
                    break;
                }
                case Maintenance: {
                    this.addMaintenanceHatch(info, dots);
                    break;
                }
                case Muffler: {
                    this.addMufflerHatch(info, dots);
                    break;
                }
                case OutputBus: {
                    this.addOutputBus(info, dots);
                    break;
                }
                case OutputHatch: {
                    this.addOutputHatch(info, dots);
                    break;
                }
            }
        } else if (hatch instanceof TTMultiblockBase.HatchElement) {
            TTMultiblockBase.HatchElement ttHatch = (TTMultiblockBase.HatchElement)hatch;
            switch (ttHatch) {
                case EnergyMulti: {
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.MultiampEnergyHatch", new Object[0]), info, dots);
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.LaserTargetHatch", new Object[0]), info, dots);
                    this.hasMultiampHatches = true;
                    break;
                }
                case DynamoMulti: {
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.MultiampEnergyDynamo", new Object[0]), info, dots);
                    this.addOtherStructurePart(GTUtility.translate("GT5U.MBTT.LaserSourceHatch", new Object[0]), info, dots);
                    this.hasMultiampHatches = true;
                    break;
                }
                default: {
                    this.addOtherStructurePart(ttHatch.getDisplayName(), info, dots);
                    break;
                }
            }
        } else {
            this.addOtherStructurePart(hatch.getDisplayName(), info, dots);
        }
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addAllCasingInfo() {
        this.addAllCasingInfo(null);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addAllCasingInfo(List<ICasing> casingOrder) {
        ObjectArraySet addedCasings = new ObjectArraySet();
        ObjectArraySet addedHatches = new ObjectArraySet();
        CharArrayList casings = new CharArrayList((CharCollection)this.structure.casings.keySet());
        if (casingOrder != null && !casingOrder.isEmpty()) {
            CharComparator comparator = (a, b) -> {
                int i1 = casingOrder.indexOf(((CasingInfo)this.structure.casings.get((char)a)).casing);
                int i2 = casingOrder.indexOf(((CasingInfo)this.structure.casings.get((char)b)).casing);
                if (i1 == -1 || i2 == -1) {
                    return -Integer.compare(i1, i2);
                }
                return Integer.compare(i1, i2);
            };
            casings.sort(comparator);
        } else {
            casings.sort(null);
        }
        ArrayListMultimap hatches = ArrayListMultimap.create();
        CharListIterator charListIterator = casings.iterator();
        while (charListIterator.hasNext()) {
            char c = ((Character)charListIterator.next()).charValue();
            CasingInfo casingInfo = (CasingInfo)this.structure.casings.get(c);
            if (addedCasings.add((Object)casingInfo.casing)) {
                this.addCasingInfoAuto(this, casingInfo.casing);
            }
            if (casingInfo.hatches == null) continue;
            for (IHatchElement hatch : casingInfo.hatches) {
                hatches.put((Object)Pair.of((Object)casingInfo.casing, hatch), (Object)casingInfo.dot);
            }
        }
        ArrayList<Pair> hatchesSorted = new ArrayList<Pair>(new HashSet(hatches.keys()));
        if (!this.hatchOrder.isEmpty()) {
            hatchesSorted.sort((p1, p2) -> {
                int i1 = this.hatchOrder.indexOf(p1.right());
                int i2 = this.hatchOrder.indexOf(p2.right());
                if (i1 == -1 || i2 == -1) {
                    return -Integer.compare(i1, i2);
                }
                return Integer.compare(i1, i2);
            });
        } else {
            ToIntFunction<Pair> categoryComparator = p -> {
                Object patt13286$temp = p.right();
                if (patt13286$temp instanceof HatchElement) {
                    HatchElement gtHatch = (HatchElement)patt13286$temp;
                    return gtHatch.ordinal();
                }
                Object patt13404$temp = p.right();
                if (patt13404$temp instanceof TTMultiblockBase.HatchElement) {
                    TTMultiblockBase.HatchElement ttHatch = (TTMultiblockBase.HatchElement)patt13404$temp;
                    return ttHatch.ordinal() + 100;
                }
                return 200;
            };
            Comparator<Pair> nameComparator = Comparator.nullsFirst(Comparator.comparing(p -> (String)this.hatchNameOverrides.getOrDefault(p.right(), (Object)((IHatchElement)p.right()).getDisplayName())));
            hatchesSorted.sort(Comparator.comparingInt(categoryComparator).thenComparing(nameComparator));
        }
        for (Pair hatch : hatchesSorted) {
            IntArrayList dots = new IntArrayList((IntCollection)new IntArraySet(hatches.get((Object)hatch)));
            dots.sort(null);
            this.addHatch((ICasing)hatch.left(), (IHatchElement)hatch.right(), dots.toIntArray());
        }
        if (this.printMultiampSupport && this.hasMultiampHatches) {
            this.addTecTechHatchInfo();
        }
        return this;
    }
}

