/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.recipe.QuantumComputerRecipeData;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuantumComputerFrontend
extends RecipeMapFrontend {
    public QuantumComputerFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter(new QuantumComputerMetaDataFormatter()));
    }

    private static class QuantumComputerMetaDataFormatter
    implements INEISpecialInfoFormatter {
        private QuantumComputerMetaDataFormatter() {
        }

        @Override
        public List<String> format(RecipeDisplayInfo recipeInfo) {
            ArrayList<String> result = new ArrayList<String>();
            QuantumComputerRecipeData data = recipeInfo.recipe.getMetadata(GTRecipeConstants.QUANTUM_COMPUTER_DATA);
            if (data != null) {
                if (data.subZero) {
                    result.add(StatCollector.func_74837_a((String)"GT5U.nei.qc.heating", (Object[])new Object[]{Float.valueOf(data.heatConstant)}));
                    result.add(StatCollector.func_74837_a((String)"GT5U.nei.qc.computation", (Object[])new Object[]{Float.valueOf(data.computation)}));
                } else {
                    result.add(StatCollector.func_74837_a((String)"GT5U.nei.qc.cooling", (Object[])new Object[]{Float.valueOf(data.coolConstant)}));
                }
                result.add(StatCollector.func_74837_a((String)"GT5U.nei.qc.maxheat", (Object[])new Object[]{Float.valueOf(data.maxHeat)}));
            }
            return result;
        }
    }
}

