/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.math.BigInteger;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEWirelessEnergy
extends MTEHatchEnergy {
    private final BigInteger eu_transferred_per_operation;
    private final long eu_transferred_per_operation_long;
    private UUID owner_uuid;

    public MTEWirelessEnergy(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
        this.eu_transferred_per_operation = BigInteger.valueOf(2L * GTValues.V[this.mTier] * WirelessNetworkManager.ticks_between_energy_addition);
        this.eu_transferred_per_operation_long = this.eu_transferred_per_operation.longValue();
    }

    public MTEWirelessEnergy(String aName, byte aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.eu_transferred_per_operation = BigInteger.valueOf(2L * GTValues.V[this.mTier] * WirelessNetworkManager.ticks_between_energy_addition);
        this.eu_transferred_per_operation_long = this.eu_transferred_per_operation.longValue();
    }

    @Override
    public String[] getDescription() {
        return new String[]{EnumChatFormatting.GRAY + "Stores energy globally in a network, up to 2^(2^31) EU.", EnumChatFormatting.GRAY + "Does not connect to wires. This block withdraws EU from the network.", GTValues.AuthorColen};
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_WIRELESS_ON[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_WIRELESS_ON[this.mTier]};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 2L * GTValues.V[this.mTier];
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return WirelessNetworkManager.totalStorage(GTValues.V[this.mTier]);
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public MTEHatch.ConnectionType getConnectionType() {
        return MTEHatch.ConnectionType.WIRELESS;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEWirelessEnergy(this.mName, this.mTier, new String[]{""}, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        this.owner_uuid = aBaseMetaTileEntity.getOwnerUuid();
        SpaceProjectManager.checkOrCreateTeam(this.owner_uuid);
        this.tryFetchingEnergy();
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % WirelessNetworkManager.ticks_between_energy_addition == 0L) {
            this.tryFetchingEnergy();
        }
    }

    private void tryFetchingEnergy() {
        long currentEU = this.getBaseMetaTileEntity().getStoredEU();
        long maxEU = this.maxEUStore();
        long euToTransfer = Long.min(maxEU - currentEU, this.eu_transferred_per_operation_long);
        if (euToTransfer <= 0L) {
            return;
        }
        if (!WirelessNetworkManager.addEUToGlobalEnergyMap(this.owner_uuid, -euToTransfer)) {
            return;
        }
        this.setEUVar(currentEU + euToTransfer);
    }
}

