/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.GTItemStack;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import ic2.core.IHasGui;
import ic2.core.item.ItemToolbox;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchMaintenance
extends MTEHatch
implements IAddUIWidgets,
IAlignment {
    private Rotation rotation = Rotation.NORMAL;
    private static ItemStack[] sAutoMaintenanceInputs;
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mAuto;

    public MTEHatchMaintenance(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "For maintaining Multiblocks", new ITexture[0]);
        this.mAuto = false;
    }

    public MTEHatchMaintenance(int aID, String aName, String aNameRegional, int aTier, boolean aAuto) {
        super(aID, aName, aNameRegional, aTier, 4, "For automatically maintaining Multiblocks", new ITexture[0]);
        this.mAuto = aAuto;
    }

    public MTEHatchMaintenance(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, boolean aAuto) {
        super(aName, aTier, aAuto ? 4 : 1, aDescription, aTextures);
        this.mAuto = aAuto;
    }

    private static ItemStack[] getAutoMaintenanceInputs() {
        if (sAutoMaintenanceInputs == null) {
            sAutoMaintenanceInputs = new ItemStack[]{ItemList.Duct_Tape.get(4L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.cell, Materials.Lubricant, 2L), GTOreDictUnificator.get(OrePrefixes.screw, Materials.Steel, 4L), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.HV, 2L)};
        }
        return sAutoMaintenanceInputs;
    }

    @Override
    public String[] getDescription() {
        String[] desc;
        if (this.mAuto) {
            desc = new String[this.mDescriptionArray.length + 3];
            System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
            desc[this.mDescriptionArray.length] = "4 Ducttape, 2 Lubricant Cells";
            desc[this.mDescriptionArray.length + 1] = "4 Steel Screws, 2 HV Circuits";
            desc[this.mDescriptionArray.length + 2] = "For each autorepair";
        } else {
            desc = new String[this.mDescriptionArray.length + 1];
            System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
            desc[this.mDescriptionArray.length] = "Cannot be shared between Multiblocks!";
        }
        return desc;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        if (this.mAuto) {
            return new ITexture[]{aBaseTexture, TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_IDLE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_IDLE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_MAINTENANCE).extFacing().build()};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        if (this.mAuto) {
            return new ITexture[]{aBaseTexture, TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_MAINTENANCE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_DUCTTAPE).extFacing().build()};
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return this.mAuto && GTMod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        if (aTileEntity.getMetaTileID() == 111) {
            return new MTEHatchMaintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, true);
        }
        return new MTEHatchMaintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, false);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (side == aBaseMetaTileEntity.getFrontFacing()) {
            if (aBaseMetaTileEntity.isClientSide()) {
                return true;
            }
            if (aPlayer instanceof FakePlayer && !aPlayer.func_146103_bH().getName().endsWith(".robot")) {
                return false;
            }
            ItemStack tStack = aPlayer.func_71045_bC();
            if (tStack != null) {
                if (tStack.func_77973_b() instanceof ItemToolbox) {
                    this.applyToolbox(tStack, aPlayer);
                } else if (ItemList.Duct_Tape.isStackEqual(tStack)) {
                    this.mSolderingTool = true;
                    this.mCrowbar = true;
                    this.mHardHammer = true;
                    this.mSoftHammer = true;
                    this.mScrewdriver = true;
                    this.mWrench = true;
                    this.getBaseMetaTileEntity().setActive(false);
                    if (--tStack.field_77994_a == 0) {
                        aPlayer.field_71071_by.field_70462_a[aPlayer.field_71071_by.field_70461_c] = null;
                    }
                } else {
                    this.openGui(aPlayer);
                }
            } else {
                this.openGui(aPlayer);
            }
            return true;
        }
        return false;
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isClientSide()) {
            StructureLibAPI.queryAlignment((IAlignmentProvider)((IAlignmentProvider)aBaseMetaTileEntity));
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mAuto && aTick % 100L == 0L) {
            aBaseMetaTileEntity.setActive(!this.isRecipeInputEqual(false));
        }
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (wrenchingSide != this.getBaseMetaTileEntity().getFrontFacing()) {
            return super.onWrenchRightClick(side, wrenchingSide, entityPlayer, aX, aY, aZ);
        }
        if (!entityPlayer.func_70093_af() && this.isRotationChangeAllowed()) {
            this.toolSetRotation(null);
            return true;
        }
        return false;
    }

    public boolean autoMaintainance() {
        return this.isRecipeInputEqual(true);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess) {
        int amt;
        ItemStack[] mInputs;
        for (ItemStack tStack : mInputs = MTEHatchMaintenance.getAutoMaintenanceInputs()) {
            if (tStack == null) continue;
            amt = tStack.field_77994_a;
            boolean temp = true;
            ItemStack[] itemStackArray = this.mInventory;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack aStack = itemStackArray[i];
                if (!GTUtility.areUnificationsEqual(aStack, tStack, true) && !GTUtility.areUnificationsEqual(GTOreDictUnificator.get(false, aStack), tStack, true) || (amt -= aStack.field_77994_a) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            block2: for (ItemStack tStack : mInputs) {
                if (tStack == null) continue;
                amt = tStack.field_77994_a;
                for (ItemStack aStack : this.mInventory) {
                    if (!GTUtility.areUnificationsEqual(aStack, tStack, true) && !GTUtility.areUnificationsEqual(GTOreDictUnificator.get(false, aStack), tStack, true)) continue;
                    if (aStack.field_77994_a < amt) {
                        amt -= aStack.field_77994_a;
                        aStack.field_77994_a = 0;
                        continue;
                    }
                    aStack.field_77994_a -= amt;
                    continue block2;
                }
            }
            this.mCrowbar = true;
            this.mHardHammer = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mSolderingTool = true;
            this.mWrench = true;
            this.updateSlots();
        }
        return true;
    }

    public void onToolClick(ItemStack aStack, EntityLivingBase aPlayer, IInventory aToolboxInventory) {
        if (aStack == null || aPlayer == null) {
            return;
        }
        if (aStack.func_77973_b() instanceof ItemToolbox && aPlayer instanceof EntityPlayer) {
            this.applyToolbox(aStack, (EntityPlayer)aPlayer);
            return;
        }
        if (GTUtility.isStackInList(aStack, (Collection<GTItemStack>)GregTechAPI.sWrenchList) && !this.mWrench && GTModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mWrench = true;
        }
        if (GTUtility.isStackInList(aStack, (Collection<GTItemStack>)GregTechAPI.sScrewdriverList) && !this.mScrewdriver && GTModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mScrewdriver = true;
        }
        if (GTUtility.isStackInList(aStack, (Collection<GTItemStack>)GregTechAPI.sSoftHammerList) && !this.mSoftHammer && GTModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mSoftHammer = true;
        }
        if (GTUtility.isStackInList(aStack, (Collection<GTItemStack>)GregTechAPI.sHardHammerList) && !this.mHardHammer && GTModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mHardHammer = true;
        }
        if (GTUtility.isStackInList(aStack, (Collection<GTItemStack>)GregTechAPI.sCrowbarList) && !this.mCrowbar && GTModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mCrowbar = true;
        }
        if (!this.mSolderingTool && GTModHandler.useSolderingIron(aStack, aPlayer, aToolboxInventory)) {
            this.mSolderingTool = true;
        }
        if (GTOreDictUnificator.isItemStackInstanceOf(aStack, "craftingDuctTape")) {
            this.mSolderingTool = true;
            this.mCrowbar = true;
            this.mHardHammer = true;
            this.mSoftHammer = true;
            this.mScrewdriver = true;
            this.mWrench = true;
            this.getBaseMetaTileEntity().setActive(false);
            --aStack.field_77994_a;
        }
        if (this.mSolderingTool && aPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP tPlayer = (EntityPlayerMP)aPlayer;
            try {
                GTMod.achievements.issueAchievement((EntityPlayer)tPlayer, "maintainance");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onToolClick(ItemStack aStack, EntityLivingBase aPlayer) {
        this.onToolClick(aStack, aPlayer, null);
    }

    private void applyToolbox(ItemStack aStack, EntityPlayer aPlayer) {
        ItemToolbox aToolbox = (ItemToolbox)aStack.func_77973_b();
        IHasGui aToolboxGUI = aToolbox.getInventory(aPlayer, aStack);
        for (int i = 0; i < aToolboxGUI.func_70302_i_(); ++i) {
            if (aToolboxGUI.func_70301_a(i) == null) continue;
            this.onToolClick(aToolboxGUI.func_70301_a(i), (EntityLivingBase)aPlayer, (IInventory)aToolboxGUI);
            if (aToolboxGUI.func_70301_a(i) == null || aToolboxGUI.func_70301_a((int)i).field_77994_a > 0) continue;
            aToolboxGUI.func_70299_a(i, null);
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.mAuto && GTMod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (this.mAuto && GTMod.gregtechproxy.mAMHInteraction) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (!GTUtility.areStacksEqual(GTOreDictUnificator.get(false, aStack), GTOreDictUnificator.get(false, this.func_70301_a(i)))) continue;
                return i == aIndex;
            }
            for (ItemStack tInput : MTEHatchMaintenance.getAutoMaintenanceInputs()) {
                if (!GTUtility.areUnificationsEqual(tInput, aStack, true) && !GTUtility.areUnificationsEqual(GTOreDictUnificator.get(false, aStack), tInput, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.mAuto) {
            this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[0]);
        } else {
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.SLOT_MAINTENANCE).setPos(78, 33).setSize(20, 20))).widget(new SlotWidget(BaseSlot.empty()){

                public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
                    return false;
                }

                protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                    if (cursorStack == null) {
                        return;
                    }
                    MTEHatchMaintenance.this.onToolClick(cursorStack, (EntityLivingBase)this.getContext().getPlayer());
                    if (cursorStack.field_77994_a < 1) {
                        this.getContext().getPlayer().field_71071_by.func_70437_b(null);
                    }
                    if (this.getContext().getPlayer() instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.getContext().getPlayer()).func_71113_k();
                    }
                }
            }.disableShiftInsert().setBackground(new IDrawable[]{GTUITextures.TRANSPARENT}).setPos(79, 34))).widget(new TextWidget("Click with Tool to repair.").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(8, 12));
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mRotation", (byte)this.rotation.getIndex());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.rotation = Rotation.byIndex((int)aNBT.func_74771_c("mRotation"));
        super.loadNBTData(aNBT);
    }

    public ExtendedFacing getExtendedFacing() {
        return ExtendedFacing.of((ForgeDirection)this.getBaseMetaTileEntity().getFrontFacing(), (Rotation)this.rotation, (Flip)Flip.NONE);
    }

    public void setExtendedFacing(ExtendedFacing alignment) {
        boolean changed = false;
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        if (base.getFrontFacing() != alignment.getDirection()) {
            base.setFrontFacing(alignment.getDirection());
            changed = true;
        }
        if (this.rotation != alignment.getRotation()) {
            this.rotation = alignment.getRotation();
            changed = true;
        }
        if (changed) {
            if (base.isServerSide() && !GregTechAPI.isDummyWorld(base.getWorld())) {
                StructureLibAPI.sendAlignment((IAlignmentProvider)((IAlignmentProvider)base), (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(base.getWorld().field_73011_w.field_76574_g, (double)base.getXCoord(), (double)base.getYCoord(), (double)base.getZCoord(), 512.0));
            } else {
                base.issueTextureUpdate();
            }
        }
    }

    public IAlignmentLimits getAlignmentLimits() {
        return (d, r, f) -> f.isNotFlipped();
    }

    public boolean isFlipChangeAllowed() {
        return false;
    }

    public boolean isRotationChangeAllowed() {
        return true;
    }
}

