/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public interface IToolStats {
    public void onToolCrafted(ItemStack var1, EntityPlayer var2);

    public void onStatsAddedToTool(MetaGeneratedTool var1, int var2);

    default public void onBreakBlock(@Nonnull EntityPlayer player, int x, int y, int z, @Nonnull Block block, int metadata, @Nullable TileEntity tile, @Nonnull BlockEvent.BreakEvent event) {
    }

    public int getToolDamagePerBlockBreak();

    public int getToolDamagePerDropConversion();

    public int getToolDamagePerContainerCraft();

    public int getToolDamagePerEntityAttack();

    public int getBaseQuality();

    public float getBaseDamage();

    public int getHurtResistanceTime(int var1, Entity var2);

    public float getSpeedMultiplier();

    public float getMaxDurabilityMultiplier();

    public DamageSource getDamageSource(EntityLivingBase var1, Entity var2);

    public String getMiningSound();

    public String getCraftingSound();

    public String getEntityHitSound();

    public String getBreakingSound();

    public Enchantment[] getEnchantments(ItemStack var1);

    public int[] getEnchantmentLevels(ItemStack var1);

    public boolean canBlock();

    public boolean isCrowbar();

    public boolean isGrafter();

    public boolean isChainsaw();

    public boolean isWrench();

    default public boolean isScrewdriver() {
        return false;
    }

    public boolean isWeapon();

    public boolean isRangedWeapon();

    public boolean isMiningTool();

    public boolean isMinableBlock(Block var1, int var2);

    public int convertBlockDrops(List<ItemStack> var1, ItemStack var2, EntityPlayer var3, Block var4, int var5, int var6, int var7, int var8, int var9, boolean var10, BlockEvent.HarvestDropsEvent var11);

    public ItemStack getBrokenItem(ItemStack var1);

    public float getNormalDamageAgainstEntity(float var1, Entity var2, ItemStack var3, EntityPlayer var4);

    public float getMagicDamageAgainstEntity(float var1, Entity var2, ItemStack var3, EntityPlayer var4);

    public IIconContainer getIcon(boolean var1, ItemStack var2);

    public short[] getRGBa(boolean var1, ItemStack var2);

    public float getMiningSpeed(Block var1, int var2, float var3, EntityPlayer var4, World var5, int var6, int var7, int var8);

    default public String getToolTypeName() {
        return null;
    }

    default public byte getMaxMode() {
        return 1;
    }
}

