/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.modularui;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Color;
import java.util.function.DoubleSupplier;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;

public class CircularGaugeDrawable
implements IDrawable {
    public static final double PI_2 = 1.5707963267948966;
    private DoubleSupplier progressSupplier;
    private float minAngle = (float)Math.toRadians(-235.0);
    private float maxAngle = (float)Math.toRadians(45.0);
    private int color = -12378880;
    private float lastAngle = Float.NaN;

    public CircularGaugeDrawable(DoubleSupplier progressSupplier) {
        this.progressSupplier = progressSupplier;
    }

    public void draw(float x0, float y0, float width, float height, float partialTicks) {
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.disableLighting();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        float progress = MathHelper.func_76131_a((float)((float)this.progressSupplier.getAsDouble()), (float)0.0f, (float)1.0f);
        float newDialAngle = this.minAngle + progress * (this.maxAngle - this.minAngle);
        this.lastAngle = Float.isNaN(this.lastAngle) ? newDialAngle : (this.lastAngle + newDialAngle) / 2.0f;
        float angle = this.lastAngle;
        float sinA = (float)Math.sin(-angle);
        float cosA = (float)Math.cos(-angle);
        tessellator.func_78371_b(5);
        tessellator.func_78370_a(Color.getRed((int)this.color), Color.getGreen((int)this.color), Color.getBlue((int)this.color), Color.getAlpha((int)this.color));
        tessellator.func_78377_a((double)(x0 + width * cosA), (double)(y0 - width * sinA), 0.0);
        tessellator.func_78377_a((double)(x0 - (height /= 2.0f) * sinA), (double)(y0 - height * cosA), 0.0);
        tessellator.func_78377_a((double)(x0 + height * sinA), (double)(y0 + height * cosA), 0.0);
        tessellator.func_78377_a((double)(x0 - height * cosA), (double)(y0 + height * sinA), 0.0);
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }
}

