/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.covers;

import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverFactory;
import gregtech.api.covers.CoverPlacer;
import gregtech.api.covers.CoverRegistration;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverDecorative;
import gregtech.common.covers.CoverNone;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class CoverRegistry {
    private static final CoverPlacer DEFAULT_COVER_PLACER = CoverPlacer.builder().build();
    public static final CoverPlacer PRIMITIVE_COVER_PLACER = CoverPlacer.builder().allowOnPrimitiveBlock().build();
    public static final CoverPlacer INTERCEPTS_RIGHT_CLICK_COVER_PLACER = CoverPlacer.builder().blocksCoverableGuiOpening().build();
    private static final Map<GTItemStack, ITexture> coverTextures = new ConcurrentHashMap<GTItemStack, ITexture>();
    private static final Map<GTItemStack, CoverRegistration> coverFactories = new ConcurrentHashMap<GTItemStack, CoverRegistration>();
    private static final CoverRegistration coverNone = new CoverRegistration(null, CoverNone::new, PRIMITIVE_COVER_PLACER);
    public static final Cover NO_COVER = coverNone.buildCover(ForgeDirection.UNKNOWN, null);
    private static GUIColorOverride colorOverride;
    private static final String guiTexturePath = "gregtech:textures/gui/GuiCover.png";
    private static final String NBT_ID = "id";

    public static void registerDecorativeCover(@NotNull ItemStack stack, ITexture cover) {
        CoverRegistry.registerCover(stack, cover, CoverDecorative::new, PRIMITIVE_COVER_PLACER);
    }

    public static void registerCover(@NotNull ItemStack stack, ITexture cover, @NotNull CoverFactory constructor) {
        CoverRegistry.registerCover(stack, cover, constructor, DEFAULT_COVER_PLACER);
    }

    public static void registerCover(@NotNull ItemStack stack, ITexture cover, @NotNull CoverFactory constructor, CoverPlacer factory) {
        if (!coverTextures.containsKey(new GTItemStack(stack))) {
            coverTextures.put(new GTItemStack(stack), cover == null || !cover.isValidTexture() ? Textures.BlockIcons.ERROR_RENDERING[0] : cover);
        }
        coverFactories.put(new GTItemStack(stack), new CoverRegistration(stack, constructor, factory));
    }

    @NotNull
    public static CoverRegistration getRegistration(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return coverNone;
        }
        CoverRegistration factory = coverFactories.get(new GTItemStack(stack));
        if (factory == null) {
            factory = coverFactories.get(new GTItemStack(stack, true));
        }
        return factory == null ? coverNone : factory;
    }

    @NotNull
    public static CoverRegistration getRegistration(int coverId) {
        return CoverRegistry.getRegistration(GTUtility.intToStack(coverId));
    }

    public static CoverPlacer getCoverPlacer(ItemStack stack) {
        return CoverRegistry.getRegistration(stack).getCoverPlacer();
    }

    public static CoverPlacer getCoverPlacer(int coverId) {
        return CoverRegistry.getCoverPlacer(GTUtility.intToStack(coverId));
    }

    public static boolean isCover(@NotNull ItemStack stack) {
        return GTUtility.isStackInList(new GTItemStack(stack), coverTextures.keySet());
    }

    public static ITexture getCoverTexture(int coverId) {
        return coverTextures.get(new GTItemStack(coverId));
    }

    public static void reloadCoverColorOverrides() {
        colorOverride = GUIColorOverride.get(guiTexturePath);
    }

    public static int getTextColorOrDefault(String textType, int defaultColor) {
        return colorOverride.getTextColorOrDefault(textType, defaultColor);
    }

    public static CoverRegistration getRegistrationFromNbt(NBTTagCompound nbt) {
        int coverID = nbt.func_74762_e(NBT_ID);
        return CoverRegistry.getRegistration(coverID);
    }

    public static void writeCoverToNbt(Cover cover, NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_ID, cover.getCoverID());
        cover.writeToNBT(nbt);
    }

    public static void cover(ICoverable coverable, int down, int up, int north, int south, int west, int east) {
        coverable.attachCover(CoverRegistry.getRegistration(down).buildCover(ForgeDirection.DOWN, coverable));
        coverable.attachCover(CoverRegistry.getRegistration(up).buildCover(ForgeDirection.UP, coverable));
        coverable.attachCover(CoverRegistry.getRegistration(north).buildCover(ForgeDirection.NORTH, coverable));
        coverable.attachCover(CoverRegistry.getRegistration(south).buildCover(ForgeDirection.SOUTH, coverable));
        coverable.attachCover(CoverRegistry.getRegistration(west).buildCover(ForgeDirection.WEST, coverable));
        coverable.attachCover(CoverRegistry.getRegistration(east).buildCover(ForgeDirection.EAST, coverable));
    }

    static {
        GregTechAPI.sItemStackMappings.add(coverTextures);
        GregTechAPI.sItemStackMappings.add(coverFactories);
    }
}

