/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.covers.CoverContext;
import gregtech.api.covers.CoverFactory;
import gregtech.api.covers.CoverPlacer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class CoverRegistration {
    private final ItemStack coverIdStack;
    private final CoverFactory factory;
    private final CoverPlacer coverPlacer;

    public CoverRegistration(ItemStack coverIdStack, CoverFactory factory, CoverPlacer coverPlacer) {
        this.coverIdStack = coverIdStack;
        this.factory = factory;
        this.coverPlacer = coverPlacer;
    }

    public Cover buildCover(ForgeDirection side, ICoverable coverable) {
        return this.buildCoverFromContext(side, coverable, null);
    }

    public Cover buildCover(ForgeDirection side, ICoverable coverable, @NotNull NBTTagCompound nbt) {
        return this.buildCoverFromContext(side, coverable, nbt);
    }

    public Cover buildCover(ForgeDirection side, ICoverable coverable, @NotNull ByteArrayDataInput data) {
        return this.buildCoverFromContext(side, coverable, data);
    }

    public Cover buildCover(@NotNull ForgeDirection side, ICoverable coverable, @NotNull ItemStack coverItem) {
        return this.buildCoverFromContext(side, coverable, coverItem);
    }

    private Cover buildCoverFromContext(ForgeDirection side, ICoverable coverable, Object initializer) {
        return this.factory.buildCover(new CoverContext(GTUtility.stackToInt(this.coverIdStack), side, coverable, initializer));
    }

    public CoverPlacer getCoverPlacer() {
        return this.coverPlacer;
    }
}

