/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;

public class MTEUniversalChemicalFuelEngine
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    protected final double DIESEL_EFFICIENCY_COEFFICIENT = 0.04;
    protected final double GAS_EFFICIENCY_COEFFICIENT = 0.04;
    protected final double ROCKET_EFFICIENCY_COEFFICIENT = 0.005;
    protected final double EFFICIENCY_CEILING = 1.5;
    protected final int HEATING_TIMER = 200;
    private long tEff;
    private int heatingTicks;
    private boolean isStoppingSafe;
    private IStructureDefinition<MTEUniversalChemicalFuelEngine> multiDefinition = null;

    public MTEUniversalChemicalFuelEngine(String name) {
        super(name);
        this.useLongPower = true;
    }

    public MTEUniversalChemicalFuelEngine(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.useLongPower = true;
    }

    public final boolean addInputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mInputHatches.add((MTEHatchInput)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addDynamoHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((MTEHatchDynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoMulti) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eDynamoMulti.add((MTEHatchDynamoMulti)aMetaTileEntity);
        }
        return false;
    }

    public IStructureDefinition<MTEUniversalChemicalFuelEngine> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"TTTTT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTTTT"}, {"TTTTT", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "TTTTT"}, {"TT~TT", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "TTETT"}, {"TTWTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT"}})).addElement('T', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)2)).addElement('W', HatchElement.Maintenance.newAny(50, 1)).addElement('M', HatchElement.Muffler.newAny(50, 2)).addElement('S', HatchElement.InputHatch.newAny(50, 3)).addElement('E', HatchElement.Dynamo.newAny(50, 4)).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)14)).addElement('C', StructureUtility.ofBlock((Block)Loaders.titaniumPlatedCylinder, (int)0)).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)4)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)13)).build();
        }
        return this.multiDefinition;
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(this.mName, 2, 2, 0);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 2, 2, 0, stackSize, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("UniversalChemicalFuelEngine.hint", 11);
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return (int)Math.sqrt(this.getPowerFlow());
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Chemical Engine, UCFE").addInfo("BURNING BURNING BURNING").addInfo("Use combustible liquid to generate power.").addInfo("You need to supply Combustion Promoter to keep it running.").addInfo("It will consume all the fuel and promoter in the hatch every second.").addInfo("If the Dynamo Hatch's buffer fills up, the machine will stop.").addInfo("When turned on, there is a 10-second period where the machine will not stop.").addInfo("Even if it doesn't stop, all the fuel in the hatch will be consumed.").addInfo("The efficiency is determined by the proportion of Combustion Promoter to fuel.").addInfo("The proportion is bigger, and the efficiency will be higher.").addInfo("It creates sqrt(Current Output Power) pollution every second").addInfo("If you forget to supply Combustion Promoter, this engine will swallow all the fuel " + EnumChatFormatting.YELLOW + "without outputting energy" + EnumChatFormatting.GRAY + ".").addInfo("The efficiency is up to 150%.").addTecTechHatchInfo().beginStructureBlock(5, 4, 9, false).addController("Mid of the second layer").addCasingInfoExactly("Stable Titanium Machine Casing", 93, false).addCasingInfoExactly("Titanium Gear Box Casing", 14, false).addCasingInfoExactly("Engine Intake Casing", 14, false).addCasingInfoExactly("Titanium Plated Cylinder", 14, false).addCasingInfoExactly("Titanium Pipe Casing", 93, false).addMaintenanceHatch("Hint block with dot 1").addMufflerHatch("Hint block with dot 2 (fill all slots with mufflers)").addInputHatch("Hint block with dot 3 (fill all slots with input hatches)").addDynamoHatch("Hint block with dot 4").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        long PromoterAmount;
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        CheckRecipeResult result = this.processFuel(tFluids, RecipeMaps.dieselFuels, PromoterAmount = this.findLiquidAmount(this.getPromoter(), tFluids), 0.04, 1.0);
        if (result.wasSuccessful()) {
            return result;
        }
        result = this.processFuel(tFluids, RecipeMaps.gasTurbineFuels, PromoterAmount, 0.04, 1.0);
        if (result.wasSuccessful()) {
            return result;
        }
        result = this.processFuel(tFluids, GTPPRecipeMaps.rocketFuels, PromoterAmount, 0.005, 3.0);
        if (result.wasSuccessful()) {
            return result;
        }
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    protected CheckRecipeResult processFuel(ArrayList<FluidStack> tFluids, RecipeMap<FuelBackend> recipeMap, long PromoterAmount, double efficiencyCoefficient, double FuelsValueBonus) {
        for (GTRecipe recipe : recipeMap.getAllRecipes()) {
            long FuelAmount;
            FluidStack tFuel = this.findFuel(recipe);
            if (tFuel == null || (FuelAmount = this.findLiquidAmount(tFuel, tFluids)) == 0L) continue;
            this.calculateEfficiency(FuelAmount, PromoterAmount, efficiencyCoefficient);
            this.consumeAllLiquid(tFuel, tFluids);
            this.consumeAllLiquid(this.getPromoter(), tFluids);
            this.setPowerFlow((long)((double)(FuelAmount * (long)recipe.mSpecialValue) * FuelsValueBonus / 20.0));
            this.mMaxProgresstime = 20;
            this.updateSlots();
            return CheckRecipeResultRegistry.GENERATING;
        }
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.heatingTicks = 0;
        super.stopMachine(reason);
    }

    @Override
    public boolean onRunningTick(ItemStack stack) {
        super.onRunningTick(stack);
        if (this.heatingTicks < 200) {
            ++this.heatingTicks;
            this.isStoppingSafe = true;
        } else if (this.isStoppingSafe) {
            this.isStoppingSafe = false;
        }
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.addAutoEnergy();
        }
        return true;
    }

    @Override
    public String[] getInfoData() {
        String[] info = super.getInfoData();
        info[4] = StatCollector.func_74837_a((String)"gg.scanner.info.generator.generates", (Object[])new Object[]{EnumChatFormatting.RED + GTUtility.formatNumbers(this.getPowerFlow() * this.tEff / 10000L) + EnumChatFormatting.RESET});
        info[6] = StatCollector.func_74838_a((String)"gg.scanner.info.generator.problems") + " " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"gg.scanner.info.generator.efficiency") + " " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((double)this.tEff / 100.0) + EnumChatFormatting.RESET + " %";
        return info;
    }

    void addAutoEnergy() {
        MTEHatch tHatch;
        long exEU = this.getPowerFlow() * this.tEff / 10000L;
        if (!this.mDynamoHatches.isEmpty()) {
            tHatch = (MTEHatchDynamo)this.mDynamoHatches.get(0);
            if (((MTEHatchDynamo)tHatch).maxEUOutput() * tHatch.maxAmperesOut() >= exEU) {
                tHatch.setEUVar(Math.min(((MTEHatchDynamo)tHatch).maxEUStore(), tHatch.getBaseMetaTileEntity().getStoredEU() + exEU));
            } else if (!this.isStoppingSafe) {
                this.stopMachine(ShutDownReasonRegistry.NONE);
            }
        }
        if (!this.eDynamoMulti.isEmpty()) {
            tHatch = (MTEHatchDynamoMulti)this.eDynamoMulti.get(0);
            if (((MTEHatchDynamoMulti)tHatch).maxEUOutput() * ((MTEHatchDynamoMulti)tHatch).maxAmperesOut() >= exEU) {
                tHatch.setEUVar(Math.min(((MTEHatchDynamoMulti)tHatch).maxEUStore(), tHatch.getBaseMetaTileEntity().getStoredEU() + exEU));
            } else if (!this.isStoppingSafe) {
                this.stopMachine(ShutDownReasonRegistry.NONE);
            }
        }
    }

    public FluidStack getPromoter() {
        return FluidRegistry.getFluidStack((String)"combustionpromotor", (int)1);
    }

    public FluidStack findFuel(GTRecipe aFuel) {
        if (aFuel.mInputs != null && aFuel.mInputs.length > 0) {
            return GTUtility.getFluidForFilledItem(aFuel.mInputs[0], true);
        }
        return aFuel.mFluidInputs[0];
    }

    public void calculateEfficiency(long aFuel, long aPromoter, double coefficient) {
        if (aPromoter == 0L) {
            this.tEff = 0L;
            return;
        }
        this.tEff = (int)(Math.exp(-coefficient * (double)aFuel / (double)aPromoter) * 1.5 * 10000.0);
    }

    public long findLiquidAmount(FluidStack liquid, List<FluidStack> input) {
        long cnt = 0L;
        for (FluidStack fluid : input) {
            if (!fluid.isFluidEqual(liquid)) continue;
            cnt += (long)fluid.amount;
        }
        if (cnt < 0L) {
            cnt = 0L;
        }
        return cnt;
    }

    public void consumeAllLiquid(FluidStack liquid, List<FluidStack> input) {
        for (FluidStack fluid : input) {
            if (!fluid.isFluidEqual(liquid)) continue;
            fluid.amount = 0;
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEUniversalChemicalFuelEngine(this.mName);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 2, 0, elementBudget, env, false, true);
    }
}

