/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.loaders;

import bartworks.API.SideReference;
import bartworks.client.renderer.RendererGlassBlock;
import bartworks.client.renderer.RendererSwitchingColorFluid;
import bartworks.common.blocks.BlockBioFluid;
import bartworks.common.tileentities.classic.TileEntityDimIDBridge;
import bartworks.util.BioCulture;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.fluid.GTFluidFactory;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaGeneratedItem98;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidLoader {
    public static IIcon autogenIIcon;
    public static Fluid ff;
    public static int renderID;
    public static Block bioFluidBlock;
    public static Fluid[] BioLabFluidMaterials;
    public static ItemStack[] BioLabFluidCells;
    public static Fluid fulvicAcid;
    public static Fluid heatedfulvicAcid;
    public static Fluid Kerogen;

    public static void run() {
        renderID = RenderingRegistry.getNextAvailableRenderId();
        ff = new Fluid("BWfakeFluid");
        GregTechAPI.sGTBlockIconload.add(() -> ff.setIcons(GregTechAPI.sBlockIcons.func_94245_a(Mods.GregTech.getResourcePath("fluids", "fluid.molten.autogenerated"))));
        fulvicAcid = FluidLoader.createAndRegisterFluid("Fulvic Acid", new Color(20, 20, 20));
        heatedfulvicAcid = FluidLoader.createAndRegisterFluid("Heated Fulvic Acid", new Color(40, 20, 20), 720);
        Kerogen = FluidLoader.createAndRegisterFluid("Kerogen", new Color(85, 85, 85));
        BioLabFluidMaterials = new Fluid[]{FluidLoader.createAndRegisterFluid("FluorecentdDNA", new Color(125, 50, 170)), FluidLoader.createAndRegisterFluid("EnzymesSollution", new Color(240, 200, 125)), FluidLoader.createAndRegisterFluid("Penicillin", new Color(255, 255, 255)), FluidLoader.createAndRegisterFluid("Polymerase", new Color(110, 180, 110))};
        BioLabFluidCells = new ItemStack[BioLabFluidMaterials.length];
        MetaGeneratedItem98.FluidCell[] fluidCells = new MetaGeneratedItem98.FluidCell[]{MetaGeneratedItem98.FluidCell.FLUORESCENT_DNA, MetaGeneratedItem98.FluidCell.ENZYME_SOLUTION, MetaGeneratedItem98.FluidCell.PENICILLIN, MetaGeneratedItem98.FluidCell.POLYMERASE};
        for (int i = 0; i < fluidCells.length; ++i) {
            FluidLoader.BioLabFluidCells[i] = fluidCells[i].get();
        }
        FluidStack dnaFluid = Mods.Gendustry.isModLoaded() ? FluidRegistry.getFluidStack((String)"liquiddna", (int)100) : Materials.Biomass.getFluid(100L);
        for (BioCulture B : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            if (!B.isBreedable()) continue;
            B.setFluid(GTFluidFactory.builder(B.getName().replace(" ", "").toLowerCase() + "fluid").withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)B.getColor().getRed(), (short)B.getColor().getBlue(), (short)B.getColor().getGreen()}).withLocalizedName(B.getLocalisedName() + " Fluid").withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid());
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10)).fluidInputs(new FluidStack(B.getFluid(), 1000)).fluidOutputs(dnaFluid).duration(500).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.centrifugeRecipes);
        }
        bioFluidBlock = new BlockBioFluid();
        GameRegistry.registerBlock((Block)bioFluidBlock, (String)"coloredFluidBlock");
        GameRegistry.registerTileEntity(TileEntityDimIDBridge.class, (String)"bwTEDimIDBridge");
        if (SideReference.Side.Client) {
            RendererSwitchingColorFluid.register();
            RendererGlassBlock.register();
        }
    }

    public static Fluid createAndRegisterFluid(String Name, Color color) {
        return GTFluidFactory.builder(Name).withLocalizedName(Name).withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)color.getRed(), (short)color.getGreen(), (short)color.getBlue(), (short)color.getAlpha()}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid();
    }

    public static Fluid createAndRegisterFluid(String Name, Color color, int temperature) {
        return GTFluidFactory.builder(Name).withLocalizedName(Name).withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)color.getRed(), (short)color.getGreen(), (short)color.getBlue(), (short)color.getAlpha()}).withStateAndTemperature(FluidState.LIQUID, temperature).buildAndRegister().asFluid();
    }
}

