/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.MakeModelStaticVisitor;
import net.glease.tc4tweak.asm.TC4Transformer;
import net.glease.tc4tweak.asm.TESRGetBlockTypeNullSafetyVisitor;
import net.glease.tc4tweak.asm.TransformerFactory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class TileAlchemyFurnaceAdvancedRendererVisitor
extends ClassVisitor {
    static final TransformerFactory FACTORY = TESRGetBlockTypeNullSafetyVisitor.FACTORY.chain(MakeModelStaticVisitor::new).chain(TileAlchemyFurnaceAdvancedRendererVisitor::new);

    public TileAlchemyFurnaceAdvancedRendererVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("renderQuadCenteredFromIcon")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new RenderQuadCenteredFromIconVisitor(this.api, mv);
        }
        return mv;
    }

    private static class RenderQuadCenteredFromIconVisitor
    extends MethodVisitor {
        public RenderQuadCenteredFromIconVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 184 && owner.equals("net/minecraft/client/renderer/RenderHelper") && desc.equals("()V")) {
                if (name.equals("disableStandardItemLighting")) {
                    TC4Transformer.log.trace("Replacing INVOKESTATIC {}#{}{} with GL11.glDisable(GL11.GL_LIGHTING)", new Object[]{owner, name, desc});
                    this.mv.visitIntInsn(17, 2896);
                    this.mv.visitMethodInsn(184, "org/lwjgl/opengl/GL11", "glDisable", "(I)V", false);
                } else if (name.equals("enableStandardItemLighting")) {
                    TC4Transformer.log.trace("Replacing INVOKESTATIC {}#{}{} with GL11.glEnable(GL11.GL_LIGHTING)", new Object[]{owner, name, desc});
                    this.mv.visitIntInsn(17, 2896);
                    this.mv.visitMethodInsn(184, "org/lwjgl/opengl/GL11", "glEnable", "(I)V", false);
                }
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

