/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.Quad;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadProvider;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadOrientation;
import com.gtnewhorizon.gtnhlib.client.renderer.util.DirectionUtil;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.ModeledBlock;
import com.gtnewhorizons.angelica.utils.ObjectPooler;
import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRenderer {
    private static final BlockPos POS_ZERO = new BlockPos(0, 0, 0);
    private final Random random = new XoRoShiRoRandom();
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final boolean useAmbientOcclusion;
    private final boolean useSodiumAO;
    private boolean useSeparateAo;
    private final LightPipelineProvider lighters;
    private final BlockOcclusionCache occlusionCache;
    private final ObjectPooler<QuadView> quadPool = new ObjectPooler<QuadView>(Quad::new);

    public BlockRenderer(LightPipelineProvider lighters) {
        this.lighters = lighters;
        this.useAmbientOcclusion = Minecraft.func_71410_x().field_71474_y.field_74348_k > 0;
        this.useSodiumAO = SodiumClientMod.options().quality.useSodiumAO;
        this.occlusionCache = new BlockOcclusionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean renderModel(IBlockAccess world, RenderBlocks renderBlocks, Block block, int meta, BlockPos pos, ChunkModelBuffers buffers, boolean cull, long seed) {
        LightMode mode = LightMode.SMOOTH;
        LightPipeline lighter = this.lighters.getLighter(mode);
        this.useSeparateAo = AngelicaConfig.enableIris && BlockRenderingSettings.INSTANCE.shouldUseSeparateAo();
        boolean rendered = false;
        QuadProvider model = ((ModeledBlock)block).getModel();
        if (model != null) {
            int color = model.getColor(world, (IBlockPos)pos, block, meta, this.random);
            for (ForgeDirection dir : DirectionUtil.ALL_DIRECTIONS) {
                List quads;
                this.random.setSeed(seed);
                if (cull) {
                    if (!this.occlusionCache.shouldDrawSide(block, meta, world, pos, dir)) continue;
                }
                if ((quads = model.getQuads(world, (IBlockPos)pos, block, meta, dir, this.random, color, this.quadPool::getInstance)).isEmpty()) continue;
                this.renderQuadList(pos, lighter, buffers, quads, ModelQuadFacing.fromDirection((ForgeDirection)dir), true);
                rendered = true;
                if (!model.isDynamic()) continue;
                for (QuadView q : quads) {
                    this.quadPool.releaseInstance(q);
                }
            }
            return rendered;
        } else {
            try {
                TessellatorManager.startCapturing();
                CapturingTessellator tess = (CapturingTessellator)TessellatorManager.get();
                tess.func_78382_b();
                tess.setOffset(POS_ZERO);
                tess.func_78373_b((double)(-pos.x), (double)(-pos.y), (double)(-pos.z));
                renderBlocks.func_147805_b(block, pos.x, pos.y, pos.z);
                List quads = TessellatorManager.stopCapturingToPooledQuads();
                tess.resetOffset();
                for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
                    this.random.setSeed(seed);
                    this.renderQuadList(pos, lighter, buffers, quads, facing, this.useAmbientOcclusion && this.useSodiumAO);
                }
                if (quads.isEmpty()) return rendered;
                rendered = true;
                return rendered;
            }
            finally {
                TessellatorManager.cleanup();
            }
        }
    }

    private void renderQuadList(BlockPos pos, LightPipeline lighter, ChunkModelBuffers buffers, List<QuadView> quads, ModelQuadFacing facing, boolean useSodiumLight) {
        ForgeDirection cullFace = ModelQuadFacing.toDirection((ModelQuadFacing)facing);
        ModelVertexSink sink = buffers.getSink(facing);
        sink.ensureCapacity(quads.size() * 4);
        ChunkRenderData.Builder renderData = buffers.getRenderData();
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            QuadView quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            if (quad.getFace() != cullFace) continue;
            if (useSodiumLight || this.useSeparateAo) {
                lighter.calculate((ModelQuadView)quad, pos, light, cullFace, quad.getLightFace(), quad.isShade());
            }
            this.renderQuad(sink, quad, light, renderData, useSodiumLight);
        }
        sink.flush();
    }

    private void renderQuad(ModelVertexSink sink, QuadView quad, QuadLightData light, ChunkRenderData.Builder renderData, boolean useSodiumLight) {
        ModelQuadOrientation order = useSodiumLight || this.useSeparateAo ? ModelQuadOrientation.orient((float[])light.br) : ModelQuadOrientation.NORMAL;
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = order.getVertexIndex(dstIndex);
            float x = quad.getX(srcIndex);
            float y = quad.getY(srcIndex);
            float z = quad.getZ(srcIndex);
            int color = quad.getColor(srcIndex);
            float ao = light.br[srcIndex];
            if (this.useSeparateAo) {
                color &= 0xFFFFFF;
                color |= (int)(ao * 255.0f) << 24;
            } else {
                color = useSodiumLight ? ColorABGR.mul(quad.getColor(srcIndex), light.br[srcIndex]) : quad.getColor(srcIndex);
            }
            float u = quad.getTexU(srcIndex);
            float v = quad.getTexV(srcIndex);
            int lm = this.useSeparateAo ? ModelQuadUtil.mergeBakedLight(quad.getLight(srcIndex), light.lm[srcIndex]) : (useSodiumLight ? light.lm[srcIndex] : quad.getLight(srcIndex));
            sink.writeQuad(x, y, z, color, u, v, lm);
        }
        TextureAtlasSprite sprite = quad.rubidium$getSprite();
        if (sprite != null) {
            renderData.addSprite(sprite);
        }
    }

    public static class Flags {
        boolean hasTexture;
        public boolean hasBrightness;
        public boolean hasColor;
        public boolean hasNormals;

        public Flags(byte flags) {
            this.hasTexture = (flags & 1) != 0;
            this.hasBrightness = (flags & 2) != 0;
            this.hasColor = (flags & 4) != 0;
            this.hasNormals = (flags & 8) != 0;
        }

        public Flags(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }

        public byte toByte() {
            byte flags = 0;
            if (this.hasTexture) {
                flags = (byte)(flags | 1);
            }
            if (this.hasBrightness) {
                flags = (byte)(flags | 2);
            }
            if (this.hasColor) {
                flags = (byte)(flags | 4);
            }
            if (this.hasNormals) {
                flags = (byte)(flags | 8);
            }
            return flags;
        }
    }
}

