/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderzoo.CommonProxy;
import crazypants.enderzoo.charge.BlockConcussionCharge;
import crazypants.enderzoo.charge.BlockConfusingCharge;
import crazypants.enderzoo.charge.BlockEnderCharge;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.enchantment.Enchantments;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.item.ItemConfusingDust;
import crazypants.enderzoo.item.ItemEnderFragment;
import crazypants.enderzoo.item.ItemForCreativeMenuIcon;
import crazypants.enderzoo.item.ItemGuardiansBow;
import crazypants.enderzoo.item.ItemSpawnEgg;
import crazypants.enderzoo.item.ItemWitheringDust;
import crazypants.enderzoo.spawn.MobSpawnEventHandler;
import crazypants.enderzoo.spawn.MobSpawns;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="EnderZoo", name="Ender Zoo", version="1.3.2", dependencies="required-after:Forge@10.13.0.1150,)", guiFactory="crazypants.enderzoo.config.ConfigFactoryEnderZoo")
public class EnderZoo {
    public static final String MODID = "EnderZoo";
    public static final String MOD_NAME = "Ender Zoo";
    public static final String VERSION = "1.3.2";
    @Mod.Instance(value="EnderZoo")
    public static EnderZoo instance;
    @SidedProxy(clientSide="crazypants.enderzoo.ClientProxy", serverSide="crazypants.enderzoo.CommonProxy")
    public static CommonProxy proxy;
    public static ItemSpawnEgg itemSpawnEgg;
    public static ItemWitheringDust itemWitheringDust;
    public static ItemConfusingDust itemConfusingDust;
    public static ItemEnderFragment itemEnderFragment;
    public static ItemForCreativeMenuIcon itemForCreativeMenuIcon;
    public static ItemGuardiansBow itemGuardiansBow;
    public static BlockConfusingCharge blockConfusingCharge;
    public static BlockEnderCharge blockEnderCharge;
    public static BlockConcussionCharge blockConcussionCharge;
    public static MobSpawnEventHandler spawnEventHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        itemForCreativeMenuIcon = ItemForCreativeMenuIcon.create();
        Config.load(event);
        for (MobInfo mob : MobInfo.values()) {
            this.registerEntity(mob);
        }
        itemSpawnEgg = ItemSpawnEgg.create();
        itemWitheringDust = ItemWitheringDust.create();
        itemConfusingDust = ItemConfusingDust.create();
        itemEnderFragment = ItemEnderFragment.create();
        itemGuardiansBow = ItemGuardiansBow.create();
        if (Config.confusingChargeEnabled) {
            blockConfusingCharge = BlockConfusingCharge.create();
        }
        if (Config.enderChargeEnabled) {
            blockEnderCharge = BlockEnderCharge.create();
        }
        if (Config.concussionChargeEnabled) {
            blockConcussionCharge = BlockConcussionCharge.create();
        }
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"crazypants.enderzoo.waila.WailaCompat.load");
    }

    private void registerEntity(MobInfo mob) {
        if (!mob.isEnabled()) {
            return;
        }
        int entityID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(mob.getClz(), (String)mob.getName(), (int)entityID, (int)mob.getEggBackgroundColor(), (int)mob.getEggForegroundColor());
        EntityRegistry.registerModEntity(mob.getClz(), (String)mob.getName(), (int)entityID, (Object)this, (int)64, (int)3, (boolean)true);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        instance = this;
        proxy.load();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Enchantments.getInstance();
        MobSpawns.instance.loadSpawnConfig();
        this.addRecipes();
        if (Config.enderZooDifficultyModifierEnabled || Config.globalDifficultyModifierEnabled) {
            spawnEventHandler = new MobSpawnEventHandler();
            spawnEventHandler.init();
        }
    }

    private void addRecipes() {
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            ItemStack cc;
            if (Config.confusingChargeEnabled) {
                OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE));
                cc = new ItemStack((Block)blockConfusingCharge);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cc, new Object[]{"csc", "sgs", "csc", Character.valueOf('c'), itemConfusingDust, Character.valueOf('s'), "sand", Character.valueOf('g'), Items.field_151016_H}));
            }
            if (Config.enderChargeEnabled) {
                OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE));
                cc = new ItemStack((Block)blockEnderCharge);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cc, new Object[]{"csc", "sgs", "csc", Character.valueOf('c'), itemEnderFragment, Character.valueOf('s'), "sand", Character.valueOf('g'), Items.field_151016_H}));
            }
            if (Config.concussionChargeEnabled) {
                OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE));
                cc = new ItemStack((Block)blockConcussionCharge);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cc, new Object[]{"eee", "sgs", "ccc", Character.valueOf('c'), itemConfusingDust, Character.valueOf('e'), itemEnderFragment, Character.valueOf('s'), "sand", Character.valueOf('g'), Items.field_151016_H}));
            }
        }
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151079_bi), (Object[])new Object[]{" f ", "fff", " f ", Character.valueOf('f'), itemEnderFragment});
    }
}

