/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityCluster;
import vswe.stevesfactory.blocks.TileEntityClusterElement;

public abstract class BlockCableDirectionAdvanced
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon advancedActiveIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon inactiveIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon advancedInactiveIcon;

    public BlockCableDirectionAdvanced() {
        super(Material.field_151573_f);
        this.func_149647_a(ModBlocks.creativeTab);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(1.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.activeIcon = register.func_94245_a("stevesfactory:" + this.getFrontTextureName(false));
        this.advancedActiveIcon = register.func_94245_a("stevesfactory:" + this.getFrontTextureName(true));
        this.inactiveIcon = register.func_94245_a("stevesfactory:" + this.getSideTextureName(false));
        this.advancedInactiveIcon = register.func_94245_a("stevesfactory:" + this.getSideTextureName(true));
    }

    protected abstract String getFrontTextureName(boolean var1);

    protected abstract String getSideTextureName(boolean var1);

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getIconFromSideAndMeta(side, BlockCableDirectionAdvanced.addAdvancedMeta(3, meta));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return this.getIconFromSideAndMeta(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIconFromSideAndMeta(int side, int meta) {
        return side == BlockCableDirectionAdvanced.getSideMeta(meta) % ForgeDirection.VALID_DIRECTIONS.length ? (this.isAdvanced(meta) ? this.advancedActiveIcon : this.activeIcon) : (this.isAdvanced(meta) ? this.advancedInactiveIcon : this.inactiveIcon);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        int meta = BlockCableDirectionAdvanced.addAdvancedMeta(BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity), item.func_77960_j());
        TileEntityClusterElement element = (TileEntityClusterElement)((Object)TileEntityCluster.getTileEntity(this.getTeClass(), (IBlockAccess)world, x, y, z));
        if (element != null) {
            element.setMetaData(meta);
        }
    }

    protected abstract Class<? extends TileEntityClusterElement> getTeClass();

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    public boolean isAdvanced(int meta) {
        return (meta & 8) != 0;
    }

    public static int getSideMeta(int meta) {
        return meta & 7;
    }

    public static int addAdvancedMeta(int meta, int advancedMeta) {
        return meta | advancedMeta & 8;
    }

    public static int getAdvancedMeta(int meta) {
        return BlockCableDirectionAdvanced.addAdvancedMeta(0, meta);
    }

    public int func_149692_a(int meta) {
        return BlockCableDirectionAdvanced.getAdvancedMeta(meta);
    }
}

