/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.client.nei.TooltipStack;
import WayofTime.alchemicalWizardry.common.summoning.meteor.Meteor;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.base.Joiner;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class NEIMeteorRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && ((Object)((Object)this)).getClass() == NEIMeteorRecipeHandler.class) {
            for (Meteor meteor : this.getSortedMeteors()) {
                this.arecipes.add(new CachedMeteorRecipe(meteor, null));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Meteor meteor : this.getSortedMeteors()) {
            if (meteor.ores.stream().anyMatch(m -> this.matchItem(result, m.getBlock()))) {
                this.arecipes.add(new CachedMeteorRecipe(meteor, result));
            }
            if (!(meteor.fillerChance > 0.0f) || !meteor.filler.stream().anyMatch(m -> this.matchItem(result, m.getBlock()))) continue;
            this.arecipes.add(new CachedMeteorRecipe(meteor, result));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Meteor meteor : this.getSortedMeteors()) {
            if (!this.matchItem(ingredient, meteor.focusItem)) continue;
            this.arecipes.add(new CachedMeteorRecipe(meteor, null));
        }
    }

    private boolean matchItem(ItemStack compared, ItemStack compareTo) {
        if (compared == null || compareTo == null) {
            return false;
        }
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)compared, (ItemStack)compareTo)) {
            return true;
        }
        if (compared.func_77977_a().startsWith("gt.blockores") && compareTo.func_77977_a().startsWith("gt.blockores")) {
            return compared.func_77960_j() % 1000 == compareTo.func_77960_j() % 1000;
        }
        String[] prefixes = new String[]{"crushed", "rawOre", "raw"};
        for (int i : OreDictionary.getOreIDs((ItemStack)compareTo)) {
            String s1 = OreDictionary.getOreName((int)i);
            if (!s1.startsWith("ore")) continue;
            for (int j : OreDictionary.getOreIDs((ItemStack)compared)) {
                if (i == j) {
                    return true;
                }
                String s2 = OreDictionary.getOreName((int)j);
                for (String prefix : prefixes) {
                    if (i != OreDictionary.getOreID((String)s2.replaceFirst("^" + prefix, "ore"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/meteor.png").toString();
    }

    public String getOverlayIdentifier() {
        return "alchemicalwizardry.meteor";
    }

    public void drawExtras(int recipe) {
        CachedMeteorRecipe meteorRecipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipe));
        int cost = meteorRecipe.getCost();
        int radius = meteorRecipe.getRadius();
        Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"nei.recipe.meteor.cost", (Object[])new Object[]{String.format("%,d", cost)}), 2, 168, 0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"nei.recipe.meteor.radius", (Object[])new Object[]{radius}), 2, 179, 0);
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)202);
        CachedMeteorRecipe recipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipeIndex));
        Point focus = recipe.focus;
        if (focus != null) {
            GuiDraw.drawTexturedModalRect((int)focus.x, (int)focus.y, (int)172, (int)0, (int)18, (int)18);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        PositionedStack pStack;
        CachedMeteorRecipe meteorRecipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipe));
        Iterator iterator = meteorRecipe.outputs.iterator();
        while (iterator.hasNext() && (pStack = (PositionedStack)iterator.next()) instanceof TooltipStack) {
            TooltipStack tStack = (TooltipStack)pStack;
            if (!Arrays.stream(tStack.items).anyMatch(s -> NEIServerUtils.areStacksSameTypeCrafting((ItemStack)s, (ItemStack)stack))) continue;
            currenttip.addAll(tStack.getTooltips());
            break;
        }
        return currenttip;
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"nei.recipe.meteor.category", (Object[])new Object[0]);
    }

    private List<Meteor> getSortedMeteors() {
        return MeteorRegistry.meteorList.stream().sorted(Comparator.comparing(m -> m.cost)).collect(Collectors.toList());
    }

    private String getFormattedChance(float chance) {
        return new DecimalFormat("0.##").format(chance * 100.0f);
    }

    private int getEstimatedAmount(float chance, int radius) {
        return (int)Math.ceil(4.1887903296220665 * Math.pow((double)radius + 0.5, 3.0) * (double)chance);
    }

    public class CachedMeteorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private final int cost;
        private final int radius;
        private Point focus;

        public CachedMeteorRecipe(Meteor meteor, ItemStack focusStack) {
            super((TemplateRecipeHandler)NEIMeteorRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.input.add(new PositionedStack((Object)meteor.focusItem, 74, 4));
            int row = 0;
            int col = 0;
            float totalComponentWeight = MeteorComponent.getTotalListWeight(meteor.ores);
            float fillerChance = meteor.fillerChance;
            ArrayList<MeteorComponent> sortedComponents = new ArrayList<MeteorComponent>(meteor.ores);
            sortedComponents.sort(Comparator.comparingInt(c -> -c.getWeight()));
            float fillerRatio = (float)((double)fillerChance / 100.0);
            float componentRatio = 1.0f - fillerRatio;
            if (fillerChance < 100.0f) {
                for (MeteorComponent component : sortedComponents) {
                    ItemStack stack = component.getBlock();
                    int xPos = 3 + 18 * col;
                    int yPos = 37 + 18 * row;
                    ArrayList<String> tooltips = new ArrayList<String>();
                    float chance = (float)component.getWeight() / totalComponentWeight * componentRatio;
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.chance", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getFormattedChance(chance)}));
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.amount", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getEstimatedAmount(chance, meteor.radius)}));
                    if (!component.getRequiredReagents().isEmpty()) {
                        tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.reagent", (Object[])new Object[]{this.getReagentStrings(component)}));
                    }
                    this.outputs.add(new TooltipStack(stack, xPos, yPos, tooltips));
                    if (++col > 8) {
                        col = 0;
                        ++row;
                    }
                    if (!NEIMeteorRecipeHandler.this.matchItem(focusStack, stack)) continue;
                    this.focus = new Point(xPos - 1, yPos - 1);
                }
            }
            if (fillerChance > 0.0f) {
                if (col != 0) {
                    col = 0;
                    ++row;
                }
                ArrayList<MeteorComponent> sortedFiller = new ArrayList<MeteorComponent>(meteor.filler);
                sortedFiller.sort(Comparator.comparingInt(c -> -c.getWeight()));
                float totalFillerWeight = MeteorComponent.getTotalListWeight(meteor.filler);
                for (MeteorComponent filler : sortedFiller) {
                    ItemStack stack = filler.getBlock();
                    int xPos = 3 + 18 * col;
                    int yPos = 37 + 18 * row;
                    ArrayList<String> tooltips = new ArrayList<String>();
                    float chance = (float)filler.getWeight() / totalFillerWeight * fillerRatio;
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.chance", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getFormattedChance(chance)}));
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.amount", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getEstimatedAmount(chance, meteor.radius)}));
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.filler", (Object[])new Object[0]));
                    if (!filler.getRequiredReagents().isEmpty()) {
                        tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.reagent", (Object[])new Object[]{this.getReagentStrings(filler)}));
                    }
                    this.outputs.add(new TooltipStack(stack, xPos, yPos, tooltips));
                    if (++col > 8) {
                        col = 0;
                        ++row;
                    }
                    if (!NEIMeteorRecipeHandler.this.matchItem(focusStack, stack)) continue;
                    this.focus = new Point(xPos - 1, yPos - 1);
                }
            }
            this.radius = meteor.radius;
            this.cost = meteor.cost;
        }

        private String getReagentStrings(MeteorComponent component) {
            ArrayList<Reagent> reagents = component.getRequiredReagents();
            ArrayList<String> reagentNames = new ArrayList<String>();
            for (Reagent r : reagents) {
                reagentNames.add(r.name);
            }
            return Joiner.on((String)", ").join(reagentNames);
        }

        public List<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public int getCost() {
            return this.cost;
        }

        public int getRadius() {
            return this.radius;
        }
    }
}

