/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.core.util.vector.Vector3d;
import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.client.printer.SchematicPrinter;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.compat.ILOTRPresent;
import com.github.lunatrius.schematica.compat.NoLOTRProxy;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.client.ChatEventHandler;
import com.github.lunatrius.schematica.handler.client.InputHandler;
import com.github.lunatrius.schematica.handler.client.OverlayHandler;
import com.github.lunatrius.schematica.handler.client.RenderTickHandler;
import com.github.lunatrius.schematica.handler.client.TickHandler;
import com.github.lunatrius.schematica.handler.client.WorldHandler;
import com.github.lunatrius.schematica.proxy.CommonProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class ClientProxy
extends CommonProxy {
    public static final Vector3d playerPosition = new Vector3d();
    public static final Vector3i pointA = new Vector3i();
    public static final Vector3i pointB = new Vector3i();
    public static final Vector3i pointMin = new Vector3i();
    public static final Vector3i pointMax = new Vector3i();
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    public static boolean isRenderingGuide = false;
    public static boolean isPendingReset = false;
    public static ForgeDirection orientation = ForgeDirection.UNKNOWN;
    public static int rotationRender = 0;
    public static SchematicWorld schematic = null;
    public static MovingObjectPosition movingObjectPosition = null;
    private final SchematicWorld schematicWorld = null;
    public static ILOTRPresent lotrProxy = null;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Type schematicDataType = new TypeToken<Map<String, Map<String, SchematicData>>>(){}.getType();

    public static void setPlayerData(EntityPlayer player, float partialTicks) {
        ClientProxy.playerPosition.x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        ClientProxy.playerPosition.y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        ClientProxy.playerPosition.z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        orientation = ClientProxy.getOrientation(player);
        rotationRender = MathHelper.func_76128_c((double)(player.field_70177_z / 90.0f)) & 3;
    }

    private static ForgeDirection getOrientation(EntityPlayer player) {
        if (player.field_70125_A > 45.0f) {
            return ForgeDirection.DOWN;
        }
        if (player.field_70125_A < -45.0f) {
            return ForgeDirection.UP;
        }
        switch (MathHelper.func_76128_c((double)((double)player.field_70177_z / 90.0 + 0.5)) & 3) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static void updatePoints() {
        ClientProxy.pointMin.x = Math.min(ClientProxy.pointA.x, ClientProxy.pointB.x);
        ClientProxy.pointMin.y = Math.min(ClientProxy.pointA.y, ClientProxy.pointB.y);
        ClientProxy.pointMin.z = Math.min(ClientProxy.pointA.z, ClientProxy.pointB.z);
        ClientProxy.pointMax.x = Math.max(ClientProxy.pointA.x, ClientProxy.pointB.x);
        ClientProxy.pointMax.y = Math.max(ClientProxy.pointA.y, ClientProxy.pointB.y);
        ClientProxy.pointMax.z = Math.max(ClientProxy.pointA.z, ClientProxy.pointB.z);
    }

    public static void movePointToPlayer(Vector3i point) {
        point.x = (int)Math.floor(ClientProxy.playerPosition.x);
        point.y = (int)Math.floor(ClientProxy.playerPosition.y - 1.0);
        point.z = (int)Math.floor(ClientProxy.playerPosition.z);
        switch (rotationRender) {
            case 0: {
                --point.x;
                ++point.z;
                break;
            }
            case 1: {
                --point.x;
                --point.z;
                break;
            }
            case 2: {
                ++point.x;
                --point.z;
                break;
            }
            case 3: {
                ++point.x;
                ++point.z;
            }
        }
    }

    public static void moveSchematicToPlayer(SchematicWorld schematic) {
        if (schematic != null) {
            Vector3i position = schematic.position;
            position.x = (int)Math.floor(ClientProxy.playerPosition.x);
            position.y = (int)Math.floor(ClientProxy.playerPosition.y) - 1;
            position.z = (int)Math.floor(ClientProxy.playerPosition.z);
            switch (rotationRender) {
                case 0: {
                    position.x -= schematic.getWidth();
                    ++position.z;
                    break;
                }
                case 1: {
                    position.x -= schematic.getWidth();
                    position.z -= schematic.getLength();
                    break;
                }
                case 2: {
                    ++position.x;
                    position.z -= schematic.getLength();
                    break;
                }
                case 3: {
                    ++position.x;
                    ++position.z;
                }
            }
        }
    }

    public static void moveSchematic(SchematicWorld schematic, Integer x, Integer y, Integer z) {
        if (schematic != null) {
            Vector3i position = schematic.position;
            position.x = x;
            position.y = y;
            position.z = z;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Map<String, SchematicData>> openCoordinatesFile() throws ClassCastException, IOException {
        void var1_4;
        File coordinatesFile = new File(ConfigurationHandler.schematicDirectory, "Coordinates.json");
        HashMap<String, Map<String, SchematicData>> hashMap = new HashMap<String, Map<String, SchematicData>>();
        if (coordinatesFile.exists() && coordinatesFile.canRead() && coordinatesFile.canWrite()) {
            try (BufferedReader reader = Files.newBufferedReader(new File(ConfigurationHandler.schematicDirectory, "Coordinates.json").toPath(), StandardCharsets.UTF_8);){
                Map map = (Map)gson.fromJson((Reader)reader, schematicDataType);
                return var1_4;
            }
            catch (Exception e1) {
                try (BufferedReader reader2 = Files.newBufferedReader(new File(ConfigurationHandler.schematicDirectory, "Coordinates.json").toPath(), Charset.defaultCharset());){
                    Map map = (Map)gson.fromJson((Reader)reader2, schematicDataType);
                    return var1_4;
                }
                catch (Exception e2) {
                    throw new ClassCastException("Failed to convert json file to Map<String,SchematicData>");
                }
            }
        }
        if (coordinatesFile.exists()) throw new IOException("No read/write permission for coordinates file");
        if (!ClientProxy.saveCoordinatesFile(hashMap)) throw new IOException("Failed to create coordinates file");
        Reference.logger.info("Created new coordinates file");
        return var1_4;
    }

    private static boolean saveCoordinatesFile(Map<String, Map<String, SchematicData>> map) {
        boolean bl;
        File coordinatesFile = new File(ConfigurationHandler.schematicDirectory, "Coordinates.json");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(coordinatesFile.getAbsoluteFile()), StandardCharsets.UTF_8);
        try {
            gson.toJson(map, schematicDataType, (Appendable)writer);
            writer.flush();
            Reference.logger.info("Successfully written to coordinates file");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Reference.logger.info("Failed to write to coordinates file");
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static boolean addCoordinatesAndRotation(String worldServerName, final String schematicName, Integer X, Integer Y, Integer Z, Integer rotationX, Integer rotationY, Integer rotationZ, Integer flipX, Integer flipY, Integer flipZ) {
        try {
            Map<String, Map<String, SchematicData>> coordinates = ClientProxy.openCoordinatesFile();
            final SchematicData schematicData = new SchematicData();
            schematicData.X = X;
            schematicData.Y = Y;
            schematicData.Z = Z;
            schematicData.RotationX = rotationX;
            schematicData.Rotation = rotationY;
            schematicData.RotationZ = rotationZ;
            schematicData.FlipX = flipX;
            schematicData.FlipY = flipY;
            schematicData.FlipZ = flipZ;
            if (coordinates.containsKey(worldServerName)) {
                coordinates.get(worldServerName).put(schematicName, schematicData);
            } else {
                coordinates.put(worldServerName, (Map<String, SchematicData>)new HashMap<String, SchematicData>(){
                    {
                        this.put(schematicName, schematicData);
                    }
                });
            }
            ClientProxy.saveCoordinatesFile(coordinates);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ImmutableTriple<Boolean, ImmutablePair<ImmutableTriple<Integer, Integer, Integer>, ImmutableTriple<Integer, Integer, Integer>>, ImmutableTriple<Integer, Integer, Integer>> getCoordinates(String worldServerName, String schematicName) {
        try {
            Map<String, SchematicData> schematicMap;
            Map<String, Map<String, SchematicData>> coordinates = ClientProxy.openCoordinatesFile();
            if (coordinates.containsKey(worldServerName) && (schematicMap = coordinates.get(worldServerName)).containsKey(schematicName)) {
                SchematicData schematicData = schematicMap.get(schematicName);
                return new ImmutableTriple((Object)true, (Object)new ImmutablePair((Object)new ImmutableTriple((Object)schematicData.RotationX, (Object)schematicData.Rotation, (Object)schematicData.RotationZ), (Object)new ImmutableTriple((Object)schematicData.FlipX, (Object)schematicData.FlipY, (Object)schematicData.FlipZ)), (Object)new ImmutableTriple((Object)schematicData.X, (Object)schematicData.Y, (Object)schematicData.Z));
            }
            return new ImmutableTriple((Object)false, null, null);
        }
        catch (Exception e) {
            return new ImmutableTriple((Object)false, null, null);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Property[] sliders;
        super.preInit(event);
        for (Property property : sliders = new Property[]{ConfigurationHandler.propAlpha, ConfigurationHandler.propBlockDelta, ConfigurationHandler.propPlaceDelay, ConfigurationHandler.propTimeout}) {
            property.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
        for (Property property : InputHandler.KEY_BINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)property);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        FMLCommonHandler.instance().bus().register((Object)InputHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)TickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RenderTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ConfigurationHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RendererSchematicGlobal.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ChatEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new OverlayHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldHandler());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        try {
            if (Loader.isModLoaded((String)"lotr")) {
                Reference.logger.info("Lotr mod detected, creating proxy");
                lotrProxy = Class.forName("com.github.lunatrius.schematica.compat.LOTRProxy").asSubclass(ILOTRPresent.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                lotrProxy = new NoLOTRProxy();
            }
        }
        catch (Exception e) {
            Reference.logger.warn("Failed to create lotr proxy in the normal way");
            lotrProxy = new NoLOTRProxy();
        }
    }

    @Override
    public File getDataDirectory() {
        File file = ClientProxy.MINECRAFT.field_71412_D;
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            Reference.logger.debug("Could not canonize path!", (Throwable)e);
            return file;
        }
    }

    @Override
    public void resetSettings() {
        super.resetSettings();
        ChatEventHandler.INSTANCE.chatLines = 0;
        SchematicPrinter.INSTANCE.setEnabled(true);
        this.unloadSchematic();
        playerPosition.set(0.0, 0.0, 0.0);
        orientation = ForgeDirection.UNKNOWN;
        rotationRender = 0;
        pointA.set(0, 0, 0);
        pointB.set(0, 0, 0);
        ClientProxy.updatePoints();
    }

    @Override
    public void unloadSchematic() {
        schematic = null;
        RendererSchematicGlobal.INSTANCE.destroyRendererSchematicChunks();
        SchematicPrinter.INSTANCE.setSchematic(null);
    }

    @Override
    public boolean loadSchematic(EntityPlayer player, File directory, String filename) {
        ISchematic schematic = SchematicFormat.readFromFile(directory, filename);
        if (schematic == null) {
            return false;
        }
        SchematicWorld world = new SchematicWorld(schematic, filename);
        Reference.logger.debug("Loaded {} [w:{},h:{},l:{}]", new Object[]{filename, world.getWidth(), world.func_72800_K(), world.getLength()});
        ClientProxy.schematic = world;
        RendererSchematicGlobal.INSTANCE.createRendererSchematicChunks(world);
        SchematicPrinter.INSTANCE.setSchematic(world);
        world.isRendering = true;
        return true;
    }

    @Override
    public boolean isPlayerQuotaExceeded(EntityPlayer player) {
        return false;
    }

    @Override
    public File getPlayerSchematicDirectory(EntityPlayer player, boolean privateDirectory) {
        return ConfigurationHandler.schematicDirectory;
    }

    private static class SchematicData {
        public int X;
        public int Y;
        public int Z;
        public int RotationX;
        public int Rotation;
        public int RotationZ;
        public int FlipX;
        public int FlipY;
        public int FlipZ;

        SchematicData() {
        }
    }
}

