/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.util.DimensionalCoord;
import appeng.tile.networking.TileWirelessConnector;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;

public class TileWirelessHub
extends TileWirelessConnector {
    private final ArrayList<DimensionalCoord> connectionList = new ArrayList();
    private double powerDraw = 0.0;

    @Override
    public DimensionalCoord getTarget() {
        return null;
    }

    @Override
    public boolean hasConnection() {
        return !this.connectionList.isEmpty();
    }

    public void addConnectionList(DimensionalCoord dc) {
        this.connectionList.add(dc);
    }

    public void removeConnectionList(DimensionalCoord dc) {
        this.connectionList.remove(dc);
    }

    @Override
    public boolean setupConnection(DimensionalCoord dc) {
        TileWirelessConnector te = (TileWirelessConnector)this.field_145850_b.func_147438_o(dc.x, dc.y, dc.z);
        if (te instanceof TileWirelessHub) {
            return false;
        }
        return te.setupConnection(this.getLocation());
    }

    @Override
    public void breakConnection() {
        for (DimensionalCoord dc : this.connectionList) {
            TileEntity te = this.field_145850_b.func_147438_o(dc.x, dc.y, dc.z);
            if (!(te instanceof TileWirelessConnector)) continue;
            TileWirelessConnector wc = (TileWirelessConnector)te;
            wc.breakConnectionNoCall();
        }
    }

    @Override
    public void cleanUp() {
        this.updateActive();
    }

    @Override
    public void setPowerDraw(double d) {
        this.powerDraw += d;
        this.getProxy().setIdlePowerUsage(this.powerDraw);
    }

    @Override
    public int getChannelUsage() {
        int channels = 0;
        for (DimensionalCoord dc : this.connectionList) {
            TileEntity te = this.field_145850_b.func_147438_o(dc.x, dc.y, dc.z);
            if (!(te instanceof TileWirelessConnector)) continue;
            TileWirelessConnector wc = (TileWirelessConnector)te;
            channels += wc.getChannelUsage();
        }
        return channels;
    }

    @Override
    public boolean isHub() {
        return true;
    }

    @Override
    public int getFreeSlots() {
        return 32 - this.connectionList.size();
    }

    public ArrayList<DimensionalCoord> getConnectionList() {
        return this.connectionList;
    }
}

