/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.CraftingAllow;
import appeng.api.config.CraftingMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.CraftCancelListener;
import appeng.api.util.CraftCompleteListener;
import appeng.api.util.CraftUpdateListener;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IInterfaceViewable;
import appeng.api.util.WorldCoord;
import appeng.container.ContainerNull;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingLink;
import appeng.crafting.CraftingWatcher;
import appeng.crafting.MECraftingInventory;
import appeng.helpers.DualityInterface;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cluster.IAECluster;
import appeng.tile.AEBaseTile;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.Level;

public final class CraftingCPUCluster
implements IAECluster,
ICraftingCPU {
    private static final String LOG_MARK_AS_COMPLETE = "Completed job for %s.";
    private final WorldCoord min;
    private final WorldCoord max;
    private final int[] usedOps = new int[3];
    private final Comparator<ICraftingPatternDetails> priorityComparator = Comparator.comparing(ICraftingPatternDetails::getPriority).thenComparing(Object::hashCode);
    private final Map<ICraftingPatternDetails, TaskProgress> tasks = new TreeMap<ICraftingPatternDetails, TaskProgress>(this.priorityComparator);
    private Map<ICraftingPatternDetails, TaskProgress> workableTasks = new TreeMap<ICraftingPatternDetails, TaskProgress>(this.priorityComparator);
    private HashSet<ICraftingMedium> knownBusyMediums = new HashSet();
    private final LinkedList<TileCraftingTile> tiles = new LinkedList();
    private final LinkedList<TileCraftingTile> storage = new LinkedList();
    private final LinkedList<TileCraftingMonitorTile> status = new LinkedList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private final HashMap<IAEItemStack, List<DimensionalCoord>> providers = new HashMap();
    private ICraftingLink myLastLink;
    private String myName = "";
    private boolean isDestroyed = false;
    private MECraftingInventory inventory = new MECraftingInventory();
    private IAEItemStack finalOutput;
    private boolean waiting = false;
    private IItemList<IAEItemStack> waitingFor = AEApi.instance().storage().createItemList();
    private IItemList<IAEItemStack> waitingForMissing = AEApi.instance().storage().createItemList();
    private long availableStorage = 0L;
    private long usedStorage = 0L;
    private MachineSource machineSrc = null;
    private int accelerator = 0;
    private boolean isComplete = true;
    private int remainingOperations;
    private boolean somethingChanged;
    private boolean isFakeCrafting;
    private long lastTime;
    private long elapsedTime;
    private long startItemCount;
    private long remainingItemCount;
    private long numsOfOutput;
    private int countToTryExtractItems;
    private boolean isMissingMode;
    private CraftingAllow craftingAllowMode = CraftingAllow.ALLOW_ALL;
    private final Map<String, List<CraftNotification>> unreadNotifications = new HashMap<String, List<CraftNotification>>();
    private final List<CraftCompleteListener> defaultOnComplete = Arrays.asList((finalOutput, numsOfOutput, elapsedTime) -> {
        if (!this.playersFollowingCurrentCraft.isEmpty()) {
            CraftNotification notification = new CraftNotification(finalOutput, numsOfOutput, elapsedTime);
            IChatComponent messageToSend = notification.createMessage();
            for (String playerName : this.playersFollowingCurrentCraft) {
                EntityPlayerMP player = this.getPlayerByName(playerName);
                if (player != null) {
                    player.func_145747_a(messageToSend);
                    player.field_70170_p.func_72956_a((Entity)player, "random.levelup", 1.0f, 1.0f);
                    continue;
                }
                this.unreadNotifications.computeIfAbsent(playerName, name -> new ArrayList()).add(notification);
            }
        }
    });
    private List<CraftCompleteListener> craftCompleteListeners = this.initializeDefaultOnCompleteListener();
    private final List<CraftUpdateListener> craftUpdateListeners = new ArrayList<CraftUpdateListener>();
    private final List<CraftCancelListener> craftCancelListeners = new ArrayList<CraftCancelListener>();
    private final List<String> playersFollowingCurrentCraft = new ArrayList<String>();

    public CraftingCPUCluster(WorldCoord min, WorldCoord max) {
        this.min = min;
        this.max = max;
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        String playerName = player.func_70005_c_();
        if (this.unreadNotifications.containsKey(playerName)) {
            List<CraftNotification> notifications = this.unreadNotifications.get(playerName);
            for (CraftNotification notification : notifications) {
                player.func_145747_a(notification.createMessage());
            }
            player.field_70170_p.func_72956_a((Entity)player, "random.levelup", 1.0f, 1.0f);
            this.unreadNotifications.remove(playerName);
        }
    }

    @Override
    public void resetFinalOutput() {
        this.finalOutput = null;
    }

    @Override
    public IAEItemStack getFinalOutput() {
        return this.finalOutput;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public ICraftingLink getLastCraftingLink() {
        return this.myLastLink;
    }

    private List<CraftCompleteListener> initializeDefaultOnCompleteListener() {
        return new ArrayList<CraftCompleteListener>(this.defaultOnComplete);
    }

    @Override
    public void addOnCompleteListener(CraftCompleteListener craftCompleteListener) {
        this.craftCompleteListeners.add(craftCompleteListener);
    }

    @Override
    public void addOnCancelListener(CraftCancelListener onCancelListener) {
        this.craftCancelListeners.add(onCancelListener);
    }

    @Override
    public void addOnCraftingUpdateListener(CraftUpdateListener onCraftingStatusUpdate) {
        this.craftUpdateListeners.add(onCraftingStatusUpdate);
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    public IMEInventory<IAEItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (TileCraftingTile r : this.tiles) {
            r.updateMeta(true);
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        FMLCommonHandler.instance().bus().unregister((Object)this);
        boolean posted = false;
        for (TileCraftingTile r : this.tiles) {
            IGrid g;
            IGridNode n = r.getActionableNode();
            if (n != null && !posted && (g = n.getGrid()) != null) {
                g.postEvent(new MENetworkCraftingCpuChange(n));
                posted = true;
            }
            r.updateStatus(null);
        }
    }

    @Override
    public Iterator<IGridHost> getTiles() {
        return this.tiles.iterator();
    }

    void addTile(TileCraftingTile te) {
        if (this.machineSrc == null || te.isCoreBlock()) {
            this.machineSrc = new MachineSource(te);
        }
        te.setCoreBlock(false);
        te.func_70296_d();
        this.tiles.push(te);
        if (te.isStorage()) {
            long additionalStorage = te.getStorageBytes();
            if (Long.MAX_VALUE - additionalStorage >= this.availableStorage) {
                this.availableStorage += additionalStorage;
                this.storage.add(te);
            } else {
                this.tiles.remove(te);
            }
        } else if (te.isStatus()) {
            this.status.add((TileCraftingMonitorTile)te);
        } else if (te.isAccelerator()) {
            this.accelerator += te.acceleratorValue();
        }
    }

    public boolean canAccept(IAEStack input) {
        IAEItemStack is;
        return input instanceof IAEItemStack && (is = this.waitingFor.findPrecise((IAEItemStack)input)) != null && is.getStackSize() > 0L;
    }

    public IAEStack injectItems(IAEStack input, Actionable type, BaseActionSource src) {
        if (!(input instanceof IAEItemStack)) {
            return input;
        }
        IAEItemStack what = (IAEItemStack)input.copy();
        IAEItemStack is = this.waitingFor.findPrecise(what);
        IAEItemStack ism = this.waitingForMissing.findPrecise(what);
        if (type == Actionable.SIMULATE) {
            if (is != null && is.getStackSize() > 0L) {
                if (is.getStackSize() >= what.getStackSize()) {
                    if (Objects.equals(this.finalOutput, what)) {
                        if (this.myLastLink != null) {
                            return ((CraftingLink)this.myLastLink).injectItems(what.copy(), type);
                        }
                        return what;
                    }
                    return null;
                }
                IAEItemStack leftOver = what.copy();
                leftOver.decStackSize(is.getStackSize());
                IAEItemStack used = what.copy();
                used.setStackSize(is.getStackSize());
                if (Objects.equals(this.finalOutput, what)) {
                    if (this.myLastLink != null) {
                        leftOver.add(((CraftingLink)this.myLastLink).injectItems(used.copy(), type));
                        return leftOver;
                    }
                    return what;
                }
                return leftOver;
            }
        } else if (type == Actionable.MODULATE && is != null && is.getStackSize() > 0L) {
            this.waiting = false;
            this.postChange(what, src);
            if (is.getStackSize() >= what.getStackSize()) {
                is.decStackSize(what.getStackSize());
                if (ism != null) {
                    ism.decStackSize(what.getStackSize());
                }
                this.updateElapsedTime(what);
                this.markDirty();
                this.postCraftingStatusChange(is);
                for (CraftUpdateListener craftUpdateListener : this.craftUpdateListeners) {
                    craftUpdateListener.accept(1);
                }
                if (Objects.equals(this.finalOutput, what)) {
                    IAEItemStack leftover = what;
                    this.finalOutput.decStackSize(what.getStackSize());
                    if (this.myLastLink != null) {
                        leftover = ((CraftingLink)this.myLastLink).injectItems(what, type);
                    }
                    if (this.finalOutput.getStackSize() <= 0L) {
                        this.completeJob();
                    }
                    this.updateCPU();
                    return leftover;
                }
                return this.inventory.injectItems(what, type, src);
            }
            IAEItemStack insert = what.copy();
            insert.setStackSize(is.getStackSize());
            what.decStackSize(is.getStackSize());
            is.setStackSize(0L);
            if (ism != null) {
                ism.setStackSize(0L);
            }
            if (Objects.equals(this.finalOutput, insert)) {
                IAEStack leftover = input;
                this.finalOutput.decStackSize(insert.getStackSize());
                if (this.myLastLink != null) {
                    what.add(((CraftingLink)this.myLastLink).injectItems(insert.copy(), type));
                    leftover = what;
                }
                if (this.finalOutput.getStackSize() <= 0L) {
                    this.completeJob();
                }
                this.updateCPU();
                this.markDirty();
                return leftover;
            }
            this.inventory.injectItems(insert, type, src);
            this.markDirty();
            return what;
        }
        return input;
    }

    private void postChange(IAEItemStack diff, BaseActionSource src) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.getListeners();
        if (i.hasNext()) {
            ImmutableList single = ImmutableList.of((Object)diff.copy());
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> o = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> receiver = o.getKey();
                if (receiver.isValid(o.getValue())) {
                    receiver.postChange(null, (Iterable<IAEItemStack>)single, src);
                    continue;
                }
                i.remove();
            }
        }
    }

    private void markDirty() {
        this.getCore().func_70296_d();
    }

    private void postCraftingStatusChange(IAEItemStack diff) {
        Collection<CraftingWatcher> list;
        if (this.getGrid() == null) {
            return;
        }
        CraftingGridCache sg = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
        if (sg.getInterestManager().containsKey(diff) && !(list = sg.getInterestManager().get(diff)).isEmpty()) {
            for (CraftingWatcher iw : list) {
                iw.getHost().onRequestChange(sg, diff);
            }
        }
    }

    private void completeJob() {
        if (this.myLastLink != null) {
            ((CraftingLink)this.myLastLink).markDone();
            this.myLastLink = null;
        }
        if (AELog.isCraftingLogEnabled()) {
            IAEItemStack logStack = this.finalOutput.copy();
            logStack.setStackSize(this.startItemCount);
            AELog.crafting(LOG_MARK_AS_COMPLETE, logStack);
        }
        this.craftCompleteListeners.forEach(f -> f.apply(this.finalOutput.getItemStack(), this.numsOfOutput, this.elapsedTime));
        this.isFakeCrafting = false;
        this.usedStorage = 0L;
        this.remainingItemCount = 0L;
        this.startItemCount = 0L;
        this.lastTime = 0L;
        this.elapsedTime = 0L;
        this.numsOfOutput = 0L;
        this.isComplete = true;
        this.playersFollowingCurrentCraft.clear();
        this.craftCompleteListeners = this.initializeDefaultOnCompleteListener();
        this.craftCancelListeners.clear();
        this.craftUpdateListeners.clear();
    }

    private EntityPlayerMP getPlayerByName(String playerName) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playerName);
    }

    private void updateCPU() {
        IAEItemStack send = this.finalOutput;
        if (this.finalOutput != null && this.finalOutput.getStackSize() <= 0L) {
            send = null;
        }
        for (TileCraftingMonitorTile t : this.status) {
            t.setJob(send);
        }
    }

    private Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> getListeners() {
        return this.listeners.entrySet().iterator();
    }

    private TileCraftingTile getCore() {
        return (TileCraftingTile)this.machineSrc.via;
    }

    private IGrid getGrid() {
        for (TileCraftingTile r : this.tiles) {
            IGrid g;
            IGridNode gn = r.getActionableNode();
            if (gn == null || (g = gn.getGrid()) == null) continue;
            return r.getActionableNode().getGrid();
        }
        return null;
    }

    private ArrayList<IAEItemStack> getExtractItems(IAEItemStack ingredient, ICraftingPatternDetails patternDetails) {
        ArrayList<IAEItemStack> list = new ArrayList<IAEItemStack>();
        if (patternDetails.canSubstitute()) {
            for (IAEItemStack fuzz : this.inventory.getItemList().findFuzzy(ingredient, FuzzyMode.IGNORE_ALL)) {
                ItemStack is;
                if (!patternDetails.isCraftable() && fuzz.getStackSize() <= 0L) continue;
                if (patternDetails.isCraftable()) {
                    IAEItemStack[] inputSlots = patternDetails.getInputs();
                    IAEItemStack finalIngredient = ingredient;
                    int matchingSlot = IntStream.range(0, inputSlots.length).filter(idx -> inputSlots[idx] != null && Objects.equals(inputSlots[idx], finalIngredient)).findFirst().orElse(-1);
                    if (matchingSlot < 0 || !patternDetails.isValidItemForSlot(matchingSlot, fuzz.getItemStack(), this.getWorld())) continue;
                }
                fuzz = fuzz.copy();
                fuzz.setStackSize(ingredient.getStackSize());
                IAEItemStack ais = this.inventory.extractItems(fuzz, Actionable.SIMULATE, (BaseActionSource)this.machineSrc);
                ItemStack itemStack = is = ais == null ? null : ais.getItemStack();
                if (is != null && (long)is.field_77994_a == ingredient.getStackSize()) {
                    list.add(ais);
                    return list;
                }
                if (is == null || !patternDetails.isCraftable()) continue;
                ingredient = ingredient.copy();
                ingredient.decStackSize(is.field_77994_a);
                list.add(ais);
            }
        } else {
            ItemStack is;
            IAEItemStack extractItems = this.inventory.extractItems(ingredient, Actionable.SIMULATE, (BaseActionSource)this.machineSrc);
            ItemStack itemStack = is = extractItems == null ? null : extractItems.getItemStack();
            if (is != null && (long)is.field_77994_a == ingredient.getStackSize()) {
                list.add(extractItems);
                return list;
            }
        }
        return list;
    }

    private boolean canCraft(ICraftingPatternDetails details, IAEItemStack[] condensedInputs) {
        for (IAEItemStack g : condensedInputs) {
            if (!this.getExtractItems(g, details).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void cancel() {
        if (this.myLastLink != null) {
            this.myLastLink.cancel();
        }
        IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
        this.getListOfItem(list, CraftingItemList.ALL);
        for (IAEItemStack is : list) {
            this.postChange(is, this.machineSrc);
        }
        this.usedStorage = 0L;
        this.isComplete = true;
        this.myLastLink = null;
        this.tasks.clear();
        this.providers.clear();
        ImmutableSet items = ImmutableSet.copyOf(this.waitingFor);
        this.waitingFor.resetStatus();
        this.waitingForMissing.resetStatus();
        for (IAEItemStack iAEItemStack : items) {
            this.postCraftingStatusChange(iAEItemStack);
        }
        this.finalOutput = null;
        this.updateCPU();
        this.craftCompleteListeners = this.initializeDefaultOnCompleteListener();
        for (Runnable runnable : this.craftCancelListeners) {
            runnable.run();
        }
        this.craftCancelListeners.clear();
        this.craftUpdateListeners.clear();
        this.storeItems();
    }

    public void updateCraftingLogic(IGrid grid, IEnergyGrid eg, CraftingGridCache cc) {
        IAEItemStack is;
        if (!this.getCore().isActive()) {
            return;
        }
        if (this.myLastLink != null && this.myLastLink.isCanceled()) {
            this.myLastLink = null;
            this.cancel();
        }
        if (this.isComplete) {
            if (this.inventory.getItemList().isEmpty()) {
                return;
            }
            this.storeItems();
            return;
        }
        this.waiting = false;
        if (this.waiting || this.tasks.isEmpty()) {
            return;
        }
        int started = this.remainingOperations = this.accelerator + 1 - (this.usedOps[0] + this.usedOps[1] + this.usedOps[2]);
        this.workableTasks.clear();
        this.workableTasks.putAll(this.tasks);
        this.knownBusyMediums.clear();
        if (this.remainingOperations > 0) {
            do {
                this.somethingChanged = false;
                this.executeCrafting(eg, cc);
            } while (this.somethingChanged && this.remainingOperations > 0);
        }
        this.usedOps[2] = this.usedOps[1];
        this.usedOps[1] = this.usedOps[0];
        this.usedOps[0] = started - this.remainingOperations;
        this.knownBusyMediums.clear();
        if (this.remainingOperations > 0 && !this.somethingChanged) {
            this.waiting = true;
        }
        if (this.isFakeCrafting && (is = this.waitingFor.findPrecise(this.finalOutput)) != null) {
            long stackSize = is.getStackSize();
            is.decStackSize(stackSize);
            this.markDirty();
            this.postCraftingStatusChange(is);
            this.finalOutput.decStackSize(stackSize);
            if (this.finalOutput.getStackSize() <= 0L) {
                this.completeJob();
            }
            this.updateCPU();
        }
    }

    private void executeCrafting(IEnergyGrid eg, CraftingGridCache cc) {
        Iterator<Map.Entry<ICraftingPatternDetails, TaskProgress>> i = this.workableTasks.entrySet().iterator();
        int executedTasks = 0;
        while (i.hasNext()) {
            Map.Entry<ICraftingPatternDetails, TaskProgress> e = i.next();
            if (e.getValue().value <= 0L) {
                this.tasks.remove(e.getKey());
                i.remove();
                continue;
            }
            ICraftingPatternDetails iCraftingPatternDetails = e.getKey();
            if (!this.canCraft(iCraftingPatternDetails, iCraftingPatternDetails.getCondensedInputs())) {
                i.remove();
                continue;
            }
            InventoryCrafting ic = null;
            boolean pushedPattern = false;
            for (ICraftingMedium m : cc.getMediums(e.getKey())) {
                IAEItemStack[] di;
                int x;
                if (e.getValue().value <= 0L || this.knownBusyMediums.contains(m)) continue;
                if (m.isBusy()) {
                    this.knownBusyMediums.add(m);
                    continue;
                }
                double sum = 0.0;
                if (ic == null) {
                    IAEItemStack[] input;
                    for (IAEItemStack anInput : input = iCraftingPatternDetails.getInputs()) {
                        if (anInput == null) continue;
                        sum += (double)anInput.getStackSize();
                    }
                    if (m instanceof DualityInterface) {
                        sum *= Math.pow(4.0, ((DualityInterface)m).getInstalledUpgrades(Upgrades.PATTERN_CAPACITY));
                    }
                    if (eg.extractAEPower(sum, Actionable.SIMULATE, PowerMultiplier.CONFIG) < sum - 0.01) continue;
                    ic = iCraftingPatternDetails.isCraftable() ? new InventoryCrafting((Container)new ContainerNull(), 3, 3) : new InventoryCrafting((Container)new ContainerNull(), iCraftingPatternDetails.getInputs().length, 1);
                    boolean found = false;
                    for (x = 0; x < input.length; ++x) {
                        if (input[x] == null) continue;
                        found = false;
                        for (IAEItemStack ias : this.getExtractItems(input[x], iCraftingPatternDetails)) {
                            ItemStack is;
                            if (iCraftingPatternDetails.isCraftable() && !iCraftingPatternDetails.isValidItemForSlot(x, ias.getItemStack(), this.getWorld())) continue;
                            IAEItemStack ais = this.inventory.extractItems(ias, Actionable.MODULATE, (BaseActionSource)this.machineSrc);
                            ItemStack itemStack = is = ais == null ? null : ais.getItemStack();
                            if (is == null) continue;
                            found = true;
                            ic.func_70299_a(x, is);
                            if (!iCraftingPatternDetails.canBeSubstitute() && (long)is.field_77994_a == input[x].getStackSize()) {
                                this.postChange(input[x], this.machineSrc);
                                break;
                            }
                            this.postChange(AEItemStack.create(is), this.machineSrc);
                        }
                        if (!found) break;
                    }
                    if (!found) {
                        for (x = 0; x < ic.func_70302_i_(); ++x) {
                            ItemStack is = ic.func_70301_a(x);
                            if (is == null) continue;
                            this.inventory.injectItems(AEItemStack.create(is), Actionable.MODULATE, (BaseActionSource)this.machineSrc);
                        }
                        ic = null;
                        break;
                    }
                }
                if (!m.pushPattern(iCraftingPatternDetails, ic)) continue;
                eg.extractAEPower(sum, Actionable.MODULATE, PowerMultiplier.CONFIG);
                this.somethingChanged = true;
                --this.remainingOperations;
                pushedPattern = true;
                this.isFakeCrafting = m instanceof DualityInterface && (di = (IAEItemStack[])m).isFakeCraftingMode();
                di = iCraftingPatternDetails.getCondensedOutputs();
                int found = di.length;
                for (x = 0; x < found; ++x) {
                    TileEntity tile;
                    IAEItemStack out = di[x];
                    this.postChange(out, this.machineSrc);
                    this.waitingFor.add(out.copy());
                    this.postCraftingStatusChange(out.copy());
                    this.providers.computeIfAbsent(out, k -> new ArrayList());
                    List<DimensionalCoord> list = this.providers.get(out);
                    if (!(m instanceof ICraftingProvider) || (tile = this.getTile(m)) == null) continue;
                    DimensionalCoord tileDimensionalCoord = new DimensionalCoord(tile);
                    boolean isAdded = false;
                    for (DimensionalCoord dimensionalCoord : list) {
                        if (!dimensionalCoord.isEqual(tileDimensionalCoord)) continue;
                        isAdded = true;
                        break;
                    }
                    if (isAdded) continue;
                    list.add(tileDimensionalCoord);
                }
                if (iCraftingPatternDetails.isCraftable()) {
                    FMLCommonHandler.instance().firePlayerCraftingEvent(Platform.getPlayer((WorldServer)this.getWorld()), iCraftingPatternDetails.getOutput(ic, this.getWorld()), (IInventory)ic);
                    for (int x2 = 0; x2 < ic.func_70302_i_(); ++x2) {
                        ItemStack output = Platform.getContainerItem(ic.func_70301_a(x2));
                        if (output == null) continue;
                        AEItemStack cItem = AEItemStack.create(output);
                        this.postChange(cItem, this.machineSrc);
                        this.waitingFor.add(cItem);
                        this.postCraftingStatusChange(cItem);
                    }
                }
                ic = null;
                this.markDirty();
                e.getValue().value--;
                if (e.getValue().value <= 0L || this.remainingOperations != 0) continue;
                return;
            }
            if (!pushedPattern) {
                i.remove();
            } else {
                ++executedTasks;
            }
            if (ic == null) continue;
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                ItemStack is = ic.func_70301_a(x);
                if (is == null) continue;
                this.inventory.injectItems(AEItemStack.create(is), Actionable.MODULATE, (BaseActionSource)this.machineSrc);
            }
        }
        for (IntConsumer intConsumer : this.craftUpdateListeners) {
            intConsumer.accept(executedTasks);
        }
    }

    private void storeItems() {
        IGrid g = this.getGrid();
        if (g == null) {
            return;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> ii = sg.getItemInventory();
        for (IAEItemStack is : this.inventory.getItemList()) {
            if ((is = this.inventory.extractItems(is.copy(), Actionable.MODULATE, (BaseActionSource)this.machineSrc)) != null) {
                this.postChange(is, this.machineSrc);
                is = ii.injectItems(is, Actionable.MODULATE, this.machineSrc);
            }
            if (is == null) continue;
            this.inventory.injectItems(is, Actionable.MODULATE, (BaseActionSource)this.machineSrc);
        }
        if (this.inventory.getItemList().isEmpty()) {
            this.inventory = new MECraftingInventory();
        }
        this.markDirty();
    }

    public boolean isMissingMode() {
        return this.isMissingMode;
    }

    public ICraftingLink submitJob(IGrid g, ICraftingJob job, BaseActionSource src, ICraftingRequester requestingMachine) {
        if (this.myLastLink != null && this.isBusy() && this.finalOutput.isSameType(job.getOutput()) && this.availableStorage >= this.usedStorage + job.getByteTotal()) {
            return this.mergeJob(g, job, src);
        }
        if (!this.tasks.isEmpty() || !this.waitingFor.isEmpty()) {
            return null;
        }
        if (this.isBusy() || !this.isActive() || this.availableStorage < job.getByteTotal()) {
            return null;
        }
        if (!job.supportsCPUCluster(this)) {
            return null;
        }
        this.providers.clear();
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> storage = sg.getItemInventory();
        MECraftingInventory ci = new MECraftingInventory(storage, true, false, false);
        this.isMissingMode = job.getCraftingMode() == CraftingMode.IGNORE_MISSING;
        ci.setMissingMode(this.isMissingMode);
        ci.setCpuInventory(this.inventory);
        try {
            this.waitingFor.resetStatus();
            this.waitingForMissing.resetStatus();
            job.startCrafting(ci, this, src);
            this.playersFollowingCurrentCraft.clear();
            if (ci.commit(src)) {
                this.craftCancelListeners.clear();
                this.craftUpdateListeners.clear();
                this.craftCompleteListeners = this.initializeDefaultOnCompleteListener();
                if (job.getOutput() != null) {
                    this.finalOutput = job.getOutput();
                    this.isFakeCrafting = false;
                    this.waiting = false;
                    this.isComplete = false;
                    this.usedStorage = job.getByteTotal();
                    this.numsOfOutput = job.getOutput().getStackSize();
                    for (IAEItemStack fte : ci.getExtractFailedList()) {
                        this.waitingForMissing.add(fte);
                    }
                    for (IAEItemStack wfm : this.waitingForMissing) {
                        this.waitingFor.add(wfm);
                    }
                    this.markDirty();
                    this.updateCPU();
                    String craftID = this.generateCraftingID();
                    this.myLastLink = new CraftingLink(this.generateLinkData(craftID, requestingMachine == null, false), this);
                    this.prepareElapsedTime();
                    this.prepareStepCount();
                    if (requestingMachine == null) {
                        return this.myLastLink;
                    }
                    CraftingLink whatLink = new CraftingLink(this.generateLinkData(craftID, false, true), requestingMachine);
                    this.submitLink(this.myLastLink);
                    this.submitLink(whatLink);
                    IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
                    this.getListOfItem(list, CraftingItemList.ALL);
                    for (IAEItemStack ge : list) {
                        this.postChange(ge, this.machineSrc);
                    }
                    return whatLink;
                }
            } else {
                this.waitingForMissing.resetStatus();
                this.tasks.clear();
                this.providers.clear();
                this.inventory.getItemList().resetStatus();
            }
        }
        catch (CraftBranchFailure e) {
            this.handleCraftBranchFailure(e, src);
            this.tasks.clear();
            this.providers.clear();
            this.inventory.getItemList().resetStatus();
        }
        return null;
    }

    private void handleCraftBranchFailure(CraftBranchFailure e, BaseActionSource src) {
        if (!(src instanceof PlayerSource)) {
            return;
        }
        try {
            EntityPlayer player = ((PlayerSource)src).player;
            if (player != null) {
                IAEItemStack missingStack = e.getMissing();
                String missingName = "?";
                Object missingDisplayName = new ChatComponentText("?");
                long missingCount = -1L;
                if (missingStack != null && missingStack.getItem() != null) {
                    missingName = missingStack.getItemStack().func_77977_a();
                    missingDisplayName = StatCollector.func_94522_b((String)(missingName + ".name")) && StatCollector.func_74838_a((String)(missingName + ".name")).equals(missingStack.getItemStack().func_82833_r()) ? new ChatComponentTranslation(missingName + ".name", new Object[0]) : new ChatComponentText(missingStack.getItemStack().func_82833_r());
                    missingCount = missingStack.getStackSize();
                }
                player.func_145747_a(new ChatComponentTranslation(PlayerMessages.CraftingItemsWentMissing.getName(), new Object[]{missingCount, missingName}).func_150258_a(" (").func_150257_a((IChatComponent)missingDisplayName).func_150258_a(")"));
            }
        }
        catch (Exception ex) {
            AELog.error(ex, "Could not notify player of crafting failure");
        }
    }

    public ICraftingLink mergeJob(IGrid g, ICraftingJob job, BaseActionSource src) {
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> storage = sg.getItemInventory();
        MECraftingInventory ci = new MECraftingInventory(storage, true, false, false);
        try {
            job.startCrafting(ci, this, src);
            if (ci.commit(src)) {
                this.finalOutput.add(job.getOutput());
                this.usedStorage += job.getByteTotal();
                this.numsOfOutput += job.getOutput().getStackSize();
                this.isMissingMode = job.getCraftingMode() == CraftingMode.IGNORE_MISSING;
                this.prepareStepCount();
                this.markDirty();
                this.updateCPU();
                return this.myLastLink;
            }
        }
        catch (CraftBranchFailure e) {
            this.handleCraftBranchFailure(e, src);
        }
        return null;
    }

    @Override
    public boolean isBusy() {
        this.tasks.entrySet().removeIf(iCraftingPatternDetailsTaskProgressEntry -> ((TaskProgress)iCraftingPatternDetailsTaskProgressEntry.getValue()).value <= 0L);
        return !this.tasks.isEmpty() || !this.waitingFor.isEmpty();
    }

    @Override
    public BaseActionSource getActionSource() {
        return this.machineSrc;
    }

    @Override
    public long getAvailableStorage() {
        return this.availableStorage;
    }

    @Override
    public long getUsedStorage() {
        return this.usedStorage;
    }

    @Override
    public int getCoProcessors() {
        return this.accelerator;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public boolean isActive() {
        TileCraftingTile core = this.getCore();
        if (core == null) {
            return false;
        }
        IGridNode node = core.getActionableNode();
        if (node == null) {
            return false;
        }
        return node.isActive();
    }

    private String generateCraftingID() {
        long now = System.currentTimeMillis();
        int hash = System.identityHashCode(this);
        int hmm = this.finalOutput == null ? 0 : this.finalOutput.hashCode();
        return Long.toString(now, 36) + '-' + Integer.toString(hash, 36) + '-' + Integer.toString(hmm, 36);
    }

    private NBTTagCompound generateLinkData(String craftingID, boolean standalone, boolean req) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("CraftID", craftingID);
        tag.func_74757_a("canceled", false);
        tag.func_74757_a("done", false);
        tag.func_74757_a("standalone", standalone);
        tag.func_74757_a("req", req);
        return tag;
    }

    private void submitLink(ICraftingLink myLastLink2) {
        if (this.getGrid() != null) {
            CraftingGridCache cc = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
            cc.addLink((CraftingLink)myLastLink2);
        }
    }

    public void getListOfItem(IItemList<IAEItemStack> list, CraftingItemList whichList) {
        switch (whichList) {
            case ACTIVE: {
                for (IAEItemStack iAEItemStack : this.waitingFor) {
                    list.add(iAEItemStack);
                }
                break;
            }
            case PENDING: {
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> entry : this.tasks.entrySet()) {
                    for (IAEItemStack ais : entry.getKey().getCondensedOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * entry.getValue().value);
                        list.add(ais);
                    }
                }
                break;
            }
            case STORAGE: {
                this.inventory.getAvailableItems(list, IterationCounter.fetchNewId());
                break;
            }
            default: {
                this.inventory.getAvailableItems(list, IterationCounter.fetchNewId());
                for (IAEItemStack iAEItemStack : this.waitingFor) {
                    list.add(iAEItemStack);
                }
                for (Map.Entry entry : this.tasks.entrySet()) {
                    for (IAEItemStack ais : ((ICraftingPatternDetails)entry.getKey()).getCondensedOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * ((TaskProgress)entry.getValue()).value);
                        list.add(ais);
                    }
                }
            }
        }
    }

    public void addStorage(IAEItemStack extractItems) {
        extractItems.setCraftable(false);
        this.inventory.injectItems(extractItems, Actionable.MODULATE, (BaseActionSource)null);
    }

    public void addEmitable(IAEItemStack i) {
        this.waitingForMissing.add(i);
    }

    public void addCrafting(ICraftingPatternDetails details, long crafts) {
        TaskProgress i = this.tasks.get(details);
        if (i == null) {
            i = new TaskProgress();
            this.tasks.put(details, i);
        }
        i.value += crafts;
    }

    public IAEItemStack getItemStack(IAEItemStack what, CraftingItemList storage2) {
        IAEItemStack is;
        switch (storage2) {
            case STORAGE: {
                is = this.inventory.getItemList().findPrecise(what);
                break;
            }
            case ACTIVE: {
                is = this.waitingFor.findPrecise(what);
                break;
            }
            case PENDING: {
                CraftingGridCache cache = null;
                if (this.getGrid() != null) {
                    cache = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
                }
                is = what.copy();
                is.setStackSize(0L);
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> t : this.tasks.entrySet()) {
                    for (IAEItemStack ais : t.getKey().getCondensedOutputs()) {
                        if (!Objects.equals(ais, is)) continue;
                        is.setStackSize(is.getStackSize() + ais.getStackSize() * t.getValue().value);
                        if (cache == null) continue;
                        List<ICraftingMedium> craftingProviders = cache.getMediums(t.getKey());
                        ArrayList<DimensionalCoord> dimensionalCoords = new ArrayList<DimensionalCoord>();
                        for (ICraftingMedium craftingProvider : craftingProviders) {
                            TileEntity tile = this.getTile(craftingProvider);
                            if (tile == null) continue;
                            dimensionalCoords.add(new DimensionalCoord(tile));
                        }
                        this.providers.put(is, dimensionalCoords);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Operation");
            }
        }
        if (is != null) {
            return is.copy();
        }
        is = what.copy();
        is.setStackSize(0L);
        return is;
    }

    private NBTTagCompound persistListeners(int from, List<?> listeners) throws IOException {
        NBTTagCompound tagListeners = new NBTTagCompound();
        for (int i = from; i < listeners.size(); ++i) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream saveListener = new ObjectOutputStream(out);
            saveListener.writeObject(listeners.get(i));
            tagListeners.func_74773_a(String.valueOf(i), out.toByteArray());
        }
        return tagListeners;
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74782_a("finalOutput", (NBTBase)this.writeItem(this.finalOutput));
        data.func_74782_a("inventory", (NBTBase)this.writeList(this.inventory.getItemList()));
        data.func_74757_a("waiting", this.waiting);
        data.func_74757_a("isComplete", this.isComplete);
        data.func_74772_a("usedStorage", this.usedStorage);
        data.func_74772_a("numsOfOutput", this.numsOfOutput);
        data.func_74757_a("isMissingMode", this.isMissingMode);
        data.func_74768_a("craftingAllowMode", this.craftingAllowMode.ordinal());
        try {
            data.func_74782_a("craftCompleteListeners", (NBTBase)this.persistListeners(1, this.craftCompleteListeners));
            data.func_74782_a("onCancelListeners", (NBTBase)this.persistListeners(0, this.craftCancelListeners));
            data.func_74782_a("craftStatusListeners", (NBTBase)this.persistListeners(0, this.craftUpdateListeners));
        }
        catch (IOException e) {
            AELog.error(e, "Could not save notification listeners to NBT");
        }
        if (!this.playersFollowingCurrentCraft.isEmpty()) {
            NBTTagList nbtTagList = new NBTTagList();
            for (String string : this.playersFollowingCurrentCraft) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(string));
            }
            data.func_74782_a("playerNameList", (NBTBase)nbtTagList);
        }
        if (!this.unreadNotifications.isEmpty()) {
            NBTTagList unreadNotificationsTag = new NBTTagList();
            for (Map.Entry entry : this.unreadNotifications.entrySet()) {
                NBTTagList notificationsTag = new NBTTagList();
                for (CraftNotification notification : (List)entry.getValue()) {
                    NBTTagCompound tag = new NBTTagCompound();
                    notification.writeToNBT(tag);
                    notificationsTag.func_74742_a((NBTBase)tag);
                }
                NBTTagCompound playerTag = new NBTTagCompound();
                playerTag.func_74778_a("playerName", (String)entry.getKey());
                playerTag.func_74782_a("notifications", (NBTBase)notificationsTag);
                unreadNotificationsTag.func_74742_a((NBTBase)playerTag);
            }
            data.func_74782_a("unreadNotifications", (NBTBase)unreadNotificationsTag);
        }
        if (this.myLastLink != null) {
            NBTTagCompound link = new NBTTagCompound();
            this.myLastLink.writeToNBT(link);
            data.func_74782_a("link", (NBTBase)link);
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : this.tasks.entrySet()) {
            NBTTagCompound item = this.writeItem(AEItemStack.create(((ICraftingPatternDetails)entry.getKey()).getPattern()));
            item.func_74772_a("craftingProgress", ((TaskProgress)entry.getValue()).value);
            list.func_74742_a((NBTBase)item);
        }
        data.func_74782_a("tasks", (NBTBase)list);
        data.func_74782_a("waitingFor", (NBTBase)this.writeList(this.waitingFor));
        data.func_74782_a("waitingForMissing", (NBTBase)this.writeList(this.waitingForMissing));
        data.func_74772_a("elapsedTime", this.getElapsedTime());
        data.func_74772_a("startItemCount", this.getStartItemCount());
        data.func_74772_a("remainingItemCount", this.getRemainingItemCount());
        list = new NBTTagList();
        for (Map.Entry entry : this.providers.entrySet()) {
            NBTTagCompound tmp = new NBTTagCompound();
            tmp.func_74782_a("item", (NBTBase)this.writeItem((IAEItemStack)entry.getKey()));
            DimensionalCoord.writeListToNBT(tmp, (List)entry.getValue());
            list.func_74742_a((NBTBase)tmp);
        }
        data.func_74782_a("providers", (NBTBase)list);
    }

    private NBTTagCompound writeItem(IAEItemStack finalOutput2) {
        NBTTagCompound out = new NBTTagCompound();
        if (finalOutput2 != null) {
            finalOutput2.writeToNBT(out);
        }
        return out;
    }

    private NBTTagList writeList(IItemList<IAEItemStack> myList) {
        NBTTagList out = new NBTTagList();
        for (IAEItemStack ais : myList) {
            out.func_74742_a((NBTBase)this.writeItem(ais));
        }
        return out;
    }

    void done() {
        TileCraftingTile core = this.getCore();
        core.setCoreBlock(true);
        if (core.getPreviousState() != null) {
            this.readFromNBT(core.getPreviousState());
            core.setPreviousState(null);
        }
        this.updateCPU();
        this.updateName();
    }

    private <T> void unpersistListeners(int from, List<T> toAdd, NBTTagCompound tagCompound) throws IOException, ClassNotFoundException {
        if (tagCompound != null) {
            byte[] r;
            int i = from;
            while ((r = tagCompound.func_74770_j(String.valueOf(i))).length != 0) {
                toAdd.add(new ObjectInputStream(new ByteArrayInputStream(r)).readObject());
                ++i;
            }
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        this.finalOutput = AEItemStack.loadItemStackFromNBT((NBTTagCompound)data.func_74781_a("finalOutput"));
        for (IAEItemStack ais : this.readList((NBTTagList)data.func_74781_a("inventory"))) {
            if (ais.isCraftable() && ais.getStackSize() == 0L) continue;
            ais.setCraftable(false);
            this.inventory.injectItems(ais, Actionable.MODULATE, (BaseActionSource)this.machineSrc);
        }
        this.waiting = data.func_74767_n("waiting");
        this.isComplete = data.func_74767_n("isComplete");
        this.usedStorage = data.func_74763_f("usedStorage");
        this.craftingAllowMode = CraftingAllow.values()[data.func_74762_e("craftingAllowMode")];
        if (data.func_74764_b("link")) {
            NBTTagCompound link = data.func_74775_l("link");
            this.myLastLink = new CraftingLink(link, this);
            this.submitLink(this.myLastLink);
        }
        NBTTagList list = data.func_150295_c("tasks", 10);
        for (int x = 0; x < list.func_74745_c(); ++x) {
            ICraftingPatternItem cpi;
            ICraftingPatternDetails details;
            Item item;
            NBTTagCompound item2 = list.func_150305_b(x);
            IAEItemStack pattern = AEItemStack.loadItemStackFromNBT(item2);
            if (pattern == null || !((item = pattern.getItem()) instanceof ICraftingPatternItem) || (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(pattern.getItemStack(), this.getWorld())) == null) continue;
            TaskProgress tp = new TaskProgress();
            tp.value = item2.func_74763_f("craftingProgress");
            this.tasks.put(details, tp);
        }
        this.waitingFor = this.readList((NBTTagList)data.func_74781_a("waitingFor"));
        for (IAEItemStack is : this.waitingFor) {
            this.postCraftingStatusChange(is.copy());
        }
        this.waitingForMissing = this.readList((NBTTagList)data.func_74781_a("waitingForMissing"));
        this.lastTime = System.nanoTime();
        this.elapsedTime = data.func_74763_f("elapsedTime");
        this.startItemCount = data.func_74763_f("startItemCount");
        this.remainingItemCount = data.func_74763_f("remainingItemCount");
        this.numsOfOutput = data.func_74763_f("numsOfOutput");
        this.isMissingMode = data.func_74767_n("isMissingMode");
        NBTBase tag = data.func_74781_a("playerNameList");
        if (tag instanceof NBTTagList) {
            NBTTagList ntl = (NBTTagList)tag;
            this.playersFollowingCurrentCraft.clear();
            for (int index = 0; index < ntl.func_74745_c(); ++index) {
                this.playersFollowingCurrentCraft.add(ntl.func_150307_f(index));
            }
        }
        list = data.func_150295_c("providers", 10);
        for (int x = 0; x < list.func_74745_c(); ++x) {
            NBTTagCompound pro = list.func_150305_b(x);
            this.providers.put(AEItemStack.loadItemStackFromNBT(pro.func_74775_l("item")), DimensionalCoord.readAsListFromNBT(pro));
        }
        try {
            this.unpersistListeners(1, this.craftCompleteListeners, data.func_74775_l("craftCompleteListeners"));
            this.unpersistListeners(0, this.craftCancelListeners, data.func_74775_l("onCancelListeners"));
            this.unpersistListeners(0, this.craftUpdateListeners, data.func_74775_l("craftStatusListeners"));
        }
        catch (IOException | ClassNotFoundException e) {
            AELog.error(e, "Could not load notification listeners from NBT");
        }
        NBTBase pro = data.func_74781_a("unreadNotifications");
        if (pro instanceof NBTTagList) {
            NBTTagList unreadNotificationsTag = (NBTTagList)pro;
            for (int i = 0; i < unreadNotificationsTag.func_74745_c(); ++i) {
                NBTTagCompound playerTag = unreadNotificationsTag.func_150305_b(i);
                String playerName = playerTag.func_74779_i("playerName");
                ArrayList<CraftNotification> notifications = new ArrayList<CraftNotification>();
                NBTBase nBTBase = playerTag.func_74781_a("notifications");
                if (nBTBase instanceof NBTTagList) {
                    NBTTagList notificationsTag = (NBTTagList)nBTBase;
                    for (int j = 0; j < notificationsTag.func_74745_c(); ++j) {
                        CraftNotification notification = new CraftNotification();
                        notification.readFromNBT(notificationsTag.func_150305_b(j));
                        notifications.add(notification);
                    }
                }
                if (notifications.isEmpty()) continue;
                this.unreadNotifications.put(playerName, notifications);
            }
        }
    }

    public void updateName() {
        this.myName = "";
        for (TileCraftingTile te : this.tiles) {
            if (!te.hasCustomName()) continue;
            if (this.myName.length() > 0) {
                this.myName = this.myName + ' ' + te.getCustomName();
                continue;
            }
            this.myName = te.getCustomName();
        }
    }

    private IItemList<IAEItemStack> readList(NBTTagList tag) {
        IItemList<IAEItemStack> out = AEApi.instance().storage().createItemList();
        if (tag == null) {
            return out;
        }
        for (int x = 0; x < tag.func_74745_c(); ++x) {
            IAEItemStack ais = AEItemStack.loadItemStackFromNBT(tag.func_150305_b(x));
            if (ais == null) continue;
            out.add(ais);
        }
        return out;
    }

    private World getWorld() {
        return this.getCore().func_145831_w();
    }

    public boolean isMaking(IAEItemStack what) {
        IAEItemStack wat = this.waitingFor.findPrecise(what);
        return wat != null && wat.getStackSize() > 0L;
    }

    public void breakCluster() {
        TileCraftingTile t = this.getCore();
        if (t != null) {
            t.breakCluster();
        }
    }

    private void prepareElapsedTime() {
        this.lastTime = System.nanoTime();
        this.elapsedTime = 0L;
    }

    private void prepareStepCount() {
        IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
        this.getListOfItem(list, CraftingItemList.ACTIVE);
        this.getListOfItem(list, CraftingItemList.PENDING);
        long itemCount = 0L;
        for (IAEItemStack ge : list) {
            itemCount += ge.getStackSize();
        }
        if (this.startItemCount > 0L) {
            long completedSteps = this.startItemCount - this.remainingItemCount;
            this.startItemCount = itemCount + completedSteps;
        } else {
            this.startItemCount = itemCount;
        }
        this.remainingItemCount = itemCount;
    }

    private void updateElapsedTime(IAEItemStack is) {
        long nextStartTime = System.nanoTime();
        this.elapsedTime = this.getElapsedTime() + nextStartTime - this.lastTime;
        this.lastTime = nextStartTime;
        this.remainingItemCount = this.getRemainingItemCount() - is.getStackSize();
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    @Override
    public long getStartItemCount() {
        return this.startItemCount;
    }

    public List<String> getPlayersFollowingCurrentCraft() {
        return this.playersFollowingCurrentCraft;
    }

    @Override
    public void togglePlayerFollowStatus(String name) {
        if (this.playersFollowingCurrentCraft.contains(name)) {
            this.playersFollowingCurrentCraft.remove(name);
        } else {
            this.playersFollowingCurrentCraft.add(name);
        }
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.getListeners();
        while (i.hasNext()) {
            IMEMonitorHandlerReceiver<IAEItemStack> iMEMonitorHandlerReceiver = i.next().getKey();
            if (!(iMEMonitorHandlerReceiver instanceof ContainerCraftingCPU)) continue;
            ContainerCraftingCPU cccpu = (ContainerCraftingCPU)iMEMonitorHandlerReceiver;
            cccpu.sendUpdateFollowPacket(this.playersFollowingCurrentCraft);
        }
    }

    public List<DimensionalCoord> getProviders(IAEItemStack is) {
        return this.providers.getOrDefault(is, Collections.EMPTY_LIST);
    }

    private TileEntity getTile(ICraftingMedium craftingProvider) {
        if (craftingProvider instanceof DualityInterface) {
            return ((DualityInterface)craftingProvider).getHost().getTile();
        }
        if (craftingProvider instanceof AEBaseTile) {
            return ((AEBaseTile)((Object)craftingProvider)).getTile();
        }
        if (craftingProvider instanceof IInterfaceViewable) {
            IInterfaceViewable interfaceViewable = (IInterfaceViewable)((Object)craftingProvider);
            return interfaceViewable.getTileEntity();
        }
        try {
            Method method = craftingProvider.getClass().getMethod("getTile", new Class[0]);
            return (TileEntity)method.invoke((Object)craftingProvider, new Object[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public int getRemainingOperations() {
        if (this.isComplete) {
            return 0;
        }
        return this.remainingOperations;
    }

    public void tryExtractItems() {
        if (this.waitingForMissing.isEmpty()) {
            return;
        }
        if (this.countToTryExtractItems > 1200) {
            this.countToTryExtractItems = 0;
            for (IAEItemStack waitingForItem : this.waitingForMissing) {
                IAEStack notInjected;
                IAEItemStack extractedItems;
                IStorageGrid pg;
                IGrid grid = this.getGrid();
                if (grid == null || (pg = (IStorageGrid)grid.getCache(IStorageGrid.class)) == null || (extractedItems = pg.getItemInventory().extractItems(waitingForItem, Actionable.MODULATE, this.machineSrc)) == null || (notInjected = this.injectItems(extractedItems, Actionable.MODULATE, this.machineSrc)) == null) continue;
                AELog.logSimple(Level.INFO, "MISSING MODE OVERFLOW! TELL DEVS ASAP!");
                pg.getItemInventory().injectItems((IAEItemStack)notInjected, Actionable.MODULATE, this.machineSrc);
            }
        } else {
            ++this.countToTryExtractItems;
        }
    }

    @Override
    public CraftingAllow getCraftingAllowMode() {
        return this.craftingAllowMode;
    }

    @Override
    public void changeCraftingAllowMode(CraftingAllow mode) {
        this.craftingAllowMode = mode;
        this.markDirty();
    }

    private static class CraftNotification {
        private ItemStack finalOutput;
        private long outputsCount;
        private long elapsedTime;

        public CraftNotification() {
            this.finalOutput = null;
            this.outputsCount = 0L;
            this.elapsedTime = 0L;
        }

        public CraftNotification(ItemStack finalOutput, long outputsCount, long elapsedTime) {
            this.finalOutput = finalOutput;
            this.outputsCount = outputsCount;
            this.elapsedTime = elapsedTime;
        }

        public IChatComponent createMessage() {
            String elapsedTimeText = DurationFormatUtils.formatDuration((long)TimeUnit.MILLISECONDS.convert(this.elapsedTime, TimeUnit.NANOSECONDS), (String)GuiText.ETAFormat.getLocal());
            return PlayerMessages.FinishCraftingRemind.get(new ChatComponentText(EnumChatFormatting.GREEN + String.valueOf(this.outputsCount)), this.finalOutput.func_151000_E(), new ChatComponentText(EnumChatFormatting.GREEN + elapsedTimeText));
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("finalOutput")) {
                this.finalOutput = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("finalOutput"));
            }
            this.outputsCount = tag.func_74763_f("outputsCount");
            this.elapsedTime = tag.func_74763_f("elapsedTime");
        }

        public void writeToNBT(NBTTagCompound tag) {
            if (this.finalOutput != null) {
                NBTTagCompound finalOutputTag = new NBTTagCompound();
                this.finalOutput.func_77955_b(finalOutputTag);
                tag.func_74782_a("finalOutput", (NBTBase)finalOutputTag);
            }
            tag.func_74772_a("outputsCount", this.outputsCount);
            tag.func_74772_a("elapsedTime", this.elapsedTime);
        }
    }

    private static class TaskProgress {
        private long value;

        private TaskProgress() {
        }
    }
}

