/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.Settings;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.features.AEFeature;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNetworkVisualiserData;
import appeng.items.AEBaseItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolNetworkVisualiser
extends AEBaseItem {
    private boolean needUpdate = true;
    ArrayList<IGridConnection> gcListCache = new ArrayList();
    ItemStack currItem;

    public ToolNetworkVisualiser() {
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack is, World worldIn, EntityPlayer p) {
        if (Platform.isServer() && p.func_70093_af()) {
            IConfigManager cm = ToolNetworkVisualiser.getConfigManager(is);
            Enum<?> newState = Platform.rotateEnum(cm.getSetting(Settings.NETWORK_VISUALISER), false, Settings.NETWORK_VISUALISER.getPossibleValues());
            cm.putSetting(Settings.NETWORK_VISUALISER, newState);
            p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolNetworkVisualiser.set", new Object[]{EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)("item.appliedenergistics2.ToolNetworkVisualiser.mode." + newState.toString().toLowerCase(Locale.US)))}));
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        TileEntity te;
        if (Platform.isServer() && (te = w.func_147438_o(x, y, z)) instanceof IGridHost) {
            DimensionalCoord dc = new DimensionalCoord(te);
            dc.writeToNBT(is.func_77978_p());
            p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolNetworkVisualiser.bound", new Object[]{String.valueOf(dc.x), String.valueOf(dc.y), String.valueOf(dc.z)}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
            this.needUpdate = true;
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack is, World w, Entity entity, int slot, boolean active) {
        IGrid g;
        IGridHost gh;
        IGridNode gn;
        EntityPlayerMP player;
        block18: {
            block17: {
                if (Platform.isClient() || !(entity instanceof EntityPlayerMP)) break block17;
                player = (EntityPlayerMP)entity;
                if (is.func_77978_p() != null) break block18;
            }
            return;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != this.currItem) {
            this.currItem = currentItem;
            this.needUpdate = true;
        }
        if (currentItem == null || !(currentItem.func_77973_b() instanceof ToolNetworkVisualiser) || !this.needUpdate) {
            return;
        }
        this.currItem = currentItem;
        DimensionalCoord dc = DimensionalCoord.readFromNBT(is.func_77978_p());
        if (w.field_73011_w.field_76574_g != dc.getDimension()) {
            return;
        }
        TileEntity te = w.func_147438_o(dc.x, dc.y, dc.z);
        if (te instanceof IGridHost && (gn = (gh = (IGridHost)te).getGridNode(ForgeDirection.UNKNOWN)) != null && (g = gn.getGrid()) != null) {
            HashMap<IGridNode, VNode> vnList = new HashMap<IGridNode, VNode>();
            ArrayList<IGridConnection> gcList = new ArrayList<IGridConnection>();
            for (IGridNode iGridNode : g.getNodes()) {
                IGridBlock igb = iGridNode.getGridBlock();
                if (!igb.isWorldAccessible() || !igb.getLocation().isInWorld(w)) continue;
                DimensionalCoord loc = igb.getLocation();
                for (IGridConnection igc : iGridNode.getConnections()) {
                    gcList.add(igc);
                }
                EnumSet<VNodeFlags> flags = EnumSet.noneOf(VNodeFlags.class);
                if (!iGridNode.meetsChannelRequirements()) {
                    flags.add(VNodeFlags.MISSING);
                }
                if (iGridNode.hasFlag(GridFlags.DENSE_CAPACITY)) {
                    flags.add(VNodeFlags.DENSE);
                }
                vnList.put(iGridNode, new VNode(loc.x, loc.y, loc.z, flags));
            }
            if (gcList.equals(this.gcListCache)) {
                this.needUpdate = false;
                return;
            }
            this.gcListCache = gcList;
            ArrayList<VLink> vLinks = new ArrayList<VLink>();
            for (IGridConnection c : gcList) {
                VNode n1 = (VNode)vnList.get(c.a());
                VNode n2 = (VNode)vnList.get(c.b());
                if (n1 == null || n2 == null || n1 == n2) continue;
                EnumSet<VLinkFlags> flags = EnumSet.noneOf(VLinkFlags.class);
                if (c.a().hasFlag(GridFlags.DENSE_CAPACITY) && c.b().hasFlag(GridFlags.DENSE_CAPACITY)) {
                    flags.add(VLinkFlags.DENSE);
                }
                if (c.a().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED) && c.b().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED)) {
                    flags.add(VLinkFlags.COMPRESSED);
                }
                vLinks.add(new VLink(n1, n2, c.getUsedChannels(), flags));
            }
            try {
                ArrayList<VNode> arrayList = new ArrayList<VNode>(vnList.values());
                NetworkHandler.instance.sendTo(new PacketNetworkVisualiserData(arrayList, vLinks), (EntityPlayerMP)entity);
                this.needUpdate = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData(target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.NETWORK_VISUALISER, (Enum)VisualisationModes.FULL);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData(target).func_74737_b());
        return out;
    }

    @Override
    protected void addCheckedInformation(ItemStack is, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolNetworkVisualiser.mode") + " " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)("item.appliedenergistics2.ToolNetworkVisualiser.mode." + ToolNetworkVisualiser.getConfigManager(is).getSetting(Settings.NETWORK_VISUALISER).toString().toLowerCase(Locale.US))));
    }

    public static enum VNodeFlags {
        DENSE,
        MISSING;

    }

    public static class VNode {
        public final int x;
        public final int y;
        public final int z;
        public final EnumSet<VNodeFlags> flags;

        public VNode(int x, int y, int z, EnumSet<VNodeFlags> flags) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.flags = flags;
        }
    }

    public static enum VLinkFlags {
        DENSE,
        COMPRESSED;

    }

    public static class VLink {
        public final VNode node1;
        public final VNode node2;
        public final int channels;
        public final EnumSet<VLinkFlags> flags;

        public VLink(VNode node1, VNode node2, int channels, EnumSet<VLinkFlags> flags) {
            this.node1 = node1;
            this.node2 = node2;
            this.channels = channels;
            this.flags = flags;
        }
    }

    public static enum VisualisationModes {
        FULL,
        NODES,
        CHANNELS,
        NONUM,
        P2P;

    }
}

