/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.util.IterationCounter;
import appeng.util.item.ItemList;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemExtremeStorageCell
extends ItemBasicStorageCell {
    protected final int totalTypes;

    public ItemExtremeStorageCell(String name, long bytes, int types, int perType, double drain) {
        super((Optional<String>)Optional.of((Object)name));
        this.setFeature(EnumSet.of(AEFeature.XtremeStorageCells));
        this.func_77625_d(1);
        this.totalBytes = bytes;
        this.perType = perType;
        this.totalTypes = types;
        this.idleDrain = drain;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return this.totalTypes;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public ItemStack getContainerItem(ItemStack itemStack) {
        return null;
    }

    @Override
    public boolean hasContainerItem(ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventoryHandler handler;
        ICellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (inventory instanceof ICellInventoryHandler && (cellInventory = (handler = (ICellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(NumberFormat.getInstance().format(cellInventory.getUsedBytes()) + " " + GuiText.Of.getLocal() + ' ' + NumberFormat.getInstance().format(cellInventory.getTotalBytes()) + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(NumberFormat.getInstance().format(cellInventory.getStoredItemTypes()) + " " + GuiText.Of.getLocal() + ' ' + NumberFormat.getInstance().format(cellInventory.getTotalItemTypes()) + ' ' + GuiText.Types.getLocal());
            if (cellInventory.getTotalItemTypes() == 1L && cellInventory.getStoredItemTypes() != 0L) {
                ItemStack itemStack = handler.getAvailableItems(new ItemList(), IterationCounter.fetchNewId()).getFirstItem().getItemStack();
                lines.add(GuiText.Contains.getLocal() + ": " + itemStack.func_82833_r());
            }
            if (handler.isPreformatted()) {
                String filter = cellInventory.getOreFilter();
                if (filter.isEmpty()) {
                    String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                    if (handler.isFuzzy()) {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Fuzzy.getLocal());
                    } else {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                    }
                    if (GuiScreen.func_146272_n()) {
                        lines.add(GuiText.Filter.getLocal() + ": ");
                        for (int i = 0; i < cellInventory.getConfigInventory().func_70302_i_(); ++i) {
                            ItemStack s = cellInventory.getConfigInventory().func_70301_a(i);
                            if (s == null) continue;
                            lines.add(s.func_82833_r());
                        }
                    }
                } else {
                    lines.add(GuiText.PartitionedOre.getLocal() + " : " + filter);
                }
                if (handler.getSticky()) {
                    lines.add(GuiText.Sticky.getLocal());
                }
            }
        }
    }
}

