/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.config.PowerMultiplier;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.NetworkVisualiserRender;
import appeng.integration.modules.waila.BaseWailaDataProvider;
import appeng.tile.networking.TileWirelessConnector;
import appeng.tile.networking.TileWirelessHub;
import appeng.util.Platform;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class WirelessDataProvider
extends BaseWailaDataProvider {
    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileWirelessConnector) {
            AEColor color;
            TileWirelessConnector wc = (TileWirelessConnector)te;
            NBTTagCompound tag = accessor.getNBTData();
            if (tag.func_74764_b("connected")) {
                if (wc.isHub()) {
                    NetworkVisualiserRender.doWirelessHubRender(DimensionalCoord.readAsListFromNBT(tag.func_74775_l("hubList")));
                } else {
                    DimensionalCoord dc = DimensionalCoord.readFromNBT(tag);
                    currentToolTip.add(StatCollector.func_74837_a((String)"waila.appliedenergistics2.wireless.connected", (Object[])new Object[]{dc.x, dc.y, dc.z}));
                    NetworkVisualiserRender.doWirelessRender(dc);
                }
                currentToolTip.add(StatCollector.func_74837_a((String)"waila.appliedenergistics2.wireless.channels", (Object[])new Object[]{tag.func_74762_e("channels")}));
                currentToolTip.add(StatCollector.func_74837_a((String)"waila.appliedenergistics2.wireless.power", (Object[])new Object[]{Platform.formatNumberDoubleRestrictedByWidth(tag.func_74769_h("power"), 5)}));
            } else {
                currentToolTip.add(StatCollector.func_74838_a((String)"waila.appliedenergistics2.wireless.notconnected"));
            }
            if (tag.func_74764_b("name")) {
                currentToolTip.add(StatCollector.func_74837_a((String)"waila.appliedenergistics2.wireless.name", (Object[])new Object[]{tag.func_74779_i("name")}));
            }
            if ((color = AEColor.values()[tag.func_74762_e("color")]) != AEColor.Transparent) {
                currentToolTip.add(StatCollector.func_74838_a((String)("gui.appliedenergistics2." + color.name())));
            }
        }
        return currentToolTip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileWirelessConnector) {
            TileWirelessConnector wc = (TileWirelessConnector)te;
            if (wc.hasConnection()) {
                TileWirelessHub wh;
                tag.func_74757_a("connected", true);
                tag.func_74768_a("channels", wc.getChannelUsage());
                tag.func_74780_a("power", PowerMultiplier.CONFIG.multiply(wc.getPowerUsage()));
                if (wc instanceof TileWirelessHub && (wh = (TileWirelessHub)wc).hasConnection()) {
                    NBTTagCompound cordList = new NBTTagCompound();
                    DimensionalCoord.writeListToNBT(cordList, wh.getConnectionList());
                    tag.func_74782_a("hubList", (NBTBase)cordList);
                } else {
                    wc.getTarget().writeToNBT(tag);
                }
            }
            if (wc.hasCustomName()) {
                tag.func_74778_a("name", wc.getCustomName());
            }
            tag.func_74768_a("color", wc.getColor().ordinal());
        }
        return tag;
    }
}

