/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.render.NetworkVisualiserRender;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.ToolNetworkVisualiser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class PacketNetworkVisualiserData
extends AppEngPacket {
    private ArrayList<ToolNetworkVisualiser.VNode> vNodeSet;
    private ArrayList<ToolNetworkVisualiser.VLink> vLinkSet;

    public PacketNetworkVisualiserData(ByteBuf stream) throws IOException {
        int flag;
        int j;
        EnumSet<Enum> flags;
        int flagsCount;
        int i;
        int ver = stream.readInt();
        if (ver != 1) {
            return;
        }
        int vNodeCount = stream.readInt();
        int vLinkCount = stream.readInt();
        this.vNodeSet = new ArrayList();
        for (i = 0; i < vNodeCount; ++i) {
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            flagsCount = stream.readInt();
            flags = EnumSet.noneOf(ToolNetworkVisualiser.VNodeFlags.class);
            for (j = 0; j < flagsCount; ++j) {
                flag = stream.readInt();
                flags.add(ToolNetworkVisualiser.VNodeFlags.values()[flag]);
            }
            this.vNodeSet.add(new ToolNetworkVisualiser.VNode(x, y, z, flags));
        }
        this.vLinkSet = new ArrayList();
        for (i = 0; i < vLinkCount; ++i) {
            int n1 = stream.readInt();
            int n2 = stream.readInt();
            int c = stream.readInt();
            flagsCount = stream.readInt();
            flags = EnumSet.noneOf(ToolNetworkVisualiser.VLinkFlags.class);
            for (j = 0; j < flagsCount; ++j) {
                flag = stream.readInt();
                flags.add((ToolNetworkVisualiser.VNodeFlags)((Object)ToolNetworkVisualiser.VLinkFlags.values()[flag]));
            }
            this.vLinkSet.add(new ToolNetworkVisualiser.VLink(this.vNodeSet.get(n1), this.vNodeSet.get(n2), c, flags));
        }
    }

    public PacketNetworkVisualiserData(ArrayList<ToolNetworkVisualiser.VNode> vNodeSet, ArrayList<ToolNetworkVisualiser.VLink> vLinkSet) throws IOException {
        this.vNodeSet = vNodeSet;
        this.vLinkSet = vLinkSet;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(1);
        data.writeInt(vNodeSet.size());
        data.writeInt(vLinkSet.size());
        for (ToolNetworkVisualiser.VNode node : vNodeSet) {
            data.writeInt(node.x);
            data.writeInt(node.y);
            data.writeInt(node.z);
            data.writeInt(node.flags.size());
            for (ToolNetworkVisualiser.VNodeFlags vNodeFlags : node.flags) {
                data.writeInt(vNodeFlags.ordinal());
            }
        }
        for (ToolNetworkVisualiser.VLink vl : vLinkSet) {
            data.writeInt(vNodeSet.indexOf(vl.node1));
            data.writeInt(vNodeSet.indexOf(vl.node2));
            data.writeInt(vl.channels);
            data.writeInt(vl.flags.size());
            for (ToolNetworkVisualiser.VLinkFlags vLinkFlags : vl.flags) {
                data.writeInt(vLinkFlags.ordinal());
            }
        }
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        NetworkVisualiserRender.networkVisualiser(this.vNodeSet, this.vLinkSet);
    }

    public static class VisualisationData {
        public static final int VERSION = 1;
    }
}

