/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Settings;
import appeng.api.config.SuperWirelessToolGroupBy;
import appeng.api.config.YesNo;
import appeng.api.events.GuiScrollEvent;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiAeButton;
import appeng.client.gui.widgets.GuiCheckBox;
import appeng.client.gui.widgets.GuiColorButton;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerSuperWirelessKit;
import appeng.core.localization.GuiColors;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketSuperWirelessToolCommand;
import appeng.helpers.SuperWirelessToolDataObject;
import appeng.items.contents.SuperWirelessKitObject;
import appeng.util.IConfigManagerHost;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiSuperWirelessKit
extends AEBaseGui
implements IConfigManagerHost {
    private final int TOP_OFFSET = 22;
    private final int SCROLLBAR_HEIGHT = 229;
    private GuiImgButton sortBy;
    private GuiImgButton hideBoundedButton;
    private GuiAeButton bind;
    private GuiAeButton unbind;
    private final GuiColorButton[] colorButtons = new GuiColorButton[17];
    private GuiCheckBox madChameleonButton;
    private final MEGuiTextField[] nameField = new MEGuiTextField[30];
    private final GuiCheckBox[] pinButtons = new GuiCheckBox[10];
    private final GuiCheckBox[] includeConnectorsButtons = new GuiCheckBox[30];
    private final GuiCheckBox[] includeHubsButtons = new GuiCheckBox[30];
    private final GuiCheckBox[] deleteButtons = new GuiCheckBox[30];
    private final IConfigManager configSrc;
    private SuperWirelessToolGroupBy mode;
    private YesNo hideBounded;
    private final GuiScrollbar unselectedColumnScroll;
    private final GuiScrollbar toBindColumnScroll;
    private final GuiScrollbar targetColumnScroll;
    private final ArrayList<ItemStack> icons;
    private final ArrayList<baseUnit> unselected = new ArrayList();
    private final ArrayList<baseUnit> toBind = new ArrayList();
    private final ArrayList<baseUnit> target = new ArrayList();
    private baseUnit toRemoveFromUnselected;
    private baseUnit toAddToUnselected;
    private baseUnit toRemoveFromToBind;
    private baseUnit toAddToToBind;
    private baseUnit toRemoveFromTarget;
    private baseUnit toAddToTarget;
    private NBTTagCompound dataCache;

    public GuiSuperWirelessKit(InventoryPlayer inventoryPlayer, SuperWirelessKitObject te) {
        this(inventoryPlayer, te, new ContainerSuperWirelessKit(inventoryPlayer, te));
    }

    public GuiSuperWirelessKit(InventoryPlayer inventoryPlayer, SuperWirelessKitObject te, ContainerSuperWirelessKit c) {
        super(c);
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        ((ContainerSuperWirelessKit)this.field_147002_h).setGui(this);
        this.mode = (SuperWirelessToolGroupBy)this.configSrc.getSetting(Settings.SUPER_WIRELESS_TOOL_GROUP_BY);
        this.hideBounded = (YesNo)this.configSrc.getSetting(Settings.SUPER_WIRELESS_TOOL_HIDE_BOUNDED);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.unselectedColumnScroll = new GuiScrollbar();
        this.toBindColumnScroll = new GuiScrollbar();
        this.targetColumnScroll = new GuiScrollbar();
        this.icons = this.setIcons();
        for (int i = 0; i < 30; ++i) {
            this.nameField[i] = new MEGuiTextField(94, 12, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.namefield.desc")){

                @Override
                public void mouseClicked(int xPos, int yPos, int button) {
                    xPos = (xPos - GuiSuperWirelessKit.this.field_147003_i) * 2;
                    yPos = (yPos - GuiSuperWirelessKit.this.field_147009_r) * 2;
                    super.mouseClicked(xPos, yPos, button);
                }
            };
            if (i >= 20) {
                this.nameField[i].x = 380;
                this.nameField[i].y = ((i - 20) * 23 + 22) * 2;
                continue;
            }
            if (i >= 10) {
                this.nameField[i].x = 226;
                this.nameField[i].y = ((i - 10) * 23 + 22) * 2;
                continue;
            }
            this.nameField[i].x = 36;
            this.nameField[i].y = (i * 23 + 22) * 2;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setScrollBar();
        this.addButtons();
    }

    private ArrayList<ItemStack> setIcons() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 16; ++i) {
            ItemStack is = GameRegistry.findItemStack((String)"appliedenergistics2", (String)"tile.BlockWirelessConnector", (int)1);
            is.func_77964_b(i + 1);
            list.add(is);
        }
        ItemStack iss = GameRegistry.findItemStack((String)"appliedenergistics2", (String)"tile.BlockWirelessConnector", (int)1);
        list.add(iss);
        for (int i = 0; i < 16; ++i) {
            ItemStack is = GameRegistry.findItemStack((String)"appliedenergistics2", (String)"tile.BlockWirelessHub", (int)1);
            is.func_77964_b(i + 1);
            list.add(is);
        }
        ItemStack is = GameRegistry.findItemStack((String)"appliedenergistics2", (String)"tile.BlockWirelessHub", (int)1);
        list.add(is);
        return list;
    }

    private void setScrollBar() {
        this.unselectedColumnScroll.setTop(22).setLeft(67).setHeight(229);
        this.toBindColumnScroll.setTop(22).setLeft(162).setHeight(229);
        this.targetColumnScroll.setTop(22).setLeft(239).setHeight(229);
        this.unselectedColumnScroll.setRange(0, this.unselected.size() - 10, 1);
        this.toBindColumnScroll.setRange(0, this.toBind.size() - 10, 1);
        this.targetColumnScroll.setRange(0, this.target.size() - 10, 1);
    }

    protected void addButtons() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.colorButtons[i] = new GuiColorButton(0, this.field_147003_i + 81, this.field_147009_r + 22 + 8 + 9 * i, 8, 8, AEColor.values()[i], AEColor.values()[i].name());
            this.field_146292_n.add(this.colorButtons[i]);
        }
        for (i = 8; i < 16; ++i) {
            this.colorButtons[i] = new GuiColorButton(0, this.field_147003_i + 90, this.field_147009_r + 22 + 8 + 9 * (i - 8), 8, 8, AEColor.values()[i], AEColor.values()[i].name());
            this.field_146292_n.add(this.colorButtons[i]);
        }
        this.colorButtons[16] = new GuiColorButton(0, this.field_147003_i + 81, this.field_147009_r + 22 - 1, 8, 8, AEColor.values()[16], AEColor.values()[16].name());
        this.field_146292_n.add(this.colorButtons[16]);
        this.madChameleonButton = new GuiCheckBox(0.5, this.field_147003_i + 90, this.field_147009_r + 22 - 1, 125, 125, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.madchameleonrecolor.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.madchameleonrecolor.desc"));
        this.field_146292_n.add(this.madChameleonButton);
        for (i = 0; i < 10; ++i) {
            this.pinButtons[i] = new GuiCheckBox(0.25, this.field_147003_i + 232, this.field_147009_r + i * 23 + 22 + 6, 110, 126, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.pinbutton.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.pinbutton.desc"));
            this.pinButtons[i].field_146125_m = false;
            this.field_146292_n.add(this.pinButtons[i]);
        }
        for (i = 0; i < 30; ++i) {
            int y;
            int x;
            if (i >= 20) {
                x = this.field_147003_i + 232;
                y = this.field_147009_r + (i - 20) * 23 + 22 + 17;
            } else if (i >= 10) {
                x = this.field_147003_i + 155;
                y = this.field_147009_r + (i - 10) * 23 + 22 + 17;
            } else {
                x = this.field_147003_i + 60;
                y = this.field_147009_r + i * 23 + 22 + 17;
            }
            this.includeHubsButtons[i] = new GuiCheckBox(0.25, x, y, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.includehubs.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.includehubs.desc"));
            this.includeConnectorsButtons[i] = new GuiCheckBox(0.25, x - 5, y, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.includeconnectors.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.includeconnectors.desc"));
            this.deleteButtons[i] = new GuiCheckBox(0.25, x - 55, y - 17, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.delete.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.delete.desc"));
            this.includeConnectorsButtons[i].field_146125_m = false;
            this.includeHubsButtons[i].field_146125_m = false;
            this.deleteButtons[i].field_146125_m = false;
            this.field_146292_n.add(this.includeHubsButtons[i]);
            this.field_146292_n.add(this.includeConnectorsButtons[i]);
            this.field_146292_n.add(this.deleteButtons[i]);
        }
        this.bind = new GuiAeButton(0, this.field_147003_i + 131, this.field_147009_r + 4, 44, 16, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.bind.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.bind.desc"));
        this.unbind = new GuiAeButton(0, this.field_147003_i + 81, this.field_147009_r + 4, 44, 16, StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.unbind.name"), StatCollector.func_74838_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.unbind.desc"));
        this.sortBy = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + 4, Settings.SUPER_WIRELESS_TOOL_GROUP_BY, SuperWirelessToolGroupBy.Single);
        this.hideBoundedButton = new GuiImgButton(this.field_147003_i + 24, this.field_147009_r + 4, Settings.SUPER_WIRELESS_TOOL_HIDE_BOUNDED, YesNo.NO);
        this.field_146292_n.add(this.bind);
        this.field_146292_n.add(this.unbind);
        this.field_146292_n.add(this.sortBy);
        this.field_146292_n.add(this.hideBoundedButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        for (baseUnit bs : this.unselected) {
            if (!bs.keyTyped(typedChar, keyCode)) continue;
            return;
        }
        for (baseUnit bs : this.toBind) {
            if (!bs.keyTyped(typedChar, keyCode)) continue;
            return;
        }
        for (baseUnit bs : this.target) {
            if (!bs.keyTyped(typedChar, keyCode)) continue;
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton btn) {
        boolean backwards;
        super.func_146284_a(btn);
        if (btn == this.sortBy) {
            backwards = Mouse.isButtonDown((int)1);
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.sortBy.getSetting(), backwards));
        } else if (btn == this.hideBoundedButton) {
            backwards = Mouse.isButtonDown((int)1);
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.hideBoundedButton.getSetting(), backwards));
        } else if (btn == this.madChameleonButton) {
            this.reColorCommand(null);
        } else if (btn == this.bind) {
            this.sendCommand("bind", null);
        } else if (btn == this.unbind) {
            this.sendCommand("unbind", null);
        }
        for (GuiColorButton colorButton : this.colorButtons) {
            if (btn != colorButton) continue;
            this.reColorCommand(colorButton.getColor());
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (this.unselectedColumnScroll != null) {
            this.unselectedColumnScroll.click(this, xCoord - this.field_147003_i, yCoord - this.field_147009_r);
        }
        if (this.toBindColumnScroll != null) {
            this.toBindColumnScroll.click(this, xCoord - this.field_147003_i, yCoord - this.field_147009_r);
        }
        if (this.targetColumnScroll != null) {
            this.targetColumnScroll.click(this, xCoord - this.field_147003_i, yCoord - this.field_147009_r);
        }
        for (baseUnit bs : this.unselected) {
            bs.mouseClicked(xCoord, yCoord, btn);
        }
        for (baseUnit bs : this.toBind) {
            bs.mouseClicked(xCoord, yCoord, btn);
        }
        for (baseUnit bs : this.target) {
            bs.mouseClicked(xCoord, yCoord, btn);
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    @Override
    protected void func_146273_a(int x, int y, int c, long d) {
        if (this.unselectedColumnScroll != null) {
            this.unselectedColumnScroll.clickMove(y - this.field_147009_r);
        }
        if (this.toBindColumnScroll != null) {
            this.toBindColumnScroll.clickMove(y - this.field_147009_r);
        }
        if (this.targetColumnScroll != null) {
            this.targetColumnScroll.clickMove(y - this.field_147009_r);
        }
        super.func_146273_a(x, y, c, d);
    }

    @Override
    public void func_146274_d() {
        int y;
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel == 0) {
            return;
        }
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        if (MinecraftForge.EVENT_BUS.post((Event)new GuiScrollEvent(this, x, y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1, wheel))) {
            return;
        }
        if (!this.mouseWheelEvent(x, y, wheel)) {
            GuiScrollbar scrollBar;
            if (this.unselectedColumnScroll != null && x > this.field_147003_i + 3 && x < this.field_147003_i + 79 && y > this.field_147009_r + 22) {
                scrollBar = this.unselectedColumnScroll;
                if (x > this.field_147003_i && y - this.field_147009_r > scrollBar.getTop() && x <= this.field_147003_i + this.field_146999_f && y - this.field_147009_r <= scrollBar.getTop() + scrollBar.getHeight()) {
                    this.unselectedColumnScroll.wheel(wheel);
                }
            }
            if (this.toBindColumnScroll != null && x > this.field_147003_i + 98 && x < this.field_147003_i + 174 && y > this.field_147009_r + 22) {
                scrollBar = this.toBindColumnScroll;
                if (x > this.field_147003_i && y - this.field_147009_r > scrollBar.getTop() && x <= this.field_147003_i + this.field_146999_f && y - this.field_147009_r <= scrollBar.getTop() + scrollBar.getHeight()) {
                    this.toBindColumnScroll.wheel(wheel);
                }
            }
            if (this.targetColumnScroll != null && x > this.field_147003_i + 175 && x < this.field_147003_i + 251 && y > this.field_147009_r + 22) {
                scrollBar = this.targetColumnScroll;
                if (x > this.field_147003_i && y - this.field_147009_r > scrollBar.getTop() && x <= this.field_147003_i + this.field_146999_f && y - this.field_147009_r <= scrollBar.getTop() + scrollBar.getHeight()) {
                    this.targetColumnScroll.wheel(wheel);
                }
            }
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.unselectedColumnScroll.draw(this);
        this.toBindColumnScroll.draw(this);
        this.targetColumnScroll.draw(this);
        this.reset();
        this.drawUnselected();
        this.drawToBind();
        this.drawTarget();
    }

    private void reset() {
        for (int i = 0; i < 30; ++i) {
            this.includeConnectorsButtons[i].field_146125_m = false;
            this.includeHubsButtons[i].field_146125_m = false;
            this.deleteButtons[i].field_146125_m = false;
            if (i >= 10) continue;
            this.pinButtons[i].field_146125_m = false;
        }
        for (baseUnit bu : this.unselected) {
            bu.isVisible = false;
        }
        for (baseUnit bu : this.toBind) {
            bu.isVisible = false;
        }
        for (baseUnit bu : this.target) {
            bu.isVisible = false;
        }
    }

    private void drawUnselected() {
        int viewStart = this.unselectedColumnScroll.getCurrentScroll();
        int viewEnd = viewStart + 10;
        int y = 0;
        for (int z = viewStart; z < Math.min(viewEnd, this.unselected.size()); ++z) {
            this.unselected.get(z).setXY(5, y, 0);
            this.unselected.get(z).draw();
            ++y;
        }
        if (this.toRemoveFromUnselected != null) {
            this.unselected.remove(this.toRemoveFromUnselected);
            this.toRemoveFromUnselected = null;
            this.setScrollBar();
        }
        if (this.toAddToUnselected != null) {
            this.unselected.add(this.toAddToUnselected);
            this.toAddToUnselected = null;
            this.setScrollBar();
        }
    }

    private void drawToBind() {
        int viewStart = this.toBindColumnScroll.getCurrentScroll();
        int viewEnd = viewStart + 10;
        int y = 0;
        for (int z = viewStart; z < Math.min(viewEnd, this.toBind.size()); ++z) {
            this.toBind.get(z).setXY(100, y, 1);
            this.toBind.get(z).draw();
            ++y;
        }
        if (this.toRemoveFromToBind != null) {
            this.toBind.remove(this.toRemoveFromToBind);
            this.toRemoveFromToBind = null;
            this.setScrollBar();
        }
        if (this.toAddToToBind != null) {
            this.toBind.add(this.toAddToToBind);
            this.toAddToToBind = null;
            this.setScrollBar();
        }
    }

    private void drawTarget() {
        int viewStart = this.targetColumnScroll.getCurrentScroll();
        int viewEnd = viewStart + 10;
        int y = 0;
        for (int z = viewStart; z < Math.min(viewEnd, this.target.size()); ++z) {
            this.target.get(z).setXY(177, y, 2);
            this.target.get(z).draw();
            ++y;
        }
        if (this.toRemoveFromTarget != null) {
            this.target.remove(this.toRemoveFromTarget);
            this.toRemoveFromTarget = null;
            this.setScrollBar();
        }
        if (this.toAddToTarget != null) {
            this.target.add(this.toAddToTarget);
            this.toAddToTarget = null;
            this.setScrollBar();
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/superwirelesskit.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.sortBy != null) {
            this.sortBy.set(this.configSrc.getSetting(Settings.SUPER_WIRELESS_TOOL_GROUP_BY));
            this.mode = (SuperWirelessToolGroupBy)this.configSrc.getSetting(Settings.SUPER_WIRELESS_TOOL_GROUP_BY);
            this.hideBoundedButton.set(this.configSrc.getSetting(Settings.SUPER_WIRELESS_TOOL_HIDE_BOUNDED));
            this.hideBounded = (YesNo)this.configSrc.getSetting(Settings.SUPER_WIRELESS_TOOL_HIDE_BOUNDED);
        }
        if (this.dataCache != null) {
            this.setData(this.dataCache);
        }
    }

    private void reColorCommand(AEColor color) {
        NBTTagList tagList = new NBTTagList();
        ArrayList<DimensionalCoord> dc = new ArrayList<DimensionalCoord>();
        for (baseUnit bu : this.toBind) {
            if (bu instanceof groupUnit) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("network", bu.data.network);
                if (bu.byColor) {
                    tag.func_74768_a("color", bu.data.color.ordinal());
                }
                tagList.func_74742_a((NBTBase)tag);
                continue;
            }
            dc.add(bu.data.cord);
        }
        NBTTagCompound cords = new NBTTagCompound();
        DimensionalCoord.writeListToNBT(cords, dc);
        NBTTagCompound command = new NBTTagCompound();
        command.func_74778_a("command", "recolor");
        command.func_74782_a("cords", (NBTBase)cords);
        command.func_74782_a("group", (NBTBase)tagList);
        command.func_74768_a("color", color == null ? -1 : color.ordinal());
        try {
            NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(command));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendCommand(String command, baseUnit bu) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("command", command);
        switch (command) {
            case "renameSingle": {
                String name = this.nameField[bu.totalPos].getText();
                tag.func_74778_a("name", name);
                NBTTagCompound pos = new NBTTagCompound();
                bu.data.cord.writeToNBT(pos);
                tag.func_74782_a("cord", (NBTBase)pos);
                try {
                    NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(tag));
                    bu.data.customName = name;
                }
                catch (IOException iOException) {}
                break;
            }
            case "renameGroup": {
                String name = this.nameField[bu.totalPos].getText();
                tag.func_74768_a("network", bu.data.network);
                tag.func_74778_a("name", name);
                if (bu.byColor) {
                    tag.func_74768_a("color", bu.data.color.ordinal());
                }
                try {
                    NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(tag));
                    bu.data.customName = name;
                }
                catch (IOException pos) {}
                break;
            }
            case "pin": {
                tag.func_74757_a("pin", bu.isPinned);
                tag.func_74768_a("network", bu.data.network);
                if (bu instanceof groupUnit) {
                    groupUnit gu = (groupUnit)bu;
                    if (bu.byColor) {
                        tag.func_74768_a("color", bu.data.color.ordinal());
                        tag.func_74778_a("type", "color");
                    } else {
                        tag.func_74778_a("type", "network");
                    }
                    if (!gu.includeConnectors) {
                        tag.func_74757_a("incCon", false);
                    }
                    if (!gu.includeHubs) {
                        tag.func_74757_a("incHub", false);
                    }
                } else {
                    NBTTagCompound cord = new NBTTagCompound();
                    bu.data.cord.writeToNBT(cord);
                    tag.func_74782_a("cord", (NBTBase)cord);
                    tag.func_74778_a("type", "single");
                }
                try {
                    NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(tag));
                }
                catch (IOException gu) {}
                break;
            }
            case "delete": {
                tag.func_74768_a("network", bu.data.network);
                try {
                    NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(tag));
                }
                catch (IOException gu) {}
                break;
            }
            case "bind": {
                NBTTagList tagListToBind = new NBTTagList();
                for (baseUnit baseUnit2 : this.toBind) {
                    NBTTagCompound tagToBind = new NBTTagCompound();
                    if (baseUnit2 instanceof groupUnit) {
                        groupUnit gu = (groupUnit)baseUnit2;
                        tagToBind.func_74768_a("network", gu.data.network);
                        if (!gu.includeConnectors) {
                            tagToBind.func_74757_a("incCon", false);
                        }
                        if (!gu.includeHubs) {
                            tagToBind.func_74757_a("incHub", false);
                        }
                        if (gu.byColor) {
                            tagToBind.func_74768_a("color", gu.data.color.ordinal());
                        }
                    } else {
                        NBTTagCompound cord = new NBTTagCompound();
                        baseUnit2.data.cord.writeToNBT(cord);
                        tagToBind.func_74782_a("cord", (NBTBase)cord);
                    }
                    tagListToBind.func_74742_a((NBTBase)tagToBind);
                }
                tag.func_74782_a("toBind", (NBTBase)tagListToBind);
                NBTTagList tagListTarget = new NBTTagList();
                for (baseUnit but : this.target) {
                    NBTTagCompound tagTarget = new NBTTagCompound();
                    if (but instanceof groupUnit) {
                        groupUnit gu = (groupUnit)but;
                        tagTarget.func_74768_a("network", gu.data.network);
                        if (!gu.includeConnectors) {
                            tagTarget.func_74757_a("incCon", false);
                        }
                        if (!gu.includeHubs) {
                            tagTarget.func_74757_a("incHub", false);
                        }
                        if (gu.byColor) {
                            tagTarget.func_74768_a("color", gu.data.color.ordinal());
                        }
                    } else {
                        but.data.cord.writeToNBT(tagTarget);
                    }
                    tagListTarget.func_74742_a((NBTBase)tagTarget);
                }
                tag.func_74782_a("target", (NBTBase)tagListTarget);
                try {
                    NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(tag));
                }
                catch (IOException iOException) {}
                break;
            }
            case "unbind": {
                NBTTagList tagListToBind = new NBTTagList();
                for (baseUnit baseUnit3 : this.toBind) {
                    NBTTagCompound tagToBind = new NBTTagCompound();
                    if (baseUnit3 instanceof groupUnit) {
                        groupUnit gu = (groupUnit)baseUnit3;
                        tagToBind.func_74768_a("network", gu.data.network);
                        if (!gu.includeConnectors) {
                            tagToBind.func_74757_a("incCon", false);
                        }
                        if (!gu.includeHubs) {
                            tagToBind.func_74757_a("incHub", false);
                        }
                        if (gu.byColor) {
                            tagToBind.func_74768_a("color", gu.data.color.ordinal());
                        }
                    } else {
                        NBTTagCompound cord = new NBTTagCompound();
                        baseUnit3.data.cord.writeToNBT(cord);
                        tagToBind.func_74782_a("cord", (NBTBase)cord);
                    }
                    tagListToBind.func_74742_a((NBTBase)tagToBind);
                }
                tag.func_74782_a("toBind", (NBTBase)tagListToBind);
                try {
                    NetworkHandler.instance.sendToServer(new PacketSuperWirelessToolCommand(tag));
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }

    private groupUnit getNetworkUnitFormResolver(ArrayList<groupUnit> list, int network, AEColor color, boolean isPin) {
        for (groupUnit gu : list) {
            if (gu.data.network != network || gu.isPinned != isPin) continue;
            if (color == null) {
                return gu;
            }
            if (!gu.byColor || gu.data.color != color) continue;
            return gu;
        }
        return null;
    }

    public void setData(NBTTagCompound newData) {
        this.dataCache = (NBTTagCompound)newData.func_74737_b();
        ArrayList<SuperWirelessToolDataObject> data = SuperWirelessToolDataObject.readFromNBTasList(newData);
        this.unselected.clear();
        this.toBind.clear();
        this.target.clear();
        ArrayList<groupUnit> networkGroupResolver = new ArrayList<groupUnit>();
        NBTTagList names = newData.func_150295_c("names", 10);
        int[] namesNetworkCache = new int[names.func_74745_c()];
        String[] networkNameCache = new String[names.func_74745_c()];
        boolean[] isByColor = new boolean[names.func_74745_c()];
        AEColor[] namesColorCache = new AEColor[names.func_74745_c()];
        String[] colorNameCache = new String[names.func_74745_c()];
        for (int i = 0; i < names.func_74745_c(); ++i) {
            NBTTagCompound tag = names.func_150305_b(i);
            namesNetworkCache[i] = tag.func_74762_e("network");
            networkNameCache[i] = tag.func_74779_i("networkName");
            isByColor[i] = tag.func_74764_b("color");
            namesColorCache[i] = AEColor.values()[tag.func_74762_e("color")];
            colorNameCache[i] = tag.func_74779_i("colorName");
        }
        NBTTagList pins = newData.func_150295_c("pins", 10);
        int[] networkIdCache = new int[pins.func_74745_c()];
        AEColor[] colorCache = new AEColor[pins.func_74745_c()];
        String[] type = new String[pins.func_74745_c()];
        DimensionalCoord[] cord = new DimensionalCoord[pins.func_74745_c()];
        boolean[] includeConnectorsCache = new boolean[pins.func_74745_c()];
        boolean[] includeHubsCache = new boolean[pins.func_74745_c()];
        for (int i = 0; i < pins.func_74745_c(); ++i) {
            NBTTagCompound tag = pins.func_150305_b(i);
            networkIdCache[i] = tag.func_74762_e("network");
            colorCache[i] = AEColor.values()[tag.func_74762_e("color")];
            type[i] = tag.func_74779_i("type");
            cord[i] = DimensionalCoord.readFromNBT(tag.func_74775_l("cord"));
            includeConnectorsCache[i] = !tag.func_74764_b("incCon");
            includeHubsCache[i] = !tag.func_74764_b("incHub");
        }
        for (SuperWirelessToolDataObject wdo : data) {
            groupUnit newUnit;
            int i;
            boolean isPinned = false;
            boolean isGroup = false;
            boolean isSameColor = false;
            boolean includeConnectors = true;
            boolean includeHubs = true;
            String networkName = "";
            String colorName = "";
            if (this.hideBounded == YesNo.YES && wdo.isConnected && (!wdo.isHub || wdo.slots == 0)) continue;
            for (i = 0; i < names.func_74745_c(); ++i) {
                if (wdo.network != namesNetworkCache[i]) continue;
                if (isByColor[i]) {
                    if (wdo.color != namesColorCache[i]) continue;
                    colorName = colorNameCache[i];
                    continue;
                }
                networkName = networkNameCache[i];
            }
            for (i = 0; i < pins.func_74745_c(); ++i) {
                if (wdo.network != networkIdCache[i]) continue;
                switch (type[i]) {
                    case "single": {
                        if (!wdo.cord.isEqual(cord[i])) break;
                        isPinned = true;
                        break;
                    }
                    case "network": {
                        isPinned = true;
                        isGroup = true;
                        break;
                    }
                    case "color": {
                        if (wdo.color != colorCache[i]) break;
                        isSameColor = true;
                        isPinned = true;
                        isGroup = true;
                        break;
                    }
                }
                if (!isPinned) continue;
                includeConnectors = includeConnectorsCache[i];
                includeHubs = includeHubsCache[i];
                break;
            }
            if (isPinned) {
                if (isGroup) {
                    if (isSameColor) {
                        groupUnit gu = this.getNetworkUnitFormResolver(networkGroupResolver, wdo.network, wdo.color, true);
                        if (gu == null) {
                            newUnit = new groupUnit(wdo, networkName, true, colorName, includeConnectors, includeHubs, true);
                            networkGroupResolver.add(newUnit);
                            this.target.add(newUnit);
                            continue;
                        }
                        gu.addToGroup(wdo);
                        continue;
                    }
                    groupUnit gu = this.getNetworkUnitFormResolver(networkGroupResolver, wdo.network, null, true);
                    if (gu != null) {
                        gu.addToGroup(wdo);
                        continue;
                    }
                    newUnit = new groupUnit(wdo, networkName, false, includeConnectors, includeHubs, true);
                    networkGroupResolver.add(newUnit);
                    this.target.add(newUnit);
                    continue;
                }
                this.target.add(new singleUnit(wdo, networkName));
                continue;
            }
            if (this.mode == SuperWirelessToolGroupBy.Single) {
                this.unselected.add(new singleUnit(wdo, networkName));
                continue;
            }
            if (this.mode == SuperWirelessToolGroupBy.Network) {
                groupUnit gu = this.getNetworkUnitFormResolver(networkGroupResolver, wdo.network, null, false);
                if (gu != null) {
                    gu.addToGroup(wdo);
                    continue;
                }
                newUnit = new groupUnit(wdo, networkName);
                networkGroupResolver.add(newUnit);
                this.unselected.add(newUnit);
                continue;
            }
            groupUnit gu = this.getNetworkUnitFormResolver(networkGroupResolver, wdo.network, wdo.color, false);
            if (gu != null) {
                gu.addToGroup(wdo);
                continue;
            }
            newUnit = new groupUnit(wdo, networkName, true, colorName);
            networkGroupResolver.add(newUnit);
            this.unselected.add(newUnit);
        }
        this.setScrollBar();
    }

    private class baseUnit {
        protected final int w = 60;
        protected final int h = 22;
        protected final int offY = 23;
        protected int x = 0;
        protected int y = 0;
        protected int xo = 0;
        protected int yo = 0;
        protected int totalPos = 0;
        protected final SuperWirelessToolDataObject data;
        protected boolean inToBind = false;
        protected boolean inTarget = false;
        protected boolean isPinned = false;
        protected String customNetworkName = "";
        protected boolean isVisible = false;
        protected boolean byColor = false;

        baseUnit(SuperWirelessToolDataObject data, String customNetworkName) {
            this.data = data;
            this.customNetworkName = customNetworkName;
        }

        public void setXY(int x, int y, int column) {
            this.x = GuiSuperWirelessKit.this.field_147003_i + x;
            this.y = GuiSuperWirelessKit.this.field_147009_r + y * 23 + 22;
            this.xo = x;
            this.yo = y;
            this.totalPos = y + column * 10;
            this.isVisible = true;
        }

        protected void handleButtons() {
            if (this.totalPos > 19 && this.data.isHub) {
                ((GuiSuperWirelessKit)GuiSuperWirelessKit.this).pinButtons[this.yo].field_146125_m = true;
                GuiSuperWirelessKit.this.pinButtons[this.yo].setState(this.isPinned);
            }
        }

        public void draw() {
            this.handleButtons();
        }

        public void drawTextBox() {
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GuiSuperWirelessKit.this.nameField[this.totalPos].drawTextBox();
            if (!GuiSuperWirelessKit.this.nameField[this.totalPos].isFocused()) {
                GuiSuperWirelessKit.this.nameField[this.totalPos].setText(this.data.customName);
            }
            GL11.glPopMatrix();
        }

        public void drawNetworkName(int descPosX, int posY) {
            GL11.glPushMatrix();
            GL11.glScaled((double)0.333, (double)0.333, (double)0.333);
            GuiSuperWirelessKit.this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.network", (Object[])new Object[]{!Objects.equals(this.customNetworkName, "") ? this.customNetworkName : String.valueOf(this.data.network)}), descPosX, posY * 3 + 18, GuiColors.CraftingCPUStored.getColor());
            GL11.glPopMatrix();
        }

        public void drawSlotsIndicator(String str, int posY, int indicatorColor) {
            Gui.func_73734_a((int)this.xo, (int)(posY + 15), (int)(this.xo + 14), (int)(posY + 20), (int)(indicatorColor - 0x1000000));
            GL11.glPushMatrix();
            GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
            GuiSuperWirelessKit.this.field_146289_q.func_78276_b(str, (this.xo + 7) * 4 - GuiSuperWirelessKit.this.field_146289_q.func_78256_a(str) / 2, posY * 4 + 66, GuiColors.CraftingCPUStored.getColor());
            GL11.glPopMatrix();
        }

        protected void renameCommand() {
        }

        public boolean keyTyped(char typedChar, int keyCode) {
            if (!this.isVisible) {
                return false;
            }
            boolean isFocused = GuiSuperWirelessKit.this.nameField[this.totalPos].isFocused();
            if (GuiSuperWirelessKit.this.nameField[this.totalPos].textboxKeyTyped(typedChar, keyCode)) {
                return true;
            }
            if (isFocused && keyCode == 28 || keyCode == 156) {
                this.renameCommand();
                return true;
            }
            return false;
        }

        public void mouseClicked(int xPos, int yPos, int button) {
            if (this.isMouseIn(xPos, yPos)) {
                if (Keyboard.isKeyDown((int)42)) {
                    BlockPosHighlighter.highlightBlocks((EntityPlayer)GuiSuperWirelessKit.this.field_146297_k.field_71439_g, this.data.targetCord == null ? Collections.singletonList(this.data.cord) : new ArrayList<DimensionalCoord>(Arrays.asList(this.data.cord, this.data.targetCord)), PlayerMessages.InterfaceHighlighted.getName(), PlayerMessages.InterfaceInOtherDim.getName());
                    GuiSuperWirelessKit.this.field_146297_k.field_71439_g.func_71053_j();
                    return;
                }
                GuiSuperWirelessKit.this.nameField[this.totalPos].mouseClicked(xPos, yPos, button);
                if (!GuiSuperWirelessKit.this.nameField[this.totalPos].isMouseIn((xPos - GuiSuperWirelessKit.this.field_147003_i) * 2, (yPos - GuiSuperWirelessKit.this.field_147009_r) * 2)) {
                    if (GuiSuperWirelessKit.this.pinButtons[this.yo].func_146116_c(null, xPos, yPos)) {
                        this.isPinned ^= true;
                        GuiSuperWirelessKit.this.sendCommand("pin", this);
                    } else if (!this.isPinned) {
                        if (this.inToBind) {
                            GuiSuperWirelessKit.this.toRemoveFromToBind = this;
                            this.inToBind = false;
                            if (button == 0) {
                                GuiSuperWirelessKit.this.toAddToUnselected = this;
                            } else if (button == 1) {
                                GuiSuperWirelessKit.this.toAddToTarget = this;
                                this.inTarget = true;
                            }
                        } else if (this.inTarget) {
                            GuiSuperWirelessKit.this.toRemoveFromTarget = this;
                            this.inTarget = false;
                            if (button == 0) {
                                GuiSuperWirelessKit.this.toAddToToBind = this;
                                this.inToBind = true;
                            } else if (button == 1) {
                                GuiSuperWirelessKit.this.toAddToUnselected = this;
                            }
                        } else if (button == 0) {
                            GuiSuperWirelessKit.this.toRemoveFromUnselected = this;
                            GuiSuperWirelessKit.this.toAddToToBind = this;
                            this.inToBind = true;
                        } else if (button == 1) {
                            GuiSuperWirelessKit.this.toRemoveFromUnselected = this;
                            GuiSuperWirelessKit.this.toAddToTarget = this;
                            this.inTarget = true;
                        }
                    }
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public boolean isMouseIn(int xCoord, int yCoord) {
            if (!this.isVisible) {
                return false;
            }
            v0 = withinXRange = this.x <= xCoord && xCoord < this.x + this.w;
            if (this.y > yCoord) ** GOTO lbl-1000
            Objects.requireNonNull(this);
            if (yCoord < this.y + 22) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            withinYRange = v1;
            return withinXRange != false && withinYRange != false;
        }
    }

    private class groupUnit
    extends baseUnit {
        private final ArrayList<SuperWirelessToolDataObject> wsList;
        private final ArrayList<DimensionalCoord> cordList;
        private boolean includeHubs;
        private boolean includeConnectors;
        private int channels;
        private int slots;
        private int usedSlots;
        private String customColorName;

        groupUnit(SuperWirelessToolDataObject data, String customNetworkName) {
            this(data, customNetworkName, false, true, true, false);
        }

        groupUnit(SuperWirelessToolDataObject data, String customNetworkName, boolean byColor, String customColorName) {
            this(data, customNetworkName, byColor, true, true, false);
            data.customName = Objects.equals(customColorName, "") ? data.color.name() : customColorName;
            this.customColorName = customColorName;
        }

        groupUnit(SuperWirelessToolDataObject data, String customNetworkName, boolean byColor, String customColorName, boolean includeConnectors, boolean includeHubs, boolean isPinned) {
            this(data, customNetworkName, byColor, includeConnectors, includeHubs, isPinned);
            data.customName = Objects.equals(customColorName, "") ? data.color.name() : customColorName;
            this.customColorName = customColorName;
        }

        groupUnit(SuperWirelessToolDataObject data, String customNetworkName, boolean byColor, boolean includeConnectors, boolean includeHubs, boolean isPinned) {
            super(data, customNetworkName);
            this.wsList = new ArrayList();
            this.cordList = new ArrayList();
            this.customColorName = "";
            this.byColor = byColor;
            this.wsList.add(data);
            this.includeHubs = includeHubs;
            this.includeConnectors = includeConnectors;
            this.isPinned = isPinned;
            if (includeConnectors && !data.isHub) {
                this.cordList.add(data.cord);
                this.channels = data.channels;
                this.slots = 1;
                this.usedSlots = 1 - data.slots;
            }
            if (includeHubs && data.isHub) {
                this.cordList.add(data.cord);
                this.channels = data.channels;
                this.slots = 32;
                this.usedSlots = 32 - data.slots;
            }
            if (!byColor) {
                data.customName = !Objects.equals(customNetworkName, "") ? customNetworkName : String.valueOf(data.network);
            }
        }

        public void addToGroup(SuperWirelessToolDataObject data) {
            this.wsList.add(data);
            if (this.includeConnectors && !data.isHub) {
                this.cordList.add(data.cord);
                this.channels += data.channels;
                ++this.slots;
                this.usedSlots += 1 - data.slots;
            }
            if (this.includeHubs && data.isHub) {
                this.cordList.add(data.cord);
                this.channels += data.channels;
                this.slots += 32;
                this.usedSlots += 32 - data.slots;
            }
        }

        private void reCalc() {
            this.cordList.clear();
            this.channels = 0;
            this.slots = 0;
            this.usedSlots = 0;
            for (SuperWirelessToolDataObject s : this.wsList) {
                if (this.includeConnectors && !s.isHub) {
                    this.cordList.add(s.cord);
                    this.channels += s.channels;
                    ++this.slots;
                    this.usedSlots += 1 - s.slots;
                }
                if (!this.includeHubs || !s.isHub) continue;
                this.cordList.add(s.cord);
                this.channels += s.channels;
                this.slots += 32;
                this.usedSlots += 32 - s.slots;
            }
        }

        @Override
        protected void handleButtons() {
            if (this.totalPos > 19) {
                ((GuiSuperWirelessKit)GuiSuperWirelessKit.this).pinButtons[this.yo].field_146125_m = true;
                GuiSuperWirelessKit.this.pinButtons[this.yo].setState(this.isPinned);
            }
            if (!this.byColor) {
                ((GuiSuperWirelessKit)GuiSuperWirelessKit.this).deleteButtons[this.totalPos].field_146125_m = true;
            }
            ((GuiSuperWirelessKit)GuiSuperWirelessKit.this).includeConnectorsButtons[this.totalPos].field_146125_m = true;
            GuiSuperWirelessKit.this.includeConnectorsButtons[this.totalPos].setState(this.includeConnectors);
            ((GuiSuperWirelessKit)GuiSuperWirelessKit.this).includeHubsButtons[this.totalPos].field_146125_m = true;
            GuiSuperWirelessKit.this.includeHubsButtons[this.totalPos].setState(this.includeHubs);
        }

        @Override
        protected void renameCommand() {
            GuiSuperWirelessKit.this.sendCommand("renameGroup", this);
        }

        @Override
        public void draw() {
            int offY = 23;
            int posY = this.yo * 23 + 22;
            int descPosX = this.xo * 3 + 46;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.45, (double)0.45, (double)0.45);
            if (this.byColor) {
                if (this.includeHubs) {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 7, (int)Math.round((double)posY / 0.45) + 2, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.color.ordinal() + 17));
                } else {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 7, (int)Math.round((double)posY / 0.45) + 2, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.color.ordinal()));
                }
                if (this.includeConnectors) {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 0, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.color.ordinal()));
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 14, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.color.ordinal()));
                } else {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 0, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.color.ordinal() + 17));
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 14, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.color.ordinal() + 17));
                }
            } else {
                if (this.includeHubs) {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 7, (int)Math.round((double)posY / 0.45) + 2, (ItemStack)GuiSuperWirelessKit.this.icons.get(17));
                } else {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 7, (int)Math.round((double)posY / 0.45) + 2, (ItemStack)GuiSuperWirelessKit.this.icons.get(0));
                }
                if (this.includeConnectors) {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 0, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(1));
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 14, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(2));
                } else {
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 0, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(18));
                    GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.45) + 14, (int)Math.round((double)posY / 0.45) + 14, (ItemStack)GuiSuperWirelessKit.this.icons.get(19));
                }
            }
            GL11.glPopMatrix();
            this.drawTextBox();
            this.drawNetworkName(descPosX, posY);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.333, (double)0.333, (double)0.333);
            if (this.byColor) {
                GuiSuperWirelessKit.this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.color", (Object[])new Object[]{!Objects.equals(this.customColorName, "") ? this.customColorName : this.data.color.toString()}), descPosX, posY * 3 + 28, GuiColors.CraftingCPUStored.getColor());
            }
            GuiSuperWirelessKit.this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.channelsUsage", (Object[])new Object[]{this.channels}), descPosX, posY * 3 + 38, GuiColors.CraftingCPUStored.getColor());
            GL11.glPopMatrix();
            int indicatorColor = AEColor.Lime.mediumVariant;
            String str = this.usedSlots + "/" + this.slots;
            if (this.usedSlots > 0) {
                indicatorColor = this.slots == this.usedSlots ? AEColor.Red.mediumVariant : AEColor.Orange.mediumVariant;
            }
            this.drawSlotsIndicator(str, posY, indicatorColor);
            super.draw();
        }

        @Override
        public void mouseClicked(int xPos, int yPos, int button) {
            if (this.isMouseIn(xPos, yPos)) {
                if (Keyboard.isKeyDown((int)42)) {
                    BlockPosHighlighter.highlightBlocks((EntityPlayer)GuiSuperWirelessKit.this.field_146297_k.field_71439_g, this.cordList, PlayerMessages.InterfaceHighlighted.getName(), PlayerMessages.InterfaceInOtherDim.getName());
                    GuiSuperWirelessKit.this.field_146297_k.field_71439_g.func_71053_j();
                } else if (GuiSuperWirelessKit.this.includeConnectorsButtons[this.totalPos].func_146116_c(null, xPos, yPos)) {
                    this.includeConnectors ^= true;
                    if (!this.includeConnectors && !this.includeHubs) {
                        this.includeHubs = true;
                    }
                    this.reCalc();
                    if (this.isPinned) {
                        GuiSuperWirelessKit.this.sendCommand("pin", this);
                    }
                } else if (GuiSuperWirelessKit.this.includeHubsButtons[this.totalPos].func_146116_c(null, xPos, yPos)) {
                    this.includeHubs ^= true;
                    if (!this.includeConnectors && !this.includeHubs) {
                        this.includeConnectors = true;
                    }
                    this.reCalc();
                    if (this.isPinned) {
                        GuiSuperWirelessKit.this.sendCommand("pin", this);
                    }
                } else if (GuiSuperWirelessKit.this.deleteButtons[this.totalPos].func_146116_c(null, xPos, yPos)) {
                    GuiSuperWirelessKit.this.sendCommand("delete", this);
                } else {
                    super.mouseClicked(xPos, yPos, button);
                }
            }
        }
    }

    private class singleUnit
    extends baseUnit {
        singleUnit(SuperWirelessToolDataObject data, String customNetworkName) {
            super(data, customNetworkName);
        }

        @Override
        public void draw() {
            String str;
            int posY = this.yo * 23 + 22;
            int descPosX = this.xo * 3 + 46;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.7666, (double)0.7666, (double)0.7666);
            GuiSuperWirelessKit.this.drawItem((int)Math.round((double)this.xo / 0.7666) + 1, this.yo * (int)Math.round(30.002608922515) + 22 + 9, (ItemStack)GuiSuperWirelessKit.this.icons.get(this.data.isHub ? this.data.color.ordinal() + 17 : this.data.color.ordinal()));
            GL11.glPopMatrix();
            this.drawTextBox();
            this.drawNetworkName(descPosX, posY);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.333, (double)0.333, (double)0.333);
            GuiSuperWirelessKit.this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.color", (Object[])new Object[]{this.data.color.toString()}), descPosX, posY * 3 + 28, GuiColors.CraftingCPUStored.getColor());
            GuiSuperWirelessKit.this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.selfpos", (Object[])new Object[]{String.valueOf(this.data.cord.x), String.valueOf(this.data.cord.y), String.valueOf(this.data.cord.z)}), descPosX, posY * 3 + 38, GuiColors.CraftingCPUStored.getColor());
            if (this.data.isConnected) {
                GuiSuperWirelessKit.this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"gui.appliedenergistics2.GuiSuperWirelessKit.targetpos", (Object[])new Object[]{String.valueOf(this.data.targetCord.x), String.valueOf(this.data.targetCord.y), String.valueOf(this.data.targetCord.z)}), descPosX, posY * 3 + 48, GuiColors.CraftingCPUStored.getColor());
            }
            GL11.glPopMatrix();
            int indicatorColor = AEColor.Lime.mediumVariant;
            if (this.data.isHub) {
                if (this.data.slots == 0) {
                    indicatorColor = AEColor.Red.mediumVariant;
                } else if (this.data.slots < 32) {
                    indicatorColor = AEColor.Orange.mediumVariant;
                }
                str = 32 - this.data.slots + "/32 | " + this.data.channels;
            } else {
                if (this.data.slots == 0) {
                    indicatorColor = AEColor.Red.mediumVariant;
                }
                str = this.data.slots + "/1 | " + this.data.channels;
            }
            this.drawSlotsIndicator(str, posY, indicatorColor);
            super.draw();
        }

        @Override
        protected void renameCommand() {
            GuiSuperWirelessKit.this.sendCommand("renameSingle", this);
        }
    }
}

