/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.CraftingStatus;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseMEGui;
import appeng.client.gui.implementations.GuiMEPortableCell;
import appeng.client.gui.implementations.GuiSecurity;
import appeng.client.gui.implementations.GuiWirelessTerm;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.InternalSlotME;
import appeng.client.me.ItemRepo;
import appeng.client.me.PinSlotME;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.modules.NEI;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.tile.misc.TileSecurity;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiMEMonitorable
extends AEBaseMEGui
implements ISortSource,
IConfigManagerHost,
IDropToFillTextField {
    public static int craftingGridOffsetX;
    public static int craftingGridOffsetY;
    private static String memoryText;
    private final IDisplayRepo repo;
    private final int offsetX = 9;
    private final int MAGIC_HEIGHT_NUMBER = 115;
    private final int lowerTextureOffset = 0;
    private final IConfigManager configSrc;
    private final boolean viewCell;
    private final ItemStack[] myCurrentViewCells = new ItemStack[5];
    private final ContainerMEMonitorable monitorableContainer;
    private GuiTabButton craftingStatusBtn;
    private GuiImgButton craftingStatusImgBtn;
    private final MEGuiTextField searchField;
    private GuiText myName;
    private int perRow = 9;
    private int reservedSpace = 0;
    private boolean customSortOrder = true;
    private int rows = 0;
    private int standardSize;
    private GuiImgButton ViewBox;
    private GuiImgButton SortByBox;
    private GuiImgButton SortDirBox;
    private GuiImgButton searchBoxSettings;
    private GuiImgButton terminalStyleBox;
    private GuiImgButton searchStringSave;
    private GuiImgButton typeFilter;
    private boolean isAutoFocus = false;
    private int currentMouseX = 0;
    private int currentMouseY = 0;

    public GuiMEMonitorable(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, te, new ContainerMEMonitorable(inventoryPlayer, te));
    }

    public GuiMEMonitorable(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerMEMonitorable c) {
        super(c);
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new ItemRepo(scrollbar, this);
        this.field_146999_f = 195;
        this.field_147000_g = 204;
        this.standardSize = this.field_146999_f;
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        this.monitorableContainer = (ContainerMEMonitorable)this.field_147002_h;
        this.monitorableContainer.setGui(this);
        this.viewCell = te instanceof IViewCellStorage;
        if (te instanceof TileSecurity) {
            this.myName = GuiText.Security;
        } else if (te instanceof WirelessTerminalGuiObject) {
            this.myName = GuiText.WirelessTerminal;
        } else if (te instanceof IPortableCell) {
            this.myName = GuiText.PortableCell;
        } else if (te instanceof IMEChest) {
            this.myName = GuiText.Chest;
        } else if (te instanceof AbstractPartTerminal) {
            this.myName = GuiText.Terminal;
        }
        this.searchField = new MEGuiTextField(90, 12, ButtonToolTips.SearchStringTooltip.getLocal()){

            @Override
            public void onTextChange(String oldText) {
                String text = this.getText();
                GuiMEMonitorable.this.repo.setSearchString(text);
                GuiMEMonitorable.this.repo.updateView();
                GuiMEMonitorable.this.setScrollBar();
            }
        };
        NEI.searchField.putFormatter(this.searchField);
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, Math.max(1, this.rows / 6));
    }

    protected void func_146284_a(GuiButton btn) {
        GuiImgButton iBtn;
        if (btn == this.craftingStatusBtn || btn == this.craftingStatusImgBtn) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(GuiBridge.GUI_CRAFTING_STATUS));
        }
        if (btn instanceof GuiImgButton && (iBtn = (GuiImgButton)btn).getSetting() != Settings.ACTIONS) {
            Enum cv = iBtn.getCurrentValue();
            boolean backwards = Mouse.isButtonDown((int)1);
            Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
            if (btn == this.terminalStyleBox) {
                AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
            } else if (btn == this.searchBoxSettings) {
                AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
            } else if (btn == this.searchStringSave) {
                AEConfig.instance.preserveSearchBar = next == YesNo.YES;
            } else {
                try {
                    NetworkHandler.instance.sendToServer(new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
            iBtn.set(next);
            if (next.getClass() == SearchBoxMode.class || next.getClass() == TerminalStyle.class) {
                memoryText = this.searchField.getText();
                this.reinitalize();
            }
        }
    }

    private void reinitalize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    @Override
    public void func_73866_w_() {
        Enum<?> searchMode;
        Keyboard.enableRepeatEvents((boolean)true);
        this.perRow = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? 9 : 9 + (this.field_146294_l - this.standardSize) / 18;
        this.rows = this.calculateRowsCount();
        this.getMeSlots().clear();
        for (int x = 0; x < this.perRow; ++x) {
            this.getMeSlots().add(new PinSlotME(this.repo, x, this.offsetX + x * 18, 18));
        }
        for (int y = 0; y < this.rows - 1; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                this.getMeSlots().add(new InternalSlotME(this.repo, x + y * this.perRow, this.offsetX + x * 18, 36 + y * 18));
            }
        }
        this.field_146999_f = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? this.standardSize + (this.perRow - 9) * 18 : this.standardSize;
        super.func_73866_w_();
        this.field_147000_g = 115 + this.rows * 18 + this.reservedSpace;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        int offset = this.field_147009_r + 8;
        if (this.customSortOrder) {
            this.SortByBox = new GuiImgButton(this.field_147003_i - 18, offset, Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
            this.field_146292_n.add(this.SortByBox);
            offset += 20;
        }
        if (this.viewCell || this instanceof GuiWirelessTerm) {
            this.ViewBox = new GuiImgButton(this.field_147003_i - 18, offset, Settings.VIEW_MODE, this.configSrc.getSetting(Settings.VIEW_MODE));
            this.field_146292_n.add(this.ViewBox);
            offset += 20;
        }
        if (!AEApi.instance().registries().itemDisplay().getItemFilters().isEmpty()) {
            this.typeFilter = new GuiImgButton(this.field_147003_i - 18, offset, Settings.TYPE_FILTER, this.configSrc.getSetting(Settings.TYPE_FILTER));
            this.field_146292_n.add(this.typeFilter);
            offset += 20;
        }
        this.SortDirBox = new GuiImgButton(this.field_147003_i - 18, offset, Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.field_146292_n.add(this.SortDirBox);
        this.searchBoxSettings = new GuiImgButton(this.field_147003_i - 18, offset += 20, Settings.SEARCH_MODE, AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE));
        this.field_146292_n.add(this.searchBoxSettings);
        this.searchStringSave = new GuiImgButton(this.field_147003_i - 18, offset += 20, Settings.SAVE_SEARCH, AEConfig.instance.preserveSearchBar ? YesNo.YES : YesNo.NO);
        this.field_146292_n.add(this.searchStringSave);
        offset += 20;
        if (!(this instanceof GuiMEPortableCell) || this instanceof GuiWirelessTerm) {
            this.terminalStyleBox = new GuiImgButton(this.field_147003_i - 18, offset, Settings.TERMINAL_STYLE, AEConfig.instance.settings.getSetting(Settings.TERMINAL_STYLE));
            this.field_146292_n.add(this.terminalStyleBox);
            offset += 20;
        }
        if (this.viewCell || this instanceof GuiWirelessTerm) {
            if (AEConfig.instance.getConfigManager().getSetting(Settings.CRAFTING_STATUS).equals((Object)CraftingStatus.BUTTON)) {
                this.craftingStatusImgBtn = new GuiImgButton(this.field_147003_i - 18, offset, Settings.CRAFTING_STATUS, AEConfig.instance.settings.getSetting(Settings.CRAFTING_STATUS));
                this.field_146292_n.add(this.craftingStatusImgBtn);
            } else {
                this.craftingStatusBtn = new GuiTabButton(this.field_147003_i + 170, this.field_147009_r - 4, 178, GuiText.CraftingStatus.getLocal(), field_146296_j);
                this.field_146292_n.add(this.craftingStatusBtn);
                this.craftingStatusBtn.setHideEdge(13);
            }
        }
        this.isAutoFocus = SearchBoxMode.AUTOSEARCH == (searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE)) || SearchBoxMode.NEI_AUTOSEARCH == searchMode;
        this.searchField.x = this.field_147003_i + Math.max(80, this.offsetX);
        this.searchField.y = this.field_147009_r + 4;
        this.searchField.setFocused(this.isAutoFocus);
        if (this.isSubGui()) {
            this.searchField.setText(memoryText);
        } else if (AEConfig.instance.preserveSearchBar) {
            this.searchField.setText(memoryText, true);
            this.repo.setSearchString(memoryText);
        }
        this.searchField.setCursorPositionEnd();
        this.setScrollBar();
        craftingGridOffsetX = Integer.MAX_VALUE;
        craftingGridOffsetY = Integer.MAX_VALUE;
        for (Object s : this.field_147002_h.field_75151_b) {
            if (s instanceof AppEngSlot && ((Slot)s).field_75223_e < 197) {
                this.repositionSlot((AppEngSlot)((Object)s));
            }
            if (!(s instanceof SlotCraftingMatrix) && !(s instanceof SlotFakeCraftingMatrix)) continue;
            Slot g = (Slot)s;
            if (g.field_75223_e <= 0 || g.field_75221_f <= 0) continue;
            craftingGridOffsetX = Math.min(craftingGridOffsetX, g.field_75223_e);
            craftingGridOffsetY = Math.min(craftingGridOffsetY, g.field_75221_f);
        }
        craftingGridOffsetX -= 25;
        craftingGridOffsetY -= 6;
    }

    protected int calculateRowsCount() {
        boolean hasNEI = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
        int NEIPadding = hasNEI ? 42 : 0;
        int extraSpace = this.field_146295_m - 115 - NEIPadding - this.reservedSpace;
        return Math.max(3, Math.min(this.getMaxRows(), (int)Math.floor(extraSpace / 18)));
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(this.myName.getLocal()), 8, 6, GuiColors.MEMonitorableTitle.getColor());
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, GuiColors.MEMonitorableInventory.getColor());
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.searchField.mouseClicked(xCoord, yCoord, btn);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        memoryText = this.searchField.getText();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture(this.getBackground());
        int x_width = 195;
        this.func_73729_b(offsetX, offsetY, 0, 0, 195, 18);
        if (this.viewCell || this instanceof GuiSecurity) {
            this.func_73729_b(offsetX + 195, offsetY, 195, 0, 46, 128);
        }
        for (int x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, 195, 18);
        }
        this.func_73729_b(offsetX, offsetY + 16 + this.rows * 18 + this.lowerTextureOffset, 0, 70, 195, 99 + this.reservedSpace - this.lowerTextureOffset);
        if (this.viewCell) {
            boolean update = false;
            for (int i = 0; i < 5; ++i) {
                if (this.myCurrentViewCells[i] == this.monitorableContainer.getCellViewSlot(i).func_75211_c()) continue;
                update = true;
                this.myCurrentViewCells[i] = this.monitorableContainer.getCellViewSlot(i).func_75211_c();
            }
            if (update) {
                this.repo.setViewCell(this.myCurrentViewCells);
            }
        }
        this.searchField.drawTextBox();
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    int getMaxRows() {
        return AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? AEConfig.instance.MEMonitorableSmallSize : Integer.MAX_VALUE;
    }

    protected void repositionSlot(AppEngSlot s) {
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - 5;
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (NEI.searchField.existsSearchField()) {
                if ((NEI.searchField.focused() || this.searchField.isFocused()) && CommonHelper.proxy.isActionKey(ActionKey.TOGGLE_FOCUS, key)) {
                    boolean focused = this.searchField.isFocused();
                    this.searchField.setFocused(!focused);
                    NEI.searchField.setFocus(focused);
                    return;
                }
                if (NEI.searchField.focused()) {
                    return;
                }
            }
            if (this.searchField.isFocused() && key == 28) {
                this.searchField.setFocused(false);
                return;
            }
            if (character == ' ' && this.searchField.getText().isEmpty()) {
                return;
            }
            boolean mouseInGui = this.isPointInRegion(0, 0, this.field_146999_f, this.field_147000_g, this.currentMouseX, this.currentMouseY);
            if (this.isAutoFocus && !this.searchField.isFocused() && mouseInGui) {
                this.searchField.setFocused(true);
            }
            if (!this.searchField.textboxKeyTyped(character, key)) {
                super.func_73869_a(character, key);
            }
        }
    }

    public void func_73876_c() {
        this.repo.setPowered(this.monitorableContainer.isPowered());
        super.func_73876_c();
    }

    @Override
    public Enum getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public Enum getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public Enum getTypeFilter() {
        return this.configSrc.getSetting(Settings.TYPE_FILTER);
    }

    @Override
    public Enum getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.SortByBox != null) {
            this.SortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.SortDirBox != null) {
            this.SortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        if (this.ViewBox != null) {
            this.ViewBox.set(this.configSrc.getSetting(Settings.VIEW_MODE));
        }
        if (this.typeFilter != null) {
            this.typeFilter.set(this.configSrc.getSetting(Settings.TYPE_FILTER));
        }
        this.repo.updateView();
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return (pointX -= this.field_147003_i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= this.field_147009_r) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    int getReservedSpace() {
        return this.reservedSpace;
    }

    void setReservedSpace(int reservedSpace) {
        this.reservedSpace = reservedSpace;
    }

    public boolean isCustomSortOrder() {
        return this.customSortOrder;
    }

    void setCustomSortOrder(boolean customSortOrder) {
        this.customSortOrder = customSortOrder;
    }

    public int getStandardSize() {
        return this.standardSize;
    }

    void setStandardSize(int standardSize) {
        this.standardSize = standardSize;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.handleTooltip(mouseX, mouseY, this.searchField);
        super.func_73863_a(mouseX, mouseY, btn);
    }

    @Override
    public boolean isOverTextField(int mousex, int mousey) {
        return this.searchField.isMouseIn(mousex, mousey);
    }

    @Override
    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        this.searchField.setText(NEI.searchField.getEscapedSearchText(displayName));
    }

    @Override
    protected void func_146984_a(Slot p_146984_1_, int p_146984_2_, int p_146984_3_, int p_146984_4_) {
        if (p_146984_1_ != null && p_146984_4_ == 4 && p_146984_1_.field_75223_e > this.field_146999_f) {
            p_146984_4_ = 0;
        }
        super.func_146984_a(p_146984_1_, p_146984_2_, p_146984_3_, p_146984_4_);
    }

    public void func_146282_l() {
        super.func_146282_l();
        this.repo.setPaused(this.hasShiftDown());
    }

    public boolean hideItemPanelSlot(int tx, int ty, int tw, int th) {
        if (this.viewCell) {
            int rw = 33;
            int rh = 14 + this.myCurrentViewCells.length * 18;
            if (this.monitorableContainer.isAPatternTerminal()) {
                rh += 21;
            }
            if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
                return false;
            }
            int rx = this.field_147003_i + this.field_146999_f;
            int ry = this.field_147009_r + 0;
            rh += ry;
            tw += tx;
            th += ty;
            return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
        }
        return false;
    }

    private boolean hasShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public void setPin(IAEItemStack ais, int idx) {
        this.repo.setPin(ais, idx);
        this.repo.updateView();
    }

    static {
        memoryText = "";
    }
}

