/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.loader.IRegister;
import com.glodblock.github.util.NameConst;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemFluidVoidStorageCell
extends AEBaseItem
implements IStorageFluidCell,
IRegister<ItemFluidVoidStorageCell> {
    public ItemFluidVoidStorageCell() {
        this.func_77655_b("fluid_storage.void");
        this.func_111206_d(FluidCraft.resource("fluid_storage.void").toString());
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
    }

    @Override
    public ItemFluidVoidStorageCell register() {
        GameRegistry.registerItem((Item)this, (String)"fluid_storage.void", (String)"ae2fc");
        this.func_77637_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof IFluidCellInventoryHandler) {
            IFluidCellInventoryHandler handler = (IFluidCellInventoryHandler)inventory;
            lines.add(NameConst.i18n("ae2fc.tooltip.fluid_storage.void"));
            lines.add(GuiText.VoidCellTooltip.getLocal());
            lines.add("0 " + GuiText.Of.getLocal() + " \u00a7k9999\u00a77 " + GuiText.BytesUsed.getLocal());
            IFluidCellInventory inv = handler.getCellInv();
            if (GuiScreen.func_146272_n()) {
                lines.add(GuiText.Filter.getLocal() + ": ");
                for (int i = 0; i < inv.getConfigInventory().func_70302_i_(); ++i) {
                    ItemStack s = inv.getConfigInventory().func_70301_a(i);
                    if (s == null) continue;
                    lines.add(s.func_82833_r());
                }
            }
        }
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        return 0L;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 0;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return 0.0;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 0;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 5);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }
}

