/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.config.SecurityPermissions;
import appeng.container.AEBaseContainer;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.slot.SlotFluidConvertingFake;
import com.glodblock.github.util.Util;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerLevelMaintainer
extends AEBaseContainer {
    private final TileLevelMaintainer tile;
    private final SlotFluidConvertingFake[] requestSlots = new SlotFluidConvertingFake[5];

    public ContainerLevelMaintainer(InventoryPlayer ipl, TileLevelMaintainer tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        AeItemStackHandler request = new AeItemStackHandler(tile.getRequestSlots());
        for (int y = 0; y < 5; ++y) {
            SlotFluidConvertingFake slot = new SlotFluidConvertingFake(request, y, 27, 20 + y * 19);
            this.func_75146_a((Slot)slot);
            this.requestSlots[y] = slot;
        }
        this.bindPlayerInventory(ipl, 0, 130);
    }

    public TileLevelMaintainer getTile() {
        return this.tile;
    }

    public SlotFluidConvertingFake[] getRequestSlots() {
        return this.requestSlots;
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        block11: {
            block10: {
                Slot slot = this.func_75139_a(slotId);
                if (!(slot instanceof SlotFluidConvertingFake)) break block10;
                ItemStack stack = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (stack == null) {
                            slot.func_75215_d(null);
                            break;
                        }
                        ((SlotFluidConvertingFake)slot).putConvertedStack(ContainerLevelMaintainer.createLevelValues(stack.func_77946_l()));
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (stack == null) break;
                        ((SlotFluidConvertingFake)slot).putConvertedStack(ContainerLevelMaintainer.createLevelValues(Objects.requireNonNull(Util.copyStackWithSize(stack, 1))));
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        ItemStack inSlot = slot.func_75211_c();
                        if (inSlot != null) {
                            if (stack == null) {
                                slot.func_75215_d(ContainerLevelMaintainer.createLevelValues(Objects.requireNonNull(Util.copyStackWithSize(inSlot, Math.max(1, inSlot.field_77994_a - 1)))));
                                break;
                            }
                            if (stack.func_77969_a(inSlot)) {
                                slot.func_75215_d(ContainerLevelMaintainer.createLevelValues(Objects.requireNonNull(Util.copyStackWithSize(inSlot, Math.min(inSlot.func_77976_d(), inSlot.field_77994_a + 1)))));
                                break;
                            }
                            ((SlotFluidConvertingFake)slot).putConvertedStack(ContainerLevelMaintainer.createLevelValues(Objects.requireNonNull(Util.copyStackWithSize(stack, 1))));
                            break;
                        }
                        if (stack != null) {
                            ((SlotFluidConvertingFake)slot).putConvertedStack(ContainerLevelMaintainer.createLevelValues(Objects.requireNonNull(Util.copyStackWithSize(stack, 1))));
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            super.doAction(player, action, slotId, id);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int idx) {
        if (Platform.isClient()) {
            return null;
        }
        for (int i = 0; i < this.getRequestSlots().length; ++i) {
            SlotFluidConvertingFake slot = this.getRequestSlots()[i];
            if (slot.func_75216_d()) continue;
            ItemStack itemStack = ((Slot)this.field_75151_b.get(idx)).func_75211_c();
            ItemStack configuration = ContainerLevelMaintainer.createLevelValues(itemStack.func_77946_l());
            configuration.func_77978_p().func_74768_a(TileLevelMaintainer.TLMTags.Index.tagName, i);
            slot.putConvertedStack(configuration);
            break;
        }
        this.func_75142_b();
        return null;
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        super.func_75142_b();
    }

    public static ItemStack createLevelValues(ItemStack itemStack) {
        NBTTagCompound data;
        NBTTagCompound nBTTagCompound = data = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        if (!data.func_74764_b(TileLevelMaintainer.TLMTags.Stack.tagName)) {
            NBTTagCompound itemStackTag = new NBTTagCompound();
            itemStack.func_77946_l().func_77955_b(itemStackTag);
            data.func_74782_a(TileLevelMaintainer.TLMTags.Stack.tagName, (NBTBase)itemStackTag);
        }
        if (!data.func_74764_b(TileLevelMaintainer.TLMTags.Quantity.tagName)) {
            data.func_74772_a(TileLevelMaintainer.TLMTags.Quantity.tagName, itemStack.field_77994_a > 0 ? (long)itemStack.field_77994_a : 1L);
        }
        if (!data.func_74764_b(TileLevelMaintainer.TLMTags.Batch.tagName)) {
            data.func_74772_a(TileLevelMaintainer.TLMTags.Batch.tagName, 1L);
        }
        if (!data.func_74764_b(TileLevelMaintainer.TLMTags.Enable.tagName)) {
            data.func_74757_a(TileLevelMaintainer.TLMTags.Enable.tagName, false);
        }
        if (data.func_74764_b(TileLevelMaintainer.TLMTags.Index.tagName)) {
            data.func_82580_o(TileLevelMaintainer.TLMTags.Index.tagName);
        }
        data.func_74768_a(TileLevelMaintainer.TLMTags.State.tagName, TileLevelMaintainer.State.None.ordinal());
        itemStack.func_77982_d(data);
        return itemStack;
    }
}

